/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.CpfCnpjObrigatorioException;
import br.com.elotech.portalarrecadacao.exception.MobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.validator.CpfCnpjValidador;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController
public class ReimprimirAlvaraController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -2260104597589548746L;
    private static final Long TIPO_DOCUMENTO_ALVARA_LOCALIZACAO = 8L;
    private CadastroGeralAisePK mobiliarioPK = this.instanciarMobiliario();
    private String cpfCnpj;

    private CadastroGeralAisePK instanciarMobiliario() {
        CadastroGeralAisePK cadastroMobiliarioPK = new CadastroGeralAisePK();
        cadastroMobiliarioPK.setTipo(Long.valueOf(2L));
        return cadastroMobiliarioPK;
    }

    public void imprimir() {
        try {
            this.validarFiltroInformado();
            ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).imprimirDocumento(this.mobiliarioPK, TIPO_DOCUMENTO_ALVARA_LOCALIZACAO);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void validarFiltroInformado() throws BaseException {
        this.validarCpfCnpj();
        this.carregarCadastroGeral();
    }

    private void validarCpfCnpj() throws CpfCnpjObrigatorioException {
        if (EloStringUtils.isEmpty((String)this.cpfCnpj)) {
            throw new CpfCnpjObrigatorioException("CPF/CNPJ n\u00e3o informado.");
        }
        if (!new CpfCnpjValidador().validarCpfCnpj(this.cpfCnpj)) {
            throw new CpfCnpjObrigatorioException("CPF/CNPJ inv\u00e1lido.");
        }
    }

    private void carregarCadastroGeral() throws BaseException {
        CadastroMobiliarioEntity mobiliarioCarregado = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregarMobiliarioPorCodigo(this.mobiliarioPK.getCodigo());
        if (mobiliarioCarregado == null) {
            throw new MobiliarioNaoEncontradoException("N\u00e3o foi encontrado um Mobili\u00e1rio para o C\u00f3digo informado.");
        }
        if (this.cpfCnpjDiferenteDoMobiliario(mobiliarioCarregado)) {
            throw new CpfCnpjObrigatorioException("O CPF/CNPJ informado n\u00e3o pertence ao C\u00f3digo informado.");
        }
    }

    private boolean cpfCnpjDiferenteDoMobiliario(CadastroMobiliarioEntity mobiliarioCarregado) {
        if (mobiliarioCarregado.getCadastroGeral() != null && mobiliarioCarregado.getCadastroGeral().getPessoa() != null && mobiliarioCarregado.getCadastroGeral().getPessoa().getCnpjCpf() != null) {
            return !mobiliarioCarregado.getCadastroGeral().getPessoa().getCnpjCpf().equals(this.cpfCnpj);
        }
        return true;
    }

    public CadastroGeralAisePK getMobiliarioPK() {
        return this.mobiliarioPK;
    }

    public void setMobiliarioPK(CadastroGeralAisePK mobiliarioPK) {
        this.mobiliarioPK = mobiliarioPK;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public void limpar() {
        this.mobiliarioPK = this.instanciarMobiliario();
        this.cpfCnpj = "";
    }
}

