/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.ConsultaCpfCnpjController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.RestricaoCadastroController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.RestricaoConsultaPreviaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@EloController(value="reciboConsultaPreviaController")
@Scope(value="flow")
public class ReciboConsultaPreviaController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String cpfCnpjSolicitante;
    private CadastroMobiliarioEntity cadastroMobiliario;
    private CadastroImobiliarioEntity cadastroImobiliario;
    private StringBuffer descricaoAtividades;
    private Long exercicio;
    private boolean renderRestricoes = false;
    private RestricaoAlvaraVo restricaoAlvaraVo;
    private boolean renderObservacoes = false;
    private boolean renderPanelMudancaEndereco = false;
    private String informacoesAdicionais;
    private String observacaoConfiguracaoAtividade;
    private String observacaoGeral;
    private List<SolicitacaoRedeSimEntity> tramites = new ArrayList();
    @Resource
    private EntidadeController entidadeController;
    @Resource
    private ConsultaCpfCnpjController consultaCpfCnpjController;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private RestricaoCadastroController restricaoCadastroController;

    public String getObservacaoGeral() {
        return this.observacaoGeral;
    }

    public void setObservacaoGeral(String observacaoGeral) {
        this.observacaoGeral = observacaoGeral;
    }

    public String getObservacaoConfiguracaoAtividade() {
        return this.observacaoConfiguracaoAtividade;
    }

    public void setObservacaoConfiguracaoAtividade(String observacaoConfiguracaoAtividade) {
        this.observacaoConfiguracaoAtividade = observacaoConfiguracaoAtividade;
    }

    public boolean isRenderRestricoes() {
        return this.renderRestricoes;
    }

    public void setRenderRestricoes(boolean renderRestricoes) {
        this.renderRestricoes = renderRestricoes;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public String getCpfCnpjSolicitante() {
        return this.cpfCnpjSolicitante;
    }

    public void setCpfCnpjSolicitante(String cpfCnpjSolicitante) {
        this.cpfCnpjSolicitante = cpfCnpjSolicitante;
    }

    public CadastroMobiliarioEntity getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    public void setCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    public CadastroImobiliarioEntity getCadastroImobiliario() {
        return this.cadastroImobiliario;
    }

    public void setCadastroImobiliario(CadastroImobiliarioEntity cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setConsultaCpfCnpjController(ConsultaCpfCnpjController consultaCpfCnpjController) {
        this.consultaCpfCnpjController = consultaCpfCnpjController;
    }

    public RestricaoAlvaraVo getRestricaoAlvaraVo() {
        return this.restricaoAlvaraVo;
    }

    public void setRestricaoAlvaraVo(RestricaoAlvaraVo restricaoAlvaraVo) {
        this.restricaoAlvaraVo = restricaoAlvaraVo;
    }

    public boolean isRenderObservacoes() {
        return this.renderObservacoes;
    }

    public void setRenderObservacoes(boolean renderObservacoes) {
        this.renderObservacoes = renderObservacoes;
    }

    public boolean isRenderPanelMudancaEndereco() {
        return this.renderPanelMudancaEndereco;
    }

    public void setRenderPanelMudancaEndereco(boolean renderPanelMudancaEndereco) {
        this.renderPanelMudancaEndereco = renderPanelMudancaEndereco;
    }

    public StringBuffer getDescricaoAtividades() {
        return this.descricaoAtividades;
    }

    public void setDescricaoAtividades(StringBuffer descricaoAtividades) {
        this.descricaoAtividades = descricaoAtividades;
    }

    public String getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public List<SolicitacaoRedeSimEntity> getTramites() {
        return this.tramites;
    }

    public void setTramites(List<SolicitacaoRedeSimEntity> tramites) {
        this.tramites = tramites;
    }

    public void gerarRecibo() throws BaseException {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        this.renderPanelMudancaEndereco = solicitacao.isNaturezaMudancaEndereco() || solicitacao.isNaturezaInicial();
        this.cadastroImobiliario = solicitacao.getCadastroImobiliario();
        String string = this.cpfCnpjSolicitante = EloStringUtils.isEmpty((String)this.consultaCpfCnpjController.getCpfcnpj()) ? solicitacao.getCpfCnpjConsulta() : this.consultaCpfCnpjController.getCpfcnpj();
        if (!solicitacao.isNaturezaInicial()) {
            this.cadastroMobiliario = solicitacao.getCadastroMobiliario();
        }
        this.montarDescricaoAtividadeDoRecibo(solicitacao);
        this.informacoesAdicionais = solicitacao.getObservacaoDasAtividades(Boolean.TRUE.booleanValue());
    }

    private void montarDescricaoAtividadeDoRecibo(SolicitacaoAlvaraEntity solicitacao) {
        this.descricaoAtividades = new StringBuffer();
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                this.descricaoAtividades.append(atividade.getCodigoAtividade()).append(" - ");
                this.descricaoAtividades.append(atividade.getDescricaoAtividade()).append("; <br>");
            }
        } else if (!EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCnaes()).booleanValue() && (solicitacao.isSolicitacaoJuridicaNormal() || solicitacao.isSolicitacaoPrestadorServico())) {
            for (MobiliarioCnaeEntity mobCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
                this.descricaoAtividades.append(mobCnae.getId().getCnae().getCodigo()).append(" - ");
                this.descricaoAtividades.append(mobCnae.getId().getCnae().getDescricao()).append("; <br>");
            }
        } else if (!EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()).booleanValue() && solicitacao.isSolicitacaoMEI()) {
            for (CadastroMobiliarioAtividadeMeiEntity mobMei : solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()) {
                this.descricaoAtividades.append(mobMei.getAtividadeMei().getCnae().getCodigo()).append(" - ");
                this.descricaoAtividades.append(mobMei.getAtividadeMei().getOcupacao()).append("; <br>");
            }
        } else if (!EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCbos()).booleanValue() && solicitacao.isSolicitacaoCBO()) {
            for (CadastroMobiliarioCboEntity mobCbo : solicitacao.getCadastroMobiliario().getMobiliarioCbos()) {
                this.descricaoAtividades.append(mobCbo.getRhCbo().getCbo()).append(" - ");
                this.descricaoAtividades.append(mobCbo.getRhCbo().getDescricao()).append("; <br>");
            }
        }
        if (this.descricaoAtividades.length() >= 2) {
            this.descricaoAtividades.delete(this.descricaoAtividades.length() - 2, this.descricaoAtividades.length());
        }
    }

    protected void getTramites(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (Objects.isNull(solicitacaoAlvara)) {
            return;
        }
        try {
            this.tramites = Collections.singletonList(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(solicitacaoAlvara.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.CONSULTA));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao buscar tramites");
        }
    }

    public String getIndeferidoDescricao(boolean indeferido) {
        return indeferido ? "Indeferimento" : "Deferimento";
    }

    public Boolean isIntegracaoSimplificadaRedeSim() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRADO_REDESIM).getValor());
    }

    public String finalizarGravarConsulta() throws BaseException {
        SolicitacaoAlvaraEntity solicitacao = this.getSolicitacao();
        if (this.isConsultaPreviaFinalizada(solicitacao)) {
            return null;
        }
        if (!solicitacao.isNaturezaInicial()) {
            solicitacao = this.carregaDadosCadastroNaSolicitacao(solicitacao);
        }
        try {
            solicitacao.setDataConsultaPrevia(new Date());
            if (!SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
                UserDetails usuario = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                solicitacao.setUserDetails(usuario);
            }
            this.entidadeController.carregaEntidade();
            this.exercicio = this.entidadeController.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio();
            solicitacao.setExercicio(this.exercicio);
            if (this.consultaCpfCnpjController.isCheckBoxNaturezaInicial()) {
                solicitacao.setCpfCnpjConsulta(this.consultaCpfCnpjController.getCpfcnpj().replaceAll("[.,-/]", ""));
            } else {
                solicitacao.setCpfCnpjConsulta(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
            }
            this.montarObservacaoRestricao(solicitacao);
            this.montarRestricaoConsultaPrevia(solicitacao);
            this.montarObservacaoGeral();
            if (!this.integradoGeo() && solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
                this.verificarExigencias();
                this.carregarObservacaoConfiguracaoAtividade(solicitacao);
            }
            this.salvarConsultaPrevia(solicitacao);
            return "toReciboConsultaPrevia";
        }
        catch (BaseException e) {
            solicitacao.setDataConsultaPrevia(null);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void montarObservacaoGeral() {
        try {
            this.observacaoGeral = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.OBSERVACAO_GERAL_CONSULTA_PREVIA).getValor();
            if (Objects.nonNull(this.observacaoGeral)) {
                this.renderObservacoes = true;
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void verificarExigencias() throws BaseException {
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara() == null || EloListUtils.safeIsEmpty((List)this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades()).booleanValue()) {
            throw new ConsultaAtividadeException("Nenhuma atividade informada para verificar as exig\u00eancias.");
        }
        this.adicionarExigenciasNaConsultaPrevia(this.solicitacaoAlvaraController.getSolicitacaoAlvara());
    }

    private void adicionarExigenciasNaConsultaPrevia(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).adicionarExigenciasNaConsultaPrevia(solicitacao);
    }

    private boolean integradoGeo() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).verificaIntegradoGeo();
    }

    public void montarObservacaoRestricao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.restricaoAlvaraVo = this.verificarRestricaoCadastro(solicitacao);
        this.renderRestricoes = this.restricaoAlvaraVo.getPossuiRestricao();
        this.renderObservacoes = !EloStringUtils.isEmpty((String)this.restricaoAlvaraVo.getObservacao());
    }

    public void montarRestricaoConsultaPrevia(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.getSolicitacaoAlvara() == null) {
            if (!(!Objects.nonNull(this.restricaoAlvaraVo) || EloStringUtils.isEmpty((String)this.restricaoAlvaraVo.getDescricaoRestricao()) && EloStringUtils.isEmpty((String)this.restricaoAlvaraVo.getObservacao()))) {
                this.addRestricaoConsultaPrevia(this.restricaoAlvaraVo, solicitacao);
            }
        } else if (solicitacao.getRestricaoConsultaPrevia() != null && solicitacao.getRestricaoConsultaPrevia().getIdRestricao() != null) {
            this.renderRestricoes = !EloStringUtils.isEmpty((String)solicitacao.getRestricaoConsultaPrevia().getDescricao());
            this.renderObservacoes = !EloStringUtils.isEmpty((String)solicitacao.getRestricaoConsultaPrevia().getObservacao());
        } else if (!(!Objects.nonNull(this.restricaoAlvaraVo) || EloStringUtils.isEmpty((String)this.restricaoAlvaraVo.getDescricaoRestricao()) && EloStringUtils.isEmpty((String)this.restricaoAlvaraVo.getObservacao()))) {
            this.addRestricaoConsultaPrevia(this.restricaoAlvaraVo, solicitacao);
        }
    }

    private boolean isConsultaPreviaFinalizada(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.getSolicitacaoAlvara() != null && solicitacao.getDataConsultaPrevia() != null) {
            StringBuilder mensagem = new StringBuilder();
            mensagem.append("Esta consulta pr\u00e9via j\u00e1 est\u00e1 finalizada. O n\u00famero da consulta \u00e9 ");
            mensagem.append(solicitacao.getNumeroSolicitacaoExercicio());
            ShowMessage.addErrorMessage((String)"msg", (String)mensagem.toString());
            return true;
        }
        return false;
    }

    private SolicitacaoAlvaraEntity carregaDadosCadastroNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDadosCadastroNaSolicitacao(solicitacao);
    }

    private void salvarConsultaPrevia(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        try {
            solicitacao.setEfetivado(SimNaoEnum.NAO.getShortText());
            if (!solicitacao.isNaturezaInicial() && !solicitacao.isNaturezaMudancaEndereco()) {
                CadastroImobiliarioTestadaEntity testada = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).recuperarTestada(solicitacao.getCadastroImobiliario().getCadastroGeral());
                solicitacao.setImobiliarioTestada(testada);
            }
            ((SolicitacaoAlvaraController)SpringContext.getBean(SolicitacaoAlvaraController.class)).setSolicitacaoAlvara(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarConsultaPrevia(solicitacao, Boolean.valueOf(true)));
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException("Ocorreu uma Falha ao Salvar a Solicita\u00e7\u00e3o, Favor entrar em contato com o setor de alvar\u00e1 da prefeitura", (Throwable)e);
        }
    }

    public String voltar() {
        if (this.getSolicitacao().isNaturezaInicial() || this.getSolicitacao().isNaturezaAlteracaoAtividade()) {
            return "toAlteracaoAtividade";
        }
        if (this.getSolicitacao().isNaturezaMudancaArea()) {
            return "toInformacoesAtividades";
        }
        if (this.getSolicitacao().isNaturezaMudancaEndereco()) {
            return "toMudancaEndereco";
        }
        if (this.getSolicitacao().isAlteracaoRazaoOuRazaoESocio()) {
            return "toInformacoesAtividades";
        }
        return "toConsultaCpfCnpj";
    }

    private RestricaoAlvaraVo verificarRestricaoCadastro(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificarRestricaoCadastroAlvara(solicitacao);
    }

    private SolicitacaoAlvaraEntity getSolicitacao() {
        return this.solicitacaoAlvaraController.getSolicitacaoAlvara();
    }

    public String getMensagemInstalacao() {
        String mensagem = "A instala\u00e7\u00e3o \u00e9 permitida neste local para as atividades abaixo:";
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoPrestadorServico() || this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoMEIPrestador()) {
            mensagem = "A inscri\u00e7\u00e3o \u00e9 permitida neste local para as atividades abaixo, somente como ponto de refer\u00eancia:";
        }
        return mensagem;
    }

    public String getMensagemObservacao() throws BaseException {
        return UtilsController.getMensagemObservacaoRecibos((ParametroAlvaraEnum)ParametroAlvaraEnum.MENSAGEM_OBSERVACAO_CONSULTA_PREVIA);
    }

    public boolean temExigencia() {
        return !EloStringUtils.isEmpty((String)this.solicitacaoAlvaraController.getSolicitacaoAlvara().getExigencias());
    }

    public boolean temInformacoesAdicionais() {
        return !EloStringUtils.isEmpty((String)this.getInformacoesAdicionais());
    }

    private RestricaoConsultaPreviaEntity addRestricaoConsultaPrevia(RestricaoAlvaraVo restricaoAlvaraVo, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).adicionaRestricaoConsultaPrevia(restricaoAlvaraVo, solicitacao);
    }

    private void carregarObservacaoConfiguracaoAtividade(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        try {
            this.observacaoConfiguracaoAtividade = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).getObservacaoConfiguracaoPorSolicitacao(solicitacao);
            if (!EloStringUtils.isEmpty((String)this.observacaoConfiguracaoAtividade)) {
                this.renderObservacoes = true;
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha ao Carregar Observacao da Configura\u00e7\u00e3o de Atividade");
        }
    }

    public boolean isExibeArea() {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        return !solicitacao.isSolicitacaoMEI() || !solicitacao.isPossuiPontoReferencia();
    }

    public boolean isSomenteMudancaArea() {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        return solicitacao.possuiSomenteNatureza(NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA);
    }
}

