/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroGeralEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeParametro;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.filter.FiltroParametro;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.ParametroGeralEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.component.tabview.TabView;
import org.primefaces.event.TabChangeEvent;
import org.springframework.context.annotation.Scope;

@EloController(value="parametrosController")
@Scope(value="flow")
public class ParametrosController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -1681928762466637725L;
    private static final String[] FILTROPARAMETROSEMAIL = new String[]{ParametroGeralEnum.SMTP.name(), ParametroGeralEnum.REMETENTEEMAIL.name(), ParametroGeralEnum.REQUERAUTENTICACAO.name()};
    private List<ParametroAlvaraEntity> parametrosAlvara;
    private List<ParametroGeralEntity> parametrosGeral;
    private List<ParametroGeralEntity> parametrosEmail = new ArrayList();
    private List<ParametroAlvaraNaturezaEntity> parametrosNatureza;
    private FiltroParametro filtro;
    private String emailDestinatario;
    private int indiceAbas;

    public List<ParametroAlvaraEntity> getParametrosAlvara() {
        return this.parametrosAlvara;
    }

    public void setParametrosAlvara(List<ParametroAlvaraEntity> parametrosAlvara) {
        this.parametrosAlvara = parametrosAlvara;
    }

    public List<ParametroGeralEntity> getParametrosGeral() {
        return this.parametrosGeral;
    }

    public void setParametrosGeral(List<ParametroGeralEntity> parametrosGeral) {
        this.parametrosGeral = parametrosGeral;
    }

    public List<ParametroAlvaraNaturezaEntity> getParametrosNatureza() {
        return this.parametrosNatureza;
    }

    public void setParametrosNatureza(List<ParametroAlvaraNaturezaEntity> parametrosNatureza) {
        this.parametrosNatureza = parametrosNatureza;
    }

    public List<ParametroGeralEntity> getParametrosEmail() {
        return this.parametrosEmail;
    }

    public void setParametrosEmail(List<ParametroGeralEntity> parametrosEmail) {
        this.parametrosEmail = parametrosEmail;
    }

    public FiltroParametro getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroParametro filtro) {
        this.filtro = filtro;
    }

    public int getIndiceAbas() {
        return this.indiceAbas;
    }

    public void setIndiceAbas(int indiceAbas) {
        this.indiceAbas = indiceAbas;
    }

    public String getEmailDestinatario() {
        return this.emailDestinatario;
    }

    public void setEmailDestinatario(String emailDestinatario) {
        this.emailDestinatario = emailDestinatario;
    }

    public void iniciar() throws BaseException {
        this.limpar();
        this.indiceAbas = 0;
    }

    public void limpar() throws BaseException {
        this.filtro = new FiltroParametro();
        this.pesquisar();
    }

    public void pesquisar() throws BaseException {
        this.parametrosAlvara = this.carregarParametrosAlvara();
        this.parametrosGeral = this.carregarParametrosGeral();
        this.parametrosNatureza = this.carregarParametrosNatureza();
        if (Objects.nonNull(this.parametrosGeral)) {
            this.parametrosEmail = this.parametrosGeral.stream().filter(p -> Arrays.asList(FILTROPARAMETROSEMAIL).stream().anyMatch(f -> p.getId().getParametro().contains((CharSequence)f))).collect(Collectors.toList());
        }
    }

    private List<ParametroAlvaraEntity> carregarParametrosAlvara() throws BaseException {
        return ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).carregarParametrosAlvara(this.filtro);
    }

    private List<ParametroGeralEntity> carregarParametrosGeral() throws BaseException {
        return ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).carregarParametrosGeral(this.filtro);
    }

    private List<ParametroAlvaraNaturezaEntity> carregarParametrosNatureza() throws BaseException {
        return ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).carregarParametrosNatureza(this.filtro);
    }

    public void salvarParametroAlvara(ParametroAlvaraEntity parametro) throws BaseException {
        ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).salvarParametroAlvara(parametro);
        ShowMessage.addInfoMessage((String)"msg", (String)"Par\u00e2metro Alvar\u00e1 atualizado.");
    }

    public void salvarParametroGeral(ParametroGeralEntity parametro) throws BaseException {
        ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).salvarParametroGeral(parametro);
        ShowMessage.addInfoMessage((String)"msg", (String)"Par\u00e2metro Geral atualizado.");
    }

    public void salvarParametroEmail(ParametroGeralEntity parametro) throws BaseException {
        ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).salvarParametroGeral(parametro);
        ShowMessage.addInfoMessage((String)"msg", (String)String.format("Par\u00e2metro %s atualizado.", parametro.getId().getParametro()));
    }

    public void salvarParametroNatureza(ParametroAlvaraNaturezaEntity parametro) throws BaseException {
        ((FacadeParametro)SpringContext.getBean(FacadeParametro.class)).salvarParametroNatureza(parametro);
        ShowMessage.addInfoMessage((String)"msg", (String)"Par\u00e2metro Natureza atualizado.");
    }

    public void trocarAba(TabChangeEvent event) {
        TabView tabView = (TabView)event.getComponent();
        this.setIndiceAbas(tabView.getActiveIndex());
    }

    public void enviarEmail() throws BaseException {
        try {
            Optional<ParametroGeralEntity> opParametroRemetenteEmail = this.parametrosEmail.stream().filter(p -> ParametroGeralEnum.REMETENTEEMAIL.name().equals(p.getId().getParametro())).findFirst();
            if (opParametroRemetenteEmail.isPresent()) {
                ParametroGeralEntity parametroGeralEntity = opParametroRemetenteEmail.get();
                String remetente = parametroGeralEntity.getValor();
                if (StringUtils.isNotEmpty((CharSequence)remetente)) {
                    EmailVo emailVo = new EmailVo();
                    emailVo.setRemetente(remetente);
                    emailVo.setDestinatario(this.emailDestinatario);
                    emailVo.setAssunto("TESTE");
                    emailVo.setMensagem("TESTE");
                    ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmail(emailVo);
                    ShowMessage.addInfoMessage((String)"msg", (String)"Email enviado!");
                } else {
                    ShowMessage.addWarnErrorMessage((String)"msg", (String)"Remetente Email n\u00e3o encontrado.");
                }
            } else {
                ShowMessage.addWarnErrorMessage((String)"msg", (String)"Par\u00e2metro REMETENTEEMAIL n\u00e3o encontrado.");
            }
        }
        catch (Exception erro) {
            this.logger.error((Object)"N\u00e3o foi poss\u00edvel enviar o email.", (Throwable)erro);
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel enviar o email.");
        }
    }
}

