/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeConfiguracaoAtividade;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.ObservacaoConfiguracaoAtividadeEntity;
import br.com.elotech.util.list.EloListUtils;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController(value="observacaoAtividadeController")
public class ObservacaoAtividadeController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 492536779862884787L;
    private List<ObservacaoConfiguracaoAtividadeEntity> observacoes;
    private String descricao;

    public List<ObservacaoConfiguracaoAtividadeEntity> getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(List<ObservacaoConfiguracaoAtividadeEntity> observacoes) {
        this.observacoes = observacoes;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void iniciar() throws BaseException {
        this.carregarObservacoes();
    }

    private void carregarObservacoes() {
        this.observacoes = new ArrayList();
        try {
            this.observacoes = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).carregarObservacoes();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha ao carregar a lista de observa\u00e7\u00f5es ", e.getMessage()));
        }
    }

    public void adicionar() {
        if (!Strings.isNullOrEmpty((String)this.descricao)) {
            ObservacaoConfiguracaoAtividadeEntity observacao = new ObservacaoConfiguracaoAtividadeEntity();
            observacao.setObservacao(this.descricao);
            this.salvar(observacao);
            if (EloListUtils.safeIsEmpty((List)this.observacoes).booleanValue()) {
                this.observacoes = new ArrayList();
            }
            this.observacoes.add(observacao);
            this.descricao = "";
        } else {
            ShowMessage.addInfoMessage((String)"msgObservacao", (String)" O campo descri\u00e7\u00e3o deve ser preenchido! ");
        }
    }

    public void remover(ObservacaoConfiguracaoAtividadeEntity observacao) {
        try {
            this.observacoes.remove(observacao);
            ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).removerObservacao(observacao);
        }
        catch (ConstraintViolationException e) {
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)" N\u00e3o \u00e9 poss\u00edvel excluir, este registro est\u00e1 ligado a outra tabela. ");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha ao remover da listagem", e.getMessage()));
        }
    }

    public void salvar(ObservacaoConfiguracaoAtividadeEntity obs) {
        try {
            ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).salvarObservacao(obs);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha ao salvar a observacao: ", e.getMessage()));
        }
    }

    public void pesquisar() {
        if (Strings.isNullOrEmpty((String)this.descricao)) {
            this.carregarObservacoes();
        } else {
            try {
                this.observacoes.clear();
                this.observacoes = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).pesquisaObservacao(this.descricao);
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha na pesquisa: ", e.getMessage()));
            }
        }
    }

    public void limpar() {
        this.descricao = "";
        this.observacoes.clear();
    }
}

