/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeUsuario;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.context.annotation.Scope;

@EloController(value="liberarAcessoLaudoController")
@Scope(value="flow")
public class LiberarAcessoLaudoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -5374045224755385867L;
    private String usuarioOuCpfCnpj;
    private UsuarioEntity usuarioSelecionado;
    private List<TipoLaudoEntity> listaTipoLaudo = new ArrayList();
    private List<TipoLaudoEntity> tiposDeLaudosSelecionados = new ArrayList();

    public String getUsuarioOuCpfCnpj() {
        return this.usuarioOuCpfCnpj;
    }

    public void setUsuarioOuCpfCnpj(String usuarioOuCpfCnpj) {
        this.usuarioOuCpfCnpj = usuarioOuCpfCnpj;
    }

    public UsuarioEntity getUsuarioSelecionado() {
        return this.usuarioSelecionado;
    }

    public void setUsuarioSelecionado(UsuarioEntity usuarioSelecionado) {
        this.usuarioSelecionado = usuarioSelecionado;
    }

    public List<TipoLaudoEntity> getListaTipoLaudo() {
        return this.listaTipoLaudo;
    }

    public List<TipoLaudoEntity> getTiposDeLaudosSelecionados() {
        return this.tiposDeLaudosSelecionados;
    }

    public void setTiposDeLaudosSelecionados(List<TipoLaudoEntity> tiposDeLaudosSelecionados) {
        this.tiposDeLaudosSelecionados = tiposDeLaudosSelecionados;
    }

    public void iniciar() throws BaseException {
        this.usuarioSelecionado = new UsuarioEntity();
        this.listaTipoLaudo = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getListaTipoLaudo();
    }

    public void pesquisar() throws BaseException {
        if (this.validarCampos()) {
            this.usuarioSelecionado = this.recuperarUsuario(this.usuarioOuCpfCnpj);
            this.preencherTiposLaudosDoUsuario();
        }
    }

    protected UsuarioEntity recuperarUsuario(String usuarioOuCpfCnpj) {
        UsuarioEntity usuario = null;
        try {
            usuario = ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).getUsuarioAlvaraLaudoByUsuarioCpfCnpj(usuarioOuCpfCnpj);
        }
        catch (BaseException e) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Usu\u00e1rio n\u00e3o localizado.");
        }
        return usuario;
    }

    protected void preencherTiposLaudosDoUsuario() {
        if (Objects.nonNull(this.usuarioSelecionado)) {
            this.tiposDeLaudosSelecionados = this.usuarioSelecionado.getTipoLaudos();
        }
    }

    protected boolean validarCampos() {
        if (EloStringUtils.isEmpty((String)this.usuarioOuCpfCnpj)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe o campo Usu\u00e1rio ou CPF/CNPJ.");
            return false;
        }
        return true;
    }

    public void salvar() {
        if (!EloListUtils.safeIsEmpty((List)this.usuarioSelecionado.getTipoLaudos()).booleanValue()) {
            this.usuarioSelecionado.getTipoLaudos().clear();
        } else {
            this.usuarioSelecionado.setTipoLaudos(new ArrayList());
        }
        this.usuarioSelecionado.getTipoLaudos().addAll(this.tiposDeLaudosSelecionados);
        try {
            this.usuarioSelecionado = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirUsuario(this.usuarioSelecionado);
            ShowMessage.addInfoMessage((String)"validacao", (String)"Permiss\u00f5es concedidas ao usu\u00e1rio.");
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("Erro ao salvar o usu\u00e1rio. " + e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void limparFormulario() {
        this.usuarioOuCpfCnpj = "";
        this.usuarioSelecionado = new UsuarioEntity();
        this.tiposDeLaudosSelecionados.clear();
    }
}

