/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ObservacaoRestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;

@EloController(value="liberacaoSolicitacaoAlvaraController")
@Scope(value="flow")
public class LiberacaoSolicitacaoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String solicitacao;
    private String protocolo;
    private List<RestricaoAlvaraEntity> listaRestricaoAlvara;
    private RestricaoAlvaraEntity restricaoAlvaraSelecionada;
    private List<PessoaEntity> listaPessoasCadastradas;
    private PessoaEntity pessoaCadastradaSelecionada;
    private boolean renderRestricaoPessoaDuplic;
    private String observacao;

    public boolean isRenderRestricaoPessoaDuplic() {
        return this.renderRestricaoPessoaDuplic;
    }

    public void setRenderRestricaoPessoaDuplic(boolean renderRestricaoPessoaDuplic) {
        this.renderRestricaoPessoaDuplic = renderRestricaoPessoaDuplic;
    }

    public PessoaEntity getPessoaCadastradaSelecionada() {
        return this.pessoaCadastradaSelecionada;
    }

    public void setPessoaCadastradaSelecionada(PessoaEntity pessoaCadastradaSelecionada) {
        this.pessoaCadastradaSelecionada = pessoaCadastradaSelecionada;
    }

    public List<PessoaEntity> getListaPessoasCadastradas() {
        return this.listaPessoasCadastradas;
    }

    public void setListaPessoasCadastradas(List<PessoaEntity> listaPessoasCadastradas) {
        this.listaPessoasCadastradas = listaPessoasCadastradas;
    }

    public RestricaoAlvaraEntity getRestricaoAlvaraSelecionada() {
        return this.restricaoAlvaraSelecionada;
    }

    public void setRestricaoAlvaraSelecionada(RestricaoAlvaraEntity restricaoAlvaraSelecionada) {
        this.restricaoAlvaraSelecionada = restricaoAlvaraSelecionada;
    }

    public String getSolicitacao() {
        return this.solicitacao;
    }

    public void setSolicitacao(String solicitacao) {
        this.solicitacao = solicitacao;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public List<RestricaoAlvaraEntity> getListaRestricaoAlvara() {
        return this.listaRestricaoAlvara;
    }

    public void setListaRestricaoAlvara(List<RestricaoAlvaraEntity> listaRestricaoAlvara) {
        this.listaRestricaoAlvara = listaRestricaoAlvara;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void pesquisarRestricao() {
        try {
            this.renderRestricaoPessoaDuplic = false;
            SolicitacaoAlvaraEntity solicitacaoSelecionada = null;
            if (!EloStringUtils.isEmpty((String)this.solicitacao) && !EloStringUtils.isEmpty((String)this.protocolo)) {
                ShowMessage.addWarnMessage((String)"msg", (String)"Informe somente um dos filtros.");
                return;
            }
            if (!EloStringUtils.isEmpty((String)this.solicitacao)) {
                String[] consulta = this.solicitacao.split("/");
                Long numeroConsulta = Long.valueOf(consulta[0]);
                Long exercicio = Long.valueOf(consulta[1]);
                solicitacaoSelecionada = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorCpfCnpjExercicioNumSolic(numeroConsulta, exercicio, null);
            } else if (!EloStringUtils.isEmpty((String)this.protocolo)) {
                List solicitacoesSelecionadas = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorProtocoloRedeSim(this.protocolo, Optional.of(TipoSolicitacaoRedeSimEnum.SOLICITACAO.getSigla()));
                if (!EloListUtils.safeIsEmpty((List)solicitacoesSelecionadas).booleanValue()) {
                    solicitacaoSelecionada = (SolicitacaoAlvaraEntity)solicitacoesSelecionadas.get(0);
                }
            } else {
                ShowMessage.addWarnMessage((String)"msg", (String)"Digite o n\u00famero ou o protocolo de uma solicita\u00e7\u00e3o");
                return;
            }
            if (solicitacaoSelecionada != null) {
                this.listaRestricaoAlvara = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).carregaRestricaoForLiberacao(solicitacaoSelecionada.getSolicitacaoAlvara());
                if (EloListUtils.safeIsEmpty((List)this.listaRestricaoAlvara).booleanValue()) {
                    ShowMessage.addInfoMessage((String)"msg", (String)"Nenhuma restri\u00e7\u00e3o encontrada para a solicita\u00e7\u00e3o informada.");
                }
            } else {
                ShowMessage.addInfoMessage((String)"msg", (String)"Nenhuma solicita\u00e7\u00e3o encontrada.");
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void liberarSolicitacao(RestricaoAlvaraEntity restricaoAlvara) throws Exception {
        try {
            if ("S".equals(restricaoAlvara.getAutorizado())) {
                ShowMessage.addWarnMessage((String)"msg", (String)String.format("%s%s", "A Solicita\u00e7\u00e3o j\u00e1 foi Autorizada por ", restricaoAlvara.getUsuario()));
            } else if (restricaoAlvara.getCadastroRestricaoAlvara().getIdRestricao().equals(PortalUtils.getCodRestricaocadPessoaJaExistente())) {
                this.abrirDetalhes(restricaoAlvara);
            } else {
                this.liberarDefinitivo(restricaoAlvara);
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu uma Falha. N\u00e3o foi poss\u00edvel liberar a Solicita\u00e7\u00e3o.");
            throw new Exception("Ocorreu uma Falha. N\u00e3o foi poss\u00edvel liberar a Solicita\u00e7\u00e3o.", e.getCause());
        }
    }

    private void liberarDefinitivo(RestricaoAlvaraEntity restricaoAlvara) throws BaseException {
        UsuarioEntity usuarioConectado = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (this.usuarioPossuiPermissao(restricaoAlvara, usuarioConectado)) {
            restricaoAlvara.setAutorizado("S");
            restricaoAlvara.setUsuario(usuarioConectado.getUsuario());
            restricaoAlvara.setDataAutorizacao(new Date());
            ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).atualizaRestricaoAlvara(restricaoAlvara);
            RequestContext.getCurrentInstance().update("message");
        } else {
            ShowMessage.addWarnMessage((String)"msg", (String)"Usu\u00e1rio n\u00e3o tem permiss\u00e3o para Liberar esta restri\u00e7\u00e3o");
        }
    }

    private boolean usuarioPossuiPermissao(RestricaoAlvaraEntity restricaoAlvara, UsuarioEntity usuarioConectado) {
        return restricaoAlvara.getCadastroRestricaoAlvara().getUsuarios().contains(usuarioConectado);
    }

    private void abrirDetalhes(RestricaoAlvaraEntity restricao) {
        this.restricaoAlvaraSelecionada = restricao;
        if (restricao.getCadastroRestricaoAlvara().getIdRestricao().equals(PortalUtils.getCodRestricaocadPessoaJaExistente())) {
            this.renderRestricaoPessoaDuplic = true;
            try {
                this.listaPessoasCadastradas = new ArrayList();
                this.pessoaCadastradaSelecionada = null;
                this.listaPessoasCadastradas = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaPessoasPorCpfCnpj(restricao.getCampoVerificacao());
                RequestContext.getCurrentInstance().execute("dialogDetalhes.show()");
                RequestContext.getCurrentInstance().update("@form");
            }
            catch (BaseException e) {
                ShowMessage.addErrorMessage((String)"msgDialog", (String)"Ocorreu uma Falha na consulta de Pessoas");
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void salvarPessoaSelecionada() {
        try {
            this.restricaoAlvaraSelecionada.setPessoa(this.pessoaCadastradaSelecionada);
            this.liberarDefinitivo(this.restricaoAlvaraSelecionada);
            RequestContext.getCurrentInstance().execute("dialogDetalhes.hide()");
            this.renderRestricaoPessoaDuplic = false;
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)String.format("%s%s", "Ocorreu uma falha :", e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void fecharDialogDetalhes() {
        this.renderRestricaoPessoaDuplic = false;
    }

    public boolean liberado(RestricaoAlvaraEntity restricao) {
        return "S".equalsIgnoreCase(restricao.getAutorizado());
    }

    public void abrirDialogObservacao(RestricaoAlvaraEntity restricao) {
        this.restricaoAlvaraSelecionada = restricao;
        RequestContext.getCurrentInstance().update("dlgObservacao");
        RequestContext.getCurrentInstance().execute("dialogObservacao.show();");
    }

    private void salvarObservacao() {
        try {
            ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).atualizaRestricaoAlvara(this.restricaoAlvaraSelecionada);
            ShowMessage.addInfoMessage((String)"msgObservacao", (String)"Observa\u00e7\u00e3o inserida com sucesso!");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)"Falha ao salvar a observa\u00e7\u00e3o");
        }
    }

    public void adicionarObservacaoRestricao() {
        if (!EloStringUtils.isEmpty((String)this.observacao)) {
            ObservacaoRestricaoAlvaraEntity observacaoRestricaoAlvara = new ObservacaoRestricaoAlvaraEntity();
            observacaoRestricaoAlvara.setDescricao(this.observacao);
            observacaoRestricaoAlvara.setIdRestricaoAlvara(this.restricaoAlvaraSelecionada);
            UsuarioEntity usuarioLogado = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            observacaoRestricaoAlvara.setUsuario(usuarioLogado);
            observacaoRestricaoAlvara.setDataObservacao(new Date());
            this.restricaoAlvaraSelecionada.getObservacoes().add(observacaoRestricaoAlvara);
            this.salvarObservacao();
            this.observacao = "";
            Object var1_1 = null;
        } else {
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)"Por favor, preencha o campo Observa\u00e7\u00e3o");
        }
    }
}

