/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.HistoricoRenovacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.HistoricoRenovacaoVo;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.filter.FiltroHistoricoRenovacao;
import br.com.elotech.report.DataSet;
import br.com.elotech.report.Parameter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;

@EloController(value="historicoRenovacaoController")
@Scope(value="flow")
public class HistoricoRenovacaoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 4247613984292024161L;
    private FiltroHistoricoRenovacao filtro;
    private List<HistoricoRenovacaoAlvaraEntity> renovacoes;
    private byte[] relatorio;
    @Resource
    private EntidadeController entidadeController;
    private StringBuilder filtrosUsados;

    public FiltroHistoricoRenovacao getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroHistoricoRenovacao filtro) {
        this.filtro = filtro;
    }

    public List<HistoricoRenovacaoAlvaraEntity> getRenovacoes() {
        if (this.renovacoes == null) {
            this.renovacoes = new ArrayList();
        }
        return this.renovacoes;
    }

    public void setRenovacoes(List<HistoricoRenovacaoAlvaraEntity> renovacoes) {
        this.renovacoes = renovacoes;
    }

    public byte[] getRelatorio() {
        return this.relatorio;
    }

    public void setRelatorio(byte[] relatorio) {
        this.relatorio = relatorio;
    }

    public void iniciar() {
        this.filtro = new FiltroHistoricoRenovacao();
    }

    public void buscarRenovacoes() throws BaseException {
        this.renovacoes.clear();
        if (this.filtro.isConsultaValida()) {
            this.renovacoes = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarHistoricoRenovacao(this.filtro);
        }
    }

    public void limparFormulario() {
        this.filtro = new FiltroHistoricoRenovacao();
        this.renovacoes.clear();
    }

    public void imprimirHistorico() throws Exception {
        try {
            this.montarFiltrosUsados();
            DataSet dataSet = new DataSet(HistoricoRenovacaoVo.class);
            HashMap params = new HashMap();
            String relatorioJasper = "RelatorioHistoricoRenovacao.jasper";
            this.montarDataSet(dataSet);
            this.adicionarParametros(params);
            this.relatorio = ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).imprimeRelatorio(relatorioJasper, dataSet, null, params);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Falha ao imprimir o relat\u00f3rio.");
        }
    }

    private void adicionarParametros(Map<String, Parameter> params) throws BaseException {
        ByteArrayInputStream inputStreamBrasao = new ByteArrayInputStream(this.entidadeController.getEntidade().getBrasao());
        params.put("brasao", new Parameter((Object)inputStreamBrasao));
        params.put("entidade", new Parameter((Object)this.entidadeController.getEntidade().getNome()));
        params.put("filtros", new Parameter((Object)this.filtrosUsados.toString()));
        params.put("nome_secretaria", new Parameter((Object)UtilsController.getNomeSecretaria()));
    }

    private void montarDataSet(DataSet dataSet) {
        for (HistoricoRenovacaoAlvaraEntity renovacao : this.renovacoes) {
            HistoricoRenovacaoVo vo = new HistoricoRenovacaoVo.HistoricoRenovacaoBuilder().cadastroImobiliario(renovacao.getSolicitacaoAlvara().getCadastroImobiliario().getId().getCodigo()).dataRenovacao(renovacao.getDataInclusao()).dataSolicitacao(renovacao.getSolicitacaoAlvara().getDataSolicitacao()).descricao(renovacao.getDescricao()).numeroSolicitacaoExercicio(renovacao.getSolicitacaoAlvara().getNumeroSolicitacaoExercicio()).usuario(renovacao.getUsuario().getUsuario()).build();
            dataSet.add((Object)vo);
        }
    }

    private void montarFiltrosUsados() {
        this.filtrosUsados = new StringBuilder("<b>Filtros:</b> ");
        if (!EloStringUtils.isEmpty((String)this.filtro.getNumeroSolicitacaoExercicio())) {
            this.filtrosUsados.append("<b>N\u00b0 da Solicita\u00e7\u00e3o:</b> ").append(this.filtro.getNumeroSolicitacaoExercicio()).append(" ");
        }
        if (this.filtro.getDataInicialSolicitacao() != null) {
            this.filtrosUsados.append("<b>Data Inicial da Solicita\u00e7\u00e3o:</b> ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getDataInicialSolicitacao(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getDataFinalSolicitacao() != null) {
            this.filtrosUsados.append("<b>Data Final da Solicita\u00e7\u00e3o:</b> ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getDataFinalSolicitacao(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getDataInicialRenovacao() != null) {
            this.filtrosUsados.append("<b>Data Inicial da Renova\u00e7\u00e3o:</b> ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getDataInicialRenovacao(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getDataFinalRenovacao() != null) {
            this.filtrosUsados.append("<b>Data Final da Renova\u00e7\u00e3o:</b> ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getDataFinalRenovacao(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getCodigoCadastroImobiliario() != null) {
            this.filtrosUsados.append("<b>Cadastro Imobili\u00e1rio:</b> ").append(this.filtro.getCodigoCadastroImobiliario());
        }
    }

    public StreamedContent downloadRelatorio() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.relatorio);
        String nomeRelatorio = "HISTORICO_RENOVACAO_" + EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd-MM-yyyy");
        return new DefaultStreamedContent((InputStream)stream, "application/pdf", nomeRelatorio + ".pdf");
    }
}

