/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.dataModel.FilaRecebimentoDataModel;
import br.com.elotech.portalarrecadacao.controller.dataModel.FilaRecebimentoProcessadaDataModel;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoProcessadaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaFilaRecebimentoProcessRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoProcessamentoFilaRecebimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoFilaRecebimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.primefaces.component.tabview.TabView;
import org.primefaces.context.RequestContext;
import org.primefaces.event.TabChangeEvent;
import org.springframework.context.annotation.Scope;

@EloController(value="filaRecebimentoProcessadaRedeSimController")
@Scope(value="flow")
public class FilaRecebimentoProcessadaRedeSimController
extends EloLogger
implements Serializable {
    private Integer indiceAbas = 0;
    private FiltroConsultaFilaRecebimentoProcessRedeSim filtro;
    private final List<TipoFilaRecebimentoRedeSimEnum> tipos = new ArrayList();
    private final List<SituacaoProcessamentoFilaRecebimentoRedeSimEnum> situacoes = new ArrayList();
    private FilaRecebimentoProcessadaDataModel filaRecebimentoProcessadaDataModel;
    private FilaRecebimentoDataModel filaRecebimentoDataModel;
    private String observacao;
    private String requisicao;

    public void iniciar() throws BaseException {
        this.filtro = new FiltroConsultaFilaRecebimentoProcessRedeSim();
        this.preencheTipos();
        this.preencheSituacoes();
        this.pesquisar();
    }

    public void limparFiltro() {
        this.filtro = new FiltroConsultaFilaRecebimentoProcessRedeSim();
        this.pesquisar();
    }

    public void preencheTipos() {
        this.tipos.clear();
        this.tipos.addAll(Arrays.asList(TipoFilaRecebimentoRedeSimEnum.values()));
    }

    public void preencheSituacoes() {
        this.situacoes.clear();
        this.situacoes.addAll(Arrays.asList(SituacaoProcessamentoFilaRecebimentoRedeSimEnum.values()));
    }

    public void pesquisar() {
        try {
            if (this.indiceAbas.compareTo(0) == 0) {
                this.setFilaRecebimentoProcessadaDataModel(new FilaRecebimentoProcessadaDataModel(this.filtro));
            } else {
                this.setFilaRecebimentoDataModel(new FilaRecebimentoDataModel(this.filtro));
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("%s%s", "Ocorreu uma falha na pesquisa", ex.getMessage()));
        }
    }

    public void abrirDialogObservacaoProcessada(FilaRecebimentoProcessadaRedeSimEntity registro) {
        this.setObservacao(registro.getObservacao());
        RequestContext.getCurrentInstance().execute("dlgObservacao.show()");
    }

    public void abrirDialogRequisicaoProcessada(FilaRecebimentoProcessadaRedeSimEntity registro) {
        this.setRequisicao(registro.getRequest());
        RequestContext.getCurrentInstance().execute("dlgRequisicao.show()");
    }

    public void abrirDialogRequisicao(FilaRecebimentoRedeSimEntity registro) {
        this.setRequisicao(registro.getRequest());
        RequestContext.getCurrentInstance().execute("dlgRequisicao.show()");
    }

    public void trocarAba(TabChangeEvent event) {
        TabView tabView = (TabView)event.getComponent();
        this.setIndiceAbas(Integer.valueOf(tabView.getActiveIndex()));
        this.limparFiltro();
    }

    public Integer getIndiceAbas() {
        return this.indiceAbas;
    }

    public void setIndiceAbas(Integer indiceAbas) {
        this.indiceAbas = indiceAbas;
    }

    public FiltroConsultaFilaRecebimentoProcessRedeSim getFiltro() {
        return this.filtro;
    }

    public List<TipoFilaRecebimentoRedeSimEnum> getTipos() {
        return this.tipos;
    }

    public List<SituacaoProcessamentoFilaRecebimentoRedeSimEnum> getSituacoes() {
        return this.situacoes;
    }

    public void setFilaRecebimentoProcessadaDataModel(FilaRecebimentoProcessadaDataModel filaRecebimentoProcessadaDataModel) {
        this.filaRecebimentoProcessadaDataModel = filaRecebimentoProcessadaDataModel;
    }

    public FilaRecebimentoProcessadaDataModel getFilaRecebimentoProcessadaDataModel() {
        return this.filaRecebimentoProcessadaDataModel;
    }

    public void setFilaRecebimentoDataModel(FilaRecebimentoDataModel filaRecebimentoDataModel) {
        this.filaRecebimentoDataModel = filaRecebimentoDataModel;
    }

    public FilaRecebimentoDataModel getFilaRecebimentoDataModel() {
        return this.filaRecebimentoDataModel;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setRequisicao(String requisicao) {
        this.requisicao = requisicao;
    }

    public String getRequisicao() {
        return this.requisicao;
    }
}

