/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exception.ConstraintException;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.filter.FiltroExigenciaRedeSim;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.io.Serializable;
import java.util.List;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@EloController(value="exigenciaRedeSimController")
@Scope(value="flow")
public class ExigenciaRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ExigenciaRedeSimEntity> exigenciasRedeSim;
    private ExigenciaRedeSimEntity exigenciaRedeSim;
    private FiltroExigenciaRedeSim filtro;

    public List<ExigenciaRedeSimEntity> getExigenciasRedeSim() {
        return this.exigenciasRedeSim;
    }

    public void setExigenciasRedeSim(List<ExigenciaRedeSimEntity> exigenciasRedeSim) {
        this.exigenciasRedeSim = exigenciasRedeSim;
    }

    public ExigenciaRedeSimEntity getExigenciaRedeSim() {
        return this.exigenciaRedeSim;
    }

    public void setExigencia(ExigenciaRedeSimEntity exigenciaRedeSim) {
        this.exigenciaRedeSim = exigenciaRedeSim;
    }

    public FiltroExigenciaRedeSim getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroExigenciaRedeSim filtro) {
        this.filtro = filtro;
    }

    public void pesquisarExigenciasRedeSim() {
        try {
            this.exigenciasRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getExigenciasRedeSim(this.filtro);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel buscar as Exig\u00eancias da Rede Sim. Entre em contato com o suporte.");
        }
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroExigenciaRedeSim();
        this.pesquisarExigenciasRedeSim();
        this.exigenciaRedeSim = null;
    }

    public void novaExigenciaRedeSim() {
        this.exigenciaRedeSim = new ExigenciaRedeSimEntity();
        this.exigenciaRedeSim.setAtivo(SimNaoEnum.getSimShortText());
    }

    public void editarExigenciaRedeSim(ExigenciaRedeSimEntity exigencia) {
        this.exigenciaRedeSim = exigencia;
    }

    public void salvarExigenciaRedeSim() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarExigenciaRedeSim(this.exigenciaRedeSim);
            ShowMessage.addInfoMessage((String)"msg", (String)"Exig\u00eancia salva com sucesso.");
            this.iniciar();
            RequestContext.getCurrentInstance().execute("dialogNovaExigencia.hide();");
        }
        catch (ValidacaoException ve) {
            ShowMessage.addErrorMessages((String)"msgDialog", (List)ve.getMensagens());
            this.logger.error((Object)ve.getMessage(), (Throwable)ve);
        }
        catch (ConstraintException ce) {
            ShowMessage.addErrorMessage((String)"msgDialog", (String)"O c\u00f3digo informado j\u00e1 existe.");
            this.logger.error((Object)ce.getMessage(), (Throwable)ce);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msgDialog", (String)"Ocorreu uma falha ao salvar a exig\u00eancia. Entre em contato com o Suporte.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void removerExigenciaRedeSim(ExigenciaRedeSimEntity exigencia) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).removerExigenciaRedeSim(exigencia);
            ShowMessage.addInfoMessage((String)"msg", (String)"Exig\u00eancia exclu\u00edda com sucesso.");
            this.iniciar();
        }
        catch (ConstraintException ce) {
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o \u00e9 poss\u00edvel deletar uma Exig\u00eancia que j\u00e1 esteja sendo utilizada.");
            this.logger.error((Object)ce.getMessage(), (Throwable)ce);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu uma falha ao tentar remover a exig\u00eancia. Entre em contato com o Suporte.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public SimNaoEnum[] simNaoEnum() {
        return SimNaoEnum.values();
    }
}

