/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.filter.FiltroEventoRedeSim;
import br.com.elotech.spring.SpringContext;
import java.io.Serializable;
import java.util.List;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@EloController(value="eventoRedeSimController")
@Scope(value="flow")
public class EventoRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 5247027928968268865L;
    private List<EventoRedeSimEntity> eventosRedeSim;
    private EventoRedeSimEntity evento;
    private FiltroEventoRedeSim filtro;

    public FiltroEventoRedeSim getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroEventoRedeSim filtro) {
        this.filtro = filtro;
    }

    public List<EventoRedeSimEntity> getEventosRedeSim() {
        return this.eventosRedeSim;
    }

    public void setEventosRedeSim(List<EventoRedeSimEntity> eventosRedeSim) {
        this.eventosRedeSim = eventosRedeSim;
    }

    public EventoRedeSimEntity getEvento() {
        return this.evento;
    }

    public void setEvento(EventoRedeSimEntity evento) {
        this.evento = evento;
    }

    public List<EventoRedeSimEntity> buscarEventosRedeSim() throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarEventosRedeSim(this.filtro);
    }

    public Boolean existeEvento(EventoRedeSimEntity evento) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).existeEvento(evento);
    }

    public void removerEvento() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).removerEventoRedeSim(this.evento);
            ShowMessage.addInfoMessage((String)"msg", (String)"Evento exclu\u00eddo com sucesso.");
            this.iniciar();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu uma falha ao deletar. Entre em contato com o Suporte.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void mostraConfirmDialog(EventoRedeSimEntity evento) {
        this.evento = evento;
        RequestContext.getCurrentInstance().execute("PF('confirmDialog').show()");
    }

    public void novoEvento() {
        this.evento = new EventoRedeSimEntity();
        this.evento.setEdicao(Boolean.valueOf(false));
    }

    public void editarEvento(EventoRedeSimEntity evento) {
        this.evento = evento;
        this.evento.setEdicao(Boolean.valueOf(true));
    }

    public void salvarEvento() throws BaseException {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarEvento(this.evento);
            this.iniciar();
            ShowMessage.addInfoMessage((String)"msg", (String)"Evento salvo com sucesso.");
        }
        catch (ValidacaoException e) {
            ShowMessage.addErrorMessages((String)"msg", (List)e.getMensagens());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu um erro ao tentar salvar o Evento. Entre em contato com o Suporte.");
        }
    }

    public void iniciar() throws BaseException {
        this.limparCampo();
    }

    public void limparCampo() throws BaseException {
        this.filtro = new FiltroEventoRedeSim();
        this.eventosRedeSim = this.buscarEventosRedeSim();
    }

    public void pesquisar() throws BaseException {
        this.eventosRedeSim = this.buscarEventosRedeSim();
    }
}

