/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.EstadosBrasilEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroGeralEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeEndereco;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.domain.CidadeEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.AtivoInativoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.type.elodate.EloDate;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloHashUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.primefaces.event.FlowEvent;
import org.springframework.context.annotation.Scope;

@EloController(value="criarUsuarioController")
@Scope(value="flow")
public class CriarUsuarioController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -5374045224755385867L;
    private AcessoWebEntity usuario;
    private Date dataNascimento;
    private String termoDeAceite;
    private boolean prefeituraValidaUsuario;
    private boolean liEConcordo;
    private String mensagemUsuarioSalvo;

    public AcessoWebEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(AcessoWebEntity usuario) {
        this.usuario = usuario;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
        this.usuario.setDataNascimento(dataNascimento != null ? EloDate.parseDate((Date)dataNascimento) : null);
    }

    public String getTermoDeAceite() {
        return this.termoDeAceite;
    }

    public boolean isLiEConcordo() {
        return this.liEConcordo;
    }

    public void setLiEConcordo(boolean liEConcordo) {
        this.liEConcordo = liEConcordo;
    }

    public String getMensagemUsuarioSalvo() {
        return this.mensagemUsuarioSalvo;
    }

    public void iniciar() throws BaseException {
        this.usuario = new AcessoWebEntity();
        this.usuario.setAcessoWebEmpresas(new ArrayList());
        this.usuario.setAcessoWebTipoPermissao(new ArrayList());
        String validaUsuario = UtilsController.getParametroGeralValor((Modulo)Modulo.ALVARAONLINE, (ParametroGeralEnum)ParametroGeralEnum.VALIDACRIACAOUSUARIO);
        this.prefeituraValidaUsuario = SimNaoEnum.SIM.getShortText().equals(validaUsuario);
    }

    private void montarTermoDeAceite() {
        try {
            ParametroAlvaraEntity termoParam = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TERMO_DE_USO);
            this.termoDeAceite = termoParam.getValor();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public EstadosBrasilEnum[] getEstados() {
        return EstadosBrasilEnum.values();
    }

    public List<CidadeEntity> completeCidade(String query) {
        List cidades = null;
        try {
            cidades = ((FacadeEndereco)SpringContext.getBean(FacadeEndereco.class)).getCidadesByUF(query, this.usuario.getUnidadeFederacao());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return cidades;
    }

    public String onFlowProcess(FlowEvent event) {
        String newStep = event.getNewStep();
        String oldStep = event.getOldStep();
        String pessoal = "tabPessoal";
        String endereco = "tabEndereco";
        String confirmacao = "tabConfirmacao";
        if (oldStep.equals(pessoal) && newStep.equals(endereco)) {
            if (this.validarDadosPessoais()) {
                return newStep;
            }
            return oldStep;
        }
        if (oldStep.equals(endereco) && newStep.equals(confirmacao)) {
            if (this.validarDadosEndereco()) {
                this.montarTermoDeAceite();
                return newStep;
            }
            return oldStep;
        }
        return newStep;
    }

    private boolean validarDadosPessoais() {
        boolean valido = true;
        if (EloStringUtils.isEmpty((String)this.usuario.getNome())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Nome \u00e9 obrigat\u00f3rio.");
        }
        if (this.usuario.getDataNascimento() == null) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Data de Nascimento \u00e9 obrigat\u00f3rio.");
        } else if (this.usuario.getDataNascimento().toDate().compareTo(new Date()) > 0) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"A Data de Nascimento n\u00e3o pode ser uma data futura.");
        }
        if (EloStringUtils.isEmpty((String)this.usuario.getEmail())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo E-mail \u00e9 obrigat\u00f3rio.");
        } else if (!UtilsController.validaEmail((String)this.usuario.getEmail())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe um e-mail v\u00e1lido.");
        }
        if (EloStringUtils.isEmpty((String)this.usuario.getCpf())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo CPF \u00e9 obrigat\u00f3rio.");
        } else if (this.isUsuarioExistente(this.usuario.getCpf())) {
            valido = false;
        }
        if (EloStringUtils.isEmpty((String)this.usuario.getSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Senha \u00e9 obrigat\u00f3rio.");
        } else if (this.usuario.getSenha().length() < 6 || this.usuario.getSenha().length() > 15) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"A senha deve possuir de 6 a 15 caracteres.");
        } else if (EloStringUtils.isEmpty((String)this.usuario.getConfirmacaoSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Confirmar Senha \u00e9 obrigat\u00f3rio.");
        } else if (!this.usuario.getSenha().equals(this.usuario.getConfirmacaoSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"As senhas informadas n\u00e3o conferem.");
        }
        return valido;
    }

    private boolean isUsuarioExistente(String cpf) {
        AcessoWebEntity usuarioAcessoWeb = null;
        try {
            UsuarioEntity usuario = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLogin(cpf);
            if (usuario == null && ((usuarioAcessoWeb = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLoginAcessoWeb(cpf)) == null || usuarioAcessoWeb.getId() == null)) {
                return false;
            }
            ShowMessage.addErrorMessage((String)"validacao", (String)"J\u00e1 existe um usu\u00e1rio cadastrado com o CPF informado.");
            return true;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao validar CPF existente");
            return false;
        }
    }

    private boolean validarDadosEndereco() {
        boolean valido = true;
        if (EloStringUtils.isEmpty((String)this.usuario.getCep()) || this.usuario.getCep().length() < 8) {
            valido = false;
            if (EloStringUtils.isEmpty((String)this.usuario.getCep())) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"O campo CEP \u00e9 obrigat\u00f3rio.");
            } else {
                ShowMessage.addErrorMessage((String)"validacao", (String)"O campo CEP deve conter 8 d\u00edgitos.");
            }
        }
        if (EloStringUtils.isEmpty((String)this.usuario.getEndereco())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Endere\u00e7o \u00e9 obrigat\u00f3rio.");
        }
        if (EloStringUtils.isEmpty((String)this.usuario.getBairro())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Bairro \u00e9 obrigat\u00f3rio.");
        }
        if (EloStringUtils.isEmpty((String)this.usuario.getUnidadeFederacao())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo UF \u00e9 obrigat\u00f3rio.");
        }
        if (this.usuario.getCidade() == null || this.usuario.getCidade().getId() == null) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Cidade \u00e9 obrigat\u00f3rio.");
        }
        return valido;
    }

    public void salvar() throws SolicitacaoAlvaraException {
        if (this.aceitouTermos() && !this.isUsuarioExistente(this.usuario.getCpf())) {
            if (this.prefeituraValidaUsuario) {
                this.usuario.setAtivo(AtivoInativoEnum.INATIVO.getShortText());
                this.usuario.setNotificado(SimNaoEnum.NAO.getShortText());
            } else {
                this.setPermissoesUsuario();
                this.usuario.setAtivo(AtivoInativoEnum.ATIVO.getShortText());
                this.usuario.setNotificado(SimNaoEnum.SIM.getShortText());
            }
            try {
                this.usuario.setSenha(EloHashUtils.hashMD5((String)EloStringUtils.build((Object[])new Object[]{this.usuario.getCpf(), ":", this.usuario.getSenha()})).toUpperCase());
                this.usuario = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirUsuario(this.usuario);
                this.montarMensagemUsuarioSalvo();
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                this.usuario.setSenha(this.usuario.getConfirmacaoSenha());
                ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu um erro ao salvar o usu\u00e1rio. Por favor, entre em contato com a Prefeitura: " + UtilsController.getEmailSetorAlvara()));
            }
        }
    }

    private void setPermissoesUsuario() {
        try {
            List permissoes = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).carregaListaAcessoWebTipoPermissaoPorModulo(new String[]{Modulo.ALVARAONLINE.toString()});
            this.usuario.getAcessoWebTipoPermissao().clear();
            this.usuario.getAcessoWebTipoPermissao().addAll(permissoes);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao inserir as permiss\u00f5es do usu\u00e1rio.");
        }
    }

    private void montarMensagemUsuarioSalvo() {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>Usu\u00e1rio cadastrado com sucesso!</b>");
        if (this.prefeituraValidaUsuario) {
            sb.append("</br></br>");
            sb.append("Entre em contato com a Prefeitura para pedir a libera\u00e7\u00e3o do usu\u00e1rio.");
        } else {
            sb.append("</br></br>");
            sb.append("O usu\u00e1rio est\u00e1 liberado para uso do sistema");
        }
        this.mensagemUsuarioSalvo = sb.toString();
    }

    public boolean aceitouTermos() {
        if (!this.liEConcordo) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Voc\u00ea deve ler e aceitar o termos para cria\u00e7\u00e3o do usu\u00e1rio.");
            return false;
        }
        return true;
    }
}

