/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.ConsultaCpfCnpjController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.Endereco;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeAlteracaoAtividades;
import br.com.elotech.portalarrecadacao.facade.FacadeBoletimImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeEnderecoCadastroAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.VisualizarLoteEnvio;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaGenericaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroAlvaraPK;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroTestadaEntity;
import br.com.elotech.tributacao.exception.CadastroImobiliarioException;
import br.com.elotech.tributacao.interfaces.Testada;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.primefaces.model.map.DefaultMapModel;
import org.primefaces.model.map.MapModel;
import org.springframework.context.annotation.Scope;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@EloController(value="cadastroImobiliarioController")
@Scope(value="flow")
public class ConsultaCadastroImobiliarioController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CadastroImobiliarioEntity cadastroImobiliario;
    private Long cadastroGeral;
    private Testada selectedTestada;
    private List<EnderecoCadastroAlvaraEntity> enderecos;
    private EnderecoCadastroAlvaraEntity endereco;
    private Boolean flagMostraEndereco = false;
    private MapModel mapModel;
    private Endereco selectedEndereco;
    private String mapCenter;
    private byte[] imagemWS;
    private boolean desabilitarBotaoAvancar = true;
    private boolean renderMap = false;
    private boolean renderMapGEO = false;
    private SolicitacaoAlvaraEntity solicitacao;
    @Resource
    private ConsultaCpfCnpjController consultaCpfCnpjController;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    private boolean naoEstabelecidoMunicipio;
    private boolean redeSim;
    private ParametroAlvaraEntity parametroCadastroImobiliarioParaNaoResidente;

    public void iniciar() {
        if (this.endereco == null) {
            this.cadastroGeral = null;
        }
        this.redeSim = false;
        try {
            this.parametroCadastroImobiliarioParaNaoResidente = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CADASTRO_IMOBILIARIO_PARA_NAO_RESIDENTE);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public SolicitacaoAlvaraEntity getSolicitacao() {
        return this.solicitacao;
    }

    public void setSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public boolean isRenderMapGEO() {
        return this.renderMapGEO;
    }

    public void setRenderMapGEO(boolean renderMapGEO) {
        this.renderMapGEO = renderMapGEO;
    }

    public boolean isRenderMap() {
        return this.renderMap;
    }

    public byte[] getImagemWS() {
        return this.imagemWS;
    }

    public void setImagemWS(byte[] imagemWS) {
        this.imagemWS = imagemWS;
    }

    public void setRenderMap(boolean renderMap) {
        this.renderMap = renderMap;
    }

    public EnderecoCadastroAlvaraEntity getEndereco() {
        return this.endereco;
    }

    public void setEndereco(EnderecoCadastroAlvaraEntity endereco) {
        this.endereco = endereco;
    }

    public boolean isNaoEstabelecidoMunicipio() {
        return this.naoEstabelecidoMunicipio;
    }

    public void setNaoEstabelecidoMunicipio(boolean naoEstabelecidoMunicipio) {
        this.naoEstabelecidoMunicipio = naoEstabelecidoMunicipio;
    }

    public void setRedeSim(boolean redeSim) {
        this.redeSim = redeSim;
    }

    public boolean isRedeSim() {
        return this.redeSim;
    }

    public ParametroAlvaraEntity getParametroCadastroImobiliarioParaNaoResidente() {
        return this.parametroCadastroImobiliarioParaNaoResidente;
    }

    public boolean mostrarCheckNaoEstabelecidoMunicipio() {
        return this.parametroCadastroImobiliarioParaNaoResidente != null && this.parametroCadastroImobiliarioParaNaoResidente.getValor() != null && this.solicitacaoAlvaraController != null && this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoCBO();
    }

    public List<EnderecoCadastroAlvaraEntity> complete(String query) {
        List enderecos = null;
        try {
            enderecos = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getCadastroImobiliarioPorEndereco(query);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return enderecos;
    }

    public void consultaCadastro() throws NumberFormatException, IOException {
        try {
            this.imagemWS = null;
            this.renderMapGEO = ((EntidadeController)SpringContext.getBean(EntidadeController.class)).getVerificaIntegradoGeo();
            this.cadastroImobiliario = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getCadastroImobiliarioPorCodigo(Long.valueOf(1L), this.getCadastroGeral());
            this.selectedTestada = null;
            this.desabilitarBotaoAvancar = true;
            if (this.cadastroImobiliario != null && this.cadastroImobiliario.getId() != null) {
                this.flagMostraEndereco = true;
                if (this.isTestadaGenerica()) {
                    if (!EloListUtils.safeIsEmpty((List)this.cadastroImobiliario.getTestadasGenericas()).booleanValue() && this.cadastroImobiliario.getTestadasGenericas().size() == 1) {
                        this.selectedTestada = (Testada)this.cadastroImobiliario.getTestadasGenericas().get(0);
                    }
                } else if (!EloListUtils.safeIsEmpty((List)this.cadastroImobiliario.getTestadas()).booleanValue() && this.cadastroImobiliario.getTestadas().size() == 1) {
                    this.selectedTestada = (Testada)this.cadastroImobiliario.getTestadas().get(0);
                    if (EloStringUtils.isEmpty((String)this.selectedTestada.getNumero()) && !EloStringUtils.isEmpty((String)this.cadastroImobiliario.getCadastroGeral().getNumero())) {
                        this.selectedTestada.setNumero(this.cadastroImobiliario.getCadastroGeral().getNumero());
                    }
                }
                if (this.selectedTestada != null) {
                    this.validarTestadaSelecionada(this.selectedTestada);
                }
                this.atualizarEnderecoCadastroAlvara();
                this.desabilitarBotaoAvancar = false;
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void atualizarEnderecoCadastroAlvara() throws BaseException {
        HashSet testadasComNumero = Sets.newHashSet();
        for (CadastroImobiliarioTestadaEntity testada : this.cadastroImobiliario.getTestadas()) {
            if (Strings.isNullOrEmpty((String)testada.getNumero()) || "0".equals(testada.getNumero())) continue;
            testadasComNumero.add(testada);
        }
        List enderecosCadastroAlvara = ((FacadeEnderecoCadastroAlvara)SpringContext.getBean(FacadeEnderecoCadastroAlvara.class)).getEnderecosPorCodigo(this.getCadastroGeral());
        if (Objects.nonNull(enderecosCadastroAlvara)) {
            ArrayList enderecosRemover = Lists.newArrayList();
            ArrayList enderecosSalvar = Lists.newArrayList();
            for (CadastroImobiliarioTestadaEntity testada : testadasComNumero) {
                EnderecoCadastroAlvaraEntity novoEndereco;
                List enderecos = enderecosCadastroAlvara.stream().filter(e -> Objects.nonNull(e) && e.getId().getCodigoLogradouro().equals(testada.getId().getLogradouroTestada().getLogradouro().getId().getLogradouro())).collect(Collectors.toList());
                if (enderecos.size() > 1) {
                    EnderecoCadastroAlvaraEntity enderecoDuplicado = (EnderecoCadastroAlvaraEntity)enderecos.stream().findFirst().get();
                    enderecosRemover.add(enderecoDuplicado);
                    novoEndereco = EnderecoCadastroAlvaraEntity.copiar((EnderecoCadastroAlvaraEntity)enderecoDuplicado);
                    novoEndereco.setNumero(testada.getNumero());
                    novoEndereco.atualizaEnderecoCompleto();
                    enderecosSalvar.add(novoEndereco);
                    continue;
                }
                if (enderecos.size() == 1) {
                    EnderecoCadastroAlvaraEntity enderecoAlteracao = (EnderecoCadastroAlvaraEntity)enderecos.stream().findFirst().get();
                    enderecoAlteracao.setNumero(testada.getNumero());
                    enderecoAlteracao.atualizaEnderecoCompleto();
                    enderecosSalvar.add(enderecoAlteracao);
                    continue;
                }
                LogradouroTestadaEntity logradouroTestada = testada.getId().getLogradouroTestada();
                novoEndereco = new EnderecoCadastroAlvaraEntity();
                EnderecoCadastroAlvaraPK pk = new EnderecoCadastroAlvaraPK();
                pk.setTipo(testada.getId().getCadastroImobiliario().getId().getTipo());
                pk.setCodigo(testada.getId().getCadastroImobiliario().getId().getCodigo());
                if (logradouroTestada.getLogradouro() == null) {
                    throw new SolicitacaoAlvaraException("Testada n\u00e3o possui Logradouro vinculado.");
                }
                pk.setCodigoLogradouro(logradouroTestada.getLogradouro().getId().getLogradouro());
                novoEndereco.setId(pk);
                if (testada.getId().getCadastroImobiliario().getCadastroGeral().getCep() != null) {
                    novoEndereco.setCep(Long.valueOf(testada.getId().getCadastroImobiliario().getCadastroGeral().getCep().longValue()));
                }
                novoEndereco.setCidade(logradouroTestada.getLogradouro().getId().getCidade().getDescricao());
                novoEndereco.setUnidadeFederacao(logradouroTestada.getLogradouro().getId().getCidade().getUnidadeFederacao().getId().getUnidadeFederacao());
                if (logradouroTestada.getLogradouro().getTipoLogradouro() != null) {
                    novoEndereco.setTipoLogradouro(logradouroTestada.getLogradouro().getTipoLogradouro().getDescricao());
                    novoEndereco.setLogradouro(logradouroTestada.getLogradouro().getDescricao());
                }
                if (testada.getId().getCadastroImobiliario().getCadastroGeral().getBairro() != null) {
                    novoEndereco.setBairro(testada.getId().getCadastroImobiliario().getCadastroGeral().getBairro().getDescricao());
                }
                novoEndereco.setComplemento(testada.getId().getCadastroImobiliario().getCadastroGeral().getComplemento());
                novoEndereco.setComplementoLote(testada.getId().getCadastroImobiliario().getComplementoLote());
                novoEndereco.setSetor(testada.getId().getCadastroImobiliario().getSetorDescr());
                novoEndereco.setQuadra(testada.getId().getCadastroImobiliario().getQuadraInscricaoCadastral());
                novoEndereco.setLote(testada.getId().getCadastroImobiliario().getLoteInscricaoCadastral());
                novoEndereco.setNumero(testada.getNumero());
                StringBuilder enderecoCompleto = new StringBuilder();
                enderecoCompleto.append(novoEndereco.getTipoLogradouro()).append(" ").append(novoEndereco.getLogradouro()).append(", ").append(novoEndereco.getNumero());
                if (!Strings.isNullOrEmpty((String)novoEndereco.getComplemento())) {
                    enderecoCompleto.append(String.format(", %s", novoEndereco.getComplemento()));
                }
                if (!Strings.isNullOrEmpty((String)novoEndereco.getComplementoLote())) {
                    enderecoCompleto.append(String.format(", %s", novoEndereco.getComplementoLote()));
                }
                novoEndereco.setEnderecoCompleto(enderecoCompleto.toString());
                enderecosSalvar.add(novoEndereco);
            }
            for (EnderecoCadastroAlvaraEntity endereco : enderecosRemover) {
                ((FacadeEnderecoCadastroAlvara)SpringContext.getBean(FacadeEnderecoCadastroAlvara.class)).excluir(endereco);
            }
            for (EnderecoCadastroAlvaraEntity endereco : enderecosSalvar) {
                ((FacadeEnderecoCadastroAlvara)SpringContext.getBean(FacadeEnderecoCadastroAlvara.class)).salvar(endereco);
            }
        }
    }

    public void consultaCadastroPorLogradouro() throws NumberFormatException, IOException {
        if (this.endereco != null) {
            this.cadastroGeral = this.endereco.getId().getCodigo();
            this.consultaCadastro();
            this.flagMostraEndereco = true;
        } else {
            ShowMessage.addErrorMessage((String)"msg", (String)"Selecione um Endere\u00e7o");
        }
    }

    public Boolean getFlagMostraEndereco() {
        return this.flagMostraEndereco;
    }

    public void setFlagMostraEndereco(Boolean flag) {
        this.flagMostraEndereco = flag;
    }

    public List<EnderecoCadastroAlvaraEntity> getEnderecos() {
        if (this.enderecos == null) {
            this.enderecos = new ArrayList();
        }
        return this.enderecos;
    }

    public void setEnderecos(List<EnderecoCadastroAlvaraEntity> enderecos) {
        this.enderecos = enderecos;
    }

    public MapModel getMapModel() {
        if (this.mapModel == null) {
            this.mapModel = new DefaultMapModel();
        }
        return this.mapModel;
    }

    public void setMapModel(MapModel mapModel) {
        this.mapModel = mapModel;
    }

    public Endereco getSelectedEndereco() {
        return this.selectedEndereco;
    }

    public void setSelectedEndereco(Endereco selectedEndereco) {
        this.selectedEndereco = selectedEndereco;
    }

    public String getMapCenter() {
        return this.mapCenter;
    }

    public void setMapCenter(String mapCenter) {
        this.mapCenter = mapCenter;
    }

    public CadastroImobiliarioEntity getCadastroImobiliario() {
        return this.cadastroImobiliario;
    }

    public void setCadastroImobiliario(CadastroImobiliarioEntity cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Testada getSelectedTestada() {
        return this.selectedTestada;
    }

    public void setSelectedTestada(Testada selectedTestada) {
        if (selectedTestada != null) {
            this.selectedTestada = selectedTestada;
        }
    }

    public boolean isDesabilitarBotaoAvancar() {
        return this.desabilitarBotaoAvancar;
    }

    public void setDesabilitarBotaoAvancar(boolean desabilitarBotaoAvancar) {
        this.desabilitarBotaoAvancar = desabilitarBotaoAvancar;
    }

    private EnderecoCadastroGeralEntity buscaEnderecoPrincipal() throws BaseException {
        return ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getBuscaEnderecoImobiliarioPrincipal(this.cadastroImobiliario.getId().getCodigo());
    }

    public Boolean mostraConsultaImobiliario() {
        ConsultaCpfCnpjController consultaCpfCnpjController = (ConsultaCpfCnpjController)SpringContext.getBean(ConsultaCpfCnpjController.class);
        return consultaCpfCnpjController.isCheckBoxNaturezaInicial() || consultaCpfCnpjController.isNaturezaMudancaEnd();
    }

    public String avancar() throws BaseException {
        try {
            if (this.getCadastroImobiliario() == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um cadastro imobili\u00e1rio.");
                return null;
            }
            if (this.getSelectedTestada() == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um logradouro");
                return null;
            }
            if (this.naoEstabelecidoMunicipio) {
                this.selecionarCadastroImobiliarioParaNaoResidenteNoMunicipio();
            }
            this.solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
            this.validarCadastroImobiliario();
            this.validarTestadaSelecionada();
            this.solicitacao.setCadastroImobiliario(this.cadastroImobiliario);
            if (this.isTestadaGenerica()) {
                this.solicitacao.setImobiliarioTestadaGenerica((CadastroImobiliarioTestadaGenericaEntity)this.selectedTestada);
            } else {
                this.solicitacao.setImobiliarioTestada((CadastroImobiliarioTestadaEntity)this.selectedTestada);
            }
            this.solicitacao.setEnderecoImobiliarioPrincipal(this.buscaEnderecoPrincipal());
            ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemCadastroImobiliario(null);
            this.imagemWS = null;
            this.validarSegmentoImobiliario();
            this.verificarAtividadesExistentesParaNovoEndereco(this.solicitacao);
            this.limparInformacoesCadastroImobiliario();
            return "toinformacaoAtividade";
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private void validarSegmentoImobiliario() throws BaseException {
        boolean valida = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).validaSegmentoImobiliario(this.solicitacao);
        if (!valida) {
            throw new CadastroImobiliarioException("Im\u00f3vel n\u00e3o residencial, portanto n\u00e3o permitido para a inscri\u00e7\u00e3o pleiteada.");
        }
    }

    private void validarTestadaSelecionada() throws CadastroImobiliarioException {
        if (this.selectedTestada == null) {
            throw new CadastroImobiliarioException("Selecione um logradouro para continuar.");
        }
    }

    public void selecionarCadastroImobiliarioParaNaoResidenteNoMunicipio() throws BaseException {
        if (!EloStringUtils.isEmpty((String)this.parametroCadastroImobiliarioParaNaoResidente.getValor())) {
            Number codigoCadastroImobiliario = EloNumberUtils.safeStringToNumber((String)this.parametroCadastroImobiliarioParaNaoResidente.getValor());
            if (codigoCadastroImobiliario == null) {
                throw new CadastroImobiliarioException(String.format("O cadastro imobili\u00e1rio configurado no par\u00e2metro %s est\u00e1 com valor incorreto.", ParametroAlvaraEnum.CADASTRO_IMOBILIARIO_PARA_NAO_RESIDENTE.name()));
            }
            this.cadastroImobiliario = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getCadastroImobiliarioPorCodigo(Long.valueOf(1L), Long.valueOf(codigoCadastroImobiliario.longValue()));
            this.selecionarTestadaParaNaoResidenteNoMunicipio();
        }
    }

    private void selecionarTestadaParaNaoResidenteNoMunicipio() throws CadastroImobiliarioException {
        if (this.cadastroImobiliario == null) {
            throw new CadastroImobiliarioException(String.format("O cadastro imobili\u00e1rio configurado no par\u00e2metro %s n\u00e3o foi encontrado.", ParametroAlvaraEnum.CADASTRO_IMOBILIARIO_PARA_NAO_RESIDENTE.name()));
        }
        this.selectedTestada = this.cadastroImobiliario.getTestadaPrincipalOuPrimeira();
        if (this.selectedTestada == null) {
            throw new CadastroImobiliarioException(String.format("O cadastro imobili\u00e1rio configurado no par\u00e2metro %s n\u00e3o possui testada.", ParametroAlvaraEnum.CADASTRO_IMOBILIARIO_PARA_NAO_RESIDENTE.name()));
        }
    }

    private void validarCadastroImobiliario() throws BaseException {
        if (this.cadastroImobiliario == null || this.cadastroImobiliario.getId() == null) {
            throw new CadastroImobiliarioException("Informe o cadastro imobili\u00e1rio.");
        }
        if (this.cadastroImobiliario.getCadastroGeral().isBairroNull()) {
            throw new CadastroImobiliarioException("O cadastro imobili\u00e1rio n\u00e3o possui informa\u00e7\u00e3o de bairro. Favor entrar em contato com o Setor de Alvar\u00e1, email:" + UtilsController.getEmailSetorAlvara());
        }
        if (this.possuiRestricaoIsencao(this.cadastroImobiliario)) {
            throw new CadastroImobiliarioException("O Cadastro Imobili\u00e1rio selecionado n\u00e3o \u00e9 v\u00e1lido para Solicita\u00e7\u00e3o de Alvar\u00e1!");
        }
        this.validarBoletimCadastroNaoAutorizadoParaEmitirAlvara();
    }

    private void validarBoletimCadastroNaoAutorizadoParaEmitirAlvara() throws BaseException {
        if (this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
            ((FacadeBoletimImobiliario)SpringContext.getBean(FacadeBoletimImobiliario.class)).validarBoletimCadastroNaoAutorizadoParaEmitirAlvara(this.cadastroImobiliario);
        }
    }

    private boolean possuiRestricaoIsencao(CadastroImobiliarioEntity cadastroImobiliario) throws CadastroImobiliarioException {
        try {
            boolean existeRestricao = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).verificaRestricaoIsencaoImobiliario(cadastroImobiliario);
            return existeRestricao;
        }
        catch (BaseException e) {
            throw new CadastroImobiliarioException("Erro na verifica\u00e7\u00e3o de isen\u00e7\u00e3o do cadastro imobili\u00e1rio");
        }
    }

    private void verificarAtividadesExistentesParaNovoEndereco(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.isNaturezaMudancaEndereco() && !solicitacao.isNaturezaAlteracaoAtividade()) {
            ConsultaAtividadeVo consultaAtividadeVo = new ConsultaAtividadeVo();
            consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
            ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarTabelaAtividadesAtuais(consultaAtividadeVo);
            if (!EloListUtils.safeIsEmpty((List)consultaAtividadeVo.getListaAtiv()).booleanValue()) {
                solicitacao.setSolicitacaoAlvaraAtividades(new ArrayList());
                solicitacao.getSolicitacaoAlvaraAtividades().addAll(((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).atribuiValoresSolicitacaoAtividade(solicitacao, consultaAtividadeVo.getListaAtiv()));
            }
        }
    }

    public void rowEvent() throws NumberFormatException, IOException, BaseException {
        Testada testada = this.selectedTestada;
        if (this.renderMapGEO) {
            this.validarImobiliarioGeo(testada);
        }
        this.validarTestadaSelecionada(testada);
    }

    private void validarImobiliarioGeo(Testada testada) {
        if (Objects.nonNull(this.selectedTestada.getNumero()) && !EloStringUtils.isEmpty((String)this.selectedTestada.getNumero()) && !this.selectedTestada.getNumero().equals("S/N")) {
            VisualizarLoteEnvio envio = new VisualizarLoteEnvio();
            Long codImobiliario = testada.getId().getCadastroImobiliario().getCadastroGeral().getId().getCodigo();
            envio.setCadastroImobiliario(codImobiliario.toString());
            envio.setCodigoLogradouro(Integer.valueOf(testada.getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().intValue()));
            envio.setNumeroPredial(Integer.valueOf(Integer.parseInt(this.selectedTestada.getNumero())));
            try {
                this.imagemWS = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).carregarImagemImobiliarioPorWS(envio);
                ByteArrayInputStream bais = new ByteArrayInputStream(this.imagemWS);
                ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemCadastroImobiliario((StreamedContent)new DefaultStreamedContent((InputStream)bais, "image/jpeg"));
                this.desabilitarBotaoAvancar = false;
            }
            catch (BaseException e) {
                ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemCadastroImobiliario((StreamedContent)new DefaultStreamedContent());
                ShowMessage.addWarnMessage((String)"msg", (String)"O Mapa deste cadastro n\u00e3o existe ou n\u00e3o foi encontrado!");
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validarTestadaSelecionada(Testada testada) throws BaseException {
        ArrayList<String> errosCadastroImobiliario = new ArrayList<String>();
        if (Objects.isNull(testada.getNumero()) || EloStringUtils.isEmpty((String)testada.getNumero())) {
            errosCadastroImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'N\u00famero'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
        }
        if (testada.getLogradouro() == null || EloStringUtils.isEmpty((String)testada.getLogradouro().getDescricao())) {
            errosCadastroImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'Logradouro'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
        }
        if (this.cadastroImobiliario.getCadastroGeral().getBairro() == null || EloStringUtils.isEmpty((String)this.cadastroImobiliario.getCadastroGeral().getBairro().getDescricao())) {
            errosCadastroImobiliario.add("Cadastro com informa\u00e7\u00f5es ausentes: 'Bairro'. Favor entrar em contato com a prefeitura informando o C\u00f3digo do Imobili\u00e1rio para regulariza\u00e7\u00e3o!");
        }
        if (!this.isTestadaGenerica()) {
            if (Objects.isNull(this.cadastroImobiliario.getTestadaPrincipal())) {
                errosCadastroImobiliario.add("N\u00e3o existe uma testada principal vinculada neste cadastro imobili\u00e1rio. Favor entrar em contato com a Prefeitura para mais informa\u00e7\u00f5es.");
            } else if (!this.renderMapGEO && !Objects.isNull(this.cadastroImobiliario.getTestadaPrincipal()) && Objects.isNull(this.cadastroImobiliario.getTestadaPrincipal().getZoneamento())) {
                errosCadastroImobiliario.add("N\u00e3o existe um zoneamento vinculado na testada principal deste cadastro imobili\u00e1rio. Favor entrar em contato com a Prefeitura para mais informa\u00e7\u00f5es.");
            }
            this.solicitacaoAlvaraController.getSolicitacaoAlvara().setErrosValidacaoImobiliario(errosCadastroImobiliario);
        }
    }

    public void voltarHandle() throws IOException, BaseException {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        RequestControlContext rec = (RequestControlContext)requestContext;
        this.limparInformacoesCadastroImobiliario();
        rec.handleEvent(new Event((Object)this, "voltar"));
    }

    public void limparInformacoesCadastroImobiliario() {
        this.flagMostraEndereco = false;
        this.cadastroGeral = null;
        this.cadastroImobiliario = null;
        this.selectedTestada = null;
        this.endereco = null;
    }

    public boolean isTestadaGenerica() throws BaseException {
        return UtilsController.isTestadaGenerica();
    }
}

