/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeTipoInscricao;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoDocTipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.faces.event.ValueChangeEvent;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@EloController(value="configurarTipoDocumentoPorTipoInscricaoController")
@Scope(value="flow")
public class ConfigurarTipoDocumentoPorTipoInscricaoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 652953905820925136L;
    private List<TipoDocumentoEntity> tiposDocumento;
    private List<TipoInscricaoAlvaraEntity> tiposInscricao;
    private TipoInscricaoAlvaraEntity tipoInscricaoSelecionado;
    private List<TipoDocumentoEntity> tiposDocumentosSelecionados = new ArrayList();
    private List<TipoDocTipoInscricaoAlvaraEntity> tiposDocumentosAlvara = new ArrayList();
    private TipoDocTipoInscricaoAlvaraEntity tipoDocumentoAlvaraExclusao;

    public List<TipoDocTipoInscricaoAlvaraEntity> getTiposDocumentosAlvara() {
        return this.tiposDocumentosAlvara;
    }

    public void setTiposDocumentosAlvara(List<TipoDocTipoInscricaoAlvaraEntity> tiposDocumentosAlvara) {
        this.tiposDocumentosAlvara = tiposDocumentosAlvara;
    }

    public List<TipoDocumentoEntity> getTiposDocumento() {
        return this.tiposDocumento;
    }

    public void setTiposDocumento(List<TipoDocumentoEntity> tiposDocumento) {
        this.tiposDocumento = tiposDocumento;
    }

    public List<TipoInscricaoAlvaraEntity> getTiposInscricao() {
        return this.tiposInscricao;
    }

    public void setTiposInscricao(List<TipoInscricaoAlvaraEntity> tiposInscricao) {
        this.tiposInscricao = tiposInscricao;
    }

    public TipoInscricaoAlvaraEntity getTipoInscricaoSelecionado() {
        if (this.tipoInscricaoSelecionado == null) {
            return new TipoInscricaoAlvaraEntity();
        }
        return this.tipoInscricaoSelecionado;
    }

    public void setTipoInscricaoSelecionado(TipoInscricaoAlvaraEntity tipoInscricaoSelecionado) {
        this.tipoInscricaoSelecionado = tipoInscricaoSelecionado;
    }

    public List<TipoDocumentoEntity> getTiposDocumentosSelecionados() {
        return this.tiposDocumentosSelecionados;
    }

    public void setTiposDocumentosSelecionados(List<TipoDocumentoEntity> tiposDocumentosSelecionados) {
        this.tiposDocumentosSelecionados = tiposDocumentosSelecionados;
    }

    public void iniciar() throws BaseException {
        this.tiposInscricao = this.carregarTiposInscricao();
        this.tiposDocumento = this.carregarTiposDocumento();
    }

    private List<TipoDocumentoEntity> carregarTiposDocumento() throws BaseException {
        return ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).buscarTiposDocumento();
    }

    private List<TipoInscricaoAlvaraEntity> carregarTiposInscricao() throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
    }

    public void salvar() {
        try {
            if (Objects.nonNull(this.tipoInscricaoSelecionado)) {
                this.tipoInscricaoSelecionado.getTiposDocTipoInscricaoAlvara().clear();
                this.tipoInscricaoSelecionado.getTiposDocTipoInscricaoAlvara().addAll(this.getTiposDocumentosAlvara());
                ((FacadeTipoInscricao)SpringContext.getBean(FacadeTipoInscricao.class)).salvarTipoInscricao(this.tipoInscricaoSelecionado);
                ShowMessage.addInfoMessage((String)"validacao", (String)"Salvo com Sucesso.");
            } else {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um tipo de inscri\u00e7\u00e3o");
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("%s%s", "Ocorreu uma falha ao salvar o documento :", e.getMessage()));
        }
    }

    public void trocarTipoInscricao(ValueChangeEvent e) throws BaseException {
        if (Objects.nonNull(e) && Objects.nonNull(e.getNewValue())) {
            this.tipoInscricaoSelecionado = (TipoInscricaoAlvaraEntity)e.getNewValue();
            this.tiposDocumentosAlvara.clear();
            this.tiposDocumentosAlvara = ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).carregaTiposDocumentoPorTipoInscricao(this.tipoInscricaoSelecionado);
        } else {
            this.tiposDocumentosAlvara.clear();
        }
    }

    public void adicionarDoc() {
        try {
            for (TipoDocTipoInscricaoAlvaraEntity tipoDocumentoAlvara : this.tiposDocumentosAlvara) {
                for (TipoDocumentoEntity tipoDocSelecionado : this.tiposDocumentosSelecionados) {
                    if (!tipoDocumentoAlvara.getTipoDocumento().getTipoDocumento().equals(tipoDocSelecionado.getTipoDocumento())) continue;
                    ShowMessage.addInfoMessage((String)"validacao", (String)String.format("%s%s%s", "O documento ", tipoDocSelecionado.getDescricao(), " j\u00e1 existe na tabela."));
                    return;
                }
            }
            for (TipoDocumentoEntity tipoDocumentoEntity : this.tiposDocumentosSelecionados) {
                TipoDocTipoInscricaoAlvaraEntity documentoNovo = new TipoDocTipoInscricaoAlvaraEntity(tipoDocumentoEntity);
                documentoNovo.setObrigatorio("N");
                documentoNovo.setTipoInscricao(this.tipoInscricaoSelecionado);
                this.tiposDocumentosAlvara.add(documentoNovo);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("%s%s", "Ocorreu uma falha ao adicionar o documento :", e.getMessage()));
        }
    }

    public void mostrarDialogConfirmacaoExclusao(TipoDocTipoInscricaoAlvaraEntity documento) {
        this.tipoDocumentoAlvaraExclusao = documento;
        RequestContext.getCurrentInstance().execute("confirmDialog.show()");
    }

    public void excluir() {
        this.tiposDocumentosAlvara.remove(this.tipoDocumentoAlvaraExclusao);
        this.salvar();
    }
}

