/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.EixoPermitidoEntity;
import br.com.elotech.portalarrecadacao.domain.ExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadePK;
import br.com.elotech.portalarrecadacao.domain.ProibicaoEntity;
import br.com.elotech.portalarrecadacao.domain.TipoExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.ZoneamentoPermitidoEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.facade.FacadeEixo;
import br.com.elotech.portalarrecadacao.facade.FacadeExigencia;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeProibicao;
import br.com.elotech.portalarrecadacao.facade.FacadeTipoExigencia;
import br.com.elotech.portalarrecadacao.facade.FacadeZoneamento;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.EixoEntity;
import br.com.elotech.tributacao.domain.aise.ObservacaoConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.ZoneamentoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.enumerator.TipoConfiguracaoAtividadeDocEnum;
import br.com.elotech.tributacao.filter.FiltroConfiguracaoAtividade;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController(value="configuracaoAtividadeController")
public class ConfiguracaoAtividadeController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -5900570986438094662L;
    private static final int TAMANHO_MAXIMO_CODIGO_CBO = 6;
    private static final int TAMANHO_MAXIMO_CODIGO_CNAE = 7;
    private List<TipoAtividadeEnum> tiposAtividadeEnum;
    private FiltroConfiguracaoAtividade filtroConfiguracaoAtividade;
    private List<Atividade> listaAtividade;
    private Atividade atividadeSelecionada;
    private List<TipoExigenciaEntity> tiposExigencia;
    private List<TipoExigenciaEntity> tiposExigenciaSelecionadas;
    private ExigenciaEntity exigencia;
    private List<ExigenciaEntity> exigenciasAtividade;
    private List<TipoLaudoEntity> tiposLaudos;
    private List<TipoLaudoEntity> tiposLaudosSelecionados;
    private LaudoExigidoEntity laudo;
    private List<LaudoExigidoEntity> laudosAtividade;
    private List<ProibicaoEntity> proibicoes;
    private List<ProibicaoEntity> proibicoesSelecionadas;
    private ProibicaoAtividadeEntity proibicaoAtividade;
    private List<ProibicaoAtividadeEntity> proibicoesAtividade;
    private List<EixoEntity> eixos;
    private List<EixoEntity> eixosSelecionados;
    private EixoPermitidoEntity eixoPermitido;
    private List<EixoPermitidoEntity> eixosPermitidos;
    private List<ZoneamentoEntity> zoneamentos;
    private List<ZoneamentoEntity> zoneamentosSelecionados;
    private ZoneamentoPermitidoEntity zoneamentoPermitido;
    private List<ZoneamentoPermitidoEntity> zoneamentosPermitidos;
    private List<ObservacaoConfiguracaoAtividadeEntity> observacoesSelecionadas;
    private List<ObservacaoConfiguracaoAtividadeEntity> observacoes;
    private ObservacaoConfiguracaoAtividadeEntity observacao;
    private List<TipoDocumentoEntity> tiposDocumentos;
    private TipoDocumentoEntity tipoDocumentoSelecionado;
    private SimNaoEnum[] simNaoEnum;
    private String documentoObrigatorio;
    private TipoConfiguracaoAtividadeDocEnum[] tipoConfigAtividadeDocumentos;
    private TipoConfiguracaoAtividadeDocEnum tipoConfigAtividadeDocSelecionado;
    private List<ConfiguracaoAtividadeDocumentoEntity> configuracaoAtividadeDocumentos;
    private ConfiguracaoAtividadeDocumentoEntity configuracaoAtividadeDocSelecionada;
    private boolean primeiroAcesso = true;

    public void iniciar() throws BaseException {
        this.tiposAtividadeEnum = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).buscarTiposAtividadeConfiguracaoAtividade();
        this.filtroConfiguracaoAtividade = new FiltroConfiguracaoAtividade();
        this.filtroConfiguracaoAtividade.setTipoAtividadeEnum(TipoAtividadeEnum.CNAE);
        this.listaAtividade = Lists.newArrayList();
        this.atividadeSelecionada = null;
    }

    private void carregarTiposExigencias() throws BaseException {
        this.tiposExigencia = ((FacadeTipoExigencia)SpringContext.getBean(FacadeTipoExigencia.class)).carregarTiposExigenciaAtivos();
    }

    private void carregarTiposLaudos() throws BaseException {
        this.tiposLaudos = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getListaTipoLaudo();
    }

    private void carregarProibicoes() throws BaseException {
        this.proibicoes = ((FacadeProibicao)SpringContext.getBean(FacadeProibicao.class)).carregarProibicoesAtivas();
    }

    public void iniciarConfiguracaoAtividade() {
        try {
            this.exigenciasAtividade = ((FacadeExigencia)SpringContext.getBean(FacadeExigencia.class)).consultarExigenciasPorConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
            this.laudosAtividade = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).carregarLaudosExigidosPorConfiguracao(this.atividadeSelecionada.getIdConfiguracaoAtividade());
            this.proibicoesAtividade = ((FacadeProibicao)SpringContext.getBean(FacadeProibicao.class)).carregarExigenciasPorConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
            this.configuracaoAtividadeDocumentos = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).carregarConfiguracaoAtividadeDocumentos(this.atividadeSelecionada.getIdConfiguracaoAtividade());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)("Erro: " + e.getMessage()));
        }
    }

    public void pesquisar() {
        try {
            this.listaAtividade = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).consultarConfiguracaoAtividadeByFiltros(this.filtroConfiguracaoAtividade);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)("Erro: " + e.getMessage()));
        }
    }

    public String mascaraCodigoAtividade() {
        if (TipoAtividadeEnum.CBO.equals((Object)this.filtroConfiguracaoAtividade.getTipoAtividadeEnum())) {
            return "9?99999";
        }
        return "9?999999";
    }

    public Integer tamanhoMaximoCodigoAtividade() {
        if (TipoAtividadeEnum.CBO.equals((Object)this.filtroConfiguracaoAtividade.getTipoAtividadeEnum())) {
            return 6;
        }
        return 7;
    }

    public String adicionaConfiguracoes() {
        try {
            if (Objects.nonNull(this.atividadeSelecionada)) {
                this.verificarConfiguracaoAtividadeExiste();
                this.carregarTiposExigencias();
                this.carregarTiposLaudos();
                this.carregarProibicoes();
                this.carregarObservacaoConfiguracaoAtividade();
                this.carregarTiposDocumentos();
                return "toAdicionaConfiguracoes";
            }
            ShowMessage.addWarnMessage((String)"msg", (String)"Selecione uma atividade");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)"msg", (String)String.format("Ocorreu uma falha ao abrir a tela para adicionar as Configura\u00e7\u00f5es: %s ", e.getMessage()));
        }
        return null;
    }

    private void verificarConfiguracaoAtividadeExiste() throws BaseException {
        if (this.atividadeSelecionada != null && this.atividadeSelecionada.getIdConfiguracaoAtividade() == null) {
            ConfiguracaoAtividadeEntity configuracaoAtividade = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).criarConfiguracaoAtividade(this.filtroConfiguracaoAtividade.getTipoAtividadeEnum(), this.atividadeSelecionada);
            this.atividadeSelecionada = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).atribuirConfiguracaoAtividadeToAtividade(configuracaoAtividade, this.atividadeSelecionada);
        }
    }

    protected void carregarTiposDocumentos() throws ValidacaoException, SolicitacaoAlvaraException {
        try {
            this.tiposDocumentos = ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).buscarTiposDocumento();
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException("Ocorreu uma falha ao carregar uma a lista de tipos de documentos", e.getCause());
        }
    }

    public String abrirTelaEixoPermitido() {
        try {
            if (!Objects.isNull(this.atividadeSelecionada)) {
                this.verificarConfiguracaoAtividadeExiste();
                this.carregarEixos();
                return "toAdicionarEixoPermitido";
            }
            ShowMessage.addWarnMessage((String)"msg", (String)"Selecione uma atividade");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)"msg", (String)String.format("Ocorreu uma falha ao abrir a tela para adicionar os eixos: %s ", e.getMessage()));
        }
        return null;
    }

    public String abrirTelaZoneamentoPermitido() {
        try {
            if (!Objects.isNull(this.atividadeSelecionada)) {
                this.verificarConfiguracaoAtividadeExiste();
                this.carregarZoneamentos();
                return "toAdicionarZoneamentoPermitido";
            }
            ShowMessage.addWarnMessage((String)"msg", (String)"Selecione uma atividade");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)"msg", (String)String.format("Ocorreu uma falha ao abrir a tela para adicionar os zoneamentos: %s ", e.getMessage()));
        }
        return null;
    }

    private void carregarEixos() throws BaseException {
        this.eixos = ((FacadeEixo)SpringContext.getBean(FacadeEixo.class)).carregarTodosEixos();
    }

    private void carregarZoneamentos() throws BaseException {
        this.zoneamentos = ((FacadeZoneamento)SpringContext.getBean(FacadeZoneamento.class)).carregarTodosZoneamentos();
    }

    public void adicionarExigencia() {
        try {
            if (EloListUtils.safeIsEmpty((List)this.tiposExigenciaSelecionadas).booleanValue()) {
                ShowMessage.addWarnMessage((String)"msgExigencia", (String)"Seleciona pelo menos um Tipo de Exig\u00eancia");
            } else {
                for (TipoExigenciaEntity tipoExigencia : this.tiposExigenciaSelecionadas) {
                    ExigenciaEntity exigencia = new ExigenciaEntity();
                    exigencia.setConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
                    exigencia.setTipoExigencia(tipoExigencia);
                    ((FacadeExigencia)SpringContext.getBean(FacadeExigencia.class)).salvarExigencia(exigencia);
                    if (this.exigenciasAtividade == null) {
                        this.exigenciasAtividade = new ArrayList();
                    }
                    if (this.exigenciasAtividade.contains(exigencia)) continue;
                    this.exigenciasAtividade.add(exigencia);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgExigencia", (String)("Erro: " + e.getMessage()));
        }
    }

    public void excluirExigencia() throws BaseException {
        this.exigenciasAtividade.remove(this.exigencia);
        ((FacadeExigencia)SpringContext.getBean(FacadeExigencia.class)).excluirExigencia(this.exigencia);
        ShowMessage.addInfoMessage((String)"msgExigencia", (String)"Exig\u00eancia exclu\u00edda com sucesso.");
    }

    public List<ConfiguracaoAtividadeDocumentoEntity> getConfiguracaoAtividadeDocumentos() {
        return this.configuracaoAtividadeDocumentos;
    }

    public void setConfiguracaoAtividadeDocumentos(List<ConfiguracaoAtividadeDocumentoEntity> configuracaoAtividadeDocumentos) {
        this.configuracaoAtividadeDocumentos = configuracaoAtividadeDocumentos;
    }

    public SimNaoEnum[] getSimNaoEnum() {
        if (this.simNaoEnum == null) {
            this.simNaoEnum = SimNaoEnum.values();
        }
        return this.simNaoEnum;
    }

    public void setSimNaoEnum(SimNaoEnum[] simNaoEnum) {
        this.simNaoEnum = simNaoEnum;
    }

    public String getDocumentoObrigatorio() {
        return this.documentoObrigatorio;
    }

    public void setDocumentoObrigatorio(String documentoObrigatorio) {
        this.documentoObrigatorio = documentoObrigatorio;
    }

    public TipoConfiguracaoAtividadeDocEnum[] getTipoConfigAtividadeDocumentos() {
        if (this.tipoConfigAtividadeDocumentos == null) {
            this.tipoConfigAtividadeDocumentos = TipoConfiguracaoAtividadeDocEnum.values();
        }
        return this.tipoConfigAtividadeDocumentos;
    }

    public void setTipoConfigAtividadeDocumentos(TipoConfiguracaoAtividadeDocEnum[] tipoConfigAtividadeDocumentos) {
        this.tipoConfigAtividadeDocumentos = tipoConfigAtividadeDocumentos;
    }

    public TipoConfiguracaoAtividadeDocEnum getTipoConfigAtividadeDocSelecionado() {
        return this.tipoConfigAtividadeDocSelecionado;
    }

    public void setTipoConfigAtividadeDocSelecionado(TipoConfiguracaoAtividadeDocEnum tipoConfigAtividadeDocSelecionado) {
        this.tipoConfigAtividadeDocSelecionado = tipoConfigAtividadeDocSelecionado;
    }

    public List<TipoAtividadeEnum> getTiposAtividadeEnum() {
        return this.tiposAtividadeEnum;
    }

    public List<TipoDocumentoEntity> getTiposDocumentos() {
        return this.tiposDocumentos;
    }

    public TipoDocumentoEntity getTipoDocumentoSelecionado() {
        return this.tipoDocumentoSelecionado;
    }

    public void setTipoDocumentoSelecionado(TipoDocumentoEntity tipoDocumentoSelecionado) {
        this.tipoDocumentoSelecionado = tipoDocumentoSelecionado;
    }

    public void setTiposDocumentos(List<TipoDocumentoEntity> tiposDocumentos) {
        this.tiposDocumentos = tiposDocumentos;
    }

    public List<Atividade> getListaAtividade() {
        return this.listaAtividade;
    }

    public void setListaAtividade(List<Atividade> listaAtividade) {
        this.listaAtividade = listaAtividade;
    }

    public Atividade getAtividadeSelecionada() {
        return this.atividadeSelecionada;
    }

    public void setAtividadeSelecionada(Atividade atividadeSelecionada) {
        this.atividadeSelecionada = atividadeSelecionada;
    }

    public FiltroConfiguracaoAtividade getFiltroConfiguracaoAtividade() {
        return this.filtroConfiguracaoAtividade;
    }

    public void setFiltroConfiguracaoAtividade(FiltroConfiguracaoAtividade filtroConfiguracaoAtividade) {
        this.filtroConfiguracaoAtividade = filtroConfiguracaoAtividade;
    }

    public List<TipoExigenciaEntity> getTiposExigenciaSelecionadas() {
        return this.tiposExigenciaSelecionadas;
    }

    public void setTiposExigenciaSelecionadas(List<TipoExigenciaEntity> tiposExigenciaSelecionadas) {
        this.tiposExigenciaSelecionadas = tiposExigenciaSelecionadas;
    }

    public List<TipoExigenciaEntity> getTiposExigencia() {
        return this.tiposExigencia;
    }

    public void setTiposExigencia(List<TipoExigenciaEntity> tiposExigencia) {
        this.tiposExigencia = tiposExigencia;
    }

    public ExigenciaEntity getExigencia() {
        return this.exigencia;
    }

    public void setExigencia(ExigenciaEntity exigencia) {
        this.exigencia = exigencia;
    }

    public List<ExigenciaEntity> getExigenciasAtividade() {
        return this.exigenciasAtividade;
    }

    public void setExigenciasAtividade(List<ExigenciaEntity> exigenciasAtividade) {
        this.exigenciasAtividade = exigenciasAtividade;
    }

    public List<TipoLaudoEntity> getTiposLaudosSelecionados() {
        return this.tiposLaudosSelecionados;
    }

    public void setTiposLaudosSelecionados(List<TipoLaudoEntity> tiposLaudosSelecionados) {
        this.tiposLaudosSelecionados = tiposLaudosSelecionados;
    }

    public List<TipoLaudoEntity> getTiposLaudos() {
        return this.tiposLaudos;
    }

    public void setTiposLaudos(List<TipoLaudoEntity> tiposLaudos) {
        this.tiposLaudos = tiposLaudos;
    }

    public LaudoExigidoEntity getLaudo() {
        return this.laudo;
    }

    public void setLaudo(LaudoExigidoEntity laudo) {
        this.laudo = laudo;
    }

    public List<LaudoExigidoEntity> getLaudosAtividade() {
        return this.laudosAtividade;
    }

    public void setLaudosAtividade(List<LaudoExigidoEntity> laudosAtividade) {
        this.laudosAtividade = laudosAtividade;
    }

    public List<ProibicaoEntity> getProibicoesSelecionadas() {
        return this.proibicoesSelecionadas;
    }

    public void setProibicoesSelecionadas(List<ProibicaoEntity> proibicoesSelecionadas) {
        this.proibicoesSelecionadas = proibicoesSelecionadas;
    }

    public ProibicaoAtividadeEntity getProibicaoAtividade() {
        return this.proibicaoAtividade;
    }

    public void setProibicaoAtividade(ProibicaoAtividadeEntity proibicaoAtividade) {
        this.proibicaoAtividade = proibicaoAtividade;
    }

    public List<ProibicaoAtividadeEntity> getProibicoesAtividade() {
        return this.proibicoesAtividade;
    }

    public void setProibicoesAtividade(List<ProibicaoAtividadeEntity> proibicoesAtividade) {
        this.proibicoesAtividade = proibicoesAtividade;
    }

    public List<ProibicaoEntity> getProibicoes() {
        return this.proibicoes;
    }

    public void setProibicoes(List<ProibicaoEntity> proibicoes) {
        this.proibicoes = proibicoes;
    }

    public List<EixoEntity> getEixos() {
        return this.eixos;
    }

    public void setEixos(List<EixoEntity> eixos) {
        this.eixos = eixos;
    }

    public List<EixoEntity> getEixosSelecionados() {
        return this.eixosSelecionados;
    }

    public void setEixosSelecionados(List<EixoEntity> eixosSelecionados) {
        this.eixosSelecionados = eixosSelecionados;
    }

    public EixoPermitidoEntity getEixoPermitido() {
        return this.eixoPermitido;
    }

    public void setEixoPermitido(EixoPermitidoEntity eixoPermitido) {
        this.eixoPermitido = eixoPermitido;
    }

    public List<EixoPermitidoEntity> getEixosPermitidos() {
        return this.eixosPermitidos;
    }

    public void setEixosPermitidos(List<EixoPermitidoEntity> eixosPermitidos) {
        this.eixosPermitidos = eixosPermitidos;
    }

    public List<ZoneamentoEntity> getZoneamentos() {
        return this.zoneamentos;
    }

    public void setZoneamentos(List<ZoneamentoEntity> zoneamentos) {
        this.zoneamentos = zoneamentos;
    }

    public List<ZoneamentoEntity> getZoneamentosSelecionados() {
        return this.zoneamentosSelecionados;
    }

    public void setZoneamentosSelecionados(List<ZoneamentoEntity> zoneamentosSelecionados) {
        this.zoneamentosSelecionados = zoneamentosSelecionados;
    }

    public ZoneamentoPermitidoEntity getZoneamentoPermitido() {
        return this.zoneamentoPermitido;
    }

    public void setZoneamentoPermitido(ZoneamentoPermitidoEntity zoneamentoPermitido) {
        this.zoneamentoPermitido = zoneamentoPermitido;
    }

    public List<ZoneamentoPermitidoEntity> getZoneamentosPermitidos() {
        return this.zoneamentosPermitidos;
    }

    public void setZoneamentosPermitidos(List<ZoneamentoPermitidoEntity> zoneamentosPermitidos) {
        this.zoneamentosPermitidos = zoneamentosPermitidos;
    }

    public List<ObservacaoConfiguracaoAtividadeEntity> getObservacoesSelecionadas() {
        return this.observacoesSelecionadas;
    }

    public void setObservacoesSelecionadas(List<ObservacaoConfiguracaoAtividadeEntity> observacoesSelecionadas) {
        this.observacoesSelecionadas = observacoesSelecionadas;
    }

    public List<ObservacaoConfiguracaoAtividadeEntity> getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(List<ObservacaoConfiguracaoAtividadeEntity> observacoes) {
        this.observacoes = observacoes;
    }

    public void setConfiguracaoAtividadeDocSelecionada(ConfiguracaoAtividadeDocumentoEntity configuracaoAtividadeDocSelecionada) {
        this.configuracaoAtividadeDocSelecionada = configuracaoAtividadeDocSelecionada;
    }

    public void mostrarDialogConfirmacaoExclusao(ExigenciaEntity exigencia) {
        this.exigencia = exigencia;
        RequestContext.getCurrentInstance().execute("confirmDialog.show()");
    }

    public void mostrarDialogConfirmacaoExclusaoLaudo(LaudoExigidoEntity laudoExigido) {
        this.laudo = laudoExigido;
        RequestContext.getCurrentInstance().execute("confirmDialogLaudo.show()");
    }

    public void mostrarDialogConfirmacaoExclusaoProibicao(ProibicaoAtividadeEntity proibicaoAtividade) {
        this.proibicaoAtividade = proibicaoAtividade;
        RequestContext.getCurrentInstance().execute("confirmDialogProibicao.show()");
    }

    public void adicionarLaudo() {
        try {
            if (EloListUtils.safeIsEmpty((List)this.tiposLaudosSelecionados).booleanValue()) {
                ShowMessage.addWarnMessage((String)"msgLaudo", (String)"Seleciona pelo menos um Tipo de Laudo");
            } else {
                for (TipoLaudoEntity tipoLaudo : this.tiposLaudosSelecionados) {
                    LaudoExigidoEntity laudoExigido = new LaudoExigidoEntity();
                    laudoExigido.setConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
                    laudoExigido.setTipoLaudo(tipoLaudo);
                    if (this.laudosAtividade == null) {
                        this.laudosAtividade = new ArrayList();
                    }
                    ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).salvarLaudoExigido(laudoExigido);
                    if (this.laudosAtividade.contains(laudoExigido)) continue;
                    this.laudosAtividade.add(laudoExigido);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgLaudo", (String)("Erro: " + e.getMessage()));
        }
    }

    public void adicionarProibicao() {
        try {
            if (EloListUtils.safeIsEmpty((List)this.proibicoesSelecionadas).booleanValue()) {
                ShowMessage.addWarnMessage((String)"msgProibicao", (String)"Seleciona pelo menos um Tipo de Proibi\u00e7\u00e3o");
            } else {
                for (ProibicaoEntity proibicao : this.proibicoesSelecionadas) {
                    ProibicaoAtividadePK pk = ProibicaoAtividadePK.newFrom((ConfiguracaoAtividadeEntity)this.atividadeSelecionada.getIdConfiguracaoAtividade(), (ProibicaoEntity)proibicao);
                    ProibicaoAtividadeEntity proibicaoAtividade = new ProibicaoAtividadeEntity(pk);
                    ((FacadeProibicao)SpringContext.getBean(FacadeProibicao.class)).salvarProibicaoAtividade(proibicaoAtividade);
                    if (this.proibicoesAtividade == null) {
                        this.proibicoesAtividade = new ArrayList();
                    }
                    if (this.proibicoesAtividade.contains(proibicaoAtividade)) continue;
                    this.proibicoesAtividade.add(proibicaoAtividade);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgLaudo", (String)("Erro: " + e.getMessage()));
        }
    }

    public void excluirLaudo() throws BaseException {
        this.laudosAtividade.remove(this.laudo);
        ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).excluirLaudoExigido(this.laudo);
        ShowMessage.addInfoMessage((String)"msgLaudo", (String)"Laudo exclu\u00eddo com sucesso.");
    }

    public void excluirProibicao() throws BaseException {
        this.proibicoesAtividade.remove(this.proibicaoAtividade);
        ((FacadeProibicao)SpringContext.getBean(FacadeProibicao.class)).excluirProibicaoAtividade(this.proibicaoAtividade);
        ShowMessage.addInfoMessage((String)"msgProibicao", (String)"Proibi\u00e7\u00e3o exclu\u00edda com sucesso.");
    }

    public void carregarInformacoesExistentesEixo() throws BaseException {
        this.eixosPermitidos = ((FacadeEixo)SpringContext.getBean(FacadeEixo.class)).carregarEixosPermitidosPorAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
    }

    public void adicionarEixoPermitido() {
        try {
            if (EloListUtils.safeIsEmpty((List)this.eixosSelecionados).booleanValue()) {
                ShowMessage.addWarnMessage((String)"msgEixoPermitido", (String)"Selecione pelo menos um Eixo.");
            } else {
                for (EixoEntity eixo : this.eixosSelecionados) {
                    EixoPermitidoEntity eixoPermitido = new EixoPermitidoEntity();
                    eixoPermitido.setConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
                    eixoPermitido.setEixo(eixo);
                    ((FacadeEixo)SpringContext.getBean(FacadeEixo.class)).salvarEixoPermitido(eixoPermitido);
                    if (this.eixosPermitidos == null) {
                        this.eixosPermitidos = new ArrayList();
                    }
                    if (this.eixosPermitidos.contains(eixoPermitido)) continue;
                    this.eixosPermitidos.add(eixoPermitido);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgEixoPermitido", (String)("Erro: " + e.getMessage()));
        }
    }

    public void excluirEixoPermitido() throws BaseException {
        this.eixosPermitidos.remove(this.eixoPermitido);
        ((FacadeEixo)SpringContext.getBean(FacadeEixo.class)).excluirEixoProibido(this.eixoPermitido);
        ShowMessage.addInfoMessage((String)"msgEixoPermitido", (String)"Eixo exclu\u00eddo com sucesso.");
    }

    public void confirmarExclusaoEixoPermitido(EixoPermitidoEntity eixoPermitido) {
        this.eixoPermitido = eixoPermitido;
        RequestContext.getCurrentInstance().execute("confirmDialogEixoPermitido.show()");
    }

    public void carregarInformacoesExistentesZoneamento() throws BaseException {
        this.zoneamentosPermitidos = ((FacadeZoneamento)SpringContext.getBean(FacadeZoneamento.class)).carregarZoneamentosPermitidosPorAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
    }

    public void adicionarZoneamentoPermitido() {
        try {
            if (EloListUtils.safeIsEmpty((List)this.zoneamentosSelecionados).booleanValue()) {
                ShowMessage.addWarnMessage((String)"msgZoneamentoPermitido", (String)"Selecione pelo menos um Zoneamento.");
            } else {
                for (ZoneamentoEntity zoneamento : this.zoneamentosSelecionados) {
                    ZoneamentoPermitidoEntity zoneamentoPermitido = new ZoneamentoPermitidoEntity();
                    zoneamentoPermitido.setConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
                    zoneamentoPermitido.setZoneamento(zoneamento);
                    ((FacadeZoneamento)SpringContext.getBean(FacadeZoneamento.class)).salvarZoneamentoPermitido(zoneamentoPermitido);
                    if (this.zoneamentosPermitidos == null) {
                        this.zoneamentosPermitidos = new ArrayList();
                    }
                    if (this.zoneamentosPermitidos.contains(zoneamentoPermitido)) continue;
                    this.zoneamentosPermitidos.add(zoneamentoPermitido);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgZoneamentoPermitido", (String)("Erro: " + e.getMessage()));
        }
    }

    public void adicionarObservacao() {
        try {
            if (EloListUtils.safeIsEmpty((List)this.observacoesSelecionadas).booleanValue()) {
                ShowMessage.addWarnMessage((String)"msgZoneamentoPermitido", (String)"Selecione pelo menos uma observa\u00e7\u00e3o.");
            } else {
                for (ObservacaoConfiguracaoAtividadeEntity observacao : this.observacoesSelecionadas) {
                    if (this.existeNaTabelaObservacao(observacao)) {
                        ShowMessage.addInfoMessage((String)"msgObservacao", (String)String.format("A Observa\u00e7\u00e3o %s selecionada j\u00e1 existe na lista!", observacao.getIdObsConfiguracaoAtividade()));
                        return;
                    }
                    if (this.atividadeSelecionada.getIdConfiguracaoAtividade().getObservacoes() == null) {
                        this.atividadeSelecionada.getIdConfiguracaoAtividade().setObservacoes((List)Lists.newArrayList());
                    }
                    this.atividadeSelecionada.getIdConfiguracaoAtividade().getObservacoes().add(observacao);
                }
                this.salvarConfiguracaoAtividade();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)("Erro: " + e.getMessage()));
        }
    }

    private boolean existeNaTabelaObservacao(ObservacaoConfiguracaoAtividadeEntity observacao) {
        if (EloListUtils.safeIsEmpty((List)this.atividadeSelecionada.getIdConfiguracaoAtividade().getObservacoes()).booleanValue()) {
            return Boolean.FALSE;
        }
        return this.atividadeSelecionada.getIdConfiguracaoAtividade().getObservacoes().stream().anyMatch(obs -> obs.getIdObsConfiguracaoAtividade().equals(observacao.getIdObsConfiguracaoAtividade()));
    }

    private void salvarConfiguracaoAtividade() {
        try {
            ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).salvarConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha ao salvar a observa\u00e7\u00e3o :", e.getMessage()));
        }
    }

    public void excluirZoneamentoPermitido() throws BaseException {
        this.zoneamentosPermitidos.remove(this.zoneamentoPermitido);
        ((FacadeZoneamento)SpringContext.getBean(FacadeZoneamento.class)).excluirZoneamentoProibido(this.zoneamentoPermitido);
        ShowMessage.addInfoMessage((String)"msgZoneamentoPermitido", (String)"Zoneamento exclu\u00eddo com sucesso.");
    }

    public void confirmarExclusaoZoneamentoPermitido(ZoneamentoPermitidoEntity zoneamentoPermitido) {
        this.zoneamentoPermitido = zoneamentoPermitido;
        RequestContext.getCurrentInstance().execute("confirmDialogZoneamentoPermitido.show()");
    }

    private void carregarObservacaoConfiguracaoAtividade() {
        try {
            this.observacoes = ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).carregarObservacoes();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void confirmarExclusaoObservacao(ObservacaoConfiguracaoAtividadeEntity observacao) {
        this.observacao = observacao;
        RequestContext.getCurrentInstance().execute("confirmDialogObservacao.show();");
    }

    public void excluirObservacao() {
        this.atividadeSelecionada.getIdConfiguracaoAtividade().getObservacoes().remove(this.observacao);
        this.salvarConfiguracaoAtividade();
    }

    public void adicionarDocumento() {
        try {
            ConfiguracaoAtividadeDocumentoEntity configAtividadeDoc = new ConfiguracaoAtividadeDocumentoEntity();
            configAtividadeDoc.setConfiguracaoAtividade(this.atividadeSelecionada.getIdConfiguracaoAtividade());
            configAtividadeDoc.setObrigatorio(this.documentoObrigatorio);
            configAtividadeDoc.setTipoDocumento(this.tipoDocumentoSelecionado);
            configAtividadeDoc.setTipo(this.tipoConfigAtividadeDocSelecionado);
            ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).salvarConfiguracaoAtividadeDoc(configAtividadeDoc);
            if (Objects.isNull(this.configuracaoAtividadeDocumentos)) {
                this.configuracaoAtividadeDocumentos = Lists.newArrayList();
            }
            this.configuracaoAtividadeDocumentos.add(configAtividadeDoc);
        }
        catch (ValidacaoException ve) {
            ShowMessage.addErrorMessages((String)"msgDocumento", (List)ve.getMensagens());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgDocumento", (String)String.format("Ocorreu uma falha ao Salvar o documento: ->%s", e.getMessage()));
        }
    }

    public void confirmarExclusaoDocumento(ConfiguracaoAtividadeDocumentoEntity doc) {
        this.configuracaoAtividadeDocSelecionada = doc;
        RequestContext.getCurrentInstance().execute("confirmRemoverDialogDoc.show()");
    }

    public void excluirDocumento() {
        try {
            this.configuracaoAtividadeDocumentos.remove(this.configuracaoAtividadeDocSelecionada);
            ((FacadeConfiguracaoAtividade)SpringContext.getBean(FacadeConfiguracaoAtividade.class)).removerConfiguracaoAtividadeDoc(this.configuracaoAtividadeDocSelecionada);
            ShowMessage.addInfoMessage((String)"msgDocumento", (String)"Documento exclu\u00eddo com sucesso.");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgDocumento", (String)String.format("Ocorreu uma falha ao tentar remover o documento: ->%s", e.getMessage()));
        }
    }

    public String iniciarConsultaAtividades() throws BaseException {
        this.iniciar();
        return "toConsultaAtividades";
    }

    public boolean isPrimeiroAcesso() {
        return this.primeiroAcesso;
    }

    public void setPrimeiroAcesso(boolean primeiroAcesso) {
        this.primeiroAcesso = primeiroAcesso;
    }
}

