/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.common.CommonController;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeUsuario;
import br.com.elotech.portalarrecadacao.filter.FiltroCadastroRestricao;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.util.filter.EloFilter;
import br.com.elotech.util.filter.HashMapEloFilter;
import br.com.elotech.util.sql.Modulo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController(value="cadastroRestricaoPorUsuarioController")
public class CadastroRestricaoPorUsuarioController
extends CommonController {
    private static final long serialVersionUID = 1L;
    private List<UsuarioEntity> usuarios;
    private List<CadastroRestricaoAlvaraEntity> cadastrosRestricao = new ArrayList();
    private List<CadastroRestricaoAlvaraEntity> cadastrosRestricaoSelecionados = new ArrayList();
    private UsuarioEntity usuarioSelecionado;
    private String cpfConsulta;
    private String nomeConsulta;

    public String getCpfConsulta() {
        return this.cpfConsulta;
    }

    public void setCpfConsulta(String cpfConsulta) {
        this.cpfConsulta = cpfConsulta;
    }

    public String getNomeConsulta() {
        return this.nomeConsulta;
    }

    public void setNomeConsulta(String nomeConsulta) {
        this.nomeConsulta = nomeConsulta;
    }

    public List<UsuarioEntity> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<UsuarioEntity> usuarios) {
        this.usuarios = usuarios;
    }

    public UsuarioEntity getUsuarioSelecionado() {
        return this.usuarioSelecionado;
    }

    public void setUsuarioSelecionado(UsuarioEntity usuarioSelecionado) {
        this.usuarioSelecionado = usuarioSelecionado;
    }

    public List<CadastroRestricaoAlvaraEntity> getCadastrosRestricao() {
        return this.cadastrosRestricao;
    }

    public void setCadastrosRestricao(List<CadastroRestricaoAlvaraEntity> cadastrosRestricao) {
        this.cadastrosRestricao = cadastrosRestricao;
    }

    public List<CadastroRestricaoAlvaraEntity> getCadastrosRestricaoSelecionados() {
        return this.cadastrosRestricaoSelecionados;
    }

    public void setCadastrosRestricaoSelecionados(List<CadastroRestricaoAlvaraEntity> cadastrosRestricaoSelecionados) {
        this.cadastrosRestricaoSelecionados = cadastrosRestricaoSelecionados;
    }

    public void iniciar() {
        try {
            this.cadastrosRestricao = this.carregarListaCadastroRestricoes();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<UsuarioEntity> carregarUsuarios(HashMapEloFilter filtro) throws BaseException {
        return ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).carregarUsuarioPorSeletor(filtro);
    }

    private List<CadastroRestricaoAlvaraEntity> carregarListaCadastroRestricoes() throws BaseException {
        return ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).carregarListaCadastroRestricoes(new FiltroCadastroRestricao());
    }

    public void carregaCadastroRestricaoPorUsuario(String idUsuario) {
        try {
            this.usuarioSelecionado = ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).carregaUsuarioPorId(idUsuario);
            this.adicionarRestricoesJaVinculadas();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel carregar as restri\u00e7\u00f5es vinculadas ao usu\u00e1rio.");
        }
    }

    private void adicionarRestricoesJaVinculadas() {
        if (this.usuarioSelecionado == null) {
            ShowMessage.addInfoMessage((String)"msg", (String)"Nenhum usu\u00e1rio selecionado.");
            return;
        }
        this.cadastrosRestricaoSelecionados.clear();
        this.cadastrosRestricaoSelecionados = this.usuarioSelecionado.getCadastroRestricoesAlvaras();
    }

    public void salvar() {
        try {
            this.usuarioSelecionado.getCadastroRestricoesAlvaras().clear();
            this.usuarioSelecionado.setCadastroRestricoesAlvaras(this.cadastrosRestricaoSelecionados);
            ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).salvarCadastroRestricaoUsuarioAlvara(this.usuarioSelecionado);
            ShowMessage.addInfoMessage((String)"msg", (String)"Restri\u00e7\u00f5es vinculadas ao usu\u00e1rio com sucesso.");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel salvar as restri\u00e7\u00f5es vinculadas a esse usu\u00e1rio.");
        }
    }

    public void pesquisar() {
        try {
            ArrayList<EloFilter> filtros = new ArrayList<EloFilter>();
            filtros.add(EloFilter.newFrom((String)"modulo", (Object)Modulo.ALVARAONLINE.getCodigo()));
            filtros.add(EloFilter.newFrom((String)"cpf", (Object)this.cpfConsulta.replace(".", "").replace("-", "")));
            filtros.add(EloFilter.newFrom((String)"nome", (Object)this.nomeConsulta));
            HashMapEloFilter filter = new HashMapEloFilter(filtros);
            this.usuarios = this.carregarUsuarios(filter);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel realizar a pesquisa.");
        }
    }

    public void limpar() {
        this.cpfConsulta = null;
        this.nomeConsulta = null;
        this.usuarios = new ArrayList();
    }
}

