/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.caelum.stella.validation.CNPJValidator;
import br.com.caelum.stella.validation.CPFValidator;
import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.ConsultaCpfCnpjController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.RestricaoCadastroController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RegimeFiscalEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.AtividadeCnaeVo;
import br.com.elotech.portalarrecadacao.enumerator.EstadosBrasilEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroEntidadeExercicioEnum;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoConfiguradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeAtividadeCnae;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeCategoriaMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeClassificacaoMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeDebitos;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.facade.FacadeEndereco;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeRegimeFiscal;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.portalarrecadacao.validator.CpfCnpjValidador;
import br.com.elotech.report.Parameter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.domain.CidadeEntity;
import br.com.elotech.tributacao.domain.aise.AtividadeCnaeEntity;
import br.com.elotech.tributacao.domain.aise.BairroEntity;
import br.com.elotech.tributacao.domain.aise.BairroPK;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CategoriaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ClassificacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroPK;
import br.com.elotech.tributacao.domain.aise.ParametroEntidadeExercicioEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.PessoaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.RegimeFiscalPeriodoRealAiseEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.TipoCapitalSocialEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocTipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoLogradouroEntity;
import br.com.elotech.tributacao.domain.aise.TipoRegistroMercantilEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.EnderecoTipoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.exception.BairroException;
import br.com.elotech.tributacao.exception.LogradouroException;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.primefaces.model.UploadedFile;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@Scope(value="flow")
@EloController
public class CadastroMobiliarioController
extends EloLogger
implements Serializable {
    private static final int ZERO = 0;
    private static final long serialVersionUID = 1L;
    private static final String VALIDACAO = "validacao";
    private static final String DIALOG_TERMOS_SHOW = "dialogTermos.show();";
    private static final String DIALOG_CONFIRMA_VALORES_SHOW = "dialogConfirmaValores.show();";
    private static final String DLG_CONFIRMACAO = "dlgConfirmacao";
    private static final String VALIDACAO_CONTRATO_SOCIAL = "validacaoContratoSocial";
    private static final String ID_MENSAGEM_VALIDACAO_BAIRRO = "validacaoBairro";
    private List<PessoaMobiliarioEntity> listaTipoPessoa;
    private String cnpjCpfContratoSocial;
    private String cadastroGeralCmcResponsavel;
    private String nomeCmcResponsavel;
    private CadastroMobiliarioEntity cadastroMobiliario;
    private List<SolicitacaoContratoSocialPessoaEntity> solicitacaoListaContratoSocialPessoa;
    private List<SolicitacaoAlvaraAtividadeEntity> listaAtividades;
    private SolicitacaoContratoSocialPessoaEntity solicitacaoContratoSocialPessoa = new SolicitacaoContratoSocialPessoaEntity();
    private String cepSocio;
    private String complementoSocio;
    private String numeroLogradouroSocio;
    private boolean naturezaMudancaEnd = false;
    private boolean naturezaAlteracaoSocio = false;
    private boolean naturezaInicial = false;
    private boolean naturezaAlteracaoAtividade = false;
    private boolean naturezaMudancaArea = false;
    private boolean naturezaMudancaRazaoSocial = false;
    private SolicitacaoAlvaraAtividadeEntity atividadePrincipalSelecionada;
    private CidadeEntity cidadeSelecionada;
    private BairroEntity bairroSelecionado;
    private List<TipoCapitalSocialEntity> listaTipoCapitalSocial;
    private List<TipoRegistroMercantilEntity> listaTipoRegistroMercantil;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private RestricaoCadastroController restricaoCadastroController;
    @Resource
    private ConsultaCpfCnpjController consultaCpfCnpjController;
    @Resource
    private EntidadeController entidadeController;
    private boolean termoDeUso;
    private LogradouroEntity logradouroSelecionado;
    private PessoaEntity pessoa = new PessoaEntity();
    private boolean mostraEndereco;
    private String nomeParticipanteContrato;
    private BigDecimal valorLaudo;
    private BigDecimal valorTaxasMobiliarias;
    private BigDecimal totalTaxas;
    private String complemento;
    private String textoTermoDeUso;
    private CadastroMobiliarioEntity cmcResponsavel = null;
    private String descNaturezasSelecionadas;
    private String verificaRestricaoCadastroExistente = "N";
    private Boolean campoRazaoFantasia = false;
    private Boolean campoCnpj = false;
    private Boolean campoRg = false;
    private Boolean campoTelefone = false;
    private Boolean campoDescAtividades = false;
    private Boolean campoTipoPessoa = false;
    private Boolean campoEmail = false;
    private Boolean campoNire = false;
    private Boolean renderGridPostosAtendimento = false;
    private Boolean renderGridEndereco = false;
    private Boolean renderGridContratoSocial = false;
    private Boolean renderGridListaAtividades = false;
    private Boolean renderGridPessoaFisica = false;
    private Boolean renderAreaUtilizada = false;
    private Boolean renderAreaPublicaLuminada = false;
    private Boolean cobraTaxaLaudo;
    private EnderecoTipoEnum tipoEnderecoSocio;
    private List<RegimeFiscalEntity> regimesFiscais;
    private Long codigoRegimeFiscalSelecionado;
    private BigDecimal areaPublicidadeLuminada;
    private Boolean renderizaRegimeFiscal = Boolean.FALSE;
    private Date dataInicioRegimeFiscal = new Date();
    private List<AtividadeCnaeVo> atividadeCnaesVo;
    private boolean renderAtividadesHotelMotel = false;
    private byte[] impressaoTermo;
    private boolean renderBotaoImprimirTermo = false;
    private boolean renderizaCategoriaMobiliarioPJ;
    private boolean renderizaClassificacaoMobiliarioPJ;
    private List<CategoriaMobiliarioEntity> categoriasMobiliario;
    private CategoriaMobiliarioEntity categoriaMobiliarioSelecionada;
    private List<ClassificacaoMobiliarioEntity> classificacoesMobiliario;
    private ClassificacaoMobiliarioEntity classificacaoMobiliarioSelecionada;
    private boolean desabilitarCamposPessoaFisica;
    private boolean permiteCadastroEnderecosForaMunicipio;
    private boolean cidadeDiferenteDaEntidade = false;
    private BairroEntity novoBairro;
    private LogradouroEntity novoLogradouro;
    private TipoLogradouroEntity tipoLogradouroSelecionado;
    private List<TipoLogradouroEntity> tiposLogradouro;
    private boolean habilitaBotaoAnexoTermoDeUso;
    private String textoTituloBotaoAnexoTermo;
    private UploadedFile arquivoTermoDeUso;
    private int cpfCnpjHistorico = 0;
    private CadastroMobiliarioEntity cadastroMobiliarioSelecionado;
    private List<CadastroMobiliarioEntity> listagemCadastrosMobiliario;

    public Boolean getRenderAreaPublicaLuminada() {
        return this.renderAreaPublicaLuminada;
    }

    public void setRenderAreaPublicaLuminada(Boolean renderAreaPublicaLuminada) {
        this.renderAreaPublicaLuminada = renderAreaPublicaLuminada;
    }

    public boolean isRenderAtividadesHotelMotel() {
        return this.renderAtividadesHotelMotel;
    }

    public void setRenderAtividadesHotelMotel(boolean renderAtividadesHotelMotel) {
        this.renderAtividadesHotelMotel = renderAtividadesHotelMotel;
    }

    public List<AtividadeCnaeVo> getAtividadeCnaesVo() {
        return this.atividadeCnaesVo;
    }

    public void setAtividadeCnaesVo(List<AtividadeCnaeVo> atividadeCnaesVo) {
        this.atividadeCnaesVo = atividadeCnaesVo;
    }

    public Date getDataInicioRegimeFiscal() {
        return this.dataInicioRegimeFiscal;
    }

    public void setDataInicioRegimeFiscal(Date dataInicioRegimeFiscal) {
        this.dataInicioRegimeFiscal = dataInicioRegimeFiscal;
    }

    public String getNomeParticipanteContrato() {
        return this.nomeParticipanteContrato;
    }

    public Boolean getCampoRazaoFantasia() {
        return this.campoRazaoFantasia;
    }

    public Boolean getCampoCnpj() {
        return this.campoCnpj;
    }

    public boolean isDesabilitarCamposPessoaFisica() {
        return this.desabilitarCamposPessoaFisica;
    }

    public void setDesabilitarCamposPessoaFisica(boolean desabilitarCamposPessoaFisica) {
        this.desabilitarCamposPessoaFisica = desabilitarCamposPessoaFisica;
    }

    public boolean isPermiteCadastroEnderecosForaMunicipio() {
        return this.permiteCadastroEnderecosForaMunicipio;
    }

    public void setPermiteCadastroEnderecosForaMunicipio(boolean permiteCadastroEnderecosForaMunicipio) {
        this.permiteCadastroEnderecosForaMunicipio = permiteCadastroEnderecosForaMunicipio;
    }

    public boolean isCidadeDiferenteDaEntidade() {
        return this.cidadeDiferenteDaEntidade;
    }

    public void setCidadeDiferenteDaEntidade(boolean cidadeDiferenteDaEntidade) {
        this.cidadeDiferenteDaEntidade = cidadeDiferenteDaEntidade;
    }

    public BairroEntity getNovoBairro() {
        return this.novoBairro;
    }

    public void setNovoBairro(BairroEntity novoBairro) {
        this.novoBairro = novoBairro;
    }

    public LogradouroEntity getNovoLogradouro() {
        return this.novoLogradouro;
    }

    public void setNovoLogradouro(LogradouroEntity novoLogradouro) {
        this.novoLogradouro = novoLogradouro;
    }

    public TipoLogradouroEntity getTipoLogradouroSelecionado() {
        return this.tipoLogradouroSelecionado;
    }

    public void setTipoLogradouroSelecionado(TipoLogradouroEntity tipoLogradouroSelecionado) {
        this.tipoLogradouroSelecionado = tipoLogradouroSelecionado;
    }

    public List<TipoLogradouroEntity> getTiposLogradouro() {
        return this.tiposLogradouro;
    }

    public void setTiposLogradouro(List<TipoLogradouroEntity> tiposLogradouro) {
        this.tiposLogradouro = tiposLogradouro;
    }

    public boolean getHabilitaBotaoAnexoTermoDeUso() {
        return this.habilitaBotaoAnexoTermoDeUso;
    }

    public void setHabilitaBotaoAnexoTermoDeUso(boolean habilitaBotaoAnexoTermoDeUso) {
        this.habilitaBotaoAnexoTermoDeUso = habilitaBotaoAnexoTermoDeUso;
    }

    public String getTextoTituloBotaoAnexoTermo() {
        return this.textoTituloBotaoAnexoTermo;
    }

    public void setTextoTituloBotaoAnexoTermo(String textoTituloBotaoAnexoTermo) {
        this.textoTituloBotaoAnexoTermo = textoTituloBotaoAnexoTermo;
    }

    public UploadedFile getArquivoTermoDeUso() {
        return this.arquivoTermoDeUso;
    }

    public void setArquivoTermoDeUso(UploadedFile arquivoTermoDeUso) {
        this.arquivoTermoDeUso = arquivoTermoDeUso;
    }

    public Boolean getCampoRg() {
        return this.campoRg;
    }

    public Boolean getCampoNire() {
        return this.campoNire;
    }

    public void setCampoNire(Boolean campoNire) {
        this.campoNire = campoNire;
    }

    public Boolean getCampoTelefone() {
        return this.campoTelefone;
    }

    public Boolean getCampoDescAtividades() {
        return this.campoDescAtividades;
    }

    public Boolean getCampoTipoPessoa() {
        return this.campoTipoPessoa;
    }

    public Boolean getCampoEmail() {
        return this.campoEmail;
    }

    public Boolean getRenderGridPostosAtendimento() {
        return this.renderGridPostosAtendimento;
    }

    public Boolean getRenderGridEndereco() {
        return this.renderGridEndereco;
    }

    public Boolean getRenderGridContratoSocial() {
        return this.renderGridContratoSocial;
    }

    public Boolean getRenderGridListaAtividades() {
        return this.renderGridListaAtividades;
    }

    public String getCepSocio() {
        return this.cepSocio;
    }

    public void setCepSocio(String cepSocio) {
        this.cepSocio = cepSocio;
    }

    public String getComplementoSocio() {
        return this.complementoSocio;
    }

    public void setComplementoSocio(String complementoSocio) {
        this.complementoSocio = complementoSocio;
    }

    public String getNumeroLogradouroSocio() {
        return this.numeroLogradouroSocio;
    }

    public void setNumeroLogradouroSocio(String numeroLogradouroSocio) {
        this.numeroLogradouroSocio = numeroLogradouroSocio;
    }

    public String getVerificaRestricaoCadastroExistente() {
        return this.verificaRestricaoCadastroExistente;
    }

    public void setVerificaRestricaoCadastroExistente(String verificaRestricaoCadastroExistente) {
        this.verificaRestricaoCadastroExistente = verificaRestricaoCadastroExistente;
    }

    public String getTextoTermoDeUso() {
        return this.textoTermoDeUso;
    }

    public void setTextoTermoDeUso(String textoTermoDeUso) {
        this.textoTermoDeUso = textoTermoDeUso;
    }

    public String getDescNaturezasSelecionadas() {
        return this.descNaturezasSelecionadas;
    }

    public void setDescNaturezasSelecionadas(String descNaturezasSelecionadas) {
        this.descNaturezasSelecionadas = descNaturezasSelecionadas;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public BigDecimal getTotalTaxas() {
        return this.totalTaxas;
    }

    public void setTotalTaxas(BigDecimal totalTaxas) {
        this.totalTaxas = totalTaxas;
    }

    public BigDecimal getValorTaxasMobiliarias() {
        return this.valorTaxasMobiliarias;
    }

    public void setValorTaxasMobiliarias(BigDecimal valorTaxasMobiliarias) {
        this.valorTaxasMobiliarias = valorTaxasMobiliarias;
    }

    public EntidadeController getEntidadeController() {
        return this.entidadeController;
    }

    public void setEntidadeController(EntidadeController entidadeController) {
        this.entidadeController = entidadeController;
    }

    public boolean isNaturezaAlteracaoSocio() {
        return this.naturezaAlteracaoSocio;
    }

    public void setNaturezaAlteracaoSocio(boolean naturezaAlteracaoSocio) {
        this.naturezaAlteracaoSocio = naturezaAlteracaoSocio;
    }

    public List<TipoCapitalSocialEntity> getListaTipoCapitalSocial() {
        return this.listaTipoCapitalSocial;
    }

    public void setListaTipoCapitalSocial(List<TipoCapitalSocialEntity> listaTipoCapitalSocial) {
        this.listaTipoCapitalSocial = listaTipoCapitalSocial;
    }

    public List<TipoRegistroMercantilEntity> getListaTipoRegistroMercantil() {
        return this.listaTipoRegistroMercantil;
    }

    public void setListaTipoRegistroMercantil(List<TipoRegistroMercantilEntity> listaTipoRegistroMercantil) {
        this.listaTipoRegistroMercantil = listaTipoRegistroMercantil;
    }

    public BairroEntity getBairroSelecionado() {
        return this.bairroSelecionado;
    }

    public void setBairroSelecionado(BairroEntity bairroSelecionado) {
        this.bairroSelecionado = bairroSelecionado;
    }

    public PessoaEntity getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(PessoaEntity pessoa) {
        this.pessoa = pessoa;
    }

    public Boolean getMostraEndereco() {
        return this.mostraEndereco;
    }

    public void setMostraEndereco(Boolean mostraEndereco) {
        this.mostraEndereco = mostraEndereco;
    }

    public String getNomeParcitipanteContrato() {
        return this.nomeParticipanteContrato;
    }

    public void setNomeParcitipanteContrato(String nomeParcitipanteContrato) {
        this.nomeParticipanteContrato = nomeParcitipanteContrato;
    }

    public LogradouroEntity getLogradouroSelecionado() {
        return this.logradouroSelecionado;
    }

    public void setLogradouroSelecionado(LogradouroEntity logradouroSelecionado) {
        this.logradouroSelecionado = logradouroSelecionado;
    }

    public CidadeEntity getCidadeSelecionada() {
        return this.cidadeSelecionada;
    }

    public void setCidadeSelecionada(CidadeEntity cidadeSelecionada) {
        this.cidadeSelecionada = cidadeSelecionada;
    }

    public boolean isNaturezaMudancaEnd() {
        return this.naturezaMudancaEnd;
    }

    public void setNaturezaMudancaEnd(boolean naturezaMudancaEnd) {
        this.naturezaMudancaEnd = naturezaMudancaEnd;
    }

    public boolean isNaturezaInicial() {
        return this.naturezaInicial;
    }

    public void setNaturezaInicial(boolean naturezaInicial) {
        this.naturezaInicial = naturezaInicial;
    }

    public boolean isNaturezaAlteracaoAtividade() {
        return this.naturezaAlteracaoAtividade;
    }

    public void setNaturezaAlteracaoAtividade(boolean naturezaAlteracaoAtividade) {
        this.naturezaAlteracaoAtividade = naturezaAlteracaoAtividade;
    }

    public boolean isNaturezaMudancaArea() {
        return this.naturezaMudancaArea;
    }

    public void setNaturezaMudancaArea(boolean naturezaMudancaArea) {
        this.naturezaMudancaArea = naturezaMudancaArea;
    }

    public boolean isNaturezaMudancaRazaoSocial() {
        return this.naturezaMudancaRazaoSocial;
    }

    public void setNaturezaMudancaRazaoSocial(boolean naturezaMudancaRazaoSocial) {
        this.naturezaMudancaRazaoSocial = naturezaMudancaRazaoSocial;
    }

    public SolicitacaoAlvaraAtividadeEntity getAtividadePrincipalSelecionada() {
        return this.atividadePrincipalSelecionada;
    }

    public void setAtividadePrincipalSelecionada(SolicitacaoAlvaraAtividadeEntity atividadePrincipalSelecionada) {
        this.atividadePrincipalSelecionada = atividadePrincipalSelecionada;
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        if (Objects.nonNull(solicitacao.getSolicitacaoAlvaraAtividades()) && !solicitacao.getSolicitacaoAlvaraAtividades().isEmpty()) {
            for (SolicitacaoAlvaraAtividadeEntity solicitacaoAlvaraAtividadeEntity : solicitacao.getSolicitacaoAlvaraAtividades()) {
                if (solicitacaoAlvaraAtividadeEntity.equals((Object)atividadePrincipalSelecionada)) {
                    solicitacaoAlvaraAtividadeEntity.setPrincipal(SimNaoEnum.getSimShortText());
                    continue;
                }
                solicitacaoAlvaraAtividadeEntity.setPrincipal(SimNaoEnum.getNaoShortText());
            }
        }
    }

    public SolicitacaoContratoSocialPessoaEntity getSolicitacaoContratoSocialPessoa() {
        return this.solicitacaoContratoSocialPessoa;
    }

    public void setSolicitacaoContratoSocialPessoa(SolicitacaoContratoSocialPessoaEntity contratoSocialPessoa) {
        this.solicitacaoContratoSocialPessoa = contratoSocialPessoa;
    }

    public String getCadastroGeralCmcResponsavel() {
        return this.cadastroGeralCmcResponsavel;
    }

    public void setCadastroGeralCmcResponsavel(String cadastroGeralCmcResponsavel) {
        this.cadastroGeralCmcResponsavel = cadastroGeralCmcResponsavel;
    }

    public String getNomeCmcResponsavel() {
        return this.nomeCmcResponsavel;
    }

    public void setNomeCmcResponsavel(String nomeCmcResponsavel) {
        this.nomeCmcResponsavel = nomeCmcResponsavel;
    }

    public CadastroMobiliarioEntity getCmcResponsavel() {
        return this.cmcResponsavel;
    }

    public void setCmcResponsavel(CadastroMobiliarioEntity cmcResponsavel) {
        this.cmcResponsavel = cmcResponsavel;
    }

    public String getCnpjCpfContratoSocial() {
        return this.cnpjCpfContratoSocial;
    }

    public void setCnpjCpfContratoSocial(String cnpjCpfContratoSocial) {
        this.cnpjCpfContratoSocial = cnpjCpfContratoSocial;
    }

    public BigDecimal getValorLaudo() {
        return this.valorLaudo;
    }

    public void setValorLaudo(BigDecimal valorLaudo) {
        this.valorLaudo = valorLaudo;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public List<SolicitacaoAlvaraAtividadeEntity> getListaAtividades() {
        return this.listaAtividades;
    }

    public void setListaAtividades(List<SolicitacaoAlvaraAtividadeEntity> listaAtividades) {
        this.listaAtividades = listaAtividades;
    }

    public List<SolicitacaoContratoSocialPessoaEntity> getSolicitacaoListaContratoSocialPessoa() {
        return this.solicitacaoListaContratoSocialPessoa;
    }

    public void setSolicitacaoListaContratoSocialPessoa(List<SolicitacaoContratoSocialPessoaEntity> listaContratoSocialPessoa) {
        this.solicitacaoListaContratoSocialPessoa = listaContratoSocialPessoa;
    }

    public CadastroMobiliarioEntity getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    public void setCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    public List<PessoaMobiliarioEntity> getListaTipoPessoa() {
        return this.listaTipoPessoa;
    }

    public void setListaTipoPessoa(List<PessoaMobiliarioEntity> listaTipoPessoa) {
        this.listaTipoPessoa = listaTipoPessoa;
    }

    public boolean isTermoDeUso() {
        return this.termoDeUso;
    }

    public void setTermoDeUso(boolean termoDeUso) {
        this.termoDeUso = termoDeUso;
    }

    public Boolean getRenderGridPessoaFisica() {
        return this.renderGridPessoaFisica;
    }

    public void setRenderGridPessoaFisica(Boolean renderGridPessoaFisica) {
        this.renderGridPessoaFisica = renderGridPessoaFisica;
    }

    public Boolean getRenderAreaUtilizada() {
        return this.renderAreaUtilizada;
    }

    public void setRenderAreaUtilizada(Boolean renderAreaUtilizada) {
        this.renderAreaUtilizada = renderAreaUtilizada;
    }

    public Boolean getRenderGridPessoaFisicaCpf() {
        return !this.solicitacaoAlvaraController.getSolicitacaoAlvara().isNaturezaInicial();
    }

    public Boolean getCobraTaxaLaudo() {
        return this.cobraTaxaLaudo;
    }

    public EnderecoTipoEnum getTipoEnderecoSocio() {
        return this.tipoEnderecoSocio;
    }

    public void setTipoEnderecoSocio(EnderecoTipoEnum tipoEnderecoSocio) {
        this.tipoEnderecoSocio = tipoEnderecoSocio;
    }

    public List<RegimeFiscalEntity> getRegimesFiscais() {
        return this.regimesFiscais;
    }

    public void setRegimesFiscais(List<RegimeFiscalEntity> regimesFiscais) {
        this.regimesFiscais = regimesFiscais;
    }

    public Long getCodigoRegimeFiscalSelecionado() {
        return this.codigoRegimeFiscalSelecionado;
    }

    public void setCodigoRegimeFiscalSelecionado(Long codigoRegimeFiscalSelecionado) {
        this.codigoRegimeFiscalSelecionado = codigoRegimeFiscalSelecionado;
    }

    public BigDecimal getAreaPublicidadeLuminada() {
        return this.areaPublicidadeLuminada;
    }

    public void setAreaPublicidadeLuminada(BigDecimal areaPublicidadeLuminada) {
        this.areaPublicidadeLuminada = areaPublicidadeLuminada;
    }

    public Boolean getRenderizaRegimeFiscal() {
        return this.renderizaRegimeFiscal;
    }

    public void setRenderizaRegimeFiscal(Boolean renderizaRegimeFiscal) {
        this.renderizaRegimeFiscal = renderizaRegimeFiscal;
    }

    public boolean isRenderizaCategoriaMobiliarioPJ() {
        return this.renderizaCategoriaMobiliarioPJ;
    }

    public void setRenderizaCategoriaMobiliarioPJ(boolean renderizaCategoriaMobiliarioPJ) {
        this.renderizaCategoriaMobiliarioPJ = renderizaCategoriaMobiliarioPJ;
    }

    public boolean isRenderizaClassificacaoMobiliarioPJ() {
        return this.renderizaClassificacaoMobiliarioPJ;
    }

    public void setRenderizaClassificacaoMobiliarioPJ(boolean renderizaClassificacaoMobiliarioPJ) {
        this.renderizaClassificacaoMobiliarioPJ = renderizaClassificacaoMobiliarioPJ;
    }

    public List<CategoriaMobiliarioEntity> getCategoriasMobiliario() {
        return this.categoriasMobiliario;
    }

    public void setCategoriasMobiliario(List<CategoriaMobiliarioEntity> categoriasMobiliario) {
        this.categoriasMobiliario = categoriasMobiliario;
    }

    public List<ClassificacaoMobiliarioEntity> getClassificacoesMobiliario() {
        return this.classificacoesMobiliario;
    }

    public void setClassificacoesMobiliario(List<ClassificacaoMobiliarioEntity> classificacoesMobiliario) {
        this.classificacoesMobiliario = classificacoesMobiliario;
    }

    public ClassificacaoMobiliarioEntity getClassificacaoMobiliarioSelecionada() {
        return this.classificacaoMobiliarioSelecionada;
    }

    public void setClassificacaoMobiliarioSelecionada(ClassificacaoMobiliarioEntity classificacaoMobiliarioSelecionada) {
        this.classificacaoMobiliarioSelecionada = classificacaoMobiliarioSelecionada;
    }

    public CategoriaMobiliarioEntity getCategoriaMobiliarioSelecionada() {
        return this.categoriaMobiliarioSelecionada;
    }

    public void setCategoriaMobiliarioSelecionada(CategoriaMobiliarioEntity categoriaMobiliarioSelecionada) {
        this.categoriaMobiliarioSelecionada = categoriaMobiliarioSelecionada;
    }

    public CadastroMobiliarioEntity getCadastroMobiliarioSelecionado() {
        return this.cadastroMobiliarioSelecionado;
    }

    public void setCadastroMobiliarioSelecionado(CadastroMobiliarioEntity cadastroMobiliarioSelecionado) {
        this.cadastroMobiliarioSelecionado = cadastroMobiliarioSelecionado;
    }

    public List<CadastroMobiliarioEntity> getListagemCadastrosMobiliario() {
        return this.listagemCadastrosMobiliario;
    }

    public void setListagemCadastrosMobiliario(List<CadastroMobiliarioEntity> listagemCadastrosMobiliario) {
        this.listagemCadastrosMobiliario = listagemCadastrosMobiliario;
    }

    private List<PessoaMobiliarioEntity> carregaListaTipoPessoaMobiliario() throws BaseException {
        ParametroAlvaraEntity parametroAlvaraMobiliarioTipoInscricao;
        ParametroAlvaraEnum tipoParametroAlvara = null;
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal()) {
            tipoParametroAlvara = ParametroAlvaraEnum.MOBILIARIO_TIPO_INSCRICAO_JURIDICA_NORMAL;
        } else if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoPrestadorServico()) {
            tipoParametroAlvara = ParametroAlvaraEnum.MOBILIARIO_TIPO_INSCRICAO_PRESTADOR_SERVICO;
        } else if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            tipoParametroAlvara = ParametroAlvaraEnum.MOBILIARIO_TIPO_INSCRICAO_MEI;
        } else if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoCBO()) {
            tipoParametroAlvara = ParametroAlvaraEnum.MOBILIARIO_TIPO_INSCRICAO_CBO;
        }
        if (tipoParametroAlvara != null && (parametroAlvaraMobiliarioTipoInscricao = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(this.entidadeController.getEntidade(), tipoParametroAlvara)) != null && !EloStringUtils.isEmpty((String)parametroAlvaraMobiliarioTipoInscricao.getValor())) {
            Long[] arrayCodigos = EloStringUtils.strToLong((String[])parametroAlvaraMobiliarioTipoInscricao.getValor().split(","));
            return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaPessoaMobiliarioPorCodigo(arrayCodigos);
        }
        return new ArrayList<PessoaMobiliarioEntity>();
    }

    public void consultaPessoaFisicaCpf() throws BaseException {
        if (Objects.isNull(this.pessoa)) {
            return;
        }
        String cpf = this.pessoa.getCnpjCpf();
        if (!EloStringUtils.isEmpty((String)cpf)) {
            this.carregaPessoaNaSolicitacaoContrato(cpf);
        } else {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)" Adicione um CPF");
        }
    }

    public void consultaPessoaCpfCnpj() throws BaseException {
        this.cidadeDiferenteDaEntidade = false;
        this.cnpjCpfContratoSocial = EloStringUtils.retiraChars((String)this.cnpjCpfContratoSocial, (String)".,- /");
        if (!EloStringUtils.isEmpty((String)this.cnpjCpfContratoSocial)) {
            if (!this.validaCpfCnpjSocio()) {
                this.mostraEndereco = false;
                return;
            }
            this.cepSocio = "";
            this.pessoa = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).getVerificarCadMobiliarioImobiliarioByPessoa(this.cnpjCpfContratoSocial);
            if (this.pessoa != null) {
                this.mostraEndereco = EloListUtils.safeIsEmpty((List)this.pessoa.getEnderecos());
                EnderecoPessoaEntity endereco = this.retornarEnderecoPessoaSocio();
                if (endereco != null) {
                    if (endereco.getBairro() == null) {
                        ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)(" O Campo bairro n\u00e3o est\u00e1 preenchido. Favor enviar e-mail para:" + UtilsController.getEmailSetorAlvara()));
                        return;
                    }
                    this.cidadeSelecionada = endereco.getBairro().getId().getCidade();
                    this.bairroSelecionado = endereco.getBairro();
                    this.logradouroSelecionado = endereco.getLogradouroEndereco();
                    if (EloNumberUtils.isBiggerThanZero((Number)endereco.getCep()).booleanValue()) {
                        this.cepSocio = String.valueOf(endereco.getCep());
                    }
                    this.complementoSocio = endereco.getComplemento();
                    this.numeroLogradouroSocio = endereco.getNumero();
                    this.tipoEnderecoSocio = EnderecoTipoEnum.fromTipo((String)endereco.getTipoEndereco());
                }
            } else {
                this.pessoa = new PessoaEntity();
                this.pessoa.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
                this.pessoa.setTipoPessoa(PortalUtils.getTipoPessoa((String)this.cnpjCpfContratoSocial));
                this.pessoa.setCnpjCpf(this.cnpjCpfContratoSocial);
                this.pessoa.setDataInclusao(new Date());
                this.nomeParticipanteContrato = null;
                this.cidadeSelecionada = null;
                this.bairroSelecionado = null;
                this.logradouroSelecionado = null;
                this.tipoEnderecoSocio = null;
                this.mostraEndereco = true;
            }
            if (this.cpfCnpjHistorico != 0 && this.cpfCnpjHistorico != this.cnpjCpfContratoSocial.length()) {
                ShowMessage.addInfoMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"CPF/CNPJ alterado, favor verificar as informa\u00e7\u00f5es preenchidas");
            }
            this.cpfCnpjHistorico = this.cnpjCpfContratoSocial.length();
        } else {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)" Adicione um CPF ou CNPJ");
        }
    }

    private boolean validaCpfCnpjSocio() {
        CpfCnpjValidador cpfCnpjValidador = new CpfCnpjValidador();
        cpfCnpjValidador.setIdMessage(VALIDACAO_CONTRATO_SOCIAL);
        return cpfCnpjValidador.validarCpfCnpj(this.cnpjCpfContratoSocial);
    }

    private EnderecoCadastroGeralEntity buscaEnderecoPrincipal() throws BaseException {
        return ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getBuscaEnderecoImobiliarioPrincipal(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getCadastroImobiliario().getId().getCodigo());
    }

    private void carregarCmcResponsavel(SolicitacaoAlvaraEntity solicitacao, String cpfCnpjUsuarioConectado) throws BaseException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            this.cmcResponsavel = this.recuperarCmcResponsavel(cpfCnpjUsuarioConectado);
            if (this.cmcResponsavel != null) {
                solicitacao.setNomeCmcResponsavel(this.cmcResponsavel.getCadastroGeral().getPessoa().getNome());
                solicitacao.setCodigoCmcResponsavel(this.cmcResponsavel.getCadastroGeral().getId().getCodigo());
            } else {
                solicitacao.setNomeCmcResponsavel("");
                solicitacao.setCodigoCmcResponsavel(Long.valueOf("0"));
            }
        } else {
            this.cmcResponsavel = solicitacao.getCadastroMobiliario().getCmcresponsavel() != null ? this.carregarCadastroMobiliarioPorCodigo(solicitacao.getCadastroMobiliario().getCmcresponsavel()) : ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaCadMobiliarioPorCpfCnpj(cpfCnpjUsuarioConectado);
        }
    }

    public CadastroMobiliarioEntity recuperarCmcResponsavel(String cpfCnpjUsuarioConectado) throws BaseException {
        List listaCadastroMobiliario = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaCadastrosMobiliarios(cpfCnpjUsuarioConectado);
        CadastroMobiliarioEntity cmcResponsavel = null;
        if (!EloListUtils.safeIsEmpty((List)listaCadastroMobiliario).booleanValue()) {
            for (CadastroMobiliarioEntity cm : listaCadastroMobiliario) {
                SituacaoMobiliarioEntity situacaoAtual = cm.getMobiliarioSituacaoAtual();
                if (cm.getCmcresponsavel() == null || situacaoAtual.hasSituacaoMobiliarioAlvara(new SituacaoMobiliarioAlvaraEnum[]{SituacaoMobiliarioAlvaraEnum.SITUACAO_BAIXADO, SituacaoMobiliarioAlvaraEnum.SITUACAO_ANULADO, SituacaoMobiliarioAlvaraEnum.SITUACAO_CASSADO})) continue;
                cmcResponsavel = cm;
            }
        }
        return cmcResponsavel;
    }

    private void disableCampos(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.isSolicitacaoJuridicaNormal()) {
            this.campoRazaoFantasia = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL});
            this.campoCnpj = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoNire = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoRg = false;
            this.campoDescAtividades = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.campoTipoPessoa = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoEmail = false;
            this.renderGridPostosAtendimento = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.renderGridEndereco = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO});
            this.renderGridContratoSocial = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
            this.renderGridListaAtividades = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.renderGridPessoaFisica = false;
            this.renderAreaUtilizada = true;
        } else if (solicitacao.isSolicitacaoPrestadorServico()) {
            this.campoRazaoFantasia = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL});
            this.campoCnpj = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoNire = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoRg = false;
            this.campoTelefone = false;
            this.campoDescAtividades = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.campoTipoPessoa = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoEmail = false;
            this.renderGridPostosAtendimento = false;
            this.renderGridEndereco = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO});
            this.renderGridContratoSocial = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
            this.renderGridListaAtividades = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.renderGridPessoaFisica = false;
            this.renderAreaUtilizada = false;
        } else if (solicitacao.isSolicitacaoMEI()) {
            this.campoRazaoFantasia = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL});
            this.campoCnpj = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoNire = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoRg = false;
            this.campoTelefone = false;
            this.campoDescAtividades = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.campoTipoPessoa = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoEmail = false;
            this.renderGridPostosAtendimento = false;
            this.renderGridEndereco = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO});
            this.renderGridContratoSocial = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
            this.renderGridListaAtividades = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.renderGridPessoaFisica = true;
            this.renderAreaUtilizada = !solicitacao.isSolicitacaoMEIPrestador() && solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
        } else if (solicitacao.isSolicitacaoCBO()) {
            this.campoRazaoFantasia = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL});
            this.campoCnpj = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoNire = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoRg = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoTelefone = false;
            this.campoDescAtividades = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.campoTipoPessoa = !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
            this.campoEmail = false;
            this.renderGridPostosAtendimento = false;
            this.renderGridEndereco = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO});
            this.renderGridContratoSocial = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
            this.renderGridListaAtividades = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
            this.renderGridPessoaFisica = true;
            this.renderAreaUtilizada = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS});
        }
    }

    public void iniciar() {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        this.listaAtividades = new ArrayList();
        this.codigoRegimeFiscalSelecionado = null;
        this.disableCampos(solicitacao);
        StringBuilder strNaturezas = this.verificarNatureza();
        this.descNaturezasSelecionadas = strNaturezas.toString();
        try {
            this.listaTipoPessoa = this.carregaListaTipoPessoaMobiliario();
            this.listaTipoCapitalSocial = this.listarTipoContratoSocial();
            this.listaTipoRegistroMercantil = this.listarTipoRegistroMercantil();
            this.textoTermoDeUso = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TERMO_DE_USO).getValor();
            this.carregarParametroTermoDeUso();
            this.cobraTaxaLaudo = SimNaoEnum.equalSim((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.COBRAR_TAXA_LAUDO).getValor());
            this.verificaRestricaoCadastroExistente = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.BLOQUEIA_CPF_DUPLICADO).getValor();
            solicitacao.setGeraRestricaoCadJaExistente("");
            UserDetails usuario = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            solicitacao.setUserDetails(usuario);
            this.carregarCmcResponsavel(solicitacao, usuario.getUsername());
            this.renderAreaPublicaLuminada = this.isExibeAreaPublicidadeLuminada();
            if (this.naturezaInicial) {
                this.entidadeController.carregaEntidade();
                CadastroGeralAiseEntity cadastroGeral = new CadastroGeralAiseEntity();
                cadastroGeral.setUsuario(PortalUtils.getUsuarioalvaraonline());
                CadastroGeralAisePK id = new CadastroGeralAisePK();
                id.setTipo(Long.valueOf(2L));
                cadastroGeral.setId(id);
                cadastroGeral.setPessoa(new PessoaEntity());
                CadastroMobiliarioEntity cadastro = new CadastroMobiliarioEntity();
                cadastro.setId(id);
                cadastro.setCadastroGeral(cadastroGeral);
                solicitacao.setCadastroMobiliario(cadastro);
                EnderecoCadastroGeralEntity enderecoCadastroGeral = this.buscaEnderecoPrincipal();
                SolicitacaoContratoSocialEntity contrato = new SolicitacaoContratoSocialEntity();
                contrato.setSolicitacaoAlvara(solicitacao);
                solicitacao.setContratoSocial(contrato);
                solicitacao.setEnderecoImobiliarioPrincipal(enderecoCadastroGeral);
                if (((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).verificaLiberacaoRestricaoByCadastroRestricao(solicitacao.getSolicitacaoAlvara(), PortalUtils.getCodRestricaocadPessoaJaExistente())) {
                    this.carregaDadosPessoaJaExistente(solicitacao);
                }
                if (solicitacao.isSolicitacaoMEI()) {
                    this.abrirFormularioParticipanteContratoSocial();
                }
                this.renderizaRegimeFiscal = UtilsController.parametroCriaRegimeFiscalAtivo();
                this.regimesFiscais = new ArrayList();
                RegimeFiscalEntity regimeFiscalMeiPadrao = this.carregarRegimeFiscalPorId();
                if (Objects.nonNull(regimeFiscalMeiPadrao)) {
                    this.regimesFiscais.add(regimeFiscalMeiPadrao);
                } else {
                    this.regimesFiscais = this.carregarRegimesFiscais();
                    this.codigoRegimeFiscalSelecionado = null;
                }
                if (solicitacao.isSolicitacaoJuridicaNormal()) {
                    this.validarRenderizacaoCategoriaMobiliario();
                    this.validarRenderizacaoClassificacaoMobiliario();
                } else if (solicitacao.isSolicitacaoMEI() && solicitacao.isReponsavelPessoaFisica()) {
                    this.pessoa.setCnpjCpf(solicitacao.getCpfCnpjConsulta());
                    this.consultaPessoaFisicaCpf();
                }
            } else {
                ContratoSocialEntity contratoSocial;
                this.carregarAtividadePrincipal(solicitacao);
                ContatoPessoaEntity contatoPessoa = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregarUltimoContatoPessoa(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa());
                if (contatoPessoa != null) {
                    solicitacao.setEmail(contatoPessoa.getEmail());
                    solicitacao.setTelefoneCelular(contatoPessoa.getTelefoneCelular());
                }
                if (this.naturezaMudancaEnd) {
                    EnderecoCadastroGeralEntity enderecoCadastroGeral = this.buscaEnderecoPrincipal();
                    this.solicitacaoAlvaraController.getSolicitacaoAlvara().setEnderecoImobiliarioPrincipal(enderecoCadastroGeral);
                }
                if (solicitacao.isSolicitacaoJuridicaNormal() || solicitacao.isSolicitacaoPrestadorServico()) {
                    SolicitacaoContratoSocialEntity solicitacaoContratoSocial = null;
                    contratoSocial = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).getUltimoContratoSocial(solicitacao.getCadastroMobiliario());
                    solicitacaoContratoSocial = contratoSocial != null ? SolicitacaoContratoSocialEntity.fromContratoSocial((ContratoSocialEntity)contratoSocial) : new SolicitacaoContratoSocialEntity();
                    solicitacaoContratoSocial.setSolicitacaoAlvara(solicitacao);
                    solicitacao.setContratoSocial(solicitacaoContratoSocial);
                }
                if (solicitacao.isSolicitacaoMEI()) {
                    List listaContratoSocialPessoa = new ArrayList();
                    contratoSocial = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).getUltimoContratoSocial(solicitacao.getCadastroMobiliario());
                    if (contratoSocial != null) {
                        listaContratoSocialPessoa = contratoSocial.getPessoas();
                    }
                    if (!EloListUtils.safeIsEmpty(listaContratoSocialPessoa).booleanValue()) {
                        ContratoSocialPessoaEntity contratoSocialPessoa = (ContratoSocialPessoaEntity)listaContratoSocialPessoa.get(0);
                        this.carregaSocioMEI(contratoSocialPessoa.getId().getPessoa().getCnpjCpf());
                    }
                }
                if (solicitacao.isSolicitacaoCBO()) {
                    PessoaEntity pessoaMobiliario = solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa();
                    solicitacao.setRg(pessoaMobiliario.getRg());
                    solicitacao.setRgOrgaoEmissor(pessoaMobiliario.getOrgaoEmissor());
                    solicitacao.setRgUfEmissor(pessoaMobiliario.getEstadoEmissor());
                    solicitacao.setRgDataEmissao(pessoaMobiliario.getDataEmissao());
                }
            }
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
                solicitacao.setDescricaoAtividades(this.getDescricaoAtividades(solicitacao));
            } else {
                solicitacao.setDescricaoAtividades(solicitacao.getCadastroMobiliario().getAtividadePrincipal());
            }
            if (solicitacao.getSolicitacaoAlvaraAtividades() != null) {
                if (solicitacao.getSolicitacaoAlvaraAtividades().size() == 1) {
                    this.atividadePrincipalSelecionada = (SolicitacaoAlvaraAtividadeEntity)solicitacao.getSolicitacaoAlvaraAtividades().get(0);
                }
                for (SolicitacaoAlvaraAtividadeEntity item : solicitacao.getSolicitacaoAlvaraAtividades()) {
                    this.listaAtividades.add(item);
                }
            }
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
                if (solicitacao.getAreaConstruida() != null && solicitacao.getAreaPatio() != null) {
                    solicitacao.setAreaUtilizada(solicitacao.getAreaConstruida().add(solicitacao.getAreaPatio()));
                } else if (solicitacao.getAreaConstruida() != null) {
                    solicitacao.setAreaUtilizada(solicitacao.getAreaConstruida());
                } else {
                    solicitacao.setAreaUtilizada(solicitacao.getCadastroMobiliario().getAreaUtilizada());
                }
            } else {
                solicitacao.setAreaUtilizada(solicitacao.getCadastroMobiliario().getAreaUtilizada());
            }
            if (solicitacao.isSolicitacaoJuridicaNormal() && solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
                this.renderAtividadesHotelMotel = false;
                this.exibirDadosHotelMotel();
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgValidacaoCnpj", (String)e.getMessage());
        }
    }

    private void carregarParametroTermoDeUso() throws BaseException {
        String paramImprimirTermo = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.IMPRIMIR_TERMO_DE_USO).getValor();
        this.renderBotaoImprimirTermo = SimNaoEnum.equalSim((String)paramImprimirTermo);
    }

    private void validarRenderizacaoCategoriaMobiliario() throws BaseException {
        try {
            String parametroHabilitaCategoriaMobiliario = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_CATEGORIA_MOBILIARIO_PJ);
            this.renderizaCategoriaMobiliarioPJ = SimNaoEnum.equalSim((String)parametroHabilitaCategoriaMobiliario);
            if (this.renderizaCategoriaMobiliarioPJ) {
                this.carregarCategoriasMobiliario();
            }
        }
        catch (ParametroNaoConfiguradoException e) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)e.getMessage());
        }
    }

    private void carregarCategoriasMobiliario() throws BaseException {
        this.categoriasMobiliario = ((FacadeCategoriaMobiliario)SpringContext.getBean(FacadeCategoriaMobiliario.class)).carregarCategoriasMobiliario();
    }

    private void validarRenderizacaoClassificacaoMobiliario() throws BaseException {
        try {
            String parametroHabilitaClassificacaoMobiliario = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_CLASSIFICACAO_MOBILIARIO_PJ);
            this.renderizaClassificacaoMobiliarioPJ = SimNaoEnum.getSimShortText().equalsIgnoreCase(parametroHabilitaClassificacaoMobiliario);
            if (this.renderizaClassificacaoMobiliarioPJ) {
                this.carregarClassificacaoMobiliario();
            }
        }
        catch (ParametroNaoConfiguradoException e) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)e.getMessage());
        }
    }

    private void carregarClassificacaoMobiliario() throws BaseException {
        this.classificacoesMobiliario = ((FacadeClassificacaoMobiliario)SpringContext.getBean(FacadeClassificacaoMobiliario.class)).carregarClassificacoesMobiliario();
    }

    private RegimeFiscalEntity carregarRegimeFiscalPorId() throws BaseException {
        try {
            ParametroAlvaraEntity paramRegimeFiscalMei = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.REGIME_FISCAL_PADRAO);
            if (Objects.nonNull(paramRegimeFiscalMei) && !EloStringUtils.isEmpty((String)paramRegimeFiscalMei.getValor())) {
                this.codigoRegimeFiscalSelecionado = Long.valueOf(paramRegimeFiscalMei.getValor());
                return ((FacadeRegimeFiscal)SpringContext.getBean(FacadeRegimeFiscal.class)).carregarRegimeFiscalPorId(this.codigoRegimeFiscalSelecionado);
            }
            return null;
        }
        catch (ParametroNaoConfiguradoException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void exibirDadosHotelMotel() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.listaAtividades).booleanValue()) {
            ArrayList<String> codigosCnaes = new ArrayList<String>();
            codigosCnaes.add("5510801");
            codigosCnaes.add("5510803");
            codigosCnaes.add("5510802");
            this.atividadeCnaesVo = new ArrayList();
            for (String codigoCnae : codigosCnaes) {
                for (SolicitacaoAlvaraAtividadeEntity atividadeSelecionada : this.listaAtividades) {
                    if (!codigoCnae.equals(atividadeSelecionada.getCodigoAtividade())) continue;
                    List atividadesCnae = this.carregaAtividadesByCnae(atividadeSelecionada.getCnae());
                    for (AtividadeCnaeEntity atividadeCnae : atividadesCnae) {
                        if (!Objects.nonNull(atividadeCnae)) continue;
                        if (EloListUtils.safeIsEmpty((List)this.atividadeCnaesVo).booleanValue()) {
                            AtividadeCnaeVo atividade = new AtividadeCnaeVo(atividadeCnae.getAtividade(), atividadeCnae.getCnae());
                            this.atividadeCnaesVo.add(atividade);
                            continue;
                        }
                        ArrayList<AtividadeCnaeVo> lista = new ArrayList<AtividadeCnaeVo>();
                        for (AtividadeCnaeVo atv : this.atividadeCnaesVo) {
                            if (atv.getAtividade().getId().equals(atividadeCnae.getAtividade().getId())) continue;
                            AtividadeCnaeVo atividade = new AtividadeCnaeVo(atividadeCnae.getAtividade(), atividadeCnae.getCnae());
                            lista.add(atividade);
                        }
                        this.atividadeCnaesVo.addAll(lista);
                    }
                }
            }
        }
        if (!EloListUtils.safeIsEmpty((List)this.atividadeCnaesVo).booleanValue()) {
            this.renderAtividadesHotelMotel = true;
            this.solicitacaoAlvaraController.getSolicitacaoAlvara().setAtividadesVo(this.atividadeCnaesVo);
        }
    }

    private List<AtividadeCnaeEntity> carregaAtividadesByCnae(CnaeEntity cnae) throws BaseException {
        return ((FacadeAtividadeCnae)SpringContext.getBean(FacadeAtividadeCnae.class)).carregarAtividadesByCnae(cnae);
    }

    private List<RegimeFiscalEntity> carregarRegimesFiscais() throws BaseException {
        if (this.renderizaRegimeFiscal.booleanValue()) {
            return ((FacadeRegimeFiscal)SpringContext.getBean(FacadeRegimeFiscal.class)).carregarTodosRegimesFiscais();
        }
        return Lists.newArrayList();
    }

    private String getDescricaoAtividades(SolicitacaoAlvaraEntity solicitacao) {
        StringBuilder sb = new StringBuilder();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            String descricao;
            int lastIndexOf;
            if (!solicitacao.isSolicitacaoMEI() || (lastIndexOf = sb.lastIndexOf(descricao = atividade.getAtividadeMei().getCnae().getDescricao())) >= 0) continue;
            sb.append(descricao).append(";\n");
        }
        return sb.toString().trim();
    }

    private void carregarAtividadePrincipal(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.isSolicitacaoMEI()) {
            this.carregarAtividadePrincipalMEI(solicitacao);
        } else if (solicitacao.isSolicitacaoCBO()) {
            this.carregarAtividadePrincipalCBO(solicitacao);
        } else {
            this.carregarAtividadePrincipalNormal(solicitacao);
        }
    }

    private void carregarAtividadePrincipalNormal(SolicitacaoAlvaraEntity solicitacao) {
        solicitacao.getCadastroMobiliario().getMobiliarioCnaes().stream().reduce((p1, p2) -> SimNaoEnum.getSimShortText().equals(p1.getCnaePrincipal()) ? p1 : p2).ifPresent(mobCnae -> solicitacao.getSolicitacaoAlvaraAtividades().stream().reduce((p1, p2) -> p1.getCnae().equals((Object)mobCnae.getId().getCnae()) ? p1 : p2).ifPresent(cnae -> {
            this.atividadePrincipalSelecionada = cnae;
        }));
    }

    private void carregarAtividadePrincipalCBO(SolicitacaoAlvaraEntity solicitacao) {
        solicitacao.getCadastroMobiliario().getMobiliarioCbos().stream().reduce((p1, p2) -> SimNaoEnum.SIM.getShortText().equals(p1.getPrincipal()) ? p1 : p2).ifPresent(mobCnae -> solicitacao.getSolicitacaoAlvaraAtividades().stream().reduce((p1, p2) -> p1.getSequenciaCbo().equals((Object)mobCnae.getRhCbo()) ? p1 : p2).ifPresent(cbo -> {
            this.atividadePrincipalSelecionada = cbo;
        }));
    }

    private void carregarAtividadePrincipalMEI(SolicitacaoAlvaraEntity solicitacao) {
        solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis().stream().reduce((p1, p2) -> SimNaoEnum.SIM.getShortText().equals(p1.getPrincipal()) ? p1 : p2).ifPresent(mei -> solicitacao.getSolicitacaoAlvaraAtividades().stream().reduce((p1, p2) -> p1.getAtividadeMei().equals((Object)mei.getAtividadeMei()) ? p1 : p2).ifPresent(atividadeMei -> {
            this.atividadePrincipalSelecionada = atividadeMei;
        }));
    }

    private CadastroMobiliarioEntity carregarCadastroMobiliarioPorCodigo(Long codigo) throws BaseException {
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregarMobiliarioPorCodigo(codigo);
    }

    private void carregaPessoaNaSolicitacaoContrato(String cpf) throws BaseException {
        try {
            if (!EloStringUtils.isEmpty((String)cpf)) {
                this.desabilitarCamposPessoaFisica = Boolean.FALSE;
                this.pessoa = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).getVerificarCadMobiliarioImobiliarioByPessoa(cpf);
                if (this.pessoa != null) {
                    EnderecoPessoaEntity endereco = this.retornarEnderecoPessoaSocio();
                    if (endereco != null) {
                        this.desabilitarCamposPessoaFisica = Boolean.TRUE;
                        this.cidadeSelecionada = endereco.getBairro().getId().getCidade();
                        this.bairroSelecionado = endereco.getBairro();
                        this.logradouroSelecionado = endereco.getLogradouroEndereco();
                        if (EloNumberUtils.isBiggerThanZero((Number)endereco.getCep()).booleanValue()) {
                            this.cepSocio = String.valueOf(endereco.getCep());
                        }
                        this.complementoSocio = endereco.getComplemento();
                        this.numeroLogradouroSocio = endereco.getNumero();
                        this.tipoEnderecoSocio = EnderecoTipoEnum.fromTipo((String)endereco.getTipoEndereco());
                    }
                } else {
                    this.pessoa = new PessoaEntity();
                    this.pessoa.setCnpjCpf(cpf);
                    this.pessoa.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
                    this.pessoa.setTipoPessoa("F");
                    this.pessoa.setDataInclusao(new Date());
                    this.mostraEndereco = true;
                    this.nomeParticipanteContrato = null;
                    this.cidadeSelecionada = null;
                    this.bairroSelecionado = null;
                    this.logradouroSelecionado = null;
                    this.numeroLogradouroSocio = null;
                    this.cepSocio = null;
                }
            }
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException(EloStringUtils.build((Object[])new Object[]{"Problema ao preencher a pessoa no contrato social da solicita\u00e7\u00e3o. ", e.getMessage()}));
        }
    }

    private StringBuilder verificarNatureza() {
        StringBuilder strNaturezas = new StringBuilder();
        for (NaturezaSolicitacaoAlvaraEntity natureza : this.solicitacaoAlvaraController.getSolicitacaoAlvara().getNaturezas()) {
            if (NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue().equals(natureza.getCodigo())) {
                this.naturezaInicial = true;
                strNaturezas.append("Natureza Inicial, ");
                continue;
            }
            if (NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE.getValue().equals(natureza.getCodigo())) {
                this.naturezaAlteracaoAtividade = true;
                strNaturezas.append("Altera\u00e7\u00e3o de Atividade, ");
            }
            if (NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO.getValue().equals(natureza.getCodigo())) {
                this.naturezaMudancaEnd = true;
                strNaturezas.append("Mudan\u00e7a de Endere\u00e7o, ");
            }
            if (NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS.getValue().equals(natureza.getCodigo())) {
                this.naturezaAlteracaoSocio = true;
                strNaturezas.append("Altera\u00e7\u00e3o de S\u00f3cios, ");
            }
            if (NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL.getValue().equals(natureza.getCodigo())) {
                this.naturezaMudancaRazaoSocial = true;
                strNaturezas.append("Altera\u00e7\u00e3o de Raz\u00e3o Social, ");
            }
            if (!NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA.getValue().equals(natureza.getCodigo())) continue;
            this.naturezaMudancaArea = true;
            strNaturezas.append("Altera\u00e7\u00e3o de \u00c1rea, ");
        }
        return strNaturezas.delete(strNaturezas.length() - 2, strNaturezas.length());
    }

    private void carregaDadosPessoaJaExistente(SolicitacaoAlvaraEntity solicitacao) {
        try {
            RestricaoAlvaraEntity restricaoAlvara = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).carregaRestricaoAlvaraBySolicitacaoCadRestricao(solicitacao.getSolicitacaoAlvara(), PortalUtils.getCodRestricaocadPessoaJaExistente());
            if (restricaoAlvara != null) {
                solicitacao.getCadastroMobiliario().getCadastroGeral().setPessoa(restricaoAlvara.getPessoa());
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String salvar() {
        if (!this.termoDeUso) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)"A Solicita\u00e7\u00e3o de alvar\u00e1 n\u00e3o ser\u00e1 finalizada. \u00c9 necess\u00e1rio aceitar os termos de uso.");
            return null;
        }
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        try {
            solicitacao.setFinalizado(SimNaoEnum.getNaoShortText());
            if (solicitacao.isNaturezaInicial()) {
                this.adicionaDescricaoAtividadesNoCadastro(solicitacao.getCadastroMobiliario());
            }
            solicitacao.setSolicitacaoAtividadeSelecionada(this.atividadePrincipalSelecionada);
            solicitacao.setDataSolicitacao(new Date());
            if (Objects.nonNull(solicitacao.getCadastroMobiliario())) {
                solicitacao.getCadastroMobiliario().setAreaPublicidade2(this.areaPublicidadeLuminada);
            }
            this.adicionarDocumentoAnexoTermoDeUso(solicitacao);
            if (solicitacao.isSolicitacaoJuridicaNormal()) {
                solicitacao = this.salvaJuridicaNormal(solicitacao);
            } else if (solicitacao.isSolicitacaoPrestadorServico()) {
                solicitacao = this.salvaPrestadorServico(solicitacao);
            } else if (solicitacao.isSolicitacaoMEI()) {
                solicitacao = this.salvaMEI(solicitacao);
            } else if (solicitacao.isSolicitacaoCBO()) {
                solicitacao = this.salvaCBO(solicitacao);
            }
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmailDebitosSocios(solicitacao);
            ((SolicitacaoAlvaraController)SpringContext.getBean(SolicitacaoAlvaraController.class)).setSolicitacaoAlvara(this.getSolicitacaoPorNumeroExercicio(solicitacao));
            return "toReciboSolicitacaoAlvara";
        }
        catch (BaseException e) {
            solicitacao.setLaudos(null);
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)e.getMessage());
            solicitacao.setFinalizado(SimNaoEnum.getNaoShortText());
            this.logger.info((Object)"N\u00e3o foi poss\u00edvel concluir a solicita\u00e7\u00e3o");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void adicionarDocumentoAnexoTermoDeUso(SolicitacaoAlvaraEntity solicitacao) {
        try {
            if (this.habilitaBotaoAnexoTermoDeUso && this.arquivoTermoDeUso != null) {
                SolicitacaoAlvaraDocumentoEntity documentoTermoUso = new SolicitacaoAlvaraDocumentoEntity();
                documentoTermoUso.setDataInclusao(new Date());
                documentoTermoUso.setDescricao("Termo de Uso assinado.");
                documentoTermoUso.setDocumento(this.arquivoTermoDeUso.getContents());
                documentoTermoUso.setNomeArquivo(this.arquivoTermoDeUso.getFileName());
                documentoTermoUso.setTipoDocumento(this.carregarTipoDocumentoTermoDeUso());
                documentoTermoUso.setSolicitacaoAlvara(solicitacao);
                solicitacao.getDocumentos().add(documentoTermoUso);
            }
        }
        catch (Exception e) {
            ShowMessage.addWarnMessage((String)VALIDACAO, (String)"N\u00e3o foi poss\u00edvel salvar o anexo do Termo de Uso.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private TipoDocumentoEntity carregarTipoDocumentoTermoDeUso() throws BaseException {
        ParametroAlvaraEntity parametroTipoDocumento = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPO_DOCUMENTO_TERMO_DE_USO);
        Long idTipoDocumento = Long.valueOf(parametroTipoDocumento.getValor());
        return ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).carregarTipoDocumentoPorId(idTipoDocumento);
    }

    private SolicitacaoAlvaraEntity salvaJuridicaNormal(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            if (this.cmcResponsavel != null) {
                solicitacao.getCadastroMobiliario().setCmcresponsavel(this.cmcResponsavel.getId().getCodigo());
            }
            solicitacao.getCadastroMobiliario().setCategoriaMobiliario(this.categoriaMobiliarioSelecionada);
            solicitacao.getCadastroMobiliario().setClassificacaoMobiliario(this.classificacaoMobiliarioSelecionada);
            solicitacao.setVerificaRestricaoCadastroExistente(this.getGerarRestricaoCadastroExistente());
            this.criarRegimeFiscal(solicitacao);
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoInicial(solicitacao, this.getGerarRestricaoCadastroExistente().booleanValue());
            return solicitacao;
        }
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoAlvaraAlteracao(solicitacao);
    }

    public void criarRegimeFiscal(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ParametroAlvaraEntity paramCriaRegimeFiscal = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CRIA_REGIME_FISCAL);
        if (paramCriaRegimeFiscal == null || SimNaoEnum.equalNao((String)paramCriaRegimeFiscal.getValor()).booleanValue()) {
            return;
        }
        if (Objects.nonNull(this.codigoRegimeFiscalSelecionado) && Objects.nonNull(this.dataInicioRegimeFiscal)) {
            RegimeFiscalPeriodoRealAiseEntity regimeFiscalPeriodo = new RegimeFiscalPeriodoRealAiseEntity();
            regimeFiscalPeriodo.setDataInicio(this.dataInicioRegimeFiscal);
            regimeFiscalPeriodo.setIdRegimeFiscal(this.codigoRegimeFiscalSelecionado);
            solicitacao.setRegimeFiscalPeriodo(regimeFiscalPeriodo);
        }
    }

    private SolicitacaoAlvaraEntity salvaPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            if (this.cmcResponsavel != null) {
                solicitacao.getCadastroMobiliario().setCmcresponsavel(this.cmcResponsavel.getId().getCodigo());
            }
            return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoInicial(solicitacao, false);
        }
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoAlvaraAlteracao(solicitacao);
    }

    private SolicitacaoAlvaraEntity salvaMEI(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            if (this.cmcResponsavel != null) {
                solicitacao.getCadastroMobiliario().setCmcresponsavel(this.cmcResponsavel.getId().getCodigo());
            }
            solicitacao.setVerificaRestricaoCadastroExistente(this.getGerarRestricaoCadastroExistente());
            this.criarContratoSocialPessoaMEI(solicitacao);
            this.criarRegimeFiscal(solicitacao);
            return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoInicial(solicitacao, this.getGerarRestricaoCadastroExistente().booleanValue());
        }
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoAlvaraAlteracao(solicitacao);
    }

    private void criarContratoSocialPessoaMEI(SolicitacaoAlvaraEntity solicitacao) {
        SolicitacaoContratoSocialEntity solicitacaoContratoSocial = solicitacao.getContratoSocial();
        if (solicitacaoContratoSocial != null) {
            SolicitacaoContratoSocialPessoaEntity solicitacaoContratoPessoa = new SolicitacaoContratoSocialPessoaEntity();
            solicitacaoContratoPessoa.setContratoSocial(solicitacaoContratoSocial);
            solicitacaoContratoPessoa.setPessoa(this.pessoa);
            solicitacaoContratoPessoa.setResponsavel(SimNaoEnum.getSimShortText());
            if (!solicitacao.getTipoDeInscricao().isMEI()) {
                this.pessoa.setNome(solicitacao.getNomeRazaoSocial());
            }
            solicitacaoContratoPessoa.setBairro(this.bairroSelecionado);
            solicitacaoContratoPessoa.setLogradouro(this.logradouroSelecionado.getId().getLogradouro());
            solicitacaoContratoPessoa.setLogradouroEndereco(this.logradouroSelecionado);
            solicitacaoContratoPessoa.setTipoEndereco(this.tipoEnderecoSocio != null ? this.tipoEnderecoSocio.getId().toString() : "");
            if (!EloStringUtils.isEmpty((String)this.cepSocio)) {
                solicitacaoContratoPessoa.setCep(Long.valueOf(this.cepSocio.replace("-", "")));
            }
            solicitacaoContratoPessoa.setComplemento(this.complementoSocio);
            solicitacaoContratoPessoa.setNumero(this.numeroLogradouroSocio);
            if (solicitacaoContratoSocial.getPessoas() == null) {
                solicitacaoContratoSocial.setPessoas(new ArrayList());
            }
            solicitacaoContratoSocial.getPessoas().add(solicitacaoContratoPessoa);
        }
    }

    private SolicitacaoAlvaraEntity salvaCBO(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            if (this.cmcResponsavel != null) {
                solicitacao.getCadastroMobiliario().setCmcresponsavel(this.cmcResponsavel.getId().getCodigo());
            }
            solicitacao.setVerificaRestricaoCadastroExistente(this.getGerarRestricaoCadastroExistente());
            return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoInicial(solicitacao, this.getGerarRestricaoCadastroExistente().booleanValue());
        }
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoAlvaraAlteracao(solicitacao);
    }

    private SolicitacaoAlvaraEntity getSolicitacaoPorNumeroExercicio(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorCpfCnpjExercicioNumSolic(solicitacao.getNumeroSolicitacao(), this.getExercicio(), null);
    }

    private Boolean verificarPropImovel(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        if (solicitacao.getCadastroImobiliario().getCadastroGeral().getPessoa().getCnpjCpf() == null) {
            return false;
        }
        if (solicitacao.getZonaGeo().toUpperCase().startsWith("ZR")) {
            String cnpjTroncoMobiliario;
            String cnpjPropImovel = solicitacao.getCadastroImobiliario().getCadastroGeral().getPessoa().getCnpjCpf();
            if (cnpjPropImovel.length() == 11) {
                throw new SolicitacaoAlvaraException("O cadastro da pessoa do im\u00f3vel n\u00e3o \u00e9 um CNPJ. Favor entrar em contato com a Prefeitura.");
            }
            String cnpjTroncoPropImovel = cnpjPropImovel.substring(0, 8);
            if (cnpjTroncoPropImovel.equals(cnpjTroncoMobiliario = solicitacao.getCpfCnpj().substring(0, 8))) {
                return true;
            }
            return false;
        }
        return true;
    }

    public void adicionarParticipanteContratoSocial() throws BaseException {
        if (EloStringUtils.isEmpty((String)this.pessoa.getCnpjCpf())) {
            this.consultaPessoaCpfCnpj();
        }
        if (!this.validaCpfCnpjSocio()) {
            return;
        }
        if (EloStringUtils.isEmpty((String)this.pessoa.getCnpjCpf()) || EloStringUtils.isEmpty((String)this.pessoa.getNome())) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"Preencha todos os campos obrigat\u00f3rios!");
            return;
        }
        if (this.solicitacaoListaContratoSocialPessoa == null) {
            this.solicitacaoListaContratoSocialPessoa = new ArrayList();
        } else {
            for (SolicitacaoContratoSocialPessoaEntity item : this.solicitacaoListaContratoSocialPessoa) {
                if (this.existePessoaComMesmoCpfCnpj(item.getPessoa(), this.pessoa.getCnpjCpf())) {
                    return;
                }
                if (!this.existeResponsavel(item)) continue;
                return;
            }
        }
        if (!EloListUtils.safeIsEmpty((List)this.pessoa.getEnderecos()).booleanValue() && !this.mostraEndereco) {
            this.consultaPessoaCpfCnpj();
        }
        try {
            if (this.validaEnderecoSocio()) {
                this.preencherDadosContratoSocialPessoa();
                this.limparDadosSocio();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"N\u00e3o foi poss\u00edvel adicionar um participante. Os campos com * s\u00e3o obrigat\u00f3rios!");
        }
    }

    private void limparDadosSocio() {
        this.solicitacaoContratoSocialPessoa = new SolicitacaoContratoSocialPessoaEntity();
        this.solicitacaoContratoSocialPessoa.setPessoa(new PessoaEntity());
        this.pessoa = new PessoaEntity();
        this.logradouroSelecionado = null;
        this.bairroSelecionado = null;
        this.cidadeSelecionada = null;
        this.cepSocio = "";
        this.complementoSocio = "";
        this.numeroLogradouroSocio = "";
        this.cnpjCpfContratoSocial = "";
        this.mostraEndereco = false;
    }

    private void preencherDadosContratoSocialPessoa() {
        this.solicitacaoContratoSocialPessoa.setBairro(this.bairroSelecionado);
        this.solicitacaoContratoSocialPessoa.setLogradouro(this.logradouroSelecionado.getId().getLogradouro());
        this.solicitacaoContratoSocialPessoa.setLogradouroEndereco(this.logradouroSelecionado);
        this.solicitacaoContratoSocialPessoa.setTipoEndereco(this.tipoEnderecoSocio.getId().toString());
        this.solicitacaoContratoSocialPessoa.setCep(Long.valueOf(this.cepSocio.replace("-", "")));
        this.solicitacaoContratoSocialPessoa.setComplemento(this.complementoSocio);
        this.solicitacaoContratoSocialPessoa.setNumero(this.numeroLogradouroSocio);
        this.solicitacaoContratoSocialPessoa.setPessoa(this.pessoa);
        this.solicitacaoContratoSocialPessoa.setContratoSocial(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getContratoSocial());
        this.solicitacaoListaContratoSocialPessoa.add(this.solicitacaoContratoSocialPessoa);
    }

    private boolean validaEnderecoSocio() throws SolicitacaoAlvaraException {
        boolean valido = true;
        String mensagemEnviarEmail = "Favor enviar e-mail para " + UtilsController.getEmailSetorAlvara();
        if (this.cidadeSelecionada == null || this.cidadeSelecionada.getId() == null) {
            if (!this.mostraEndereco) {
                ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"N\u00e3o foi encontrada a Cidade no endere\u00e7o da pessoa informada");
            }
            valido = false;
        }
        if (this.bairroSelecionado == null || this.bairroSelecionado.getId() == null) {
            if (!this.mostraEndereco) {
                ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"N\u00e3o foi encontrado o Bairro no endere\u00e7o da pessoa informada");
            }
            valido = false;
        }
        if (this.logradouroSelecionado == null || this.logradouroSelecionado.getId() == null || this.logradouroSelecionado.getId().getLogradouro() == null) {
            if (!this.mostraEndereco) {
                ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"N\u00e3o foi encontrado o Logradouro no endere\u00e7o da pessoa informada");
            }
            valido = false;
        }
        if (this.tipoEnderecoSocio == null || this.tipoEnderecoSocio.getId() == null) {
            if (!this.mostraEndereco) {
                ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"N\u00e3o foi encontrado o Tipo do Endere\u00e7o no endere\u00e7o da pessoa informada");
            }
            valido = false;
        }
        if (EloStringUtils.isEmpty((String)this.cepSocio)) {
            if (!this.mostraEndereco) {
                ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"N\u00e3o foi encontrado o CEP no endere\u00e7o da pessoa informada");
            }
            valido = false;
        }
        if (!this.mostraEndereco && !valido) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)mensagemEnviarEmail);
        }
        if (this.mostraEndereco && !valido) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"Todos campos com * s\u00e3o obrigat\u00f3rios!");
        }
        return valido;
    }

    private boolean existePessoaComMesmoCpfCnpj(PessoaEntity pessoa, String cnpjCpf) {
        if (pessoa.getCnpjCpf() != null && pessoa.getCnpjCpf().equals(cnpjCpf)) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"J\u00e1 existe uma pessoa registrada com este CPF!");
            return true;
        }
        return false;
    }

    private boolean existeResponsavel(SolicitacaoContratoSocialPessoaEntity item) {
        if (SimNaoEnum.equalSim((String)this.solicitacaoContratoSocialPessoa.getResponsavel()).booleanValue() && SimNaoEnum.equalSim((String)item.getResponsavel()).booleanValue()) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"J\u00e1 existe um respons\u00e1vel registrado!");
            return true;
        }
        return false;
    }

    public void abrirFormularioParticipanteContratoSocial() {
        this.pessoa = new PessoaEntity();
        this.pessoa.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
        this.solicitacaoContratoSocialPessoa = new SolicitacaoContratoSocialPessoaEntity();
        this.solicitacaoContratoSocialPessoa.setPessoa(new PessoaEntity());
        this.solicitacaoListaContratoSocialPessoa = new ArrayList();
        this.solicitacaoListaContratoSocialPessoa.addAll(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getContratoSocial().getPessoas());
        this.cepSocio = "";
        this.cnpjCpfContratoSocial = "";
        this.mostraEndereco = false;
        this.carregarParametroPermiteCadastrarBairroCidadeForaDoMunicipio();
        this.cidadeSelecionada = null;
        this.bairroSelecionado = null;
        this.logradouroSelecionado = null;
        this.tipoEnderecoSocio = null;
        this.mostraEndereco = true;
        this.cepSocio = null;
        this.cpfCnpjHistorico = 0;
    }

    private void carregarParametroPermiteCadastrarBairroCidadeForaDoMunicipio() {
        try {
            ParametroAlvaraEntity parametroPermiteCadastroEnderecosForaMunicipio = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.PERMITE_CADASTRO_BAIRRO_CIDADE);
            this.permiteCadastroEnderecosForaMunicipio = SimNaoEnum.equalSim((String)parametroPermiteCadastroEnderecosForaMunicipio.getValor());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)e.getMessage());
        }
    }

    private boolean isRestricaoCadastrosDuplicados(SolicitacaoAlvaraEntity solicitacao, Boolean geraRestricao) throws BaseException {
        if (!this.isAcessoWeb() && this.getUsuarioLogado().isRoleVerificaCadastroDuplicado()) {
            this.listagemCadastrosMobiliario = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaCadastrosMobiliarios(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getCpfCnpj());
            if (!EloListUtils.safeIsEmpty((List)this.listagemCadastrosMobiliario).booleanValue()) {
                return false;
            }
            return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificaCadastrosDuplicados(solicitacao, geraRestricao);
        }
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificaCadastrosDuplicados(solicitacao, geraRestricao);
    }

    private boolean isAcessoWeb() {
        UserDetails userDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return userDetails instanceof AcessoWebEntity;
    }

    public String validarCamposObrigatorios() {
        try {
            SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
            if (!this.validaCpfCnpj(solicitacao.getCpfCnpj())) {
                return null;
            }
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && this.atividadePrincipalSelecionada == null) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"Selecione uma atividade principal!");
                return null;
            }
            if (SimNaoEnum.equalSim((String)solicitacao.getFinalizado()).booleanValue()) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"Esta solicita\u00e7\u00e3o j\u00e1 foi conclu\u00edda.");
                return null;
            }
            this.tratarCamposTelefone(solicitacao);
            this.verificarSeHabilitaBotaoAnexoTermoDeUso();
            if (solicitacao.isSolicitacaoJuridicaNormal()) {
                return this.validarCamposAlvaraJuridicaNormal(solicitacao);
            }
            if (solicitacao.isSolicitacaoPrestadorServico()) {
                return this.validarCamposAlvaraPrestadorServico(solicitacao);
            }
            if (solicitacao.isSolicitacaoMEI()) {
                return this.validarCamposAlvaraMEI(solicitacao);
            }
            if (solicitacao.isSolicitacaoCBO()) {
                return this.verificaDuplicidadeCBO(solicitacao);
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            RequestContext.getCurrentInstance().execute("statusDialog.hide()");
        }
        return null;
    }

    private void tratarCamposTelefone(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.getTelefone() == null) {
            solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getContatoPessoaPrincipal().setTelefoneComercial(null);
        } else {
            solicitacao.setTelefone(solicitacao.getTelefone().replaceAll("[\\s()-]", ""));
        }
        if (solicitacao.getTelefoneCelular() == null) {
            solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getContatoPessoaPrincipal().setTelefoneCelular(null);
        } else {
            solicitacao.setTelefoneCelular(solicitacao.getTelefoneCelular().replaceAll("[\\s()-]", ""));
        }
        solicitacao.getCadastroMobiliario().setTelefone(solicitacao.getTelefonePreenchido());
    }

    private void verificarSeHabilitaBotaoAnexoTermoDeUso() throws BaseException {
        this.textoTituloBotaoAnexoTermo = "Anexar termo de uso assinado.";
        if (this.renderBotaoImprimirTermo && !this.isTipoDocumentoTermoValido()) {
            this.renderBotaoImprimirTermo = false;
            ShowMessage.addErrorMessage((String)"validacaoTermos", (String)"O Par\u00e2metro TIPO_DOCUMENTO_TERMO_DE_USO n\u00e3o foi configurado.");
            this.textoTituloBotaoAnexoTermo = "O Par\u00e2metro TIPO_DOCUMENTO_TERMO_DE_USO n\u00e3o foi configurado.";
            return;
        }
        ParametroAlvaraEntity parametroTipoDocumentoTermoDeUso = this.parametroTipoDocumentoDoTermoDeUsoConfigurado();
        this.habilitaBotaoAnexoTermoDeUso = this.tipoDocumentoNaoAnexadoAnteriormente(parametroTipoDocumentoTermoDeUso);
    }

    private boolean isTipoDocumentoTermoValido() throws BaseException {
        ParametroAlvaraEntity parametroTipoDocumentoTermoDeUso = this.parametroTipoDocumentoDoTermoDeUsoConfigurado();
        if (Objects.isNull(parametroTipoDocumentoTermoDeUso) || EloStringUtils.isEmpty((String)parametroTipoDocumentoTermoDeUso.getValor())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean tipoDocumentoNaoAnexadoAnteriormente(ParametroAlvaraEntity parametroTipoDocumentoTermoDeUso) throws BaseException {
        List tiposDocumentoDoTipoDeInscricaoSelecionado = this.carregarTiposDocumentoDoTipoDeInscricaoSelecionado();
        List tiposDocumentoConfiguradosParaAtividade = this.carregarTiposDocumentoDasAtividadesSelecionadas();
        boolean tipoJaUtilizadoEmOutrasConfiguracoes = tiposDocumentoDoTipoDeInscricaoSelecionado.stream().anyMatch(tipoDoc -> tipoDoc.getTipoDocumento().getTipoDocumento().toString().equals(parametroTipoDocumentoTermoDeUso.getValor()));
        if (!tipoJaUtilizadoEmOutrasConfiguracoes) {
            tipoJaUtilizadoEmOutrasConfiguracoes = tiposDocumentoConfiguradosParaAtividade.stream().anyMatch(tipoDoc -> tipoDoc.getTipoDocumento().getTipoDocumento().toString().equals(parametroTipoDocumentoTermoDeUso.getValor()));
        }
        if (tipoJaUtilizadoEmOutrasConfiguracoes) {
            this.textoTituloBotaoAnexoTermo = "O Tipo de Documento configurado no par\u00e2metro TIPO_DOCUMENTO_TERMO_DE_USO j\u00e1 est\u00e1 sendo usado em outra configura\u00e7\u00e3o.";
            return false;
        }
        return true;
    }

    private List<ConfiguracaoAtividadeDocumentoEntity> carregarTiposDocumentoDasAtividadesSelecionadas() throws BaseException {
        return ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).carregaTiposDocumentoPorAtividades(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades());
    }

    private List<TipoDocTipoInscricaoAlvaraEntity> carregarTiposDocumentoDoTipoDeInscricaoSelecionado() throws BaseException {
        return ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).carregaTiposDocumentoPorTipoInscricao(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getTipoDeInscricao());
    }

    private ParametroAlvaraEntity parametroTipoDocumentoDoTermoDeUsoConfigurado() throws BaseException {
        ParametroAlvaraEntity tipoDocumentoTermoDeUso = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPO_DOCUMENTO_TERMO_DE_USO);
        return tipoDocumentoTermoDeUso;
    }

    private String verificaDuplicidadeCBO(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (!this.existeCampoNulo(solicitacao)) {
            this.validarProprietarioImovel(solicitacao);
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL}) && this.isRestricaoCadastrosDuplicados(solicitacao, this.getGerarRestricaoCadastroExistente())) {
                this.validarCadastroDuplicado();
                return null;
            }
            return this.validarCamposAlvaraCBO();
        }
        throw new SolicitacaoAlvaraException("Favor preencher todos os campos com * !");
    }

    private void validarCadastroDuplicado() throws BaseException, SolicitacaoAlvaraException {
        RequestContext context = RequestContext.getCurrentInstance();
        ParametroAlvaraEntity parametroAlvara = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.BLOQUEIA_CPF_DUPLICADO);
        if (SimNaoEnum.equalSim((String)parametroAlvara.getValor()).booleanValue()) {
            throw new SolicitacaoAlvaraException("J\u00e1 existe um cadastro com esse CPF. Entre em contato com a prefeitura: " + UtilsController.getEmailSetorAlvara());
        }
        context.execute("dlgConfirmaAtualizacaoCBO.show()");
    }

    private void validarProprietarioImovel(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        if (solicitacao.getVerificaPropImovel() != null && SimNaoEnum.equalSim((String)solicitacao.getVerificaPropImovel()).booleanValue() && !this.verificarPropImovel(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("N\u00e3o \u00e9 poss\u00edvel concluir a solicita\u00e7\u00e3o, o cnpj do propriet\u00e1rio do im\u00f3vel \u00e9 diferente da atual empresa solicitante!");
        }
    }

    public String validarCamposAlvaraCBO() throws BaseException {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        RequestContext context = RequestContext.getCurrentInstance();
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            if (this.isExibirSimulacaoTaxa()) {
                this.totalTaxas = this.getValorTotalTaxaMobiliariaETaxaLaudo(solicitacao);
                context.update(DLG_CONFIRMACAO);
                context.execute(DIALOG_CONFIRMA_VALORES_SHOW);
            } else {
                context.execute(DIALOG_TERMOS_SHOW);
            }
        } else if (this.isExibirSimulacaoTaxa()) {
            this.valorTaxasMobiliarias = this.possuiDebitoExercicioAtual(solicitacao) == false ? this.getTaxaMobiliaria(solicitacao) : BigDecimal.ZERO;
            this.valorLaudo = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && solicitacao.possuiAtividadeNova() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && (solicitacao.isAreaMaiorQueAtual() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) ? this.getValorTaxaLaudo() : BigDecimal.ZERO;
            this.totalTaxas = EloNumberUtils.safeAdd((BigDecimal)this.valorLaudo, (BigDecimal)this.valorTaxasMobiliarias, (int)2);
            if (BigDecimal.ZERO.compareTo(this.totalTaxas) < 0) {
                context.update(DLG_CONFIRMACAO);
                context.execute(DIALOG_CONFIRMA_VALORES_SHOW);
            } else {
                context.execute(DIALOG_TERMOS_SHOW);
            }
        } else {
            context.execute(DIALOG_TERMOS_SHOW);
        }
        return null;
    }

    private boolean validaCpfCnpj(String cpfCnpj) {
        if (cpfCnpj == null || cpfCnpj.isEmpty()) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)"Favor preencher todos os campos com * !");
            return false;
        }
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoCBO()) {
            if (cpfCnpj.length() != 11 || new CPFValidator(false).invalidMessagesFor(cpfCnpj).size() != 0) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"CPF Inv\u00e1lido.");
                return false;
            }
        } else if (cpfCnpj.length() != 14 || new CNPJValidator(false).invalidMessagesFor(cpfCnpj).size() != 0) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)"CNPJ Inv\u00e1lido.");
            return false;
        }
        return true;
    }

    private BigDecimal getTaxaMobiliaria(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getConsultaTaxaMobiliaria(solicitacao);
    }

    private BigDecimal getValorTaxaLaudo() throws BaseException {
        if (this.cobraTaxaLaudo.booleanValue()) {
            return new BigDecimal(this.getParametroEntidadeExerc(ParametroEntidadeExercicioEnum.VALORLAUDO.name()));
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getValorTotalTaxaMobiliariaETaxaLaudo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.valorTaxasMobiliarias = this.getTaxaMobiliaria(solicitacao);
        this.valorLaudo = this.getValorTaxaLaudo();
        if (this.valorTaxasMobiliarias != null) {
            return EloNumberUtils.safeAdd((BigDecimal)this.valorLaudo, (BigDecimal)this.valorTaxasMobiliarias, (int)2);
        }
        return this.valorLaudo;
    }

    private Boolean possuiDebitoExercicioAtual(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificarDebitoExercicioAtual(this.getGuiaRecolhimento(solicitacao), solicitacao.getCadastroMobiliario().getId(), this.getExercicio());
    }

    private Long getExercicio() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getEntidade().getId().getExercicioTributacao().getExercicio();
    }

    private GuiaRecolhimentoEntity getGuiaRecolhimento(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaGuiaRecolhimentoPorSolicitacao(this.getExercicio(), solicitacao);
    }

    public boolean renderizaBotaoImprimirTaxasAlvara() throws BaseException {
        if (UtilsController.desabilitaImpressaoTaxasAlvara()) {
            return false;
        }
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        if (solicitacao.isGrauRiscoLiberdadeEconomica() && SimNaoEnum.equalNao((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.PERMITE_GERAR_TAXA_LIBERDADE_ECONOMICA).getValor()).booleanValue()) {
            return false;
        }
        if (solicitacao.isNaturezaMudancaArea() && solicitacao.getNaturezas().size() == 1) {
            if (!solicitacao.isAreaMaiorQueAtual() && !solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) {
                return true;
            }
        } else if (solicitacao.isAlteracaoRazaoOuRazaoESocio()) {
            return false;
        }
        if (solicitacao.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS})) {
            return false;
        }
        if (solicitacao.isSolicitacaoPrestadorServico() || solicitacao.isSolicitacaoMEIPrestador() && EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            return true;
        }
        return !solicitacao.isGrauRiscoAlto();
    }

    private boolean existeCampoNulo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (!this.campoRazaoFantasia.booleanValue() && EloStringUtils.isEmpty((String)solicitacao.getNomeRazaoSocial())) {
            return true;
        }
        if (!this.campoRazaoFantasia.booleanValue() && !solicitacao.isSolicitacaoCBO() && EloStringUtils.isEmpty((String)solicitacao.getFantasia()) && !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS})) {
            return true;
        }
        if (!this.campoCnpj.booleanValue() && EloStringUtils.isEmpty((String)solicitacao.getCpfCnpj())) {
            return true;
        }
        if (!this.campoTelefone.booleanValue() && EloStringUtils.isEmpty((String)solicitacao.getTelefone()) && EloStringUtils.isEmpty((String)solicitacao.getTelefoneCelular())) {
            return true;
        }
        if (!this.campoDescAtividades.booleanValue() && this.solicitacaoAlvaraController.getSolicitacaoAlvara().isNaturezaAlteracaoAtividade() && EloStringUtils.isEmpty((String)solicitacao.getDescricaoAtividades())) {
            return true;
        }
        if (!this.campoEmail.booleanValue() && EloStringUtils.isEmpty((String)solicitacao.getEmail())) {
            return true;
        }
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS}) && !EloNumberUtils.isBiggerThanZero((Number)solicitacao.getContratoSocial().getNumeroAlteracao()).booleanValue()) {
            return true;
        }
        if (solicitacao.isSolicitacaoMEI()) {
            if (EloStringUtils.isEmpty((String)this.pessoa.getCnpjCpf())) {
                return true;
            }
            if (!this.desabilitarCamposPessoaFisica) {
                if (this.tipoEnderecoSocio == null) {
                    return true;
                }
                if (this.cidadeSelecionada == null) {
                    return true;
                }
                if (this.bairroSelecionado == null) {
                    return true;
                }
                if (EloStringUtils.isEmpty((String)this.cepSocio)) {
                    return true;
                }
                if (this.logradouroSelecionado == null) {
                    return true;
                }
                if (EloStringUtils.isEmpty((String)this.numeroLogradouroSocio)) {
                    return true;
                }
            }
        }
        if (solicitacao.isSolicitacaoCBO()) {
            if (EloStringUtils.isEmpty((String)solicitacao.getRg())) {
                return true;
            }
            if (EloStringUtils.isEmpty((String)solicitacao.getRgOrgaoEmissor())) {
                return true;
            }
            if (EloStringUtils.isEmpty((String)solicitacao.getRgUfEmissor())) {
                return true;
            }
            if (solicitacao.getRgDataEmissao() == null) {
                return true;
            }
        }
        if (this.renderizaRegimeFiscal.booleanValue() && !EloNumberUtils.isBiggerThanZero((Number)this.codigoRegimeFiscalSelecionado).booleanValue()) {
            throw new SolicitacaoAlvaraException("Selecione o Regime Fiscal para continuar.");
        }
        return false;
    }

    public String aceitarTermos() {
        boolean aceito = false;
        RequestContext context = RequestContext.getCurrentInstance();
        if (this.termoDeUso) {
            aceito = true;
            context.addCallbackParam("aceito", (Object)aceito);
            return this.salvar();
        }
        context.addCallbackParam("aceito", (Object)aceito);
        ShowMessage.addErrorMessage((String)"validacaoTermos", (String)"A Solicita\u00e7\u00e3o de Alvar\u00e1 n\u00e3o ser\u00e1 finalizada. \u00c9 necess\u00e1rio aceitar os termos de uso.");
        return null;
    }

    public List<CidadeEntity> completeCidade(String query) {
        List cidades = null;
        try {
            cidades = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaCidadePorDescricao(query);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return cidades;
    }

    public List<LogradouroEntity> completeEndereco(String query) {
        List enderecos = null;
        try {
            if (this.cidadeSelecionada != null) {
                enderecos = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaLogradouroPorCidade(this.cidadeSelecionada.getId(), query);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return enderecos;
    }

    public List<BairroEntity> completeBairro(String query) {
        List bairros = null;
        try {
            if (this.cidadeSelecionada != null) {
                bairros = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaBairroPorDescricaoECidade(this.cidadeSelecionada.getId(), query);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bairros;
    }

    public void selectLogradouro(SelectEvent event) {
        this.logradouroSelecionado = (LogradouroEntity)event.getObject();
    }

    public void selectCidade(SelectEvent event) throws BaseException {
        this.cidadeSelecionada = (CidadeEntity)event.getObject();
        this.cidadeDiferenteDaEntidade = this.validarCidadeDiferenteDaEntidade();
        this.limparCamposEnderecoSocio();
    }

    private void limparCamposEnderecoSocio() {
        this.cepSocio = null;
        this.numeroLogradouroSocio = null;
        this.bairroSelecionado = null;
        this.logradouroSelecionado = null;
        this.tipoEnderecoSocio = null;
        this.novoBairro = null;
        this.novoLogradouro = null;
    }

    private boolean validarCidadeDiferenteDaEntidade() throws BaseException {
        EntidadeAiseEntity entidade = this.entidadeController.getEntidade();
        if (entidade.getBairro() != null && entidade.getBairro().getId().getCidade() != null) {
            return !entidade.getBairro().getId().getCidade().equals((Object)this.cidadeSelecionada);
        }
        return false;
    }

    public List<TipoCapitalSocialEntity> listarTipoContratoSocial() throws BaseException {
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).buscarTodosTipoCapitalSocial();
    }

    public List<TipoRegistroMercantilEntity> listarTipoRegistroMercantil() throws BaseException {
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).buscarTodosRegistrosMercantis();
    }

    public void verificarSocios() {
        boolean existeSocio = true;
        if (this.solicitacaoListaContratoSocialPessoa == null || this.solicitacaoListaContratoSocialPessoa.isEmpty()) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"\u00c9 preciso informar um S\u00f3cio no quadro societ\u00e1rio!");
            existeSocio = false;
        } else if (this.verificarSeExisteResponsavelContratoSocial(existeSocio)) {
            this.solicitacaoAlvaraController.getSolicitacaoAlvara().getContratoSocial().getPessoas().clear();
            this.solicitacaoAlvaraController.getSolicitacaoAlvara().getContratoSocial().getPessoas().addAll(this.solicitacaoListaContratoSocialPessoa);
            RequestContext.getCurrentInstance().execute("dialogSocios.hide()");
        }
    }

    private boolean verificarSeExisteResponsavelContratoSocial(boolean existeSocio) {
        long quantidadeComoResponsavel = this.solicitacaoListaContratoSocialPessoa.stream().filter(contratoSocial -> SimNaoEnum.equalSim((String)contratoSocial.getResponsavel())).count();
        if (quantidadeComoResponsavel == 0L) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"\u00c9 necess\u00e1rio ter 1 (um) dos participantes como Respons\u00e1vel.");
        } else if (quantidadeComoResponsavel > 1L) {
            ShowMessage.addErrorMessage((String)VALIDACAO_CONTRATO_SOCIAL, (String)"N\u00e3o \u00e9 permitido ter mais de 1 (um) participantes como Respons\u00e1vel.");
        }
        return quantidadeComoResponsavel == 1L;
    }

    public void adicionarComplemento() throws BaseException {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).addComplemento(solicitacao, this.complemento);
        if (this.complemento != null && !this.complemento.trim().isEmpty()) {
            StringBuilder strComplemento = new StringBuilder();
            if (solicitacao.getCadastroMobiliario().getCadastroGeral().getComplemento() != null && !solicitacao.isNaturezaMudancaEndereco()) {
                strComplemento.append(solicitacao.getCadastroMobiliario().getCadastroGeral().getComplemento().trim()).append("; ");
            }
            strComplemento.append(this.complemento.trim());
            solicitacao.setComplementoCadGeral(strComplemento.toString().replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("\n", " "));
        }
    }

    public String formataNumber(BigDecimal valor) {
        return EloStringUtils.formatValor((BigDecimal)valor, (int)2);
    }

    private Boolean getGerarRestricaoCadastroExistente() {
        return this.verificaRestricaoCadastroExistente.equalsIgnoreCase(SimNaoEnum.getSimShortText());
    }

    public void imprimirTaxas(SolicitacaoAlvaraEntity solicitacao) {
        try {
            if (solicitacao.isSolicitacaoMEI()) {
                ShowMessage.addInfoMessage((String)VALIDACAO, (String)"Tipo de Inscri\u00e7\u00e3o MEI \u00e9 Isento de Taxas");
            } else {
                ImprimirTaxasAlvara imprimirTaxasAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimiTaxaAlvaraCadastroMob(solicitacao);
                String userKey = ((FacadeDebitos)SpringContext.getBean(FacadeDebitos.class)).loginWeb();
                RequestContext context = RequestContext.getCurrentInstance();
                if (Objects.nonNull(imprimirTaxasAlvara.getCarne())) {
                    String urlImprimiCarne = (String)SpringContext.getBean((String)"urlImprimirCarne", String.class);
                    String urlCarne = urlImprimiCarne + "uid=" + userKey + "&value=" + imprimirTaxasAlvara.getCarne();
                    context.execute("window.open('" + urlCarne + "','_blank')");
                }
                if (Objects.nonNull(imprimirTaxasAlvara.getBloqueto())) {
                    String urlImprimirBloqueto = (String)SpringContext.getBean((String)"urlImprimirBloqueto", String.class);
                    String urlBloqueto = urlImprimirBloqueto + "uid=" + userKey + "&value=" + imprimirTaxasAlvara.getBloqueto() + "&exercicio=" + imprimirTaxasAlvara.getExercicioBloqueto();
                    context.execute("window.open('" + urlBloqueto + "','_blank')");
                }
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void imprimirAlvara(SolicitacaoAlvaraEntity solicitacao) {
        try {
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirAlvara(solicitacao);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)String.format("%s%s", "Aten\u00e7\u00e3o!  ", e.getMessage()));
        }
    }

    private String validarCamposAlvaraJuridicaNormal(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        RequestContext context = RequestContext.getCurrentInstance();
        if (!this.existeCampoNulo(solicitacao)) {
            if (!this.validarInformacoesHotelMotel()) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"\u00c9 preciso informar um valor nas Ativides de Hotel ou Motel ");
                return null;
            }
            if (!this.validarEmail(solicitacao)) {
                return null;
            }
            if (!this.isCategoriaMobiliarioValida()) {
                return null;
            }
            if (!this.isClassificacaoMobiliarioValida()) {
                return null;
            }
            if (solicitacao.getVerificaPropImovel() != null && solicitacao.getVerificaPropImovel().equals(SimNaoEnum.getSimShortText()) && !this.verificarPropImovel(solicitacao).booleanValue()) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"N\u00e3o \u00e9 poss\u00edvel concluir a solicita\u00e7\u00e3o, o cnpj do propriet\u00e1rio do Im\u00f3vel \u00e9 diferente da atual Empresa solicitante!");
                return null;
            }
            if (this.isRestricaoCadastrosDuplicados(solicitacao, this.getGerarRestricaoCadastroExistente())) {
                this.restricaoCadastroController.setRenderBtAvancar(Boolean.valueOf(false));
                this.restricaoCadastroController.getRestricaoAlvaraVo().setDescricaoRestricao("J\u00e1 Existe um Cadastro com este CNPJ/CPF.");
                return "toRestricoesCadastro";
            }
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
                if (this.isPessoaMobLtda(solicitacao.getPessoaMobiliario().getPessoaMobiliario()) && (this.solicitacaoListaContratoSocialPessoa == null || this.solicitacaoListaContratoSocialPessoa.isEmpty())) {
                    ShowMessage.addErrorMessage((String)VALIDACAO, (String)" Adicione os participantes do contrato social!");
                    return null;
                }
                if (!EloListUtils.safeIsEmpty((List)this.listagemCadastrosMobiliario).booleanValue()) {
                    RequestContext.getCurrentInstance().execute("dialogCadastroDuplicado.show()");
                } else if (this.isExibirSimulacaoTaxa()) {
                    this.totalTaxas = this.getValorTotalTaxaMobiliariaETaxaLaudo(solicitacao);
                    context.execute(DIALOG_CONFIRMA_VALORES_SHOW);
                    context.update(DLG_CONFIRMACAO);
                } else {
                    context.execute("dialogTermos.show()");
                }
            } else {
                if (solicitacao.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS})) {
                    this.termoDeUso = true;
                    return this.aceitarTermos();
                }
                if (this.verificaIsencaoCadastroGeral(solicitacao.getCadastroMobiliario().getCadastroGeral()).booleanValue()) {
                    context.execute("dialogTermos.show()");
                } else {
                    this.gerarTaxasSeForNecessario(solicitacao, context);
                }
            }
        } else {
            ShowMessage.addWarnErrorMessage((String)VALIDACAO, (String)("Favor preencher todos os campos com * ! Caso o campo esteja desabilitado, por favor envie um e-mail para " + UtilsController.getEmailSetorAlvara()));
        }
        return null;
    }

    public void selecionaCadastroExistente() {
        if (this.cadastroMobiliarioSelecionado != null) {
            this.cadastroMobiliarioSelecionado.getMobiliarioCnaes().clear();
            this.cadastroMobiliarioSelecionado.getMobiliarioAtividadeMeis().clear();
            this.cadastroMobiliarioSelecionado.getCadastroGeral().setUsuario(PortalUtils.getUsuarioalvaraonline());
            this.solicitacaoAlvaraController.getSolicitacaoAlvara().setCadastroMobiliario(this.cadastroMobiliarioSelecionado);
            RequestContext.getCurrentInstance().execute(DIALOG_TERMOS_SHOW);
        } else {
            ShowMessage.addWarnErrorMessage((String)"growlCadastro", (String)"Selecione um Cadastro Mobili\u00e1rio para continuar.");
        }
    }

    private boolean isCategoriaMobiliarioValida() {
        if (this.renderizaCategoriaMobiliarioPJ && this.categoriaMobiliarioSelecionada == null) {
            ShowMessage.addWarnMessage((String)VALIDACAO, (String)"Informe a Categoria do Mobili\u00e1rio.");
            return false;
        }
        return true;
    }

    private boolean isClassificacaoMobiliarioValida() {
        if (this.renderizaClassificacaoMobiliarioPJ && this.classificacaoMobiliarioSelecionada == null) {
            ShowMessage.addWarnMessage((String)VALIDACAO, (String)"Informe a Classifica\u00e7\u00e3o do Mobili\u00e1rio.");
            return false;
        }
        return true;
    }

    private boolean validarInformacoesHotelMotel() {
        boolean camposObrigatorios = Boolean.FALSE;
        camposObrigatorios = EloListUtils.safeIsEmpty((List)this.atividadeCnaesVo) == false ? this.atividadeCnaesVo.stream().filter(item -> item.existeUmCampoPreenchido()).findFirst().isPresent() : Boolean.TRUE.booleanValue();
        return camposObrigatorios;
    }

    private void gerarTaxasSeForNecessario(SolicitacaoAlvaraEntity solicitacao, RequestContext context) throws BaseException {
        if (this.isExibirSimulacaoTaxa()) {
            this.valorTaxasMobiliarias = this.possuiDebitoExercicioAtual(solicitacao) == false && !this.isCadastroMobiliarioIsento(solicitacao.getCadastroMobiliario()) ? this.getTaxaMobiliaria(solicitacao) : BigDecimal.ZERO;
            this.valorLaudo = solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && solicitacao.possuiAtividadeNova() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && (solicitacao.isAreaMaiorQueAtual() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) || solicitacao.isAlteracaoRazaoOuRazaoESocio() && solicitacao.isSituacaoMobiliarioNormal() && Objects.nonNull(solicitacao.getCadastroMobiliario().getDataValidadeAlvara()) ? this.getValorTaxaLaudo() : BigDecimal.ZERO;
            this.totalTaxas = EloNumberUtils.safeAdd((BigDecimal)this.valorLaudo, (BigDecimal)this.valorTaxasMobiliarias, (int)2);
            if (BigDecimal.ZERO.compareTo(this.totalTaxas) < 0) {
                context.execute(DIALOG_CONFIRMA_VALORES_SHOW);
            } else {
                context.execute(DIALOG_TERMOS_SHOW);
            }
        } else {
            context.execute(DIALOG_TERMOS_SHOW);
        }
    }

    private boolean isCadastroMobiliarioIsento(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).isCadastroMobiliarioIsento(cadastroMobiliario);
    }

    private boolean validarEmail(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        if (!UtilsController.validaEmail((String)solicitacao.getEmail())) {
            throw new SolicitacaoAlvaraException("Informe um e-mail v\u00e1lido!");
        }
        return true;
    }

    private String validarCamposAlvaraPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        RequestContext context = RequestContext.getCurrentInstance();
        try {
            if (!this.existeCampoNulo(solicitacao)) {
                if (!this.validarEmail(solicitacao)) {
                    return null;
                }
                if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
                    if (this.isPessoaMobLtda(solicitacao.getPessoaMobiliario().getPessoaMobiliario()) && EloListUtils.safeIsEmpty((List)this.solicitacaoListaContratoSocialPessoa).booleanValue()) {
                        ShowMessage.addErrorMessage((String)VALIDACAO, (String)" Adicione os participantes do contrato social!");
                        return null;
                    }
                    if (this.temLaudosAGerar(solicitacao)) {
                        this.valorLaudo = this.getValorTaxaLaudo();
                        this.totalTaxas = this.getValorTaxaLaudo();
                    }
                    if (EloNumberUtils.isBiggerThanZero((Number)this.totalTaxas).booleanValue() && this.isExibirSimulacaoTaxa()) {
                        context.execute(DIALOG_CONFIRMA_VALORES_SHOW);
                    } else {
                        context.execute(DIALOG_TERMOS_SHOW);
                    }
                } else {
                    if ((this.validaGeraLaudoPrestadorServico(solicitacao = this.carregarAtividadesMobNaSolicitacao(solicitacao)) || this.temLaudosAGerar(solicitacao)) && this.isExibirSimulacaoTaxa()) {
                        this.valorLaudo = this.getValorTaxaLaudo();
                        this.totalTaxas = this.getValorTaxaLaudo();
                    }
                    if (EloNumberUtils.isBiggerThanZero((Number)this.totalTaxas).booleanValue()) {
                        context.execute(DIALOG_CONFIRMA_VALORES_SHOW);
                    } else {
                        context.execute(DIALOG_TERMOS_SHOW);
                    }
                }
            } else {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"Favor preencher todos os campos com * !");
            }
        }
        catch (BaseException be) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)be.getMessage());
            return null;
        }
        return null;
    }

    private boolean isPessoaMobLtda(Long idPessoaMobiliario) throws BaseException {
        ParametroAlvaraEntity paramPessoaMobLtda = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.COD_PESSOA_MOB_LTDA_OBRIGATORIO_SOCIO);
        if (!EloStringUtils.isEmpty((String)paramPessoaMobLtda.getValor()) && idPessoaMobiliario.equals(new Long(paramPessoaMobLtda.getValor()))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String validarCamposAlvaraMEI(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        RequestContext context = RequestContext.getCurrentInstance();
        if (!this.existeCampoNulo(solicitacao)) {
            if (this.pessoa.getCnpjCpf().length() != 11 || new CPFValidator(false).invalidMessagesFor(this.pessoa.getCnpjCpf()).size() != 0) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"CPF da Pessoa F\u00edsica Inv\u00e1lido.");
                return null;
            }
            if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().getTipoDeInscricao().isMEI() && EloStringUtils.isEmpty((String)this.pessoa.getNome())) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"Nome Completo da Pessoa F\u00edsica \u00e9 obrigat\u00f3rio.");
                return null;
            }
            if (!this.validarEmail(solicitacao)) {
                return null;
            }
            if (solicitacao.getVerificaPropImovel() != null && solicitacao.getVerificaPropImovel().equals(SimNaoEnum.getSimShortText()) && !this.verificarPropImovel(solicitacao).booleanValue()) {
                ShowMessage.addErrorMessage((String)VALIDACAO, (String)"N\u00e3o \u00e9 poss\u00edvel concluir a solicita\u00e7\u00e3o, o cnpj do propriet\u00e1rio do Im\u00f3vel \u00e9 diferente da atual Empresa solicitante!");
                return null;
            }
            if (this.isRestricaoCadastrosDuplicados(solicitacao, this.getGerarRestricaoCadastroExistente())) {
                this.restricaoCadastroController.setRenderBtAvancar(Boolean.valueOf(false));
                this.restricaoCadastroController.getRestricaoAlvaraVo().setDescricaoRestricao("J\u00e1 Existe um Cadastro com este CNPJ/CPF.");
                return "toRestricoesCadastro";
            }
            if (!EloListUtils.safeIsEmpty((List)this.listagemCadastrosMobiliario).booleanValue()) {
                RequestContext.getCurrentInstance().execute("dialogCadastroDuplicado.show()");
            } else if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
                context.execute(DIALOG_TERMOS_SHOW);
            } else {
                this.carregarAtividadesMobNaSolicitacao(solicitacao);
                context.execute(DIALOG_TERMOS_SHOW);
            }
        } else {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)"Favor preencher todos os campos com * !");
        }
        return null;
    }

    private boolean validaGeraLaudoPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).validaGeraLaudoPrestadorServico(solicitacao);
    }

    private boolean temLaudosAGerar(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        Set laudosAGerar = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaLaudosAGerarPrestadorServico(solicitacao);
        return laudosAGerar != null && !laudosAGerar.isEmpty();
    }

    private SolicitacaoAlvaraEntity carregarAtividadesMobNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        try {
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarAtividadesMobNaSolicitacao(solicitacao);
        }
        catch (BaseException be) {
            ShowMessage.addErrorMessage((String)VALIDACAO, (String)be.getMessage());
        }
        return solicitacao;
    }

    private String getParametroEntidadeExerc(String param) throws BaseException {
        List listaParametros = ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).carregaParametros(this.getEntidadeTrib().getId().getEntidade().getId(), Long.valueOf(EloDateUtils.getYear((Date)new Date())));
        for (ParametroEntidadeExercicioEntity parametro : listaParametros) {
            if (!parametro.getId().getParametro().equals(param)) continue;
            return parametro.getValor();
        }
        return null;
    }

    private EntidadeTributacaoEntity getEntidadeTrib() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getEntidade();
    }

    private void adicionaDescricaoAtividadesNoCadastro(CadastroMobiliarioEntity cadastroMobiliario) {
        cadastroMobiliario.setAtividadePrincipal(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getDescricaoAtividades());
    }

    public EstadosBrasilEnum[] getEstados() {
        return EstadosBrasilEnum.values();
    }

    private void carregaSocioMEI(String cpf) throws BaseException {
        if (!EloStringUtils.isEmpty((String)cpf)) {
            this.pessoa = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).getVerificarCadMobiliarioImobiliarioByPessoa(cpf);
            if (this.pessoa != null) {
                EnderecoPessoaEntity endereco = this.retornarEnderecoPessoaSocio();
                if (endereco != null) {
                    this.cidadeSelecionada = endereco.getBairro().getId().getCidade();
                    this.bairroSelecionado = endereco.getBairro();
                    this.logradouroSelecionado = endereco.getLogradouroEndereco();
                    this.cepSocio = endereco.getCep() != null ? endereco.getCep().toString() : "";
                    this.numeroLogradouroSocio = endereco.getNumero();
                    this.complementoSocio = endereco.getComplemento();
                    this.tipoEnderecoSocio = EnderecoTipoEnum.fromTipo((String)endereco.getTipoEndereco());
                }
                this.desabilitarCamposPessoaFisica = endereco != null || !this.isNaturezaInicial();
            }
        }
    }

    private EnderecoPessoaEntity retornarEnderecoPessoaSocio() {
        Optional first;
        EnderecoPessoaEntity endereco = null;
        if (this.pessoa.getEnderecoPessoaPrincipal() != null) {
            endereco = this.pessoa.getEnderecoPessoaPrincipal();
        } else if (!EloListUtils.safeIsEmpty((List)this.pessoa.getEnderecos()).booleanValue() && (first = this.pessoa.getEnderecos().stream().findFirst()).isPresent()) {
            endereco = (EnderecoPessoaEntity)first.get();
        }
        return endereco;
    }

    public String getTituloDialogTaxas() {
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoCBO()) {
            return "Taxas/ISS a Serem Cobradas";
        }
        return "Taxas a Serem Cobradas";
    }

    private Boolean verificaIsencaoCadastroGeral(CadastroGeralAiseEntity cadastroGeral) throws BaseException {
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).verificaIsencaoCadastroGeral(cadastroGeral.getIsencoes());
    }

    public List<EnderecoTipoEnum> listaTipoEndereco() {
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoCBO() || this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            return Arrays.asList(EnderecoTipoEnum.values());
        }
        return Arrays.asList(EnderecoTipoEnum.fromTipo((String)EnderecoTipoEnum.COMERCIAL.getId().toString()), EnderecoTipoEnum.fromTipo((String)EnderecoTipoEnum.CORRESPONDENCIA.getId().toString()));
    }

    private boolean isExibirSimulacaoTaxa() throws BaseException {
        return SimNaoEnum.getSimShortText().equals(UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.EXIBIR_SIMULACAO_TAXA).getValor()) && (!this.solicitacaoAlvaraController.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica() || SimNaoEnum.equalSim((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.PERMITE_GERAR_TAXA_LIBERDADE_ECONOMICA).getValor()) != false);
    }

    public boolean habilitaBotaoImprimirTermo() {
        try {
            if (this.termoDeUso) {
                this.carregarParametroTermoDeUso();
                if (this.renderBotaoImprimirTermo && !this.isTipoDocumentoTermoValido()) {
                    ShowMessage.addErrorMessage((String)"validacaoTermos", (String)"O Par\u00e2metro TIPO_DOCUMENTO_TERMO_DE_USO n\u00e3o foi configurado.");
                    return Boolean.FALSE;
                }
                if (!this.renderBotaoImprimirTermo && !this.isTipoDocumentoTermoValido()) {
                    return Boolean.FALSE;
                }
                if (!this.renderBotaoImprimirTermo && this.isTipoDocumentoTermoValido()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacaoTermos", (String)e.getMessage());
        }
        return Boolean.FALSE;
    }

    public boolean habilitaBotaoConfirmaTermo() {
        try {
            if (this.termoDeUso && !this.renderBotaoImprimirTermo || this.termoDeUso && this.renderBotaoImprimirTermo && this.isTipoDocumentoTermoValido()) {
                return Boolean.TRUE;
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacaoTermos", (String)e.getMessage());
        }
        return Boolean.FALSE;
    }

    public boolean isRenderBotaoImprimirTermo() {
        return this.renderBotaoImprimirTermo;
    }

    public void setRenderBotaoImprimirTermo(boolean renderBotaoImprimirTermo) {
        this.renderBotaoImprimirTermo = renderBotaoImprimirTermo;
    }

    public void imprimirTermo() throws BaseException {
        try {
            HashMap<String, Parameter> params = new HashMap<String, Parameter>();
            String relatorioJasper = "Termo.jasper";
            EntidadeAiseEntity entidade = this.entidadeController.getEntidade();
            ByteArrayInputStream inputStreamBrasao = new ByteArrayInputStream(this.entidadeController.getEntidade().getBrasao());
            params.put("brasao", new Parameter((Object)inputStreamBrasao));
            params.put("entidade", new Parameter((Object)entidade.getNome()));
            params.put("secretaria", new Parameter((Object)this.buscarNomeSecretaria(entidade).toUpperCase()));
            String texto = this.textoTermoDeUso.replaceAll("<p>", "").replaceAll("<br>", "").replaceAll("</p>", "\n").replaceAll("</br>", "\n");
            params.put("termo", new Parameter((Object)texto));
            params.put("responsavel", new Parameter((Object)this.solicitacaoAlvaraController.getSolicitacaoAlvara().getNomeRazaoSocial()));
            this.impressaoTermo = ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).imprimeRelatorio(relatorioJasper, null, null, params);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha ao imprimir o relat\u00f3rio.");
        }
    }

    private String buscarNomeSecretaria(EntidadeAiseEntity entidade) throws BaseException {
        ParametroAlvaraEntity parametroNomeSecretaria = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(entidade, ParametroAlvaraEnum.NOME_SECRETARIA);
        return Objects.nonNull(parametroNomeSecretaria) && Objects.nonNull(parametroNomeSecretaria.getValor()) ? parametroNomeSecretaria.getValor() : "";
    }

    public StreamedContent downloadTermo() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.impressaoTermo);
        String nomeRelatorio = "TERMOS_E_CONDI\u00c7\u00d5ES_DE_USO_" + EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd-MM-yyyy");
        return new DefaultStreamedContent((InputStream)stream, "application/pdf", nomeRelatorio + ".pdf");
    }

    protected boolean isExibeAreaPublicidadeLuminada() throws BaseException {
        String parametroExibeAreaPublica = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.EXIBE_AREA_PUBLICA_LUMINADA);
        return SimNaoEnum.equalSim((String)parametroExibeAreaPublica);
    }

    public void cadastrarNovoEndereco() throws BaseException {
        this.instanciarNovoBairro();
        this.instanciarNovoLogradouro();
        this.carregarTiposLogradouro();
    }

    private void instanciarNovoLogradouro() {
        LogradouroPK id = new LogradouroPK();
        id.setCidade(this.cidadeSelecionada);
        this.novoLogradouro = new LogradouroEntity();
        this.novoLogradouro.setId(id);
        this.novoLogradouro.setInativo(SimNaoEnum.getNaoShortText());
    }

    protected void carregarTiposLogradouro() throws BaseException {
        this.tiposLogradouro = ((FacadeEndereco)SpringContext.getBean(FacadeEndereco.class)).carregarTiposLogradouro();
    }

    public void salvarNovoEnderecoSocio() {
        try {
            this.salvarBairro();
            this.salvarLogradouro();
            RequestContext.getCurrentInstance().execute("dlgCadastroNovoEndereco.hide()");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)ID_MENSAGEM_VALIDACAO_BAIRRO, (String)e.getMessage());
        }
    }

    private void salvarLogradouro() throws Exception {
        try {
            if (Objects.isNull(this.novoLogradouro)) {
                throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel salvar um Logradouro nulo!");
            }
            this.logradouroSelecionado = ((FacadeEndereco)SpringContext.getBean(FacadeEndereco.class)).salvarLogradouro(this.novoLogradouro);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.mostrarMensagensDeErro(this.novoLogradouro.getMensagensErro());
            throw new LogradouroException(e.getMessage());
        }
    }

    private void salvarBairro() throws Exception {
        try {
            if (Objects.isNull(this.novoBairro)) {
                throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel salvar um Bairro nulo!");
            }
            this.bairroSelecionado = ((FacadeEndereco)SpringContext.getBean(FacadeEndereco.class)).salvarBairro(this.novoBairro);
        }
        catch (BairroException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.mostrarMensagensDeErro(this.novoBairro.getMensagensErro());
            throw new BairroException(e.getMessage());
        }
    }

    private void mostrarMensagensDeErro(List<String> erros) {
        erros.forEach(e -> ShowMessage.addWarnMessage((String)ID_MENSAGEM_VALIDACAO_BAIRRO, (String)e));
    }

    private void instanciarNovoBairro() {
        this.novoBairro = new BairroEntity();
        BairroPK idBairro = new BairroPK(null, this.cidadeSelecionada);
        this.novoBairro.setId(idBairro);
        this.novoBairro.setExclusaoLogica(SimNaoEnum.getNaoShortText());
        this.novoBairro.setInativo(SimNaoEnum.getNaoShortText());
    }

    public void validaRegraCnpj() {
        try {
            if (!this.getUsuarioLogado().isRoleVerificaCadastroDuplicado() && !EloStringUtils.isEmpty((String)this.solicitacaoAlvaraController.getSolicitacaoAlvara().getCpfCnpj())) {
                ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).validaRegraCnpj(this.solicitacaoAlvaraController.getSolicitacaoAlvara(), this.getGerarRestricaoCadastroExistente().booleanValue());
            }
        }
        catch (BaseException e) {
            ShowMessage.addWarnMessage((String)"msgValidacaoCnpj", (String)e.getMessage());
        }
    }

    public void adicionarArquivoTermoDeUso(FileUploadEvent fileUploadEvent) throws BaseException {
        this.arquivoTermoDeUso = fileUploadEvent.getFile();
        if (this.habilitaBotaoAnexoTermoDeUso && this.arquivoTermoDeUso != null) {
            SolicitacaoAlvaraDocumentoEntity documentoTermoUso = new SolicitacaoAlvaraDocumentoEntity();
            documentoTermoUso.setDataInclusao(new Date());
            documentoTermoUso.setDescricao("Termo de Uso assinado.");
            documentoTermoUso.setDocumento(this.arquivoTermoDeUso.getContents());
            documentoTermoUso.setNomeArquivo(this.arquivoTermoDeUso.getFileName());
            documentoTermoUso.setTipoDocumento(this.carregarTipoDocumentoTermoDeUso());
            documentoTermoUso.setSolicitacaoAlvara(this.solicitacaoAlvaraController.getSolicitacaoAlvara());
            this.solicitacaoAlvaraController.getSolicitacaoAlvara().getDocumentos().add(documentoTermoUso);
        }
    }

    public UsuarioEntity getUsuarioLogado() {
        return (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }
}

