/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.AndamentoAlvaraProvisorioEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.DebitoWebVo;
import br.com.elotech.portalarrecadacao.domain.vo.ReceitaVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.filter.FiltroAlvaraProvisorioRedeSim;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.utils.faces.FacesUtil;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.filter.GuiaRecolhimentoReceitaFiltro;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.annotation.Scope;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@EloController(value="alvaraProvisorioRedeSimController")
@Scope(value="flow")
public class AlvaraProvisorioRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NUMERO_PARCELA = 1;
    private FiltroAlvaraProvisorioRedeSim filtro;
    private List<AndamentoAlvaraProvisorioEntity> andamentosAlvaras;
    private List<AndamentoAlvaraProvisorioEntity> andamentoAlvaraTramites;
    private SolicitacaoAlvaraRedeSimDTO arquivoEmpresa;
    private AndamentoAlvaraProvisorioEntity andamentoSelecionado;
    private List<CadastroMobiliarioEntity> listagemCadastrosMobiliario;
    private GuiaRecolhimentoEntity guiaRecolhimentoSelecionado;
    private List<ReceitaVo> receitasSelecionadas;
    private List<ReceitaVo> receitas;
    private Integer numeroParcela;
    private String observacaoDebito;
    private Date vencimentoPrimeiraParcela;
    private List<GuiaRecolhimentoEntity> guiasRecolhimento;
    private String totalReceitas;
    private List<LaudoAlvaraEntity> laudos;
    private List<DebitoEntity> listaDebitos;
    private List<DebitoEntity> listaDebitosSelecionadosParaEnvio;

    public List<DebitoEntity> getListaDebitos() {
        return this.listaDebitos;
    }

    public void setListaDebitos(List<DebitoEntity> listaDebitos) {
        this.listaDebitos = listaDebitos;
    }

    public List<DebitoEntity> getListaDebitosSelecionadosParaEnvio() {
        return this.listaDebitosSelecionadosParaEnvio;
    }

    public void setListaDebitosSelecionadosParaEnvio(List<DebitoEntity> listaDebitosSelecionadosParaEnvio) {
        this.listaDebitosSelecionadosParaEnvio = listaDebitosSelecionadosParaEnvio;
    }

    public List<LaudoAlvaraEntity> getLaudos() {
        return this.laudos;
    }

    public void setLaudos(List<LaudoAlvaraEntity> laudos) {
        this.laudos = laudos;
    }

    public FiltroAlvaraProvisorioRedeSim getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroAlvaraProvisorioRedeSim filtro) {
        this.filtro = filtro;
    }

    public List<AndamentoAlvaraProvisorioEntity> getAndamentosAlvaras() {
        return this.andamentosAlvaras;
    }

    public void setAndamentosAlvaras(List<AndamentoAlvaraProvisorioEntity> andamentosAlvaras) {
        this.andamentosAlvaras = andamentosAlvaras;
    }

    public List<AndamentoAlvaraProvisorioEntity> getAndamentoAlvaraTramites() {
        return this.andamentoAlvaraTramites;
    }

    public void setAndamentoAlvaraTramites(List<AndamentoAlvaraProvisorioEntity> andamentoAlvaraTramites) {
        this.andamentoAlvaraTramites = andamentoAlvaraTramites;
    }

    public SolicitacaoAlvaraRedeSimDTO getArquivoEmpresa() {
        return this.arquivoEmpresa;
    }

    public void setArquivoEmpresa(SolicitacaoAlvaraRedeSimDTO arquivoEmpresa) {
        this.arquivoEmpresa = arquivoEmpresa;
    }

    public AndamentoAlvaraProvisorioEntity getAndamentoSelecionado() {
        return this.andamentoSelecionado;
    }

    public void setAndamentoSelecionado(AndamentoAlvaraProvisorioEntity andamentoSelecionado) {
        this.andamentoSelecionado = andamentoSelecionado;
    }

    public List<CadastroMobiliarioEntity> getListagemCadastrosMobiliario() {
        return this.listagemCadastrosMobiliario;
    }

    public void setListagemCadastrosMobiliario(List<CadastroMobiliarioEntity> listagemCadastrosMobiliario) {
        this.listagemCadastrosMobiliario = listagemCadastrosMobiliario;
    }

    public String getNomeSolicitante() {
        return this.arquivoEmpresa.getDados_solicitacao().getSolicitante().getDs_nome();
    }

    public GuiaRecolhimentoEntity getGuiaRecolhimentoSelecionado() {
        return this.guiaRecolhimentoSelecionado;
    }

    public void setGuiaRecolhimentoSelecionado(GuiaRecolhimentoEntity guiaRecolhimentoSelecionado) {
        this.guiaRecolhimentoSelecionado = guiaRecolhimentoSelecionado;
    }

    public List<ReceitaVo> getReceitasSelecionadas() {
        return this.receitasSelecionadas;
    }

    public void setReceitasSelecionadas(List<ReceitaVo> receitasSelecionadas) {
        this.receitasSelecionadas = receitasSelecionadas;
    }

    public List<ReceitaVo> getReceitas() {
        return this.receitas;
    }

    public void setReceitas(List<ReceitaVo> receitas) {
        this.receitas = receitas;
    }

    public Integer getNumeroParcela() {
        return this.numeroParcela;
    }

    public void setNumeroParcela(Integer numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    public String getObservacaoDebito() {
        return this.observacaoDebito;
    }

    public void setObservacaoDebito(String observacaoDebito) {
        this.observacaoDebito = observacaoDebito;
    }

    public Date getVencimentoPrimeiraParcela() {
        return this.vencimentoPrimeiraParcela;
    }

    public void setVencimentoPrimeiraParcela(Date vencimentoPrimeiraParcela) {
        this.vencimentoPrimeiraParcela = vencimentoPrimeiraParcela;
    }

    public List<GuiaRecolhimentoEntity> getGuiasRecolhimento() {
        return this.guiasRecolhimento;
    }

    public void setGuiasRecolhimento(List<GuiaRecolhimentoEntity> guiasRecolhimento) {
        this.guiasRecolhimento = guiasRecolhimento;
    }

    public String getTotalReceitas() {
        return this.totalReceitas;
    }

    public void setTotalReceitas(String totalReceitas) {
        this.totalReceitas = totalReceitas;
    }

    public void iniciar() {
        try {
            this.atualizaSituacaoDebitoPago();
            this.filtro = new FiltroAlvaraProvisorioRedeSim();
            this.filtro.setEnviouAlvara(SimNaoEnum.getNaoShortText());
            this.filtro.setGerouAlvara(SimNaoEnum.getNaoShortText());
            this.filtro.setGerouDebito(SimNaoEnum.getNaoShortText());
            this.listaDebitos = new ArrayList();
            this.pesquisarAndamentosAlvara();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    public void pesquisarAndamentosAlvara() throws SolicitacaoAlvaraRedeSimException {
        try {
            this.andamentosAlvaras = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).pesquisarAlvarasProvisorios(this.filtro);
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraRedeSimException("Falha ao pesquisar andamento", e.getCause());
        }
    }

    public void buscarTramitesAndamento(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        try {
            this.andamentoAlvaraTramites = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarTramitesAndamento(solicitacaoRedeSim);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao buscar tramites");
        }
    }

    public SimNaoEnum[] simNaoEnum() {
        return SimNaoEnum.values();
    }

    public boolean desabilitarCampoGerouDebito() {
        if (this.filtro.isDebitoPago()) {
            this.filtro.setGerouDebito(SimNaoEnum.getSimShortText());
            return true;
        }
        return false;
    }

    public String getTextFromSituacao(String sigla) {
        for (SituacaoConsultaPreviaRedeSimEnum situacao : SituacaoConsultaPreviaRedeSimEnum.values()) {
            if (!situacao.getSigla().equals(sigla)) continue;
            return situacao.getTexto();
        }
        return sigla;
    }

    public void redirectToConsultaIndividual(AndamentoAlvaraProvisorioEntity andamento) throws IOException, BaseException {
        this.andamentoSelecionado = andamento;
        this.setArquivoEmpresa((SolicitacaoAlvaraRedeSimDTO)EloJsonUtils.fromJson((String)this.andamentoSelecionado.getSolicitacaoRedeSim().getArquivoDadosEmpresa(), SolicitacaoAlvaraRedeSimDTO.class));
        String cnpjCpf = this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara().getCpfCnpj();
        this.listagemCadastrosMobiliario = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getCadastroMobiliarioPorCpfCnpj(cnpjCpf);
        if (this.listagemCadastrosMobiliario == null) {
            this.listagemCadastrosMobiliario = new ArrayList();
        }
        this.laudos = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).buscaLaudosPorSolicitacao(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara().getSolicitacaoAlvara());
        this.buscarTramitesAndamento(this.andamentoSelecionado.getSolicitacaoRedeSim());
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        RequestControlContext rec = (RequestControlContext)requestContext;
        rec.handleEvent(new Event((Object)this, "toSolicitacaoAndamentoProvisorioRedeSim"));
        this.andamentoSelecionado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarUltimoAndamentoAlvaraProvisorio(this.andamentoSelecionado.getSolicitacaoRedeSim());
    }

    public void iniciarGeracaoDebito() {
        try {
            this.andamentoSelecionado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarUltimoAndamentoAlvaraProvisorio(this.andamentoSelecionado.getSolicitacaoRedeSim());
            this.guiaRecolhimentoSelecionado = null;
            this.receitasSelecionadas = Lists.newArrayList();
            this.receitas = Lists.newArrayList();
            this.numeroParcela = 1;
            this.observacaoDebito = null;
            this.vencimentoPrimeiraParcela = EloDateUtils.addDay((Date)new Date(), (int)30);
            this.guiasRecolhimento = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getGuiasRecolhimentoAlvara(UtilsController.getEntidadeTributacao());
            if (this.possuiDebitoNaSolicitacao(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara())) {
                this.carregarDebitosEmAberto();
                FacesUtil.execute((String)"dlgPossuiDebitoNaSolicitacao.show()");
            } else {
                FacesUtil.execute((String)"dlgListaGeraDebito.show()");
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacaoDebito", (String)e.getMessage());
        }
    }

    private boolean possuiDebitoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).possuiDebitoNaSolicitacao(solicitacao);
    }

    public void carregarReceitas() {
        try {
            GuiaRecolhimentoReceitaFiltro filtro = new GuiaRecolhimentoReceitaFiltro();
            EntidadeTributacaoEntity entidadeTributacao = UtilsController.getEntidadeTributacao();
            filtro.setExercicio(entidadeTributacao.getExercicio());
            filtro.setEntidade(entidadeTributacao.getId().getEntidade().getId());
            filtro.setGuiaRecolhimento(this.guiaRecolhimentoSelecionado.getGuiaRecolhimento());
            this.receitas = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getReceitasPorGuia(filtro);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacaoDebito", (String)e.getMessage());
        }
    }

    public void validarDebito() {
        BigDecimal totalReceitas = BigDecimal.ZERO;
        if (Objects.isNull(this.vencimentoPrimeiraParcela)) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Selecione o vencimento da primeira Parcela !");
        } else if (this.vencimentoPrimeiraParcela.compareTo(new Date()) < 0) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Vencimento da primeira Parcela n\u00e3o est\u00e1 correto !");
        } else if (Objects.isNull(this.guiaRecolhimentoSelecionado)) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Selecione uma d\u00edvida !");
        } else if (EloListUtils.safeIsEmpty((List)this.receitasSelecionadas).booleanValue()) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Selecione uma receita ");
        } else {
            for (ReceitaVo receita : this.receitasSelecionadas) {
                if (!EloNumberUtils.isBiggerThanZero((Number)receita.getValor()).booleanValue()) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"Preecha o campo valor.");
                    return;
                }
                totalReceitas = totalReceitas.add(receita.getValor());
            }
            this.totalReceitas = EloStringUtils.formatValor((BigDecimal)totalReceitas, (int)2);
            FacesUtil.execute((String)"dlgValidacaoDebito.show()");
        }
    }

    public void gerarDebito() throws BaseException {
        block5: {
            try {
                DebitoWebVo debitoWebVo = new DebitoWebVo();
                debitoWebVo.setGuia(this.guiaRecolhimentoSelecionado.getGuiaRecolhimento().intValue());
                debitoWebVo.setObservacao(this.observacaoDebito);
                debitoWebVo.setReceitas(this.receitasSelecionadas);
                debitoWebVo.setVencimentoPrimeiraParcela(this.vencimentoPrimeiraParcela);
                debitoWebVo.setSolicitacaoAlvara(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara());
                if (!this.existeDebitosComGuiaRepetida(debitoWebVo).booleanValue()) {
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarDebitoWebAlvaraProvisorio(debitoWebVo);
                    FacesUtil.execute((String)"dlgGeraDebito.hide(); dlgValidacaoDebito.hide()");
                    try {
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoAndamentoAlvaraProvisorio(this.andamentoSelecionado.criarNovoAndamentoDebitoGerado());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                        ShowMessage.addErrorMessage((String)"validacao", (String)"Falha ao Salvar Hist\u00f3rico do Andamento.");
                        throw new SolicitacaoAlvaraRedeSimException(e.getMessage());
                    }
                    this.andamentoAlvaraTramites = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarTramitesAndamento(this.andamentoSelecionado.getSolicitacaoRedeSim());
                    this.carregarDebitosEmAberto();
                    FacesUtil.execute((String)"dlgValidacaoDebito.hide()");
                    FacesUtil.execute((String)"dlgGeraDebito.hide()");
                    FacesUtil.execute((String)"dlgEnviarDebitosSuccess.show()");
                    break block5;
                }
                ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o \u00e9 permitido criar dois d\u00e9bitos com a mesma d\u00edvida. Selecione uma nova d\u00edvida.");
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
                throw new SolicitacaoAlvaraRedeSimException(e.getMessage());
            }
        }
    }

    private Boolean existeDebitosComGuiaRepetida(DebitoWebVo debitoWebVo) {
        for (DebitoEntity debito : this.listaDebitos) {
            if (!debito.getId().getGuiaRecolhimento().getId().getGuiaRecolhimento().equals(debitoWebVo.getGuia())) continue;
            return true;
        }
        return false;
    }

    private void carregarDebitosEmAberto() throws BaseException {
        this.listaDebitos = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDebitosEmAbertoNaSolicitacao(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara());
    }

    public void verificarDebitoNaSolicitacao() {
        try {
            this.andamentoSelecionado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarUltimoAndamentoAlvaraProvisorio(this.andamentoSelecionado.getSolicitacaoRedeSim());
            if (!this.possuiDebitoNaSolicitacao(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara())) {
                FacesUtil.execute((String)"dlgVerificaDebito.show()");
            } else if (!this.possuiDebitosEmAbertoNaSolicitacao(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara())) {
                this.gerarAlvaraOnline();
            } else {
                FacesUtil.execute((String)"dialogPossuiDebitosEmAbertoWidgetVar.show()");
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private boolean possuiDebitosEmAbertoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List debitosEmAberto = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarDebitosEmAbertoNaSolicitacao(solicitacao);
        return debitosEmAberto.size() != 0;
    }

    public void gerarAlvaraOnline() throws BaseException {
        try {
            if (UtilsController.jaFoiGeradoAlvaraProvisorio((SolicitacaoRedeSimEntity)this.andamentoSelecionado.getSolicitacaoRedeSim())) {
                this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara().setRenovacao(SimNaoEnum.getSimShortText());
            }
            if (!this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara().isNaturezaInicial()) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).efetivarAlteracaoSolicitacao(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara());
            }
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarObsAlvaraRedeSim(this.andamentoSelecionado.getSolicitacaoRedeSim());
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarAlvaraRedeSim(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara());
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).imprimirDocumentoRedeSim(this.andamentoSelecionado.getSolicitacaoRedeSim().getSolicitacaoAlvara(), DocumentoTipoEnum.ALVARA_LOCALIZACAO);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            FacesUtil.execute((String)"dlgVerificaDebito.hide()");
            throw new SolicitacaoAlvaraRedeSimException(e.getMessage());
        }
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(this.andamentoSelecionado.getSolicitacaoRedeSim(), SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO, Optional.of("Alvar\u00e1 Provis\u00f3rio"));
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoAndamentoAlvaraProvisorio(this.andamentoSelecionado.criarNovoAndamentoAlvaraGerado());
            this.andamentoSelecionado = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarUltimoAndamentoAlvaraProvisorio(this.andamentoSelecionado.getSolicitacaoRedeSim());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Falha ao Salvar Hist\u00f3rico do Andamento.");
        }
        this.andamentoAlvaraTramites = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarTramitesAndamento(this.andamentoSelecionado.getSolicitacaoRedeSim());
        FacesUtil.execute((String)"dialogPossuiDebitosEmAbertoWidgetVar.hide()");
    }

    private void atualizaSituacaoDebitoPago() throws SolicitacaoAlvaraException {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).atualizarSituacaoParaDebitoPago();
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException("Falha ao atualizar situa\u00e7\u00e3o da solicita\u00e7\u00e3o para d\u00e9bito pago", e.getCause());
        }
    }

    public boolean isInvalidarDocumentoEmitidoAtivo() {
        try {
            ParametroAlvaraEntity paramInvalidarDocumentoEmitido = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INVALIDAR_DOCUMENTO_EMITIDO);
            if (paramInvalidarDocumentoEmitido.getValor().equals(SimNaoEnum.getSimShortText())) {
                return Boolean.TRUE;
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public void invalidarDocumento() {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(this.andamentoSelecionado.getSolicitacaoRedeSim(), SituacaoRespostaRedeSimEnum.SUSPENSO, Boolean.FALSE.booleanValue());
            this.andamentoSelecionado.getSolicitacaoRedeSim().setInvalidado(SimNaoEnum.getSimShortText());
            FacesUtil.execute((String)"dlgConfirmarInvalidarDocumento.hide()");
            ShowMessage.addInfoMessage((String)"validacao", (String)"Documento suspenso com sucesso!");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao suspender o alvar\u00e1");
        }
    }

    public boolean isEnviaAlvaraProvisorioRedeSim() {
        try {
            ParametroAlvaraEntity paramEnviaAlvaraProvisorio = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_ALVARA_PROVISORIO_REDE_SIM);
            if (paramEnviaAlvaraProvisorio.getValor().equals(SimNaoEnum.getSimShortText())) {
                return Boolean.TRUE;
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public void enviarDocumentoRedeSim() {
        try {
            this.andamentoSelecionado.getSolicitacaoRedeSim().setAlvaraEnviado(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(this.andamentoSelecionado.getSolicitacaoRedeSim(), SituacaoRespostaRedeSimEnum.EMITIDO, Boolean.FALSE.booleanValue());
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.andamentoSelecionado.getSolicitacaoRedeSim());
            try {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoAndamentoAlvaraProvisorio(this.andamentoSelecionado.criarNovoAndamentoAlvaraEnviado());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacao", (String)"Falha ao Salvar Hist\u00f3rico do Andamento.");
                throw new SolicitacaoAlvaraRedeSimException(e.getMessage());
            }
            FacesUtil.execute((String)"dlgVerificaDebito.hide()");
            FacesUtil.execute((String)"dlgEnviarDocumentoRedeSim.hide()");
            FacesUtil.execute((String)"dlgEnviarAlvaraRedeSimSuccess.show()");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void novoDebito() {
        this.guiaRecolhimentoSelecionado = null;
        this.numeroParcela = null;
        this.receitas = new ArrayList();
        this.receitasSelecionadas = new ArrayList();
        this.observacaoDebito = "";
        FacesUtil.execute((String)"dlgGeraDebito.show();");
    }

    public void enviarDebitoEmail() {
        if (EloListUtils.safeIsEmpty((List)this.listaDebitosSelecionadosParaEnvio).booleanValue()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Selecione pelo menos um d\u00e9bito para enviar.");
            return;
        }
        FacesUtil.execute((String)"dlgEnviaDebitoEmail.show();");
    }

    public void enviarEmail() {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.andamentoSelecionado.getSolicitacaoRedeSim();
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EM_ANALISE, Boolean.TRUE.booleanValue(), this.listaDebitosSelecionadosParaEnvio);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma falha ao enviar o bloqueto.");
        }
        FacesUtil.execute((String)"dlgEnviaDebitoEmail.hide(); dlgListaGeraDebito.hide();");
    }
}

