/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeAdicionaNumeroConselho;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CarteiraProfissionalEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.security.AuthenticationProviderAise;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FileUploadEvent;
import org.springframework.context.annotation.Scope;

@EloController(value="adicionaNumeroConselhoController")
@Scope(value="flow")
public class AdicionaNumeroConselhoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SolicitacaoAlvaraAtividadeEntity> listaDeSolicitacaoAtividades = new ArrayList();
    private SolicitacaoAlvaraNumConselhoEntity solicitacaoAlvaraNumConselhoSelecionado = new SolicitacaoAlvaraNumConselhoEntity();
    private SolicitacaoAlvaraNumConselhoEntity solAlvNumConselhoItemSelecionado;
    private SolicitacaoAlvaraAtividadeEntity atividadeSelecionada;
    private List<CarteiraProfissionalEntity> carteirasProfissionais = new ArrayList();
    private CarteiraProfissionalEntity carteiraSelecionada;
    private List<SolicitacaoAlvaraNumConselhoEntity> listaNumeroConselhoDaAtividade = new ArrayList();
    private List<SolicitacaoAlvaraDocumentoConselhoEntity> listaDocumentosConselho;
    private SolicitacaoAlvaraNumConselhoEntity numeroConselhoSelecionado;
    private SolicitacaoAlvaraDocumentoConselhoEntity documentoSelecionado;
    private List<TipoDocumentoEntity> tiposDocumento;
    private TipoDocumentoEntity tipoDocumentoSelecionado;
    private List<SolicitacaoAlvaraDocumentoConselhoEntity> documentosParaEnviar;
    private List<String> anexos;
    private Boolean habilitaUploadDocumentos;
    private SolicitacaoAlvaraDocumentoConselhoEntity documentoNovo;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private AuthenticationProviderAise authenticationProviderAise;

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public SolicitacaoAlvaraNumConselhoEntity getSolAlvNumConselhoItemSelecionado() {
        return this.solAlvNumConselhoItemSelecionado;
    }

    public void setSolAlvNumConselhoItemSelecionado(SolicitacaoAlvaraNumConselhoEntity solAlvNumConselhoItemSelecionado) {
        this.solAlvNumConselhoItemSelecionado = solAlvNumConselhoItemSelecionado;
    }

    public SolicitacaoAlvaraNumConselhoEntity getSolicitacaoAlvaraNumConselhoSelecionado() {
        return this.solicitacaoAlvaraNumConselhoSelecionado;
    }

    public void setSolicitacaoAlvaraNumConselhoSelecionado(SolicitacaoAlvaraNumConselhoEntity solicitacaoAlvaraNumConselhoSelecionado) {
        this.solicitacaoAlvaraNumConselhoSelecionado = solicitacaoAlvaraNumConselhoSelecionado;
    }

    public List<SolicitacaoAlvaraAtividadeEntity> getListaDeSolicitacaoAtividades() {
        return this.listaDeSolicitacaoAtividades;
    }

    public void setListaDeSolicitacaoAtividades(List<SolicitacaoAlvaraAtividadeEntity> listaDeSolicitacaoAtividades) {
        this.listaDeSolicitacaoAtividades = listaDeSolicitacaoAtividades;
    }

    public SolicitacaoAlvaraAtividadeEntity getAtividadeSelecionada() {
        return this.atividadeSelecionada;
    }

    public void setAtividadeSelecionada(SolicitacaoAlvaraAtividadeEntity atividadeSelecionada) {
        this.atividadeSelecionada = atividadeSelecionada;
    }

    public List<CarteiraProfissionalEntity> getCarteirasProfissionais() {
        return this.carteirasProfissionais;
    }

    public void setCarteirasProfissionais(List<CarteiraProfissionalEntity> carteirasProfissionais) {
        this.carteirasProfissionais = carteirasProfissionais;
    }

    public CarteiraProfissionalEntity getCarteiraSelecionada() {
        return this.carteiraSelecionada;
    }

    public void setCarteiraSelecionada(CarteiraProfissionalEntity carteiraSelecionada) {
        this.carteiraSelecionada = carteiraSelecionada;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public List<SolicitacaoAlvaraNumConselhoEntity> getListaNumeroConselhoDaAtividade() {
        return this.listaNumeroConselhoDaAtividade;
    }

    public List<SolicitacaoAlvaraDocumentoConselhoEntity> getListaDocumentosConselho() {
        return this.listaDocumentosConselho;
    }

    public void setListaDocumentosConselho(List<SolicitacaoAlvaraDocumentoConselhoEntity> listaDocumentosConselho) {
        this.listaDocumentosConselho = listaDocumentosConselho;
    }

    public SolicitacaoAlvaraNumConselhoEntity getNumeroConselhoSelecionado() {
        return this.numeroConselhoSelecionado;
    }

    public void setNumeroConselhoSelecionado(SolicitacaoAlvaraNumConselhoEntity numeroConselhoSelecionado) {
        this.numeroConselhoSelecionado = numeroConselhoSelecionado;
    }

    public SolicitacaoAlvaraDocumentoConselhoEntity getDocumentoSelecionado() {
        return this.documentoSelecionado;
    }

    public void setDocumentoSelecionado(SolicitacaoAlvaraDocumentoConselhoEntity documentoSelecionado) {
        this.documentoSelecionado = documentoSelecionado;
    }

    public List<TipoDocumentoEntity> getTiposDocumento() {
        return this.tiposDocumento;
    }

    public void setTiposDocumento(List<TipoDocumentoEntity> tiposDocumento) {
        this.tiposDocumento = tiposDocumento;
    }

    public TipoDocumentoEntity getTipoDocumentoSelecionado() {
        return this.tipoDocumentoSelecionado;
    }

    public void setTipoDocumentoSelecionado(TipoDocumentoEntity tipoDocumentoSelecionado) {
        this.tipoDocumentoSelecionado = tipoDocumentoSelecionado;
    }

    public List<SolicitacaoAlvaraDocumentoConselhoEntity> getDocumentosParaEnviar() {
        return this.documentosParaEnviar;
    }

    public void setDocumentosParaEnviar(List<SolicitacaoAlvaraDocumentoConselhoEntity> documentosParaEnviar) {
        this.documentosParaEnviar = documentosParaEnviar;
    }

    public List<String> getAnexos() {
        return this.anexos;
    }

    public void setAnexos(List<String> anexos) {
        this.anexos = anexos;
    }

    public Boolean getHabilitaUploadDocumentos() {
        return this.habilitaUploadDocumentos;
    }

    public void setHabilitaUploadDocumentos(Boolean habilitaUploadDocumentos) {
        this.habilitaUploadDocumentos = habilitaUploadDocumentos;
    }

    public void iniciar() {
        try {
            this.carregarCarteirasProfissionais();
            this.carregarParametroHabilitaUploadDocumentos();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void carregarParametroHabilitaUploadDocumentos() throws BaseException {
        String paramHabilitaUploadDocumentos = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_UPLOAD_RESP_CONSELHO);
        this.habilitaUploadDocumentos = SimNaoEnum.SIM.getShortText().equals(paramHabilitaUploadDocumentos);
    }

    public void adicionarNumConselho() {
        if (this.validaCampos()) {
            this.solicitacaoAlvaraNumConselhoSelecionado.setSolicitacaoAtividade(this.atividadeSelecionada);
            this.atividadeSelecionada.getNumerosConselho().add(this.solicitacaoAlvaraNumConselhoSelecionado);
            this.solicitacaoAlvaraController.getListaSolAlvaraNumConselho().add(this.solicitacaoAlvaraNumConselhoSelecionado);
            this.solicitacaoAlvaraNumConselhoSelecionado = new SolicitacaoAlvaraNumConselhoEntity();
        }
    }

    private boolean validaCampos() {
        if (this.solicitacaoAlvaraNumConselhoSelecionado.getNomeResponsavel().equals("") || this.solicitacaoAlvaraNumConselhoSelecionado.getNumeroRegistro().equals("") || this.solicitacaoAlvaraNumConselhoSelecionado.getCarteiraProfissional() == null) {
            ShowMessage.addInfoMessage((String)"msg", (String)"Preencha todos os campos com *");
            return false;
        }
        return true;
    }

    public Boolean verificaAtividadesPossuemNumeroConselho() throws BaseException {
        if (!this.solicitacaoAlvaraController.getSolicitacaoAlvara().possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            return false;
        }
        return EloListUtils.safeIsEmpty((List)this.carregarAtividadesPossuemNumeroConselho()) == false;
    }

    public List<SolicitacaoAlvaraAtividadeEntity> carregarAtividadesPossuemNumeroConselho() throws BaseException {
        this.listaDeSolicitacaoAtividades = new ArrayList();
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades() != null) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades()) {
                if (!this.isAtividadeComNumConselho(atividade)) continue;
                this.listaDeSolicitacaoAtividades.add(atividade);
            }
        }
        return this.listaDeSolicitacaoAtividades;
    }

    protected boolean isAtividadeComNumConselho(SolicitacaoAlvaraAtividadeEntity atividade) {
        if (this.isAlvaraInicial()) {
            return atividade.exigeResponsavel();
        }
        return "I".equals(atividade.getSituacao()) && atividade.exigeResponsavel();
    }

    private boolean isAlvaraInicial() {
        return this.solicitacaoAlvaraController.getSolicitacaoAlvara().possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL});
    }

    public void setarAtividadeSelecionada(SolicitacaoAlvaraAtividadeEntity atividade) {
        this.atividadeSelecionada = atividade;
        this.listaNumeroConselhoDaAtividade.clear();
        this.listaNumeroConselhoDaAtividade.addAll(atividade.getNumerosConselho());
        this.selecionarPrimeiroNumeroConselho();
    }

    private void selecionarPrimeiroNumeroConselho() {
        if (!EloListUtils.safeIsEmpty((List)this.atividadeSelecionada.getNumerosConselho()).booleanValue()) {
            this.numeroConselhoSelecionado = (SolicitacaoAlvaraNumConselhoEntity)this.atividadeSelecionada.getNumerosConselho().stream().findFirst().get();
            this.onRowSelectTabNumeroConselho();
        }
    }

    public void fechaFormulario() {
        if (this.validarAtividadeSelecionada()) {
            this.solicitacaoAlvaraNumConselhoSelecionado = new SolicitacaoAlvaraNumConselhoEntity();
            this.tiposDocumento = new ArrayList();
        }
    }

    private boolean validarAtividadeSelecionada() {
        boolean retorno = true;
        if (EloListUtils.safeIsEmpty((List)this.atividadeSelecionada.getNumerosConselho()).booleanValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Informe o Respons\u00e1vel T\u00e9cnico da atividade: ");
            sb.append(this.atividadeSelecionada.getDescricaoAtividade());
            ShowMessage.addWarnMessage((String)"msg", (String)sb.toString());
            retorno = false;
        }
        if (this.habilitaUploadDocumentos.booleanValue()) {
            retorno = this.validaUploadDocumentosResponsaveis(this.atividadeSelecionada);
        }
        if (retorno) {
            RequestContext.getCurrentInstance().execute("numDialog.hide()");
        }
        return retorno;
    }

    private void carregarCarteirasProfissionais() throws BaseException {
        if (EloListUtils.safeIsEmpty((List)this.carteirasProfissionais).booleanValue()) {
            this.carteirasProfissionais.addAll(((FacadeAdicionaNumeroConselho)SpringContext.getBean(FacadeAdicionaNumeroConselho.class)).carregaCarteirasProfissionais());
        }
    }

    public void removerNumConselho(SolicitacaoAlvaraNumConselhoEntity numeroConselho) {
        this.solicitacaoAlvaraController.getListaSolAlvaraNumConselho().remove(numeroConselho);
        this.atividadeSelecionada.getNumerosConselho().remove(numeroConselho);
        this.tiposDocumento = new ArrayList();
    }

    public String avancar() {
        block7: {
            try {
                if (!this.integradoGeo()) {
                    if (this.validarResponsaveisTecnicosSemGeo().booleanValue()) {
                        return "toCadastroMobiliario";
                    }
                    break block7;
                }
                for (SolicitacaoAlvaraAtividadeEntity atividade : this.listaDeSolicitacaoAtividades) {
                    if (!EloListUtils.safeIsEmpty((List)atividade.getNumerosConselho()).booleanValue()) continue;
                    try {
                        if (!((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).possuiRestricaoResponsavelTecnicoBloqueante(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvara())) continue;
                        StringBuilder mensagem = new StringBuilder();
                        mensagem.append("Caso n\u00e3o precise de respons\u00e1vel, entre em contato com o setor respons\u00e1vel:");
                        mensagem.append(System.lineSeparator());
                        mensagem.append("- T\u00e9cnico do Meio Ambiente com a Secretaria de Meio Ambiente;");
                        mensagem.append(System.lineSeparator());
                        mensagem.append("- T\u00e9cnico de Vigil\u00e2ncia Sanit\u00e1ria ou Ambiental com a Secretaria de Sa\u00fade.");
                        ShowMessage.addInfoMessage((String)"msg", (String)mensagem.toString());
                        return "";
                    }
                    catch (BaseException e) {
                        this.logger.error((Object)"N\u00e3o foi poss\u00edvel verificar a libera\u00e7\u00e3o da solicitacao (Resp. T\u00e9cnico)", e.getCause());
                    }
                }
                return "toCadastroMobiliario";
            }
            catch (Exception e) {
                ShowMessage.addErrorMessage((String)"msg", (String)EloStringUtils.build((Object[])new Object[]{" Ocorreu uma falha ao avan\u00e7ar para a pr\u00f3xima etapa, ", e.getMessage()}));
            }
        }
        return "";
    }

    protected Boolean validarResponsaveisTecnicosSemGeo() {
        for (SolicitacaoAlvaraAtividadeEntity atividade : this.listaDeSolicitacaoAtividades) {
            if (EloListUtils.safeIsEmpty((List)atividade.getNumerosConselho()).booleanValue()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Informe o Respons\u00e1vel T\u00e9cnico da atividade: ");
                sb.append(atividade.getDescricaoAtividade());
                ShowMessage.addWarnMessage((String)"msg", (String)sb.toString());
                return false;
            }
            if (!this.habilitaUploadDocumentos.booleanValue() || this.validaUploadDocumentosResponsaveis(atividade).booleanValue()) continue;
            return false;
        }
        RequestContext.getCurrentInstance().execute("numDialog.hide()");
        return true;
    }

    private Boolean validaUploadDocumentosResponsaveis(SolicitacaoAlvaraAtividadeEntity atividade) {
        if (!EloListUtils.safeIsEmpty((List)atividade.getNumerosConselho()).booleanValue()) {
            for (SolicitacaoAlvaraNumConselhoEntity numConselho : atividade.getNumerosConselho()) {
                if (numConselho.possuiTodosDocumentosAnexados(this.tiposDocumento).booleanValue()) continue;
                for (String erro : numConselho.getMensagemErroDocumentosNaoEnviados()) {
                    ShowMessage.addWarnMessage((String)"msg", (String)erro);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean integradoGeo() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).verificaIntegradoGeo();
    }

    public void onRowSelectTabNumeroConselho() {
        if (Objects.nonNull(this.numeroConselhoSelecionado)) {
            try {
                this.tiposDocumento = ((FacadeAdicionaNumeroConselho)SpringContext.getBean(FacadeAdicionaNumeroConselho.class)).buscarTiposDocumentoResponsavelTecnico();
            }
            catch (BaseException e) {
                ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel carregar os Tipos de Documento atrav\u00e9s do par\u00e2metro 'TIPOS_DOCUMENTO_RESP_TECNICO'");
            }
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        if (event.getFile() != null && event.getFile().getContents() != null) {
            this.documentoNovo = new SolicitacaoAlvaraDocumentoConselhoEntity();
            this.documentoNovo.setSolicitacaoAlvaraNumConselho(this.numeroConselhoSelecionado);
            SolicitacaoAlvaraEntity solicitacaoAlvara = this.atividadeSelecionada.getSolicitacaoAlvara();
            this.documentoNovo.setSolicitacaoAlvaraDocumento(this.criarSolicitacaoAlvaraDocumento(event, solicitacaoAlvara));
            this.anexos.add(event.getFile().getFileName());
        }
    }

    private SolicitacaoAlvaraDocumentoEntity criarSolicitacaoAlvaraDocumento(FileUploadEvent event, SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.getDocumentos() == null) {
            solicitacaoAlvara.setDocumentos(new ArrayList());
        }
        SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento = new SolicitacaoAlvaraDocumentoEntity();
        solicitacaoAlvaraDocumento.setSolicitacaoAlvara(solicitacaoAlvara);
        solicitacaoAlvaraDocumento.setTipoDocumento(this.tipoDocumentoSelecionado);
        solicitacaoAlvaraDocumento.setDocumento(event.getFile().getContents());
        solicitacaoAlvaraDocumento.setSituacao(SituacaoDocumentoAlvaraEnum.EM_ANALISE);
        solicitacaoAlvaraDocumento.setDataInclusao(new Date());
        solicitacaoAlvaraDocumento.setUsuario((UsuarioEntity)this.authenticationProviderAise.getUsuarioLogado());
        solicitacaoAlvara.getDocumentos().add(solicitacaoAlvaraDocumento);
        return solicitacaoAlvaraDocumento;
    }

    private boolean tipoDocumentoJaAdicionado(SolicitacaoAlvaraDocumentoConselhoEntity documento) {
        boolean tipoDocumentoJaAdicionado = false;
        if (!EloListUtils.safeIsEmpty((List)this.numeroConselhoSelecionado.getDocumentos()).booleanValue()) {
            List documentosExistentes = this.numeroConselhoSelecionado.getDocumentos();
            for (SolicitacaoAlvaraDocumentoConselhoEntity docExistente : documentosExistentes) {
                if (!docExistente.getSolicitacaoAlvaraNumConselho().equals((Object)this.numeroConselhoSelecionado) || !docExistente.getSolicitacaoAlvaraDocumento().getTipoDocumento().equals((Object)documento.getSolicitacaoAlvaraDocumento().getTipoDocumento())) continue;
                tipoDocumentoJaAdicionado = true;
            }
        }
        return tipoDocumentoJaAdicionado;
    }

    public Boolean enviouDocumentos(TipoDocumentoEntity tipoDocumento) {
        if (!EloListUtils.safeIsEmpty((List)this.numeroConselhoSelecionado.getDocumentos()).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoConselhoEntity documento : this.numeroConselhoSelecionado.getDocumentos()) {
                if (!documento.getSolicitacaoAlvaraDocumento().getTipoDocumento().equals((Object)tipoDocumento)) continue;
                return true;
            }
        }
        return false;
    }

    public void enviar() {
        if (this.anexos.size() <= 0) {
            ShowMessage.addErrorMessage((String)"validacaoDocumentos", (String)"Adicione um Documento");
            return;
        }
        if (this.tipoDocumentoJaAdicionado(this.documentoNovo)) {
            ShowMessage.addErrorMessage((String)"validacaoDocumentos", (String)"Este Tipo de Documento j\u00e1 foi anexado para este respons\u00e1vel.");
        } else {
            this.documentosParaEnviar = Lists.newArrayList();
            this.documentosParaEnviar.add(this.documentoNovo);
            this.numeroConselhoSelecionado.addDocumentos(this.documentosParaEnviar);
            RequestContext.getCurrentInstance().execute("docsDialog.hide()");
        }
    }

    public void removeDocumento(TipoDocumentoEntity tipoDocumento) {
        if (!EloListUtils.safeIsEmpty((List)this.numeroConselhoSelecionado.getDocumentos()).booleanValue()) {
            ArrayList<SolicitacaoAlvaraDocumentoConselhoEntity> documentosRemover = new ArrayList<SolicitacaoAlvaraDocumentoConselhoEntity>();
            for (SolicitacaoAlvaraDocumentoConselhoEntity documento : this.numeroConselhoSelecionado.getDocumentos()) {
                if (!documento.getSolicitacaoAlvaraDocumento().getTipoDocumento().equals((Object)tipoDocumento)) continue;
                documentosRemover.add(documento);
            }
            this.numeroConselhoSelecionado.getDocumentos().removeAll(documentosRemover);
        }
    }

    public void openDialog(TipoDocumentoEntity tipoDocumento) {
        this.tipoDocumentoSelecionado = tipoDocumento;
        if (this.anexos == null) {
            this.anexos = new ArrayList();
        }
        if (!this.anexos.isEmpty()) {
            this.anexos.clear();
        }
        if (this.documentosParaEnviar == null) {
            this.documentosParaEnviar = new ArrayList();
        }
    }

    public void removeAnexo(String anexo) {
        if (this.anexos.contains(anexo)) {
            this.anexos.remove(anexo);
        }
    }
}

