/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.LoginPortalArrecadacao;
import br.com.elotech.portalarrecadacao.controller.ParecerDosLaudosController;
import br.com.elotech.portalarrecadacao.controller.RequerimentoSolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDispensaAmbientalEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.DocumentoAtividadeTipoInscricaoVo;
import br.com.elotech.portalarrecadacao.domain.vo.SolicitacaoAlvaraVo;
import br.com.elotech.portalarrecadacao.dto.DispensaAmbientalDTO;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoValidadeAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.GeraDebitoException;
import br.com.elotech.portalarrecadacao.exception.LoginOAuthException;
import br.com.elotech.portalarrecadacao.exception.RenovacaoAlvaraException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeDebitos;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeLoginPortal;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeValidacaoDocumentos;
import br.com.elotech.portalarrecadacao.utils.faces.FacesUtil;
import br.com.elotech.report.DataSet;
import br.com.elotech.report.Parameter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoConfiguracaoAtividadeDocEnum;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.security.AuthenticationProviderAise;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.webflow.context.ExternalContext;

@Scope(value="flow")
@EloController
public class AcompanhamentoSolicitacaoController
extends EloLogger
implements Serializable {
    private static final String ANONYMOUS_USER = "anonymousUser";
    private static final long serialVersionUID = 1L;
    private static final String SELETORTELAACOMPANHAMENTO = "ROLE_TELAACOMPANHAMENTO";
    private static final String SELETORROLEALVARA = "ROLE_ALVARA";
    private static final String DD_MM_YYYY = "dd/MM/yyyy";
    private String cpfCnpj;
    private SolicitacaoAlvaraEntity solicitacaoSelecionada;
    private LaudoAlvaraEntity laudoSelecionado;
    private List<SolicitacaoAlvaraEntity> listaSolicitacao;
    private List<LaudoAlvaraEntity> listaLaudos;
    private List<LaudoAlvaraEntity> listaLaudosProvisorios;
    private List<AndamentoLaudoAlvaraEntity> listaAndamento;
    private boolean renderBotaoImprimirAlvara = false;
    private String solicitacao;
    private List<TipoDocumentoEntity> tiposDocumento;
    private List<SolicitacaoAlvaraDocumentoEntity> listaDocumentos;
    private TipoDocumentoEntity selectedTipoDocumento;
    private List<String> anexos;
    private List<SolicitacaoAlvaraDocumentoEntity> documentosRenovacao;
    private String secretariaLaudo;
    private String situacaoLaudo;
    private String dataParecer;
    private AndamentoLaudoAlvaraEntity andamentoSelecionado;
    private boolean flagBotaoConectarUsuario;
    private boolean usuarioLogado = false;
    private boolean renderBotaoImprimirTaxasReciboRenovacao = false;
    private boolean renderBotaoImprimirAlvaraReciboRenovacao = false;
    private boolean renderColunaVisualizaDoc = false;
    private boolean renderLicencaSanitaria = false;
    private boolean flagPossuiDocumentoParaAtividade = false;
    private List<LaudoAlvaraDocumentoEntity> documentosDoLaudo;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private EntidadeController entidadeController;
    @Resource
    private RequerimentoSolicitacaoAlvaraController requerimentoSolicitacaoAlvaraController;
    @Resource
    private ParecerDosLaudosController parecerDosLaudosController;
    private List<Atividade> listaAtividade;
    private List<ContratoSocialPessoaEntity> listaSocios;
    private String tipoAtividade;
    private SolicitacaoAlvaraDocumentoEntity documentoAlvara;
    private boolean termoDeUso = false;
    private String dataHoraAtualRecibo;
    private String cpfCnpjCmcResponsavelRecibo;
    private String cpfCnpjRecibo;
    private String textoTermoDeUso;
    private String dataValidadeSefaz;
    private boolean flagOpcaoRenovacaoRiscoA;
    private boolean flagLabelValidadeSefaz = false;
    private List<LaudoAlvaraEntity> listaLaudoVistoriar;
    private String descricaoAndamento;
    private boolean renovacaoRiscoBaixo;
    private boolean renovacaoRiscoBaixoOuLaudo;
    private EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal;
    private Boolean permiteRenovacaoAnual;
    private List<SolicitacaoAlvaraDocumentoEntity> listaDocumentosNaoValidados;
    private String motivosInvalidacaoDocumentos;
    private List<DocumentoAtividadeTipoInscricaoVo> documentosAtividadeTipoInscricao;
    private List<SolicitacaoAlvaraDocumentoEntity> novosDocumentosEnviar;
    private List<String> novosDocumentosAnexos;
    private List<SolicitacaoAlvaraDocumentoEntity> novosDocumentos;
    private String protocoloRedeSim;
    private boolean permiteUsuarioImprimir = true;
    @Autowired
    private AuthenticationProviderAise authenticationProviderAise;
    private boolean solicitacaoComLaudosCancelados;
    private SolicitacaoAlvaraVo solicitacaoVo = new SolicitacaoAlvaraVo();
    private SolicitacaoAlvaraEntity newSolicitacaoDaRenovacao;
    private String textoLiConcordoDispensaAmbiental;
    private boolean concordoDispensaAmbiental = false;

    public boolean isFlagPossuiDocumentoParaAtividade() {
        return this.flagPossuiDocumentoParaAtividade;
    }

    public void setFlagPossuiDocumentoParaAtividade(boolean flagPossuiDocumentoParaAtividade) {
        this.flagPossuiDocumentoParaAtividade = flagPossuiDocumentoParaAtividade;
    }

    public SolicitacaoAlvaraEntity getNewSolicitacaoDaRenovacao() {
        return this.newSolicitacaoDaRenovacao;
    }

    public void setNewSolicitacaoDaRenovacao(SolicitacaoAlvaraEntity newSolicitacaoDaRenovacao) {
        this.newSolicitacaoDaRenovacao = newSolicitacaoDaRenovacao;
    }

    public SolicitacaoAlvaraVo getSolicitacaoVo() {
        return this.solicitacaoVo;
    }

    public void setSolicitacaoVo(SolicitacaoAlvaraVo solicitacaoVo) {
        this.solicitacaoVo = solicitacaoVo;
    }

    public boolean isSolicitacaoComLaudosCancelados() {
        return this.solicitacaoComLaudosCancelados;
    }

    public void setSolicitacaoComLaudosCancelados(boolean solicitacaoComLaudosCancelados) {
        this.solicitacaoComLaudosCancelados = solicitacaoComLaudosCancelados;
    }

    public boolean isRenderLicencaSanitaria() {
        return this.renderLicencaSanitaria;
    }

    public void setRenderLicencaSanitaria(boolean renderLicencaSanitaria) {
        this.renderLicencaSanitaria = renderLicencaSanitaria;
    }

    public boolean isRenderColunaVisualizaDoc() {
        return this.renderColunaVisualizaDoc;
    }

    public void setRenderColunaVisualizaDoc(boolean renderColunaVisualizaDoc) {
        this.renderColunaVisualizaDoc = renderColunaVisualizaDoc;
    }

    public List<LaudoAlvaraDocumentoEntity> getDocumentosDoLaudo() {
        return this.documentosDoLaudo;
    }

    public void setDocumentosDoLaudo(List<LaudoAlvaraDocumentoEntity> documentosDoLaudo) {
        this.documentosDoLaudo = documentosDoLaudo;
    }

    public String getDataParecer() {
        return this.dataParecer;
    }

    public boolean isRenovacaoRiscoBaixo() {
        return this.renovacaoRiscoBaixo;
    }

    public void setRenovacaoRiscoBaixo(boolean renovacaoRiscoBaixo) {
        this.renovacaoRiscoBaixo = renovacaoRiscoBaixo;
    }

    public boolean isRenovacaoRiscoBaixoOuLaudo() {
        return this.renovacaoRiscoBaixoOuLaudo;
    }

    public void setRenovacaoRiscoBaixoOuLaudo(boolean renovacaoRiscoBaixoOuLaudo) {
        this.renovacaoRiscoBaixoOuLaudo = renovacaoRiscoBaixoOuLaudo;
    }

    public EnderecoCadastroGeralEntity getEnderecoImobiliarioPrincipal() {
        return this.enderecoImobiliarioPrincipal;
    }

    public void setEnderecoImobiliarioPrincipal(EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal) {
        this.enderecoImobiliarioPrincipal = enderecoImobiliarioPrincipal;
    }

    public String getSecretariaLaudo() {
        return this.secretariaLaudo;
    }

    public void setSecretariaLaudo(String secretariaLaudo) {
        this.secretariaLaudo = secretariaLaudo;
    }

    public String getSituacaoLaudo() {
        return this.situacaoLaudo;
    }

    public void setSituacaoLaudo(String situacaoLaudo) {
        this.situacaoLaudo = situacaoLaudo;
    }

    public String getDescricaoAndamento() {
        return this.descricaoAndamento;
    }

    public RequerimentoSolicitacaoAlvaraController getRequerimentoSolicitacaoAlvaraController() {
        return this.requerimentoSolicitacaoAlvaraController;
    }

    public void setRequerimentoSolicitacaoAlvaraController(RequerimentoSolicitacaoAlvaraController requerimentoSolicitacaoAlvaraController) {
        this.requerimentoSolicitacaoAlvaraController = requerimentoSolicitacaoAlvaraController;
    }

    public void setDescricaoAndamento(String descricaoAndamento) {
        this.descricaoAndamento = descricaoAndamento;
    }

    public boolean isFlagOpcaoRenovacaoRiscoA() {
        return this.flagOpcaoRenovacaoRiscoA;
    }

    public void setFlagOpcaoRenovacaoRiscoA(boolean flagOpcaoRenovacaoRiscoA) {
        this.flagOpcaoRenovacaoRiscoA = flagOpcaoRenovacaoRiscoA;
    }

    public List<LaudoAlvaraEntity> getListaLaudoVistoriar() {
        return this.listaLaudoVistoriar;
    }

    public void setListaLaudoVistoriar(List<LaudoAlvaraEntity> listaLaudoVistoriar) {
        this.listaLaudoVistoriar = listaLaudoVistoriar;
    }

    public boolean isFlagLabelValidadeSefaz() {
        return this.flagLabelValidadeSefaz;
    }

    public void setFlagLabelValidadeSefaz(boolean flagLabelValidadeSefaz) {
        this.flagLabelValidadeSefaz = flagLabelValidadeSefaz;
    }

    public String getDataValidadeSefaz() {
        return this.dataValidadeSefaz;
    }

    public void setDataValidadeSefaz(String dataValidadeSefaz) {
        this.dataValidadeSefaz = dataValidadeSefaz;
    }

    public String getTextoTermoDeUso() {
        return this.textoTermoDeUso;
    }

    public void setTextoTermoDeUso(String textoTermoDeUso) {
        this.textoTermoDeUso = textoTermoDeUso;
    }

    public String getCpfCnpjCmcResponsavelRecibo() {
        return this.cpfCnpjCmcResponsavelRecibo;
    }

    public void setCpfCnpjCmcResponsavelRecibo(String cpfCnpjCmcResponsavelRecibo) {
        this.cpfCnpjCmcResponsavelRecibo = cpfCnpjCmcResponsavelRecibo;
    }

    public String getCpfCnpjRecibo() {
        return this.cpfCnpjRecibo;
    }

    public void setCpfCnpjRecibo(String cpfCnpjRecibo) {
        this.cpfCnpjRecibo = cpfCnpjRecibo;
    }

    public String getDataHoraAtualRecibo() {
        return this.dataHoraAtualRecibo;
    }

    public void setDataHoraAtualRecibo(String dataHoraAtualRecibo) {
        this.dataHoraAtualRecibo = dataHoraAtualRecibo;
    }

    public boolean isTermoDeUso() {
        return this.termoDeUso;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public void setTermoDeUso(boolean termoDeUso) {
        this.termoDeUso = termoDeUso;
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getDocumentos() {
        if (this.documentosRenovacao == null) {
            this.documentosRenovacao = new ArrayList();
        }
        return this.documentosRenovacao;
    }

    public void setDocumentos(List<SolicitacaoAlvaraDocumentoEntity> documentos) {
        this.documentosRenovacao = documentos;
    }

    public List<String> getAnexos() {
        return this.anexos;
    }

    public void setAnexos(List<String> anexos) {
        this.anexos = anexos;
    }

    public TipoDocumentoEntity getSelectedTipoDocumento() {
        return this.selectedTipoDocumento;
    }

    public void setSelectedTipoDocumento(TipoDocumentoEntity selectedTipoDocumento) {
        this.selectedTipoDocumento = selectedTipoDocumento;
    }

    public List<TipoDocumentoEntity> getTiposDocumento() {
        return this.tiposDocumento;
    }

    public void setTiposDocumento(List<TipoDocumentoEntity> tiposDocumento) {
        this.tiposDocumento = tiposDocumento;
    }

    public List<LaudoAlvaraEntity> getListaLaudosProvisorios() {
        return this.listaLaudosProvisorios;
    }

    public void setListaLaudosProvisorios(List<LaudoAlvaraEntity> listaLaudosProvisorios) {
        this.listaLaudosProvisorios = listaLaudosProvisorios;
    }

    public String getTipoAtividade() {
        return this.tipoAtividade;
    }

    public void setTipoAtividade(String tipoAtividade) {
        this.tipoAtividade = tipoAtividade;
    }

    public List<Atividade> getListaAtividade() {
        return this.listaAtividade;
    }

    public void setListaAtividade(List<Atividade> listaAtividade) {
        this.listaAtividade = listaAtividade;
    }

    public List<ContratoSocialPessoaEntity> getListaSocios() {
        return this.listaSocios;
    }

    public void setListaSocios(List<ContratoSocialPessoaEntity> listaSocios) {
        this.listaSocios = listaSocios;
    }

    public List<AndamentoLaudoAlvaraEntity> getListaAndamento() {
        return this.listaAndamento;
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getListaDocumentos() {
        return this.listaDocumentos;
    }

    public void setListaDocumentos(List<SolicitacaoAlvaraDocumentoEntity> listaDocumentos) {
        this.listaDocumentos = listaDocumentos;
    }

    public void setListaAndamento(List<AndamentoLaudoAlvaraEntity> listaAndamento) {
        this.listaAndamento = listaAndamento;
    }

    public LaudoAlvaraEntity getLaudoSelecionado() {
        return this.laudoSelecionado;
    }

    public void setLaudoSelecionado(LaudoAlvaraEntity laudoSelecionado) {
        this.laudoSelecionado = laudoSelecionado;
    }

    public boolean isRenderBotaoImprimirAlvara() {
        return this.renderBotaoImprimirAlvara;
    }

    public void setRenderBotaoImprimirAlvara(boolean renderBotaoImprimirAlvara) {
        this.renderBotaoImprimirAlvara = renderBotaoImprimirAlvara;
    }

    public String getSolicitacao() {
        return this.solicitacao;
    }

    public void setSolicitacao(String numeroSolicitacao) {
        this.solicitacao = numeroSolicitacao;
    }

    public List<LaudoAlvaraEntity> getListaLaudos() {
        return this.listaLaudos;
    }

    public void setListaLaudos(List<LaudoAlvaraEntity> listaLaudos) {
        this.listaLaudos = listaLaudos;
    }

    public List<SolicitacaoAlvaraEntity> getListaSolicitacao() {
        return this.listaSolicitacao;
    }

    public void setListaSolicitacao(List<SolicitacaoAlvaraEntity> listaSolicitacao) {
        this.listaSolicitacao = listaSolicitacao;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoSelecionada() {
        return this.solicitacaoSelecionada;
    }

    public void setSolicitacaoSelecionada(SolicitacaoAlvaraEntity solicitacaoSelecionada) {
        this.solicitacaoSelecionada = solicitacaoSelecionada;
    }

    public AndamentoLaudoAlvaraEntity getAndamentoSelecionado() {
        return this.andamentoSelecionado;
    }

    public void setAndamentoSelecionado(AndamentoLaudoAlvaraEntity andamentoSelecionado) {
        this.andamentoSelecionado = andamentoSelecionado;
    }

    public Boolean getPermiteRenovacaoAnual() {
        return this.permiteRenovacaoAnual;
    }

    public void setPermiteRenovacaoAnual(Boolean permiteRenovacaoAnual) {
        this.permiteRenovacaoAnual = permiteRenovacaoAnual;
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getListaDocumentosNaoValidados() {
        return this.listaDocumentosNaoValidados;
    }

    public void setListaDocumentosNaoValidados(List<SolicitacaoAlvaraDocumentoEntity> listaDocumentosNaoValidados) {
        this.listaDocumentosNaoValidados = listaDocumentosNaoValidados;
    }

    public String getMotivosInvalidacaoDocumentos() {
        return this.motivosInvalidacaoDocumentos;
    }

    public void setMotivosInvalidacaoDocumentos(String motivosInvalidacaoDocumentos) {
        this.motivosInvalidacaoDocumentos = motivosInvalidacaoDocumentos;
    }

    public List<DocumentoAtividadeTipoInscricaoVo> getDocumentosAtividadeTipoInscricao() {
        return this.documentosAtividadeTipoInscricao;
    }

    public void setDocumentosAtividadeTipoInscricao(List<DocumentoAtividadeTipoInscricaoVo> documentosAtividadeTipoInscricao) {
        this.documentosAtividadeTipoInscricao = documentosAtividadeTipoInscricao;
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getNovosDocumentosEnviar() {
        return this.novosDocumentosEnviar;
    }

    public void setNovosDocumentosEnviar(List<SolicitacaoAlvaraDocumentoEntity> novosDocumentosEnviar) {
        this.novosDocumentosEnviar = novosDocumentosEnviar;
    }

    public String getTextoLiConcordoDispensaAmbiental() {
        return this.textoLiConcordoDispensaAmbiental;
    }

    public void setTextoLiConcordoDispensaAmbiental(String textoLiConcordoDispensaAmbiental) {
        this.textoLiConcordoDispensaAmbiental = textoLiConcordoDispensaAmbiental;
    }

    public boolean isConcordoDispensaAmbiental() {
        return this.concordoDispensaAmbiental;
    }

    public void setConcordoDispensaAmbiental(boolean concordoDispensaAmbiental) {
        this.concordoDispensaAmbiental = concordoDispensaAmbiental;
    }

    public void pesquisarSolicitacao() {
        this.renderColunaVisualizaDoc = false;
        this.listaAndamento = new ArrayList();
        this.listaLaudos = new ArrayList();
        if (this.filtroPesquisaInvalido()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"\u00c9 necess\u00e1rio informar no m\u00ednimo um campo para realizar a pesquisa.");
            return;
        }
        try {
            String[] consulta;
            if (!EloStringUtils.isEmpty((String)this.solicitacao) && Objects.nonNull(consulta = this.solicitacao.split("/")) && consulta.length >= 2 && Arrays.stream(consulta).allMatch(Objects::nonNull)) {
                this.solicitacaoVo.setNumeroSolicitacao(consulta[0]);
                this.solicitacaoVo.setExercicio(Long.valueOf(consulta[1]));
            }
            this.solicitacaoVo.setCpfCnpj(this.cpfCnpj);
            this.listaSolicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorCpfCnpj(this.solicitacaoVo);
            this.selecionarPrimeiraSolicitacao();
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean filtroPesquisaInvalido() {
        return EloStringUtils.isEmpty((String)this.solicitacao) && EloStringUtils.isEmpty((String)this.cpfCnpj) && this.solicitacaoVo != null && EloStringUtils.isEmpty((String)this.solicitacaoVo.getProtocoloRedeSim());
    }

    private void selecionarPrimeiraSolicitacao() {
        if (!EloListUtils.safeIsEmpty((List)this.listaSolicitacao).booleanValue()) {
            this.setSolicitacaoSelecionada((SolicitacaoAlvaraEntity)this.listaSolicitacao.get(0));
            this.selecionarLaudos();
        }
    }

    protected boolean verificaSituacaoDocumento() {
        boolean renderBotao = true;
        if (!EloListUtils.safeIsEmpty((List)this.listaDocumentos).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : this.listaDocumentos) {
                if (documento.isDocumentoValidado()) continue;
                renderBotao = false;
                break;
            }
        }
        return renderBotao;
    }

    public void selecionarLaudos() {
        try {
            this.solicitacaoComLaudosCancelados = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).isExisteLaudoComSituacaoCancelado(this.solicitacaoSelecionada);
            if (this.solicitacaoComLaudosCancelados) {
                ShowMessage.addWarnMessage((String)"validacao", (String)"Cont\u00e9m laudos com pareceres em situa\u00e7\u00e3o 'Cancelado'.");
            }
            this.permiteRenovacaoAnual();
            if (this.solicitacaoSelecionada.getDataValidadeSefaz() != null) {
                this.flagLabelValidadeSefaz = true;
                this.dataValidadeSefaz = this.formataData(this.solicitacaoSelecionada.getDataValidadeSefaz());
            } else {
                this.flagLabelValidadeSefaz = false;
                this.dataValidadeSefaz = null;
            }
            this.solicitacaoAlvaraController.setSolicitacaoAlvara(this.solicitacaoSelecionada);
            this.listaLaudos = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).buscaLaudosPorSolicitacao(this.solicitacaoSelecionada.getSolicitacaoAlvara());
            this.listaDocumentos = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDocumentosEnviadosSolicitacao(this.solicitacaoSelecionada);
            if (!EloListUtils.safeIsEmpty((List)this.listaLaudos).booleanValue()) {
                this.renderColunaVisualizaDoc = this.listaLaudos.stream().anyMatch(laudo -> SimNaoEnum.SIM.getShortText().equals(laudo.getTipoLaudo().getVisualizaDocumento()));
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean verificarSeUsuarioTemPermissaoAcessoSolicitacao() {
        String cpfCnpjUtilizadoNaConsulta = this.solicitacaoSelecionada.getCpfCnpjConsulta();
        UserDetails userLogado = this.getUsuarioLogado();
        this.setPermiteUsuarioImprimir(this.solicitacaoSelecionada.isSolicitacaoMEI() && this.validarPermissaoImpressaoAlvara(cpfCnpjUtilizadoNaConsulta, userLogado));
        return this.permiteUsuarioImprimir;
    }

    private boolean validarPermissaoImpressaoAlvara(String cpfCnpjUtilizadoNaConsulta, UserDetails usuarioLogado) {
        return cpfCnpjUtilizadoNaConsulta.equalsIgnoreCase(usuarioLogado.getUsername()) || this.usuarioPossuiRoleTelaAcompanhamento(usuarioLogado);
    }

    private boolean usuarioPossuiRoleTelaAcompanhamento(UserDetails usuarioLogado) {
        return usuarioLogado.getAuthorities().stream().anyMatch(acesso -> SELETORTELAACOMPANHAMENTO.equalsIgnoreCase(acesso.getAuthority()));
    }

    public UserDetails getUsuarioLogado() {
        return this.authenticationProviderAise.getUsuarioLogado();
    }

    public String formataData(Date data) {
        if (data != null) {
            return EloDateUtils.toAnsiDateString((Date)data, (String)DD_MM_YYYY);
        }
        return "";
    }

    public String formataHora(Date data) {
        if (data != null) {
            return EloDateUtils.toAnsiDateString((Date)data, (String)"HH:mm:ss");
        }
        return "";
    }

    public List<AndamentoLaudoAlvaraEntity> carregaListaAndamentoAlvaras(Long codigoLaudo) throws BaseException {
        return ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getCarregaListaAndamentoLaudoAlvara(codigoLaudo);
    }

    public void onRowSelectTabLaudos(LaudoAlvaraEntity laudo) {
        try {
            this.listaAndamento = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getCarregaListaAndamentoLaudoAlvara(laudo.getIdLaudoAlvara());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean documentosValidados(SolicitacaoAlvaraEntity solicitacao) {
        try {
            if (Objects.nonNull(solicitacao.getProtocoloRedeSim())) {
                return this.isDocumentosValidadosRedeSim(solicitacao);
            }
            return solicitacao.exigeUploadDocumentos() && solicitacao.isTodosDocumentosValidos();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu uma falha ao verificar valida\u00e7\u00e3o dos documentos");
            return Boolean.FALSE;
        }
    }

    private boolean isDocumentosValidadosRedeSim(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        FacadeRedeSim facadeRedeSim = (FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class);
        return facadeRedeSim.anexosRedeSimValidados(facadeRedeSim.getConsultaRedeSim(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO));
    }

    public boolean possuiDocumentosNaoValidados(SolicitacaoAlvaraEntity solicitacao) {
        try {
            if (Objects.nonNull(solicitacao.getProtocoloRedeSim())) {
                return !this.isDocumentosValidadosRedeSim(solicitacao);
            }
            return solicitacao.exigeUploadDocumentos() && !solicitacao.possuiDocumentoEmAnalise() && !solicitacao.isTodosDocumentosValidos();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu uma falha ao verificar valida\u00e7\u00e3o dos documentos");
            return Boolean.FALSE;
        }
    }

    public boolean possuiDocumentosEmAnalise(SolicitacaoAlvaraEntity solicitacao) {
        try {
            if (Objects.nonNull(solicitacao.getProtocoloRedeSim())) {
                return Boolean.FALSE;
            }
            return solicitacao.exigeUploadDocumentos() && solicitacao.possuiDocumentoEmAnalise();
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu uma falha ao verificar valida\u00e7\u00e3o dos documentos");
            return Boolean.FALSE;
        }
    }

    public boolean isExigeDocumentoNaImpressao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ArrayList tiposDocs = Lists.newArrayList();
        for (NaturezaSolicitacaoAlvaraEntity natureza : solicitacao.getNaturezas()) {
            String[] arrParam;
            ParametroAlvaraNaturezaEntity parametroAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getParametroAlvaraNatureza(natureza, ParametroAlvaraNaturezaEnum.DOCUMENTOS_VALIDADOS_IMPRESSAO, solicitacao.getTipoDeInscricao());
            if (!Objects.nonNull(parametroAlvara) || EloStringUtils.isEmpty((String)parametroAlvara.getValor())) continue;
            for (String tipoDoc : arrParam = parametroAlvara.getValor().split(",")) {
                if (tiposDocs.contains(tipoDoc)) continue;
                tiposDocs.add(tipoDoc);
            }
        }
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).exigirDocumentoNaImpressao(solicitacao, tiposDocs);
    }

    public boolean isRenderBotaoImprimirTaxasReciboRenovacao() {
        return this.renderBotaoImprimirTaxasReciboRenovacao;
    }

    public void setRenderBotaoImprimirTaxasReciboRenovacao(boolean renderBotaoImprimirTaxasReciboRenovacao) {
        this.renderBotaoImprimirTaxasReciboRenovacao = renderBotaoImprimirTaxasReciboRenovacao;
    }

    public boolean isRenderBotaoImprimirAlvaraReciboRenovacao() {
        return this.renderBotaoImprimirAlvaraReciboRenovacao;
    }

    public void setRenderBotaoImprimirAlvaraReciboRenovacao(boolean renderBotaoImprimirAlvaraReciboRenovacao) {
        this.renderBotaoImprimirAlvaraReciboRenovacao = renderBotaoImprimirAlvaraReciboRenovacao;
    }

    public void setEntidadeController(EntidadeController entidadeController) {
        this.entidadeController = entidadeController;
    }

    public EntidadeController getEntidadeController() {
        return this.entidadeController;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public boolean isFlagBotaoConectarUsuario() {
        return this.flagBotaoConectarUsuario;
    }

    public void setFlagBotaoConectarUsuario(boolean flagBotaoConectarUsuario) {
        this.flagBotaoConectarUsuario = flagBotaoConectarUsuario;
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getNovosDocumentos() {
        if (this.novosDocumentos == null) {
            this.novosDocumentos = new ArrayList();
        }
        return this.novosDocumentos;
    }

    public void setNovosDocumentos(List<SolicitacaoAlvaraDocumentoEntity> novosDocumentos) {
        this.novosDocumentos = novosDocumentos;
    }

    public List<String> getNovosDocumentosAnexos() {
        return this.novosDocumentosAnexos;
    }

    public void setNovosDocumentosAnexos(List<String> novosDocumentosAnexos) {
        this.novosDocumentosAnexos = novosDocumentosAnexos;
    }

    public boolean isPermiteUsuarioImprimir() {
        return this.permiteUsuarioImprimir;
    }

    public void setPermiteUsuarioImprimir(boolean permiteUsuarioImprimir) {
        this.permiteUsuarioImprimir = permiteUsuarioImprimir;
    }

    public String getProtocoloRedeSim() {
        return this.protocoloRedeSim;
    }

    public void setProtocoloRedeSim(String protocoloRedeSim) {
        this.protocoloRedeSim = protocoloRedeSim;
    }

    public void imprimirAlvara(SolicitacaoAlvaraEntity solicitacao) {
        try {
            if (solicitacao.isRedeSim() && solicitacao.isGrauRiscoLiberdadeEconomica()) {
                FacadeRedeSim facadeRedeSim = (FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class);
                SolicitacaoRedeSimEntity solicitacaoRedeSim = facadeRedeSim.getConsultaRedeSim(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
                facadeRedeSim.generateTermoDispensaRedeSim(solicitacaoRedeSim, Boolean.FALSE.booleanValue());
            } else {
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirAlvara(solicitacao);
            }
        }
        catch (GeraDebitoException d) {
            this.logger.error((Object)d.getMessage(), (Throwable)d);
            ShowMessage.addErrorMessage((String)"msg", (String)String.format("%s%s", "N\u00e3o foi poss\u00edvel concluir a opera\u00e7\u00e3o: ", d.getMessage()));
            this.renderBotaoImprimirTaxasReciboRenovacao = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    public void verificarUsuario() throws BaseException {
        if (this.isUsuarioAnonimo()) {
            String linkLoginExterno = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getValorParamGeral(Modulo.ALVARAONLINE.getCodigo(), "LINKLOGINEXTERNO");
            if (StringUtils.isNotBlank((CharSequence)linkLoginExterno)) {
                String url = null;
                String clientOauth = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getValorParamGeral(Modulo.ALVARAONLINE.getCodigo(), "CLIENTOAUTH");
                String redirectTelaAcompanhamento = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getValorParamGeral(Modulo.ALVARAONLINE.getCodigo(), "REDIRECTTELAACOMPANHAMENTO");
                url = StringUtils.isNotBlank((CharSequence)clientOauth) && StringUtils.isNotBlank((CharSequence)redirectTelaAcompanhamento) ? String.format("%s?response_type=code&client_id=%s&redirect_uri=%s&scope=&state=", linkLoginExterno, clientOauth, redirectTelaAcompanhamento) : linkLoginExterno;
                RequestContext context = RequestContext.getCurrentInstance();
                context.execute("window.open('" + url + "','_self')");
            } else {
                RequestContext.getCurrentInstance().execute("dlgAcessoRestrito.show();");
            }
        } else {
            this.renderizarBotoes();
        }
    }

    public void imprimirTaxas(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        RequestContext context = RequestContext.getCurrentInstance();
        try {
            if (solicitacaoAlvara != null) {
                if (this.usuarioLogado) {
                    if (solicitacaoAlvara.isSolicitacaoMEI()) {
                        ShowMessage.addInfoMessage((String)"msg", (String)"Tipo de Inscri\u00e7\u00e3o MEI \u00e9 Isento de Taxas");
                        return;
                    }
                    ImprimirTaxasAlvara imprimirTaxasAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirTaxas(solicitacaoAlvara);
                    String userKey = ((FacadeDebitos)SpringContext.getBean(FacadeDebitos.class)).loginWeb();
                    if (imprimirTaxasAlvara.getCarne() != null) {
                        String urlImprimiCarne = (String)SpringContext.getBean((String)"urlImprimirCarne", String.class);
                        String urlCarne = urlImprimiCarne + "uid=" + userKey + "&value=" + imprimirTaxasAlvara.getCarne();
                        context.execute("window.open('" + urlCarne + "','_blank')");
                    }
                    if (Objects.nonNull(imprimirTaxasAlvara.getBloqueto())) {
                        String urlImprimirBloqueto = (String)SpringContext.getBean((String)"urlImprimirBloqueto", String.class);
                        String urlBloqueto = urlImprimirBloqueto + "uid=" + userKey + "&value=" + imprimirTaxasAlvara.getBloqueto() + "&exercicio=" + imprimirTaxasAlvara.getExercicioBloqueto();
                        context.execute("window.open('" + urlBloqueto + "','_blank')");
                    }
                    context.addCallbackParam("abrirDialogInfo", (Object)false);
                } else {
                    context.addCallbackParam("abrirDialogInfo", (Object)false);
                    ShowMessage.addErrorMessage((String)"msg", (String)"Usu\u00e1rio n\u00e3o Autenticado!");
                }
            } else {
                context.addCallbackParam("abrirDialogInfo", (Object)false);
                ShowMessage.addErrorMessage((String)"msg", (String)"Selecione uma Solicita\u00e7\u00e3o!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            context.addCallbackParam("abrirDialogInfo", (Object)false);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    public void iniciar() throws BaseException {
        this.listaSolicitacao = null;
        this.listaLaudos = null;
        this.solicitacao = null;
        this.cpfCnpj = null;
        this.flagLabelValidadeSefaz = false;
        this.dataValidadeSefaz = null;
        this.permiteRenovacaoAnual = false;
        this.entidadeController.verificarAcessoContribuinte();
        this.renderLicencaSanitaria = this.carregarParametroImprimirLicencaSanitaria();
        this.renderizarBotoes();
    }

    private void renderizarBotoes() {
        if (this.isUsuarioAnonimo()) {
            this.flagBotaoConectarUsuario = true;
            this.usuarioLogado = false;
            return;
        }
        UserDetails usuario = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        for (GrantedAuthority usuarioSeletor : usuario.getAuthorities()) {
            if (!usuarioSeletor.getAuthority().equals(SELETORTELAACOMPANHAMENTO) && !usuarioSeletor.getAuthority().equals(SELETORROLEALVARA)) continue;
            this.flagBotaoConectarUsuario = false;
            this.usuarioLogado = true;
        }
    }

    public void getRequestParameter(String name, ExternalContext context) {
        try {
            this.entidadeController.isNavMenu();
            String tokenTemporario = context.getRequestParameterMap().get(name);
            if (tokenTemporario != null) {
                JSONObject jsonObject = ((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).getTokenOauth(Modulo.ALVARAONLINE.getCodigo(), tokenTemporario, this.getParametroGeral());
                if (jsonObject != null) {
                    this.checkOAuthResponse(jsonObject);
                    UsuarioEntity usuario = ((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).criaUsuarioPorToken((String)jsonObject.get("access_token"), Optional.empty());
                    if (usuario == null) {
                        ShowMessage.addInfoMessage((String)"msg", (String)"Usu\u00e1rio n\u00e3o foi Autenticado!");
                    } else {
                        UsuarioEntity user = usuario;
                        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities()));
                        this.logger.info((Object)(" ## USUARIO logado " + usuario.getUsuario()));
                        ((LoginPortalArrecadacao)SpringContext.getBean(LoginPortalArrecadacao.class)).setLogado(Boolean.valueOf(true));
                        ((LoginPortalArrecadacao)SpringContext.getBean(LoginPortalArrecadacao.class)).setNomeUsuarioLogado(usuario.getPessoa().getNome());
                        this.pesquisarSolicitacao();
                    }
                } else {
                    ShowMessage.addErrorMessage((String)"msg", (String)"Usu\u00e1rio n\u00e3o foi Autenticado! (N\u00e3o foi poss\u00edvel recuperar os dados do usu\u00e1rio)");
                }
            }
        }
        catch (BaseException | LoginOAuthException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)String.format("%s%s", "Ocorreu uma Falha na Integra\u00e7\u00e3o do Login! ERROR:", e.getMessage()));
            this.logger.error((Object)e.getMessage(), e);
        }
    }

    private String getParametroGeral() throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getParamentroGeral(Modulo.ALVARAONLINE.getCodigo(), "REDIRECTTELAACOMPANHAMENTO");
    }

    private void checkOAuthResponse(JSONObject json) throws LoginOAuthException {
        if (json.has("error")) {
            LoginOAuthException oauthException = new LoginOAuthException();
            oauthException.formJson(json);
            throw oauthException;
        }
    }

    public String renovarAlvara() throws BaseException {
        try {
            this.validaSolicitacaoSelecionada();
            this.renderBotaoImprimirAlvaraReciboRenovacao = false;
            this.flagOpcaoRenovacaoRiscoA = true;
            this.validaRenovacaoAlvara();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)"msg", (String)e.getMessage());
            return null;
        }
        this.entidadeController.carregaEntidade();
        this.carregarTermoDeUso();
        if (this.permiteMontarDadosRecibo()) {
            return this.montarDadosReciboEMostrarTermoDeUso();
        }
        try {
            if (!this.validaLaudosParaRenovacao(this.solicitacaoSelecionada.getLaudos())) {
                this.lancarRenovacaoAlvaraException("Todos os Laudos devem estar Liberados!");
            }
            if (this.solicitacaoSelecionada.exigeUploadDocumentos() && !this.verificaSituacaoDocumento() && this.solicitacaoSelecionada.getDataValidadeSefaz() == null) {
                this.lancarRenovacaoAlvaraException("Todos os Documentos devem estar validados!");
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)"msg", (String)e.getMessage());
            return null;
        }
        this.carregarSocios(this.solicitacaoSelecionada);
        this.carregarAtividades(this.solicitacaoSelecionada);
        this.carregarLaudosProvisorios();
        try {
            this.carregarListaTipoDocumentos();
            this.flagPossuiDocumentoParaAtividade = ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).possuiDocumentoParaAtividade(this.solicitacaoSelecionada, TipoConfiguracaoAtividadeDocEnum.RENOVACAO);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnMessage((String)"msg", (String)e.getMessage());
            this.lancarRenovacaoAlvaraException(e.getMessage());
            return null;
        }
        if (this.permiteMostrarDialogRenovacao()) {
            RequestContext.getCurrentInstance().execute("dialogRenovacao.show();");
            return null;
        }
        return "toRenovacaoAlvara";
    }

    private void validaRenovacaoAlvara() throws RenovacaoAlvaraException {
        this.validaNumeroAlvaraSolicitacaoSelecionada();
        this.validaPendenciaParaRenovacao();
        this.validaUsuarioLogado();
        this.validaAlvaraRenovado();
    }

    private boolean permiteMostrarDialogRenovacao() {
        return this.isPermiteMostrarDialogRenovacao();
    }

    public boolean isPermiteMostrarDialogRenovacao() {
        return !this.solicitacaoSelecionada.isSolicitacaoMEIPrestador() && !this.solicitacaoSelecionada.isSolicitacaoPrestadorServico() && (this.permiteRenovacaoLaudoRiscoA() || this.permiteRenovacaoAnual != false);
    }

    public boolean permiteMontarDadosRecibo() {
        return this.solicitacaoSelecionada.getDataValidadeSefaz() == null && this.solicitacaoSelecionada.possuiTodosLaudosLiberadoDefinitivo() && this.verificaSituacaoDocumento() && this.permiteRenovacaoAnual == false;
    }

    private void validaUsuarioLogado() throws RenovacaoAlvaraException {
        if (!this.usuarioLogado) {
            this.lancarRenovacaoAlvaraException("Nenhum usu\u00e1rio conectado. Fa\u00e7a login e tente novamente.");
        }
    }

    private void validaNumeroAlvaraSolicitacaoSelecionada() throws RenovacaoAlvaraException {
        if (this.solicitacaoSelecionada.getNumeroAlvara() == null) {
            this.lancarRenovacaoAlvaraException("O Alvar\u00e1 n\u00e3o foi gerado para efetuar a Renova\u00e7\u00e3o");
        }
    }

    private void validaSolicitacaoSelecionada() throws RenovacaoAlvaraException {
        if (this.solicitacaoSelecionada == null) {
            String mensagem = "Selecione uma solicita\u00e7\u00e3o para Renovar!";
            this.lancarRenovacaoAlvaraException(mensagem);
        }
    }

    private void lancarRenovacaoAlvaraException(String mensagem) throws RenovacaoAlvaraException {
        this.logger.error((Object)mensagem);
        throw new RenovacaoAlvaraException(mensagem);
    }

    private void carregarListaTipoDocumentos() throws BaseException {
        this.documentosAtividadeTipoInscricao = ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).carregarDocumentoPorAtividadeOuTipoInscricao(this.solicitacaoSelecionada, TipoConfiguracaoAtividadeDocEnum.RENOVACAO);
        this.documentosRenovacao = new ArrayList();
        this.documentoAlvara = new SolicitacaoAlvaraDocumentoEntity();
    }

    public void carregarLaudosProvisorios() {
        this.listaLaudosProvisorios = new ArrayList();
        if (!EloListUtils.safeIsEmpty((List)this.listaLaudos).booleanValue()) {
            for (LaudoAlvaraEntity laudo : this.listaLaudos) {
                if (laudo.getStatus() != StatusLaudoAlvara.LIBERADO_PROVISORIO) continue;
                this.listaLaudosProvisorios.add(laudo);
            }
        }
    }

    public boolean temLaudosProvisorios() {
        return EloListUtils.safeIsEmpty((List)this.listaLaudosProvisorios) == false;
    }

    private String montarDadosReciboEMostrarTermoDeUso() {
        try {
            this.renderizaBotaoImprimirAlvaraReciboRenovacao();
            this.cpfCnpjRecibo = EloStringUtils.formatCpfCnpj((String)this.solicitacaoSelecionada.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
            this.dataHoraAtualRecibo = EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd/MM/yyyy - HH:mm");
            this.listaLaudoVistoriar = new ArrayList();
            this.termoDeUso = false;
            RequestContext.getCurrentInstance().execute("dialogTermos.show();");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void renderizaBotaoImprimirAlvaraReciboRenovacao() {
        this.renderBotaoImprimirAlvaraReciboRenovacao = this.temLaudosProvisorios() && this.solicitacaoSelecionada.getDataValidadeSefaz() == null;
    }

    private void validaPendenciaParaRenovacao() throws RenovacaoAlvaraException {
        if (this.isPendenciaParaRenovacao() && !this.permiteRenovacaoAnual.booleanValue()) {
            this.lancarRenovacaoAlvaraException("N\u00e3o existe laudos ou documentos pendentes para realizar a renova\u00e7\u00e3o.");
        }
    }

    protected boolean isPendenciaParaRenovacao() {
        return this.solicitacaoSelecionada.getDataValidadeSefaz() == null && this.solicitacaoSelecionada.possuiTodosLaudosLiberadoDefinitivo() && this.verificaSituacaoDocumento() && this.solicitacaoSelecionada.isGrauRiscoAlto();
    }

    private void validaAlvaraRenovado() throws RenovacaoAlvaraException {
        if (this.isAlvaraRenovado() && !this.permiteRenovacaoAnual.booleanValue()) {
            this.lancarRenovacaoAlvaraException("A renova\u00e7\u00e3o j\u00e1 foi realizada!");
        }
    }

    protected boolean isAlvaraRenovado() {
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(this.solicitacaoSelecionada.getRenovacao()) && this.solicitacaoSelecionada.getDataValidadeSefaz() == null && this.solicitacaoSelecionada.possuiTodosLaudosLiberadoDefinitivo();
    }

    public void carregarTermoDeUso() throws BaseException {
        ParametroAlvaraEntity parametroAlvaraTermoDeUso = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(this.entidadeController.getEntidade(), ParametroAlvaraEnum.TERMO_DE_USO);
        if (parametroAlvaraTermoDeUso != null) {
            this.textoTermoDeUso = parametroAlvaraTermoDeUso.getValor();
        }
    }

    public boolean permiteRenovacaoLaudoRiscoA() {
        return this.solicitacaoSelecionada != null && this.solicitacaoSelecionada.isGrauRiscoBaixo() && SimNaoEnum.NAO.getShortText().equalsIgnoreCase(this.solicitacaoSelecionada.getRenovacao());
    }

    public boolean validaLaudosParaRenovacao(List<LaudoAlvaraEntity> laudos) throws BaseException {
        for (LaudoAlvaraEntity laudo : laudos) {
            if (this.isAlgumAndamentoLaudoLiberado(laudo)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlgumAndamentoLaudoLiberado(LaudoAlvaraEntity laudo) throws BaseException {
        this.listaAndamento = this.carregaListaAndamentoAlvaras(laudo.getIdLaudoAlvara());
        for (AndamentoLaudoAlvaraEntity andamentoLaudo : this.listaAndamento) {
            if (!andamentoLaudo.getStatus().equals((Object)StatusLaudoAlvara.LIBERADO_PROVISORIO) && !andamentoLaudo.getStatus().equals((Object)StatusLaudoAlvara.LIBERADO_DEFINITIVO)) continue;
            return true;
        }
        return false;
    }

    public void carregarSocios(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.getCadastroMobiliario().getContratosSociais() != null) {
            this.listaSocios = new ArrayList();
            for (ContratoSocialEntity contratoSocial : solicitacao.getCadastroMobiliario().getContratosSociais()) {
                this.listaSocios.addAll(contratoSocial.getPessoas());
            }
        }
    }

    public void carregarAtividades(SolicitacaoAlvaraEntity solicitacao) {
        this.listaAtividade = new ArrayList();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            if (atividade.getCnae() != null) {
                this.tipoAtividade = "Cnae";
                CnaeEntity cnae = new CnaeEntity();
                cnae.setCodigo(atividade.getCnae().getCodigo());
                cnae.setDescricao(atividade.getCnae().getDescricao());
                this.listaAtividade.add(cnae);
                continue;
            }
            if (atividade.getAtividadeMei() != null) {
                this.tipoAtividade = "Atividade Mei";
                AtividadeMeiEntity mei = new AtividadeMeiEntity();
                mei.setCnae(atividade.getAtividadeMei().getCnae());
                mei.setCodigo(atividade.getAtividadeMei().getCnae().getCodigo());
                mei.setDescricao(atividade.getAtividadeMei().getDescricao());
                this.listaAtividade.add(mei);
                continue;
            }
            if (atividade.getSequenciaCbo() == null) continue;
            this.tipoAtividade = "Cbo";
            RhCboEntity cbo = new RhCboEntity();
            cbo.setCodigo(atividade.getSequenciaCbo().getCodigo());
            cbo.setDescricao(atividade.getSequenciaCbo().getDescricao());
            this.listaAtividade.add(cbo);
        }
    }

    public void openDialog(TipoDocumentoEntity tipoDocumento) {
        this.selectedTipoDocumento = tipoDocumento;
        if (this.anexos == null) {
            this.anexos = new ArrayList();
        } else {
            this.anexos.clear();
        }
    }

    public void removeDocumento(DocumentoAtividadeTipoInscricaoVo docSelecionado) {
        ArrayList<SolicitacaoAlvaraDocumentoEntity> docs = new ArrayList<SolicitacaoAlvaraDocumentoEntity>();
        for (SolicitacaoAlvaraDocumentoEntity documento : this.documentosRenovacao) {
            if (!documento.getTipoDocumento().equals((Object)docSelecionado.getTipoDocumento())) continue;
            docs.add(documento);
        }
        this.documentosRenovacao.removeAll(docs);
    }

    public void removeNovosDocumentos(TipoDocumentoEntity tipoDocumento) {
        ArrayList<SolicitacaoAlvaraDocumentoEntity> docs = new ArrayList<SolicitacaoAlvaraDocumentoEntity>();
        for (SolicitacaoAlvaraDocumentoEntity documento : this.novosDocumentos) {
            if (!documento.getTipoDocumento().equals((Object)tipoDocumento)) continue;
            docs.add(documento);
        }
        this.novosDocumentos.removeAll(docs);
    }

    public void removeAnexo(String anexo) {
        if (this.anexos.contains(anexo)) {
            this.anexos.remove(anexo);
        }
    }

    public Boolean enviouDocumentos(TipoDocumentoEntity tipoDocumento) {
        if (!EloListUtils.safeIsEmpty((List)this.documentosRenovacao).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : this.documentosRenovacao) {
                if (!documento.getTipoDocumento().equals((Object)tipoDocumento)) continue;
                return true;
            }
        }
        return false;
    }

    public void handleFileUpload(FileUploadEvent event) {
        this.documentoAlvara = new SolicitacaoAlvaraDocumentoEntity();
        this.documentoAlvara.setSituacao(SituacaoDocumentoAlvaraEnum.EM_ANALISE);
        this.documentoAlvara.setSolicitacaoAlvara(this.solicitacaoAlvaraController.getSolicitacaoAlvara());
        this.documentoAlvara.setDocumento(event.getFile().getContents());
        this.documentoAlvara.setDataInclusao(new Date());
        this.documentoAlvara.setRenovacao("S");
        this.anexos.add(event.getFile().getFileName());
    }

    public void adicionarNovosDocumentos() {
        if (this.novosDocumentosAnexos.isEmpty()) {
            ShowMessage.addErrorMessage((String)"validacaoDocumentos", (String)"Adicione um Documento");
            return;
        }
        for (SolicitacaoAlvaraDocumentoEntity doc : this.novosDocumentosEnviar) {
            if (this.selectedTipoDocumento == null) continue;
            doc.setTipoDocumento(this.selectedTipoDocumento);
        }
        this.getNovosDocumentos().addAll(this.novosDocumentosEnviar);
        this.novosDocumentosEnviar.clear();
        RequestContext.getCurrentInstance().execute("docsDialog.hide()");
    }

    public void enviar() {
        if (this.selectedTipoDocumento != null) {
            this.documentoAlvara.setTipoDocumento(this.selectedTipoDocumento);
        }
        this.getDocumentos().add(this.documentoAlvara);
    }

    public boolean isCriarSolicitacaoNaRenovacao() throws SolicitacaoAlvaraException {
        try {
            return SimNaoEnum.equalSim((String)UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.CRIAR_SOLICITACAO_NA_RENOVACAO).getValor());
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException("Verifique a configura\u00e7\u00e3o do par\u00e2metro CRIAR_SOLICITACAO_NA_RENOVACAO", e.getCause());
        }
    }

    public String confirmarRenovacao() {
        try {
            this.renderBotaoImprimirTaxasReciboRenovacao = false;
            if (!this.isCriarSolicitacaoNaRenovacao() || !this.solicitacaoSelecionada.isRedeSim()) {
                this.renderBotaoImprimirAlvaraReciboRenovacao = !this.temLaudosProvisorios() && this.solicitacaoSelecionada.getDataValidadeSefaz() == null || this.solicitacaoSelecionada.isGrauRiscoBaixo() && SimNaoEnum.NAO.getShortText().equalsIgnoreCase(this.solicitacaoSelecionada.getRenovacao());
                StringBuilder descHistorico = new StringBuilder();
                if (this.solicitacaoSelecionada.isGrauRiscoBaixo() && SimNaoEnum.NAO.getShortText().equalsIgnoreCase(this.solicitacaoSelecionada.getRenovacao())) {
                    descHistorico.append("Renova\u00e7\u00e3o Grau de Risco B");
                }
                this.solicitacaoSelecionada.setRenovacao("S");
                this.solicitacaoSelecionada.setDataRenovacao(new Date());
                this.listaLaudoVistoriar = new ArrayList();
                if (this.listaLaudosProvisorios != null) {
                    for (LaudoAlvaraEntity laudo : this.listaLaudosProvisorios) {
                        if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(laudo.getVistoriar())) continue;
                        laudo.setStatus(StatusLaudoAlvara.RENOVAR);
                        this.listaLaudoVistoriar.add(laudo);
                    }
                }
                if (this.getDocumentos() != null && !this.getDocumentos().isEmpty()) {
                    if (descHistorico.length() > 0) {
                        descHistorico.append("; ");
                    }
                    descHistorico.append("Renova\u00e7\u00e3o - Adicionado documentos");
                    this.solicitacaoSelecionada.setDocumentos(this.getDocumentos());
                }
                if (this.permiteRenovacaoAnual.booleanValue()) {
                    if (descHistorico.length() > 0) {
                        descHistorico.append("; ");
                    }
                    descHistorico.append("Renova\u00e7\u00e3o - Validade Alvar\u00e1 Anual");
                    this.salvarValidadeAnual();
                }
                UserDetails userLogado = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarHistoricoRenovacao(this.listaLaudoVistoriar, this.solicitacaoSelecionada, userLogado, descHistorico.toString());
                this.cpfCnpjRecibo = EloStringUtils.formatCpfCnpj((String)this.solicitacaoSelecionada.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
                this.dataHoraAtualRecibo = EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd/MM/yyyy - HH:mm");
                return "toReciboSolicitacaoRenovacao";
            }
            this.newSolicitacaoDaRenovacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).clonarSolicitacaoNaRenovacao(this.solicitacaoSelecionada);
            FacesUtil.execute((String)"cloneSolicitacaoDialog.show()");
            this.solicitacaoSelecionada = null;
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu uma Falha, n\u00e3o foi poss\u00edvel salvar a Renova\u00e7\u00e3o : " + e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void salvarValidadeAnual() throws BaseException {
        SolicitacaoAlvaraValidadeEntity validadeAnualAtual;
        Date dataValidadeAnual = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).montarDataAlvaraValidadeAnual();
        if (dataValidadeAnual != null && this.permiteCriarValidadeAnual(dataValidadeAnual, validadeAnualAtual = this.carregarValidadeAnual(this.solicitacaoSelecionada))) {
            this.alteraSituacaoValidadeAlvaraParaNao(validadeAnualAtual);
            SolicitacaoAlvaraValidadeEntity validadeAlvara = new SolicitacaoAlvaraValidadeEntity();
            validadeAlvara.setDataValidade(dataValidadeAnual);
            validadeAlvara.setDescricao(TipoValidadeAlvaraEnum.ALVARA_ANUAL.getDescricao());
            validadeAlvara.setAtual("S");
            validadeAlvara.setSolicitacaoAlvara(this.solicitacaoSelecionada);
            this.salvarValidadeAlvara(validadeAlvara);
        }
    }

    private SolicitacaoAlvaraValidadeEntity carregarValidadeAnual(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarValidadeAnual(solicitacaoAlvara);
    }

    private void alteraSituacaoValidadeAlvaraParaNao(SolicitacaoAlvaraValidadeEntity validadeAnualAtual) throws BaseException {
        validadeAnualAtual.setAtual(SimNaoEnum.NAO.getShortText());
        this.salvarValidadeAlvara(validadeAnualAtual);
    }

    private void salvarValidadeAlvara(SolicitacaoAlvaraValidadeEntity validadeAlvara) throws BaseException {
        ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoAlvaraValidade(validadeAlvara);
    }

    private boolean permiteCriarValidadeAnual(Date dataValidadeAnual, SolicitacaoAlvaraValidadeEntity validadeAnual) {
        return validadeAnual == null || validadeAnual.getDataValidade().compareTo(dataValidadeAnual) != 0;
    }

    public String aceitaTermosTelaAcompanhamento() throws BaseException {
        RequestContext context = RequestContext.getCurrentInstance();
        if (this.termoDeUso) {
            String descHistorico = null;
            if (this.solicitacaoSelecionada.isGrauRiscoBaixo() && !this.solicitacaoSelecionada.isRenovacaoDeSolicitacao()) {
                descHistorico = "Renova\u00e7\u00e3o Grau de Risco B";
            }
            this.solicitacaoSelecionada.setRenovacao(SimNaoEnum.getSimShortText());
            this.solicitacaoSelecionada.setDataRenovacao(new Date());
            context.execute("dialogTermos.hide();");
            UserDetails userLogadoDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarHistoricoRenovacao(null, this.solicitacaoSelecionada, userLogadoDetails, descHistorico);
            this.renderBotaoImprimirAlvaraReciboRenovacao = true;
            return "toReciboSolicitacaoRenovacao";
        }
        this.solicitacaoSelecionada.setRenovacao("N");
        this.solicitacaoSelecionada.setDataRenovacao(null);
        context.execute("dialogTermos.show();");
        ShowMessage.addErrorMessage((String)"validacaoTermos", (String)"A Solicita\u00e7\u00e3o da Renova\u00e7\u00e3o do Alvar\u00e1 n\u00e3o ser\u00e1 finalizada. \u00c9 necess\u00e1rio aceitar os termos de uso.");
        return null;
    }

    public String aceitarTermosTelaRenovacao() {
        RequestContext context = RequestContext.getCurrentInstance();
        if (this.termoDeUso) {
            context.execute("dialogTermos.hide();");
            return this.confirmarRenovacao();
        }
        context.execute("dialogTermos.show();");
        ShowMessage.addErrorMessage((String)"validacaoTermos", (String)"A Solicita\u00e7\u00e3o da Renova\u00e7\u00e3o do Alvar\u00e1 n\u00e3o ser\u00e1 finalizada. \u00c9 necess\u00e1rio aceitar os termos de uso.");
        return null;
    }

    public void validarInformacaoRenovacao() {
        try {
            this.termoDeUso = false;
            if (this.solicitacaoSelecionada.isSolicitacaoJuridicaNormal() || this.solicitacaoSelecionada.isSolicitacaoMEINormal() || this.solicitacaoSelecionada.isSolicitacaoCBO()) {
                this.validarDocObrigatorioPorAtividade();
                this.validaRenovacao();
            } else {
                this.validaDocumentosLaudosRenovacao();
                this.renderBotaoImprimirAlvaraReciboRenovacao = false;
            }
            RequestContext.getCurrentInstance().execute("dialogTermos.show();");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private void validarDocObrigatorioPorAtividade() throws BaseException {
        ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).validarDocObrigatorioPorAtividade(this.solicitacaoSelecionada, this.documentosRenovacao);
    }

    private void validaRenovacao() throws SolicitacaoAlvaraException {
        if (this.solicitacaoSelecionada.isGrauRiscoAlto() || this.solicitacaoSelecionada.isRenovacaoDeSolicitacao() || this.solicitacaoSelecionada.isGrauRiscoBaixo() && this.renovacaoRiscoBaixoOuLaudo) {
            this.validaDocumentosLaudosRenovacao();
        }
    }

    private void validaDocumentosLaudosRenovacao() throws SolicitacaoAlvaraException {
        boolean flagVerificaLaudo = false;
        if (EloListUtils.safeIsEmpty((List)this.documentosRenovacao).booleanValue()) {
            if (this.temLaudosProvisorios()) {
                for (LaudoAlvaraEntity laudo : this.listaLaudosProvisorios) {
                    if (laudo.getVistoriar() == null || !laudo.getVistoriar().equals("S")) continue;
                    flagVerificaLaudo = true;
                }
            }
            if (!flagVerificaLaudo && this.solicitacaoSelecionada.getDataValidadeSefaz() != null) {
                throw new SolicitacaoAlvaraException("\u00c9 preciso escolher um laudo para vistoria ou adicionar um documento!");
            }
            if (!flagVerificaLaudo && this.solicitacaoSelecionada.getDataValidadeSefaz() == null) {
                throw new SolicitacaoAlvaraException("\u00c9 preciso selecionar um laudo para vistoria!");
            }
        }
    }

    public String confirmarOpcaoRenovacao() {
        if (this.permiteRenovacaoAnual.booleanValue() || this.renovacaoRiscoBaixo || this.renovacaoRiscoBaixoOuLaudo) {
            if (this.renovacaoRiscoBaixo) {
                this.flagOpcaoRenovacaoRiscoA = false;
            } else if (this.renovacaoRiscoBaixoOuLaudo) {
                this.flagOpcaoRenovacaoRiscoA = true;
            }
            RequestContext.getCurrentInstance().execute("dialogRenovacao.hide();");
            return "toRenovacaoAlvara";
        }
        ShowMessage.addErrorMessage((String)"validacaoDlgRenovacao", (String)"Escolha a op\u00e7\u00e3o que deseja para a renova\u00e7\u00e3o!");
        return null;
    }

    public void carregaDescricaoAndamento(AndamentoLaudoAlvaraEntity andamento) {
        this.andamentoSelecionado = andamento;
        try {
            this.enderecoImobiliarioPrincipal = this.buscaEnderecoPrincipal(this.solicitacaoSelecionada);
            if (this.enderecoImobiliarioPrincipal != null) {
                if (this.solicitacaoSelecionada.getCadastroImobiliario() == null && this.solicitacaoSelecionada.getCadastroMobiliario() != null) {
                    this.solicitacaoSelecionada.setCadastroImobiliario(this.solicitacaoSelecionada.getCadastroMobiliario().getCadastroImobiliario());
                }
                this.secretariaLaudo = this.andamentoSelecionado.getIdLaudoAlvara().getTipoLaudo().getDescricao();
                this.situacaoLaudo = this.andamentoSelecionado.getStatus() == StatusLaudoAlvara.LIBERADO_PROVISORIO ? String.format("%s - V\u00e1lido at\u00e9: %s", this.andamentoSelecionado.getStatus().toString(), EloDateUtils.toAnsiDateString((Date)this.andamentoSelecionado.getValidadeProvisorio(), (String)DD_MM_YYYY)) : this.andamentoSelecionado.getStatus().toString();
                this.dataParecer = EloDateUtils.toAnsiDateString((Date)this.andamentoSelecionado.getDataAndamento(), (String)DD_MM_YYYY);
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)String.format("%s%s", "Ocorreu uma falha no carregamento dos dados do parecer do laudo : ", e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private EnderecoCadastroGeralEntity buscaEnderecoPrincipal(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.getCadastroImobiliario() != null) {
            return ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getBuscaEnderecoImobiliarioPrincipal(solicitacao.getCadastroImobiliario().getCadastroGeral().getId().getCodigo());
        }
        if (solicitacao.getCadastroMobiliario() != null) {
            return ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getBuscaEnderecoImobiliarioPrincipal(solicitacao.getCadastroMobiliario().getCadastroImobiliario().getCadastroGeral().getId().getCodigo());
        }
        return null;
    }

    public void verDetalhes(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.requerimentoSolicitacaoAlvaraController.verDetalhes(solicitacao, false);
    }

    public String formatCpfCnpj(String cpfCnpj) {
        try {
            return EloStringUtils.formatCpfCnpjReport((String)cpfCnpj);
        }
        catch (FormatError e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String formatFone(String fone) {
        try {
            return EloStringUtils.formatFone((String)fone);
        }
        catch (FormatError e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean renderizaBotaoRenovar() {
        try {
            if (Objects.isNull(this.solicitacaoSelecionada)) {
                return Boolean.FALSE;
            }
            if (this.solicitacaoSelecionada.isGrauRiscoBaixo() && this.solicitacaoSelecionada.isRedeSim()) {
                if (!this.isDocumentosValidadosRedeSim(this.solicitacaoSelecionada) || this.solicitacaoSelecionada.possuiTodosLaudosLiberadoDefinitivo()) {
                    return Boolean.FALSE;
                }
                if (this.solicitacaoSelecionada.possuiLaudoProvisorio()) {
                    return Boolean.TRUE;
                }
            }
            if (this.flagBotaoConectarUsuario || this.solicitacaoSelecionada.isSolicitacaoMEI() || !this.solicitacaoSelecionada.possuiTodosLaudosLiberado() || UtilsController.desabilitaImpressaoTaxasAlvara() && EloListUtils.safeIsEmpty((List)this.getListaLaudos()).booleanValue()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            return Boolean.FALSE;
        }
    }

    public boolean renderizaBotaoImprimirTaxasAlvara() throws BaseException {
        if (Objects.isNull(this.solicitacaoSelecionada) || this.solicitacaoSelecionada.isSolicitacaoMEI()) {
            return false;
        }
        if (this.solicitacaoSelecionada.isGrauRiscoLiberdadeEconomica() && SimNaoEnum.equalNao((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.PERMITE_GERAR_TAXA_LIBERDADE_ECONOMICA).getValor()).booleanValue()) {
            return false;
        }
        if (this.solicitacaoSelecionada.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS})) {
            return false;
        }
        if (UtilsController.desabilitaImpressaoTaxasAlvara()) {
            return false;
        }
        if (UtilsController.possuiIntegracaoRedeSim() && this.solicitacaoSelecionada.isRedeSim() && !this.solicitacaoSelecionada.isRenovacaoDeSolicitacao()) {
            return false;
        }
        return !this.flagBotaoConectarUsuario;
    }

    public String mensagemImpressao() {
        if (this.solicitacaoSelecionada.isSolicitacaoMEI()) {
            return "Fa\u00e7a a Impress\u00e3o da Inscri\u00e7\u00e3o no bot\u00e3o Imprimir Alvar\u00e1.";
        }
        return "Fa\u00e7a a Impress\u00e3o do Alvar\u00e1 no bot\u00e3o Imprimir Alvar\u00e1.";
    }

    public boolean mostrarBotaoLoginAcompanhamento() {
        this.renderizarBotoes();
        return this.flagBotaoConectarUsuario;
    }

    public boolean permiteRenovacaoAnual() {
        try {
            this.permiteRenovacaoAnual = UtilsController.permiteRenovacaoAnual((SolicitacaoAlvaraEntity)this.solicitacaoSelecionada);
            return this.permiteRenovacaoAnual;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            return false;
        }
    }

    public String getUsuarioLogado(UsuarioEntity usuario) {
        if (usuario != null && this.isUsuarioValido(usuario)) {
            return usuario.getPessoa().getDoisPrimeirosNomes();
        }
        return "Usu\u00e1rio";
    }

    private boolean isUsuarioValido(UsuarioEntity usuario) {
        return usuario instanceof UsuarioEntity && usuario.getPessoa() != null;
    }

    public String getDescricaoRenovacaoRiscoBaixo() {
        StringBuilder str = new StringBuilder();
        try {
            String paramDias = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.DIASALVARAPROVISORIO).getValor();
            str.append("Deseja renovar somente a validade de ");
            str.append(paramDias);
            str.append(" dias (Risco Baixo)");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("Falha ao carregar par\u00e2emtro DIASALVARAPROVISORIO. %s  ", e.getMessage()));
        }
        return str.toString();
    }

    public void carregarDocumentosDosLaudos(LaudoAlvaraEntity laudo) {
        if (EloListUtils.safeIsEmpty((List)laudo.getDocumentos()).booleanValue()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Por enquanto n\u00e3o foi anexado nenhum documento para este laudo.");
        } else {
            this.documentosDoLaudo.clear();
            this.documentosDoLaudo.addAll(laudo.getDocumentos().stream().filter(doc -> Objects.nonNull(doc.getExercicio())).sorted(Comparator.comparingLong(LaudoAlvaraDocumentoEntity::getExercicio).reversed()).collect(Collectors.toList()));
            RequestContext context = RequestContext.getCurrentInstance();
            context.execute("docLaudoDialog.show()");
        }
    }

    public StreamedContent downloadFile(LaudoAlvaraDocumentoEntity documento) {
        ByteArrayInputStream stream = new ByteArrayInputStream(documento.getDocumento());
        return new DefaultStreamedContent((InputStream)stream);
    }

    public void listarDocumentosNaoValidados(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoSelecionada = solicitacaoAlvara;
        this.listaDocumentosNaoValidados = this.solicitacaoSelecionada.getDocumentos().stream().filter(SolicitacaoAlvaraDocumentoEntity::isDocumentoNaoValidado).collect(Collectors.toList());
        if (!EloListUtils.safeIsEmpty((List)this.listaDocumentosNaoValidados).booleanValue()) {
            StringBuilder sb = new StringBuilder();
            for (SolicitacaoAlvaraDocumentoEntity documento : this.listaDocumentosNaoValidados) {
                if (EloStringUtils.isEmpty((String)documento.getMotivoInvalidacao())) continue;
                if (EloNumberUtils.isBiggerThanZero((Number)sb.length()).booleanValue()) {
                    sb.append(System.lineSeparator());
                }
                sb.append(documento.getMotivoInvalidacao());
            }
            this.motivosInvalidacaoDocumentos = sb.toString();
        }
    }

    public void enviarNovosDocumentos() throws BaseException {
        for (SolicitacaoAlvaraDocumentoEntity documento : this.novosDocumentos) {
            ((FacadeValidacaoDocumentos)SpringContext.getBean(FacadeValidacaoDocumentos.class)).salvarDocumento(documento);
        }
        this.novosDocumentos.clear();
        ShowMessage.addInfoMessage((String)"validacao", (String)"Novos documentos encaminhados para avalia\u00e7\u00e3o do respons\u00e1vel.");
    }

    public void mostrarUploadDocumentos() throws BaseException {
        this.documentosAtividadeTipoInscricao = ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).carregarDocumentoPorAtividadeOuTipoInscricao(this.solicitacaoSelecionada, TipoConfiguracaoAtividadeDocEnum.SOLICITACAO);
        if (this.novosDocumentosEnviar == null) {
            this.novosDocumentosEnviar = new ArrayList();
        } else {
            this.novosDocumentosEnviar.clear();
        }
    }

    public void anexarArquivo(FileUploadEvent event) {
        if (event.getFile() != null && event.getFile().getContents() != null) {
            this.documentoAlvara = new SolicitacaoAlvaraDocumentoEntity();
            this.documentoAlvara.setSituacao(SituacaoDocumentoAlvaraEnum.EM_ANALISE);
            this.documentoAlvara.setSolicitacaoAlvara(this.solicitacaoAlvaraController.getSolicitacaoAlvara());
            this.documentoAlvara.setDocumento(event.getFile().getContents());
            this.documentoAlvara.setTipoDocumento(this.selectedTipoDocumento);
            this.documentoAlvara.setDataInclusao(new Date());
            this.documentoAlvara.setSolicitacaoAlvara(this.solicitacaoSelecionada);
            this.documentoAlvara.setNomeArquivo(event.getFile().getFileName());
            UserDetails userLogado = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            if (userLogado instanceof UsuarioEntity) {
                this.documentoAlvara.setUsuario((UsuarioEntity)userLogado);
            }
            this.novosDocumentosAnexos.add(event.getFile().getFileName());
            this.novosDocumentosEnviar.add(this.documentoAlvara);
        }
    }

    public boolean enviouNovosDocumentos(TipoDocumentoEntity tipoDocumento) {
        if (!EloListUtils.safeIsEmpty((List)this.novosDocumentos).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : this.novosDocumentos) {
                if (!documento.getTipoDocumento().equals((Object)tipoDocumento)) continue;
                return true;
            }
        }
        return false;
    }

    public void removerDocumentoAnexado(String anexo) {
        if (this.novosDocumentosAnexos.contains(anexo)) {
            this.novosDocumentosAnexos.remove(anexo);
        }
        ArrayList<SolicitacaoAlvaraDocumentoEntity> docsParaRemover = new ArrayList<SolicitacaoAlvaraDocumentoEntity>();
        for (SolicitacaoAlvaraDocumentoEntity documento : this.novosDocumentosEnviar) {
            if (!documento.getNomeArquivo().equals(anexo)) continue;
            docsParaRemover.add(documento);
        }
        if (!EloListUtils.safeIsEmpty(docsParaRemover).booleanValue()) {
            this.novosDocumentosEnviar.removeAll(docsParaRemover);
        }
    }

    public void openDialogNovosDocumentos(TipoDocumentoEntity tipoDocumento) {
        this.selectedTipoDocumento = tipoDocumento;
        if (this.novosDocumentosAnexos == null) {
            this.novosDocumentosAnexos = new ArrayList();
        } else {
            this.novosDocumentosAnexos.clear();
        }
    }

    private boolean carregarParametroImprimirLicencaSanitaria() {
        try {
            ParametroAlvaraEntity parametroAlvara = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(this.entidadeController.getEntidade(), ParametroAlvaraEnum.IMPRIMIR_LICENCA_SANITARIA);
            if (SimNaoEnum.SIM.getShortText().equals(parametroAlvara.getValor())) {
                return Boolean.TRUE;
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), e.getCause());
            ShowMessage.addInfoMessage((String)"validacao", (String)"Ocorreu uma falha ao carregar o par\u00e2metro para imprimir licen\u00e7a sanit\u00e1ria.");
        }
        return Boolean.FALSE;
    }

    public void imprimirLicencaSanitaria(SolicitacaoAlvaraEntity solicitacao) {
        try {
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirLicencaSanitaria(solicitacao);
        }
        catch (ValidacaoException ve) {
            ShowMessage.addErrorMessages((String)"validacao", (List)ve.getMensagens());
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    public void setDocumentosDoLaudoSelecionado(LaudoAlvaraEntity laudo) {
        this.parecerDosLaudosController.setDocumentosDoLaudoSelecionado(laudo);
        FacesUtil.execute((String)"dialogUploadDocumentoLaudoWidgetVar.show()");
    }

    public boolean isUsuarioAnonimo() {
        return ANONYMOUS_USER.equals(SecurityContextHolder.getContext().getAuthentication().getPrincipal());
    }

    public boolean exibeBotaoImpressaoDispensaLicencaSanitaria() throws BaseException {
        try {
            return this.solicitacaoSelecionada != null && !this.solicitacaoSelecionada.possuiLaudoAmbiental() && this.solicitacaoSelecionada.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && UtilsController.isImpressaoDispensaLicencaAmbientalConfigurada() && SimNaoEnum.equalSim((String)this.solicitacaoSelecionada.getFinalizado()) != false && this.solicitacaoSelecionada.getNumeroAlvara() != null;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro inesperado ao carregar ao verificar a Dispensa de Licen\u00e7a Ambiental.");
            return false;
        }
    }

    public void carregarTextoLiConcordoDispensaAmbiental() throws BaseException {
        this.textoLiConcordoDispensaAmbiental = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TEXTO_LI_CONCORDO_DISPENSA_LICENCA_AMBIENTAL);
        this.concordoDispensaAmbiental = false;
    }

    public void imprimirDispensaLicencaAmbiental() {
        try {
            if (this.solicitacaoSelecionada != null && UtilsController.isImpressaoDispensaLicencaAmbientalConfigurada()) {
                this.gravarSolicitacaoImpressao();
                byte[] relatorioDispensaAmbiental = this.montarDataSetDispensaAmbiental();
                if (relatorioDispensaAmbiental == null || relatorioDispensaAmbiental.length == 0) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro inesperado ao tentar imprimir a Dispensa de Licen\u00e7a Ambiental.");
                } else {
                    UtilsController.imprimirRelatorio((byte[])relatorioDispensaAmbiental);
                }
            }
        }
        catch (BaseException be) {
            this.logger.error((Object)be.getMessage(), (Throwable)be);
            ShowMessage.addErrorMessage((String)"validacao", (String)be.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro inesperado ao tentar imprimir a Dispensa de Licen\u00e7a Ambiental.");
        }
    }

    private byte[] montarDataSetDispensaAmbiental() throws Exception {
        DispensaAmbientalDTO dto = new DispensaAmbientalDTO();
        EnderecoPessoaEntity enderecoPessoaPrincipal = this.solicitacaoSelecionada.getCadastroImobiliario().getCadastroGeral().getPessoa().getEnderecoPessoaPrincipal();
        if (enderecoPessoaPrincipal != null) {
            dto.setBairro(this.preencherBairroRelatorioDispensaAmbiental(enderecoPessoaPrincipal));
            dto.setCep(this.preencherCepRelatorioDispensaAmbiental(enderecoPessoaPrincipal));
            dto.setEndereco(this.preencherEnderecoNumeroDispensaAmbiental(enderecoPessoaPrincipal));
            dto.setMunicipioUf(this.preencherMunicipioUFDIspensaAmbiental(enderecoPessoaPrincipal));
        }
        dto.setCadastroImobiliario(this.solicitacaoSelecionada.getCadastroImobiliario().getId().getCodigo().toString());
        dto.setAtividade(this.montarTextoAtividadePrincipal());
        dto.setCpfCnpj(EloStringUtils.formatCpfCnpjReport((String)this.solicitacaoSelecionada.getCpfCnpj()));
        dto.setDataEmissao(new Date());
        dto.setRazaoSocial(this.solicitacaoSelecionada.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome());
        dto.setNumeroExercicioSolicitacao(this.solicitacaoSelecionada.getNumeroSolicitacaoExercicio());
        dto.setDeclaracao(this.preencherDeclaracao(dto.getAtividade()));
        DataSet dataSet = new DataSet(DispensaAmbientalDTO.class);
        dataSet.add((Object)dto);
        String relatorioJasper = "RelatorioDispensaLicencaAmbiental.jasper";
        HashMap<String, Parameter> params = new HashMap<String, Parameter>();
        ByteArrayInputStream inputStreamBrasao = new ByteArrayInputStream(this.entidadeController.getEntidade().getBrasao());
        params.put("brasao", new Parameter((Object)inputStreamBrasao));
        params.put("entidade", new Parameter((Object)this.entidadeController.getEntidade().getNome()));
        try {
            params.put("assinatura", new Parameter((Object)this.getClass().getClassLoader().getResourceAsStream("img/assinaturaDispensa.png")));
        }
        catch (Exception e) {
            this.logger.error((Object)"N\u00e3o foi poss\u00edvel carregar a assinatura da Licen\u00e7a de Dispensa Ambiental.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).imprimeRelatorio(relatorioJasper, dataSet, null, params);
    }

    private String preencherDeclaracao(String atividade) {
        return String.format("\"Esta Dispensa de Licenciamento Ambiental Municipal foi emitida com base na Resolu\u00e7\u00e3o N\u00ba. 02/2019 SEMA/COMDEMA em fun\u00e7\u00e3o do seu reduzido potencial poluidor/degradador, cujo CNAE foi classificado como risco baixo ou baixo risco A, de acordo com o definido na Resolu\u00e7\u00e3o CGSIM N\u00ba. 51/2019 e demais atividades econ\u00f4micas, conforme Decreto Municipal n\u00ba. 794/2016. Esta DLAM refere-se ao funcionamento do empreendimento com a atividade %s, localizado no endere\u00e7o acima, sendo que qualquer altera\u00e7\u00e3o, por retirada ou inclus\u00e3o de CNAE dever\u00e1 ser objeto de nova an\u00e1lise. Esta DLAM est\u00e1 condicionada ao atendimento das normas ambientais vigentes, portanto, vedado o exerc\u00edcio de atividade n\u00e3o autorizada, que a qualquer tempo ser\u00e1 objeto de fiscaliza\u00e7\u00e3o pelos \u00f3rg\u00e3os competentes, podendo ser cancelada na ocorr\u00eancia de viola\u00e7\u00e3o ou inadequa\u00e7\u00e3o de quaisquer normas legais, omiss\u00e3o ou falsa descri\u00e7\u00e3o de informa\u00e7\u00f5es relevantes que subsidiaram a sua emiss\u00e3o.\"", atividade);
    }

    private String preencherMunicipioUFDIspensaAmbiental(EnderecoPessoaEntity enderecoPessoaPrincipal) {
        StringBuilder sb = new StringBuilder();
        if (enderecoPessoaPrincipal.getLogradouroEndereco() != null && enderecoPessoaPrincipal.getLogradouroEndereco().getId().getCidade() != null) {
            sb.append(enderecoPessoaPrincipal.getLogradouroEndereco().getId().getCidade().getDescricao()).append(" - ").append(enderecoPessoaPrincipal.getLogradouroEndereco().getId().getCidade().getDescricaoUF());
        }
        return sb.toString();
    }

    private String preencherEnderecoNumeroDispensaAmbiental(EnderecoPessoaEntity enderecoPessoaPrincipal) {
        StringBuilder sb = new StringBuilder();
        if (enderecoPessoaPrincipal.getLogradouroEndereco() != null) {
            sb.append(enderecoPessoaPrincipal.getLogradouroEndereco().getDescricao()).append(" - ").append(enderecoPessoaPrincipal.getNumero());
        }
        return sb.toString();
    }

    private String preencherCepRelatorioDispensaAmbiental(EnderecoPessoaEntity enderecoPessoaPrincipal) {
        if (enderecoPessoaPrincipal.getCep() != null) {
            return EloStringUtils.formatCepReport((String)enderecoPessoaPrincipal.getCep().toString());
        }
        return "";
    }

    private String preencherBairroRelatorioDispensaAmbiental(EnderecoPessoaEntity enderecoPessoaPrincipal) {
        if (enderecoPessoaPrincipal.getBairro() != null) {
            return enderecoPessoaPrincipal.getBairro().getDescricao();
        }
        return "";
    }

    private String montarTextoAtividadePrincipal() {
        StringBuilder sb = new StringBuilder();
        SolicitacaoAlvaraAtividadeEntity atividadePrincipal = this.solicitacaoSelecionada.getAtividadePrincipal();
        if (atividadePrincipal != null) {
            sb.append(atividadePrincipal.getCodigoAtividade()).append(" - ").append(atividadePrincipal.getDescricaoAtividade());
        }
        return sb.toString();
    }

    private void gravarSolicitacaoImpressao() {
        try {
            UsuarioEntity usuarioAutenticado = UtilsController.usuarioAutenticado();
            SolicitacaoDispensaAmbientalEntity solicitacaoDispensa = new SolicitacaoDispensaAmbientalEntity();
            solicitacaoDispensa.setDataSolicitacao(new Date());
            solicitacaoDispensa.setSolicitacaoAlvara(this.solicitacaoSelecionada);
            solicitacaoDispensa.setSolicitante(usuarioAutenticado.getUsuario());
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarSolicitacaoDispensaLicencaAmbiental(solicitacaoDispensa);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro inesperado ao tentar salvar o solicitante da Dispensa da Licen\u00e7a Ambiental.");
        }
    }
}

