/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.common;

import br.com.elotech.portalarrecadacao.common.CommonGeraDocumento;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.rest.geradocumento.EnvioGeraDocumento;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GeraDocumentoAlvaraLocalizacao
extends CommonGeraDocumento {
    private static final long serialVersionUID = 6755204781768768432L;
    public static final Integer MODO_GRAVACAO_NOVO_DOCUMENTO = 0;
    public static final Integer OPERACAO = 0;
    public static final String DESCRICAO_TIPO_DOCUMENTO = "ALVAR\u00c1 DE LOCALIZA\u00c7\u00c3O";
    public static final String SUBTIPO_RISCO_A = "M";
    public static final String SUBTIPO_PRESTADOR = "I";
    @JsonProperty(value="AreaTotalConstruida")
    private Double areaTotalConstruida;
    @JsonProperty(value="DataValidade")
    private Date dataValidade;
    @JsonProperty(value="ModoGravacao")
    private Integer modoGravacao = MODO_GRAVACAO_NOVO_DOCUMENTO;
    @JsonProperty(value="PossuiDebitoPendente")
    private Boolean possuiDebitoPendente;
    @JsonProperty(value="Operacao")
    private Integer operacao;
    @JsonProperty(value="ListaFiltroSubReport")
    private Map<Integer, String> listaFiltroSubReport;
    @JsonProperty(value="CodigoPGD")
    private String codigoPGD;
    @JsonProperty(value="CodigoLiberacaoSGO")
    private String codigoLiberacaoSGO;

    public GeraDocumentoAlvaraLocalizacao(SolicitacaoAlvaraEntity solicitacao, EntidadeTributacaoEntity entidadeTributacao) {
        this.criarJson(solicitacao, entidadeTributacao);
    }

    public Double getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    public void setAreaTotalConstruida(Double areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    public Integer getModoGravacao() {
        return this.modoGravacao;
    }

    public void setModoGravacao(Integer modoGravacao) {
        this.modoGravacao = modoGravacao;
    }

    public Boolean getPossuiDebitoPendente() {
        return this.possuiDebitoPendente;
    }

    public void setPossuiDebitoPendente(Boolean possuiDebitoPendente) {
        this.possuiDebitoPendente = possuiDebitoPendente;
    }

    public Integer getOperacao() {
        return this.operacao;
    }

    public void setOperacao(Integer operacao) {
        this.operacao = operacao;
    }

    public Map<Integer, String> getListaFiltroSubReport() {
        return this.listaFiltroSubReport;
    }

    public void setListaFiltroSubReport(Map<Integer, String> listaFiltroSubReport) {
        this.listaFiltroSubReport = listaFiltroSubReport;
    }

    public String getCodigoPGD() {
        return this.codigoPGD;
    }

    public void setCodigoPGD(String codigoPGD) {
        this.codigoPGD = codigoPGD;
    }

    public String getCodigoLiberacaoSGO() {
        return this.codigoLiberacaoSGO;
    }

    public void setCodigoLiberacaoSGO(String codigoLiberacaoSGO) {
        this.codigoLiberacaoSGO = codigoLiberacaoSGO;
    }

    public void criarJson(SolicitacaoAlvaraEntity solicitacao, EntidadeTributacaoEntity entidadeTributacao) {
        super.criarJson(solicitacao, entidadeTributacao);
        if (Objects.isNull(solicitacao.getAreaConstruida())) {
            solicitacao.setAreaConstruida(BigDecimal.ZERO);
        }
        this.setAreaTotalConstruida(Double.valueOf(solicitacao.getAreaConstruida().doubleValue()));
        this.setDataValidade(solicitacao.getCadastroMobiliario().getDataValidadeAlvara());
        this.setModoGravacao(MODO_GRAVACAO_NOVO_DOCUMENTO);
        this.setPossuiDebitoPendente(null);
        this.setTipoDocumento(EnvioGeraDocumento.TIPO_DOCUMENTO_ALVARA_LOCALIZACAO);
        this.setTipoDocumentoDescricao(DESCRICAO_TIPO_DOCUMENTO);
        this.setDocumento(Integer.valueOf(solicitacao.getNumeroAlvara().intValue()));
        this.setOperacao(OPERACAO);
        this.setListaFiltroSubReport(null);
        this.setCodigoPGD("");
        this.setDataPrimeiroAlvara(new Date());
        this.setCodigoLiberacaoSGO(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCodigoLiberacaoSGO());
        if (solicitacao.isGrauRiscoLiberdadeEconomica()) {
            this.setSubTipo(SUBTIPO_RISCO_A);
        }
        if (solicitacao.isSolicitacaoPrestadorServico() || solicitacao.isSolicitacaoMEIPrestador()) {
            this.setSubTipo(SUBTIPO_PRESTADOR);
        }
    }
}

