/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandVerificaRestricaoCadastroAlvara;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvRestricoesCadastroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.spring.SpringContext;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandVerificaRestricaoCadastroAlvara")
@Scope(value="prototype")
public class CommandVerificaRestricaoCadastroAlvaraImpl
implements CommandVerificaRestricaoCadastroAlvara {
    @Resource
    private SrvRestricoesCadastroAlvara srvRestricaoCadastroAlvara;
    private RestricaoAlvaraVo restricaoAlvaraVo;
    private SolicitacaoAlvaraEntity solicitacao;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;

    public void execute() throws BaseException {
        this.srvSolicitacaoAlvara.verificarIdClassificacaoTipoInscricao(this.solicitacao);
        if (Objects.isNull(this.solicitacao.getSolicitacaoAlvara())) {
            this.solicitacao.setSolicitacaoAlvara(this.repositorySolicitacaoAlvara.getSequence());
            this.repositorySolicitacaoAlvara.saveOrUpdate(this.solicitacao);
        }
        if (Objects.isNull(this.solicitacao.getNumeroSolicitacao())) {
            this.solicitacao.setNumeroSolicitacao(this.repositorySolicitacaoAlvara.getNumeroSolicitacao(PortalUtils.getEntidade(), this.solicitacao.getExercicio()));
            this.repositorySolicitacaoAlvara.saveOrUpdate(this.solicitacao);
        }
        if (this.solicitacao.isRedeSim() && this.solicitacao.isNaturezaMudancaEndereco()) {
            this.solicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).hibernateInitializeSolicitacaoAlvara(this.solicitacao);
        }
        this.restricaoAlvaraVo = this.srvRestricaoCadastroAlvara.verificarRestricaoCadastro(this.solicitacao);
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public RestricaoAlvaraVo getRestricaoAlvara() {
        return this.restricaoAlvaraVo;
    }
}

