/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandValidaRegraCnpj;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandValidaRegraCnpj")
@Scope(value="prototype")
public class CommandValidaRegraCnpjImpl
implements CommandValidaRegraCnpj {
    private SolicitacaoAlvaraEntity solicitacao;
    private boolean geraRestricaoCadastroExistente;
    @Resource
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;

    public void execute() throws BaseException {
        if (this.solicitacao.isSolicitacaoJuridicaNormal()) {
            this.srvSolicitacaoAlvaraHelper.validaRestricaoCnpjPJ(this.solicitacao, Boolean.valueOf(this.geraRestricaoCadastroExistente));
        } else if (this.solicitacao.isSolicitacaoMEI()) {
            this.srvSolicitacaoAlvaraHelper.validaCnpjMei(this.solicitacao);
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public void setGeraRestricaoCadastroExistente(boolean geraRestricaoCadastroExistente) {
        this.geraRestricaoCadastroExistente = geraRestricaoCadastroExistente;
    }
}

