/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandUpdateRestricaoAlvara;
import br.com.elotech.portalarrecadacao.domain.ObservacaoRestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryObservacaoRestricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoAlvara;
import br.com.elotech.spring.SpringContext;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandUpdateRestricaoAlvara")
public class CommandUpdateRestricaoAlvaraImpl
implements CommandUpdateRestricaoAlvara {
    private RestricaoAlvaraEntity restricaoAlvara;
    @Resource
    private RepositoryRestricaoAlvara repositoryRestricaoAlvara;
    @Resource
    private RepositoryObservacaoRestricaoAlvara repositoryObservacaoRestricaoAlvara;

    public void execute() throws BaseException {
        for (ObservacaoRestricaoAlvaraEntity obs : this.restricaoAlvara.getObservacoes()) {
            if (obs.getId() != null) continue;
            obs.setId(this.repositoryObservacaoRestricaoAlvara.getSequence());
        }
        this.repositoryRestricaoAlvara.saveOrUpdate(this.restricaoAlvara);
        if (this.restricaoAlvara.getSolicitacaoAlvara().isRedeSim()) {
            this.alterarSituacaoSolicitacaoRedeSimAnalise(this.restricaoAlvara.getSolicitacaoAlvara());
        }
    }

    public void setRestricaoAlvara(RestricaoAlvaraEntity restricaoAlvara) {
        this.restricaoAlvara = restricaoAlvara;
    }

    private void alterarSituacaoSolicitacaoRedeSimAnalise(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (solicitacaoAlvara.possuiTodasRestricoesBloqueantesAutorizadas()) {
            SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(solicitacaoAlvara.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ANALISE, Optional.empty());
        }
    }
}

