/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandStatusWebIss;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.dto.webiss.RespostaSincronizacaoWebIssDTO;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@EloCommand(value="commandStatusWebIss")
@Scope(value="prototype")
public class CommandStatusWebIssImpl
implements CommandStatusWebIss {
    private static final Logger log = LoggerFactory.getLogger(CommandStatusWebIssImpl.class);
    private String protocolo;
    private RespostaSincronizacaoWebIssDTO respostaSincronizacaoWebIssDTO;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;

    public void execute() throws BaseException {
        ParametroAlvaraEntity tokenAcessoWebiss = this.srvSolicitacaoAlvaraHelper.getParametroAlvara(ParametroAlvaraEnum.TOKEN_ACESSO_WEBISS);
        ParametroAlvaraEntity urlWebiss = this.srvSolicitacaoAlvaraHelper.getParametroAlvara(ParametroAlvaraEnum.URL_WEBISS);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("autenticacao", tokenAcessoWebiss.getValor());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(urlWebiss.getValor() + "/api/dados/sincronizar/status/" + this.protocolo, HttpMethod.GET, request, RespostaSincronizacaoWebIssDTO.class, new Object[0]);
        this.respostaSincronizacaoWebIssDTO = (RespostaSincronizacaoWebIssDTO)response.getBody();
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public RespostaSincronizacaoWebIssDTO getRespostaSincronizacaoWebIssDTO() {
        return this.respostaSincronizacaoWebIssDTO;
    }
}

