/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandSalvarParecerLaudoFiscalizacao;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoAndamentoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.ProcessoFiscalizacaoEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.ProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.exception.DataInvalidaException;
import br.com.elotech.portalarrecadacao.exception.StatusLaudoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeUsuario;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoLaudoAlvara;
import br.com.elotech.portalarrecadacao.rest.dto.ProcessoFiscalizacaoAndamentoLaudoDTO;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandSalvarParecerLaudoFiscalizacao")
@Scope(value="prototype")
public class CommandSalvarParecerLaudoFiscalizacaoImpl
implements CommandSalvarParecerLaudoFiscalizacao {
    private ProcessoFiscalizacaoAndamentoLaudoDTO processo;
    private AndamentoLaudoAlvaraEntity andamentoLaudoAlvara;
    @Resource
    private RepositoryAndamentoLaudoAlvara repositoryAndamentoLaudoAlvara;

    public void execute() throws BaseException {
        LaudoAlvaraEntity laudo = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).findLaudoById(this.processo.getLaudo());
        UsuarioEntity usuario = ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).getUsuarioAlvaraLaudoByUsuarioCpfCnpj(this.processo.getUsuario());
        if (this.validarProcesso()) {
            Date dataParecer = this.processo.getDataParecer() != null ? this.processo.getDataParecer() : new Date();
            AndamentoLaudoAlvaraEntity andamento = new AndamentoLaudoAlvaraEntity();
            andamento.setIdLaudoAlvara(laudo);
            andamento.setStatus(StatusLaudoAlvara.fromCodigo((String)this.processo.getSituacao()));
            andamento.setDescricao(this.processo.getDescricao());
            andamento.setDataAndamento(dataParecer);
            andamento.setUsuario(usuario);
            andamento.setNomeVistoriante(this.processo.getFiscal());
            andamento.setProcessoFiscalizacao(ProcessoFiscalizacaoEntity.of((AndamentoLaudoAlvaraEntity)andamento, (ProcessoFiscalizacao)this.getProcessoFiscalizacaoVo()));
            ObservacaoAndamentoLaudoEntity observacaoAndamentoLaudo = new ObservacaoAndamentoLaudoEntity();
            observacaoAndamentoLaudo.setDescricao(andamento.getDescricao());
            observacaoAndamentoLaudo.setIdAndamentoLaudoAlvara(andamento);
            observacaoAndamentoLaudo.setUsuario(usuario);
            observacaoAndamentoLaudo.setDataObservacao(dataParecer);
            observacaoAndamentoLaudo.setResolvido(SimNaoEnum.NAO.getShortText());
            andamento.getObservacoes().add(observacaoAndamentoLaudo);
            this.inserirData(laudo, andamento);
            ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).salvarAndamentoLaudo(andamento);
            laudo.setStatus(andamento.getStatus());
            ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).salvarLaudoAlvara(laudo);
            this.andamentoLaudoAlvara = andamento;
        }
    }

    private void inserirData(LaudoAlvaraEntity laudo, AndamentoLaudoAlvaraEntity andamento) throws DataInvalidaException {
        if (StatusLaudoAlvara.LIBERADO_PROVISORIO == andamento.getStatus()) {
            if (this.processo.getDataProvisorio() == null) {
                throw new DataInvalidaException("Informe a data de validade para o laudo provis\u00f3rio");
            }
            if (this.processo.getDataProvisorio().compareTo(new Date()) < 0) {
                throw new DataInvalidaException("A data n\u00e3o pode ser anterior a data atual");
            }
            andamento.setValidadeProvisorio(this.processo.getDataProvisorio());
            laudo.setDataValidade(this.processo.getDataProvisorio());
        } else if (StatusLaudoAlvara.LIBERADO_DEFINITIVO == andamento.getStatus()) {
            laudo.setDataValidade(null);
        }
    }

    private boolean validarProcesso() throws StatusLaudoNaoEncontradoException {
        if (this.processo == null || this.processo.getLaudo() == null || this.processo.getSituacao() == null) {
            return false;
        }
        StatusLaudoAlvara statusLaudoAlvara = StatusLaudoAlvara.fromCodigo((String)this.processo.getSituacao());
        if (Objects.isNull(statusLaudoAlvara)) {
            throw new StatusLaudoNaoEncontradoException("O status " + this.processo.getSituacao() + " n\u00e3o existe");
        }
        return true;
    }

    public void setProcessoFiscalizacaoAndamentoLaudoDTO(ProcessoFiscalizacaoAndamentoLaudoDTO processoFiscalizacaoAndamentoLaudo) {
        this.processo = processoFiscalizacaoAndamentoLaudo;
    }

    public AndamentoLaudoAlvaraEntity getAndamentoLaudoAlvaraEntity() {
        return this.andamentoLaudoAlvara;
    }

    private ProcessoFiscalizacao getProcessoFiscalizacaoVo() {
        ProcessoFiscalizacao processoVo = new ProcessoFiscalizacao();
        processoVo.setUrl(this.processo.getUrl());
        return processoVo;
    }
}

