/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandSalvarLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvaraDocumento;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandSalvarLaudoAlvara")
public class CommandSalvarLaudoAlvaraImpl
implements CommandSalvarLaudoAlvara {
    private LaudoAlvaraEntity laudo;
    private LaudoAlvaraEntity laudoSalvo;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoALvara;
    @Resource
    private RepositoryLaudoAlvaraDocumento repositoryLaudoAlvaraDocumento;

    public void execute() throws BaseException {
        if (this.laudo.getIdLaudoAlvara() == null) {
            this.laudo.setIdLaudoAlvara(this.repositoryLaudoALvara.getSequence());
        }
        if (!EloListUtils.safeIsEmpty((List)this.laudo.getDocumentos()).booleanValue()) {
            for (LaudoAlvaraDocumentoEntity documento : this.laudo.getDocumentos()) {
                if (documento.getId() != null) continue;
                documento.setId(this.repositoryLaudoAlvaraDocumento.getSequence());
            }
        }
        this.laudoSalvo = this.repositoryLaudoALvara.saveOrUpdate(this.laudo);
    }

    public void setLaudo(LaudoAlvaraEntity laudo) {
        this.laudo = laudo;
    }

    public LaudoAlvaraEntity getLaudos() {
        return this.laudoSalvo;
    }
}

