/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.daoSupport.EloDaoSupport;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandProcessarRegistroFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.command.impl.CommandProcessarRegistroFilaRecebimentoRedeSimImpl;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoProcessadaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoProcessamentoFilaRecebimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.EventosNaoTratadosException;
import br.com.elotech.portalarrecadacao.exception.ProtocoloMenorQueOInicialException;
import br.com.elotech.portalarrecadacao.exception.RegistroProcessadoAnteriormenteException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaDTO;
import br.com.elotech.portalarrecadacao.repository.RepositoryFilaRecebimentoProcessRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoDocumentosDTO;
import br.com.elotech.portalarrecadacao.service.ProcessamentoWS01Service;
import br.com.elotech.portalarrecadacao.service.ProcessamentoWS02Service;
import br.com.elotech.portalarrecadacao.service.ProcessamentoWS04Service;
import br.com.elotech.portalarrecadacao.utils.JsonUtils;
import com.google.gson.Gson;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandProcessarRegistroFilaRecebimentoRedeSim")
@Scope(value="prototype")
public class CommandProcessarRegistroFilaRecebimentoRedeSimImpl
implements CommandProcessarRegistroFilaRecebimentoRedeSim {
    private static final Logger log = LoggerFactory.getLogger(CommandProcessarRegistroFilaRecebimentoRedeSimImpl.class);
    private FilaRecebimentoRedeSimEntity registro;
    private FilaRecebimentoProcessadaRedeSimEntity registroProcessado;
    @Autowired
    private ProcessamentoWS01Service processamentoWS01Service;
    @Autowired
    private ProcessamentoWS02Service processamentoWS02Service;
    @Autowired
    private ProcessamentoWS04Service processamentoWS04Service;
    @Autowired
    private RepositoryFilaRecebimentoRedeSim repositoryFilaRecebimentoRedeSim;
    @Autowired
    private RepositoryFilaRecebimentoProcessRedeSim repositoryFilaRecebimentoProcessRedeSim;
    @Resource
    private EloDaoSupport eloDaoSupport;

    public void setRegistro(FilaRecebimentoRedeSimEntity registro) {
        this.registro = registro;
    }

    public void execute() throws BaseException {
        this.processarRegistro();
    }

    private void processarServico(String token) throws BaseException {
        Gson gson = new Gson();
        String json = this.registro.getRequest();
        switch (1.$SwitchMap$br$com$elotech$portalarrecadacao$enumerator$TipoFilaRecebimentoRedeSimEnum[this.registro.getTipo().ordinal()]) {
            case 1: {
                ConsultaPreviaDTO consultaPreviaDTO = (ConsultaPreviaDTO)gson.fromJson(JsonUtils.sanitize((String)json), ConsultaPreviaDTO.class);
                this.processamentoWS01Service.processar(this.registro.getProtocolo(), token, json, consultaPreviaDTO);
                break;
            }
            case 2: {
                SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = SolicitacaoAlvaraRedeSimDTO.of((String)json);
                this.processamentoWS02Service.processar(this.registro.getProtocolo(), token, json, solicitacaoDTO);
                break;
            }
            case 3: {
                SolicitacaoDocumentosDTO solicitacaoDocumentosDTO = (SolicitacaoDocumentosDTO)gson.fromJson(JsonUtils.sanitize((String)json), SolicitacaoDocumentosDTO.class);
                this.processamentoWS04Service.processar(this.registro.getProtocolo(), token, json, solicitacaoDocumentosDTO);
                break;
            }
            default: {
                throw new ValidacaoException("Tipo de servi\u00e7o n\u00e3o cadastrado para processamento.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processarRegistro() {
        block14: {
            String token = UUID.randomUUID().toString();
            log.info("[{}] Iniciando processamento - {} - {}: {}", new Object[]{token, this.registro.getTipo().getDescricao(), this.registro.getProtocolo(), this.registro.getRequest()});
            this.registroProcessado = FilaRecebimentoProcessadaRedeSimEntity.of((FilaRecebimentoRedeSimEntity)this.registro);
            this.processarServico(token);
            this.registroProcessado.setSituacao(SituacaoProcessamentoFilaRecebimentoRedeSimEnum.PROCESSADO);
            log.info("[{}] Processamento finalizado com sucesso", (Object)token);
            try {
                UtilsController.commitAndRestartTransaction();
            }
            catch (Exception ex) {
                log.error(String.format("[%s] Erro no processamento: %s ", token, ex.getMessage()), (Throwable)ex);
                this.registroProcessado.setObservacao(String.format("%s%n%s", ex.getMessage(), ExceptionUtils.getStackTrace((Throwable)ex)));
                this.registroProcessado.setSituacao(SituacaoProcessamentoFilaRecebimentoRedeSimEnum.ERRO);
                UtilsController.rollBackAndRestartTransaction();
            }
            this.registroProcessado.setDataProcessamento(new Date());
            this.registroProcessado = this.repositoryFilaRecebimentoProcessRedeSim.saveOrUpdate(this.registroProcessado);
            this.repositoryFilaRecebimentoRedeSim.remove(this.registro);
            UtilsController.commitTransaction();
            break block14;
            catch (EventosNaoTratadosException | ProtocoloMenorQueOInicialException | RegistroProcessadoAnteriormenteException ex) {
                log.info("[{}] Ignorando processamento - {}", (Object)token, (Object)ex.getMessage());
                this.registroProcessado.setObservacao(ex.getMessage());
                this.registroProcessado.setSituacao(ex instanceof EventosNaoTratadosException ? SituacaoProcessamentoFilaRecebimentoRedeSimEnum.PROCESSADO : SituacaoProcessamentoFilaRecebimentoRedeSimEnum.ERRO);
                try {
                    UtilsController.commitAndRestartTransaction();
                }
                catch (Exception ex2) {
                    log.error(String.format("[%s] Erro no processamento: %s ", token, ex2.getMessage()), (Throwable)ex2);
                    this.registroProcessado.setObservacao(String.format("%s%n%s", ex2.getMessage(), ExceptionUtils.getStackTrace((Throwable)ex2)));
                    this.registroProcessado.setSituacao(SituacaoProcessamentoFilaRecebimentoRedeSimEnum.ERRO);
                    UtilsController.rollBackAndRestartTransaction();
                }
                this.registroProcessado.setDataProcessamento(new Date());
                this.registroProcessado = this.repositoryFilaRecebimentoProcessRedeSim.saveOrUpdate(this.registroProcessado);
                this.repositoryFilaRecebimentoRedeSim.remove(this.registro);
                UtilsController.commitTransaction();
            }
            catch (Exception ex2) {
                boolean isNullPointer = Objects.nonNull(ex2.getCause()) && ex2.getCause() instanceof NullPointerException;
                Throwable exception = isNullPointer ? ex2.getCause() : ex2;
                log.error(String.format("[%s] Erro no processamento: %s ", token, exception.getMessage()), exception);
                this.registroProcessado.setObservacao(String.format("%s%n%s", exception.getMessage(), ExceptionUtils.getStackTrace((Throwable)exception)));
                this.registroProcessado.setSituacao(SituacaoProcessamentoFilaRecebimentoRedeSimEnum.ERRO);
                {
                    catch (Throwable throwable) {
                        try {
                            UtilsController.commitAndRestartTransaction();
                        }
                        catch (Exception ex3) {
                            log.error(String.format("[%s] Erro no processamento: %s ", token, ex3.getMessage()), (Throwable)ex3);
                            this.registroProcessado.setObservacao(String.format("%s%n%s", ex3.getMessage(), ExceptionUtils.getStackTrace((Throwable)ex3)));
                            this.registroProcessado.setSituacao(SituacaoProcessamentoFilaRecebimentoRedeSimEnum.ERRO);
                            UtilsController.rollBackAndRestartTransaction();
                        }
                        this.registroProcessado.setDataProcessamento(new Date());
                        this.registroProcessado = this.repositoryFilaRecebimentoProcessRedeSim.saveOrUpdate(this.registroProcessado);
                        this.repositoryFilaRecebimentoRedeSim.remove(this.registro);
                        UtilsController.commitTransaction();
                        throw throwable;
                    }
                }
                try {
                    UtilsController.commitAndRestartTransaction();
                }
                catch (Exception ex4) {
                    log.error(String.format("[%s] Erro no processamento: %s ", token, ex4.getMessage()), (Throwable)ex4);
                    this.registroProcessado.setObservacao(String.format("%s%n%s", ex4.getMessage(), ExceptionUtils.getStackTrace((Throwable)ex4)));
                    this.registroProcessado.setSituacao(SituacaoProcessamentoFilaRecebimentoRedeSimEnum.ERRO);
                    UtilsController.rollBackAndRestartTransaction();
                }
                this.registroProcessado.setDataProcessamento(new Date());
                this.registroProcessado = this.repositoryFilaRecebimentoProcessRedeSim.saveOrUpdate(this.registroProcessado);
                this.repositoryFilaRecebimentoRedeSim.remove(this.registro);
                UtilsController.commitTransaction();
            }
        }
    }

    public FilaRecebimentoProcessadaRedeSimEntity getRegistroProcessado() {
        return this.registroProcessado;
    }
}

