/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandPreencherSolicitacaoAlvaraAtividades;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Atividades;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.aise.RepositoryAtividadeMei;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandPreencherSolicitacaoAlvaraAtividades")
@Scope(value="prototype")
public class CommandPreencherSolicitacaoAlvaraAtividadesImpl
implements CommandPreencherSolicitacaoAlvaraAtividades {
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    private List<Atividades> atividadesDaRequisicao;
    private List<Atividade> atividades;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private RepositoryAtividadeMei repositoryAtividadeMei;

    public void execute() throws BaseException {
        this.atividades = new ArrayList();
        for (Atividades atividadeItem : this.atividadesDaRequisicao) {
            if (this.solicitacaoAlvara.isSolicitacaoMEI()) {
                String codigoCnae = EloStringUtils.somenteNumeros((String)atividadeItem.getCo_cnae());
                ArrayList atividadesMei = new ArrayList(this.repositoryAtividadeMei.consultaAtividadeMeiPorCnae(codigoCnae, SimNaoEnum.getNaoShortText()));
                atividadesMei.forEach(p -> p.setPrincipal(SimNaoEnum.getNaoShortText()));
                if (atividadeItem.isIs_atividade_principal()) {
                    atividadesMei.forEach(p -> p.setPrincipal(SimNaoEnum.getSimShortText()));
                }
                this.atividades.addAll(atividadesMei);
                continue;
            }
            ConsultaAtividadeVo consultaAtividadeVo = new ConsultaAtividadeVo();
            consultaAtividadeVo.setSolicitacaoAlvara(this.solicitacaoAlvara);
            consultaAtividadeVo.setCodigoAtividade(EloStringUtils.somenteNumeros((String)atividadeItem.getCo_cnae()));
            Atividade atividadePorCodigo = this.srvSolicitacaoAlvara.consultaAtividadePorCodigo(consultaAtividadeVo);
            if (Objects.isNull(atividadePorCodigo)) {
                throw new ConsultaAtividadeException(String.format("A atividade %s n\u00e3o est\u00e1 cadastrada na base. Favor entrar em contato com o setor respons\u00e1vel.", atividadeItem.getCo_cnae()));
            }
            atividadePorCodigo.setPrincipal(SimNaoEnum.toShortText((Boolean)atividadeItem.isIs_atividade_principal()));
            this.atividades.add(atividadePorCodigo);
        }
        this.atividades.forEach(atividade -> atividade.setSituacao("I"));
        if (EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            this.solicitacaoAlvara.setSolicitacaoAlvaraAtividades(this.srvSolicitacaoAlvara.atribuiValoresSolicitacaoAtividades(this.solicitacaoAlvara, this.atividades));
        }
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public void setAtividadesDaRequisicao(List<Atividades> atividadesDaRequisicao) {
        this.atividadesDaRequisicao = atividadesDaRequisicao;
    }

    public List<Atividade> getAtividades() {
        return this.atividades;
    }
}

