/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.common.log.EloDefaultLogger;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandNotificarValidacaoDocumento;
import br.com.elotech.portalarrecadacao.domain.FilaEnvioEmailSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoFilaEnvioEmailSolicitacaoEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryFilaEnvioEmailSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvEnviaEmailAlteracoesSolicitacao;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandNotificarValidacaoDocumento")
@Scope(value="prototype")
public class CommandNotificarValidacaoDocumentoImpl
extends EloDefaultLogger
implements CommandNotificarValidacaoDocumento {
    @Resource
    private RepositoryFilaEnvioEmailSolicitacaoAlvara repositoryFilaEnvioEmailSolicitacaoAlvara;
    @Resource
    private SrvEnviaEmailAlteracoesSolicitacao srvEnviaEmailAlteracoesSolicitacao;
    private SolicitacaoAlvaraDocumentoEntity documento;

    public void execute() throws BaseException {
        FilaEnvioEmailSolicitacaoAlvaraEntity filaEnvio = new FilaEnvioEmailSolicitacaoAlvaraEntity();
        filaEnvio.setId(this.repositoryFilaEnvioEmailSolicitacaoAlvara.getSequence());
        filaEnvio.setSolicitacaoAlvara(this.documento.getSolicitacaoAlvara());
        filaEnvio.setTipoEnvioEmail(TipoFilaEnvioEmailSolicitacaoEnum.VALIDACAO_DOCUMENTO);
        String observacao = String.format("<p>Documento <b>%s</b> alterado para situa\u00e7\u00e3o de <b>%s</b>.</p>", this.documento.getTipoDocumento().getDescricao(), this.documento.getSituacao().getDescricao());
        filaEnvio.setObservacao(observacao);
        try {
            this.srvEnviaEmailAlteracoesSolicitacao.enviaEmailDireto(this.documento.getSolicitacaoAlvara(), (List)Lists.newArrayList((Object[])new FilaEnvioEmailSolicitacaoAlvaraEntity[]{filaEnvio}));
        }
        catch (BaseException e) {
            this.logger.info((Object)"FALHA NO ENVIO DE EMAIL >>>");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.repositoryFilaEnvioEmailSolicitacaoAlvara.saveOrUpdate(filaEnvio);
        }
    }

    public void setSolicitacaoAlvaraDocumentoEntity(SolicitacaoAlvaraDocumentoEntity documento) {
        this.documento = documento;
    }
}

