/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandImprimirTaxas;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliario;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandImprimirTaxas")
public class CommandImprimirTaxasImpl
implements CommandImprimirTaxas {
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private SrvSolicitacaoAlvaraCBO srvSolicitacaoAlvaraCBO;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    private ImprimirTaxasAlvara imprimirTaxasAlvara;
    @Resource
    private RepositorySituacaoMobiliario repositorySituacaoMobiliario;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public void execute() throws BaseException {
        BigDecimal areaUtilizadaMobiliario = null;
        BigDecimal areaBombeiroMobiliario = null;
        BigDecimal areaPatioMobiliario = null;
        BigDecimal areaConstruidaMobiliario = null;
        if (!this.solicitacaoAlvara.isNaturezaInicial()) {
            areaUtilizadaMobiliario = this.solicitacaoAlvara.getCadastroMobiliario().getAreaUtilizada();
            areaBombeiroMobiliario = this.solicitacaoAlvara.getCadastroMobiliario().getAreaBombeiro();
            areaPatioMobiliario = this.solicitacaoAlvara.getCadastroMobiliario().getAreaPatio();
            areaConstruidaMobiliario = this.solicitacaoAlvara.getCadastroMobiliario().getAreaConstruida();
        }
        try {
            this.srvSolicitacaoAlvara.validaSolicitacaoImpressaoTaxas(this.solicitacaoAlvara);
            this.srvSolicitacaoAlvara.executeAlteracaoArea(this.solicitacaoAlvara);
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
        }
        Date dataEncerramento = this.solicitacaoAlvara.isSituacaoMobiliarioDesatualizado() ? this.solicitacaoAlvara.getCadastroMobiliario().getDataEncerramento() : null;
        try {
            try {
                if (this.solicitacaoAlvara.isNaturezaInicial()) {
                    this.solicitacaoAlvara.setCadastroMobiliario(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarCadastroMobiliario(this.solicitacaoAlvara.getCadastroMobiliario()));
                }
                this.solicitacaoAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).hibernateInitializeSolicitacaoAlvara(this.solicitacaoAlvara);
                this.imprimirTaxasAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirTaxasAlvara(this.solicitacaoAlvara);
            }
            catch (Exception e) {
                if (!this.solicitacaoAlvara.isNaturezaInicial()) {
                    this.solicitacaoAlvara.getCadastroMobiliario().setAreaUtilizada(areaUtilizadaMobiliario);
                    this.solicitacaoAlvara.getCadastroMobiliario().setAreaBombeiro(areaBombeiroMobiliario);
                    this.solicitacaoAlvara.getCadastroMobiliario().setAreaPatio(areaPatioMobiliario);
                    this.solicitacaoAlvara.getCadastroMobiliario().setAreaConstruida(areaConstruidaMobiliario);
                }
                if (this.solicitacaoAlvara.isSituacaoMobiliarioDesatualizado()) {
                    this.solicitacaoAlvara.getCadastroMobiliario().setDataEncerramento(dataEncerramento);
                    ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).alterarSituacaoMobiliarioParaDesatualizado(this.solicitacaoAlvara);
                }
                this.solicitacaoAlvara.setCadastroMobiliario(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarCadastroMobiliario(this.solicitacaoAlvara.getCadastroMobiliario()));
                throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacaoAlvara = solicitacao;
    }

    public ImprimirTaxasAlvara getImprimirTaxas() {
        return this.imprimirTaxasAlvara;
    }
}

