/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandImprimiTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliario;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandImprimiTaxasAlvara")
public class CommandImprimiTaxasAlvaraImpl
implements CommandImprimiTaxasAlvara {
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private SrvSolicitacaoAlvaraCBO srvSolicitacaoAlvaraCBO;
    private SolicitacaoAlvaraEntity solicitacao;
    private ImprimirTaxasAlvara imprimirTaxasAlvara;
    @Resource
    private RepositorySituacaoMobiliario repositorySituacaoMobiliario;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public void execute() throws BaseException {
        if (this.solicitacao.isSolicitacaoJuridicaNormal()) {
            this.imprimirTaxasAlvara = this.srvSolicitacaoAlvara.imprimirTaxas(this.solicitacao);
            this.solicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).hibernateInitializeSolicitacaoAlvara(this.solicitacao);
        } else if (this.solicitacao.isSolicitacaoPrestadorServico()) {
            this.imprimirTaxasAlvara = this.srvSolicitacaoAlvaraPrestadorServico.imprimirTaxaPrestadorServico(this.solicitacao);
        } else if (this.solicitacao.isSolicitacaoCBO()) {
            this.imprimirTaxasAlvara = this.srvSolicitacaoAlvaraCBO.imprimirTaxas(this.solicitacao);
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public ImprimirTaxasAlvara getImprimirTaxas() {
        return this.imprimirTaxasAlvara;
    }
}

