/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandImprimiAlvara;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import java.net.URISyntaxException;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandImprimiAlvara")
public class CommandImprimiAlvaraImpl
implements CommandImprimiAlvara {
    private SolicitacaoAlvaraEntity solicitacao;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraCBO srvSolicitacaoAlvaraCBO;

    public void execute() throws BaseException {
        try {
            if (this.solicitacao.isSolicitacaoJuridicaNormal()) {
                this.srvSolicitacaoAlvara.imprimirAlvara(this.solicitacao);
            } else if (this.solicitacao.isSolicitacaoPrestadorServico()) {
                this.srvSolicitacaoAlvaraPrestadorServico.imprimirAlvara(this.solicitacao);
            } else if (this.solicitacao.isSolicitacaoMEI()) {
                this.srvSolicitacaoAlvaraMEI.imprimirAlvara(this.solicitacao);
            } else if (this.solicitacao.isSolicitacaoCBO()) {
                this.srvSolicitacaoAlvaraCBO.imprimirAlvara(this.solicitacao);
            }
        }
        catch (URISyntaxException e) {
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }
}

