/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandGetTokenDefinitivoOauth;
import br.com.elotech.portalarrecadacao.http.utils.HttpUtils;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandGetTokenDefinitivoOauth")
public class CommandGetTokenDefinitivoOauthImpl
extends EloLogger
implements CommandGetTokenDefinitivoOauth {
    private String tokenTemp;
    private JSONObject object;
    private String modulo;
    private String redirect;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;

    public void execute() throws BaseException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair("grant_type", "authorization_code"));
        nameValuePairs.add(new BasicNameValuePair("redirect_uri", this.redirect));
        nameValuePairs.add(new BasicNameValuePair("client_id", this.repositoryParametroGeral.getParametro(this.modulo, "CLIENTOAUTH")));
        nameValuePairs.add(new BasicNameValuePair("client_secret", this.repositoryParametroGeral.getParametro(this.modulo, "CLIENTSECRETOAUTH")));
        nameValuePairs.add(new BasicNameValuePair("code", this.tokenTemp));
        HttpResponse response = null;
        try {
            response = HttpUtils.requestHttpPost((String)this.repositoryParametroGeral.getParametro(this.modulo, "LINKACESSOTOKENOAUTH"), nameValuePairs);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            this.object = JSONObject.fromObject((Object)rd.readLine());
        }
        catch (IOException | URISyntaxException | HttpException e) {
            this.logger.error((Object)e.getMessage(), e);
        }
    }

    public void setTokenTemp(String tokenTemp) {
        this.tokenTemp = tokenTemp;
    }

    public JSONObject getResposta() {
        return this.object;
    }

    public void setModulo(String modulo) {
        this.modulo = modulo;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }
}

