/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandGetSolicitacoesConcluidasNaoRespondidas;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.util.list.EloListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandGetSolicitacoesConcluidasNaoRespondidas")
public class CommandGetSolicitacoesConcluidasNaoRespondidasImpl
implements CommandGetSolicitacoesConcluidasNaoRespondidas {
    private List<SolicitacaoRedeSimEntity> solicitacoes;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public void execute() throws BaseException {
        this.solicitacoes = this.repositoryConsultaRedeSim.getSolicitacoesConcluidasNaoRespondidas();
        if (!EloListUtils.safeIsEmpty((List)this.solicitacoes).booleanValue()) {
            for (SolicitacaoRedeSimEntity solicitacaoRedeSim : this.solicitacoes) {
                SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
                if (solicitacaoAlvara == null) continue;
                if (solicitacaoAlvara.getNaturezas().size() <= 0) {
                    solicitacaoAlvara.setNaturezas(new ArrayList());
                }
                if (solicitacaoAlvara.getCadastroMobiliario() != null) {
                    Hibernate.initialize((Object)solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao());
                    solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao().stream().forEach(s -> Hibernate.initialize((Object)s.getSituacaoMobiliario()));
                    solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao().stream().forEach(s -> {
                        if (Objects.nonNull(s.getSituacaoMobiliario()) && EloListUtils.safeIsEmpty((List)s.getSituacaoMobiliario().getSituacoesMobiliarioAlvara()).booleanValue()) {
                            Hibernate.initialize((Object)s.getSituacaoMobiliario().getSituacoesMobiliarioAlvara());
                        }
                    });
                    Hibernate.initialize((Object)solicitacaoAlvara.getCadastroMobiliario().getMobiliarioServicos());
                    if (solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral() != null) {
                        Hibernate.initialize((Object)solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIsencoes());
                        if (solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa() != null) {
                            Hibernate.initialize((Object)solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getContatos());
                        }
                    }
                }
                Hibernate.initialize((Object)solicitacaoAlvara.getLaudos());
                if (EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getDocumentos()).booleanValue()) {
                    Hibernate.initialize((Object)solicitacaoAlvara.getDocumentos());
                }
                if (solicitacaoAlvara.getSolicitacaoAlvaraAtividades().size() <= 0) {
                    solicitacaoAlvara.setSolicitacaoAlvaraAtividades(new ArrayList());
                } else {
                    for (SolicitacaoAlvaraAtividadeEntity solicitacao : solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                        if (solicitacao.getCnae() != null && solicitacao.getCnae().getCarteirasProfissionais().size() <= 0) {
                            solicitacao.getCnae().setCarteirasProfissionais(new ArrayList());
                        }
                        if (solicitacao.getAtividadeMei() != null && solicitacao.getAtividadeMei().getCarteirasProfissionais().size() <= 0) {
                            solicitacao.getAtividadeMei().setCarteirasProfissionais(new ArrayList());
                        }
                        if (solicitacao.getSequenciaCbo() == null || solicitacao.getSequenciaCbo().getCarteirasProfissionais().size() > 0) continue;
                        solicitacao.getSequenciaCbo().setCarteirasProfissionais(new ArrayList());
                    }
                }
                if (solicitacaoAlvara.getCadastroImobiliario() != null && solicitacaoAlvara.getCadastroImobiliario().getTestadas().size() <= 0) {
                    solicitacaoAlvara.getCadastroImobiliario().setTestadas(new ArrayList());
                }
                for (SolicitacaoAlvaraAtividadeEntity solAtividade : solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                    if (solAtividade.getNumerosConselho().size() > 0) continue;
                    solAtividade.setNumerosConselho(new ArrayList());
                }
                if (solicitacaoAlvara.getCadastroMobiliario() == null) continue;
                if (solicitacaoAlvara.getCadastroMobiliario().getContratosSociais().size() <= 0) {
                    solicitacaoAlvara.getCadastroMobiliario().getContratosSociais();
                    continue;
                }
                for (ContratoSocialEntity contratoSocial : solicitacaoAlvara.getCadastroMobiliario().getContratosSociais()) {
                    if (contratoSocial.getPessoas().size() > 0) continue;
                    contratoSocial.getPessoas();
                    for (ContratoSocialPessoaEntity p : contratoSocial.getPessoas()) {
                        if (p.getId() == null || p.getId().getPessoa() == null) continue;
                        Hibernate.initialize((Object)p.getId().getPessoa().getContatos());
                    }
                }
            }
        }
    }

    public List<SolicitacaoRedeSimEntity> getSolicitacoesConcluidasNaoRespondidas() {
        return this.solicitacoes;
    }
}

