/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandGeracaoLaudosRedeSim;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandGeracaoLaudosRedeSim")
public class CommandGeracaoLaudosRedeSimImpl
implements CommandGeracaoLaudosRedeSim {
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;

    public void execute() throws BaseException {
        if (SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_GERACAO_LAUDO_LIBERDADE_ECONOMICA)).booleanValue() && this.solicitacaoAlvara.isGrauRiscoLiberdadeEconomica()) {
            return;
        }
        if (this.solicitacaoAlvara.isNaturezaInicial() && (!this.solicitacaoAlvara.isSolicitacaoMEI() || SimNaoEnum.equalNao((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_PROCESSO_AUTOMATICO_SOLICITACAO_MEI).getValor()).booleanValue())) {
            this.srvSolicitacaoAlvara.generateLaudos(this.solicitacaoAlvara);
            return;
        }
        if (this.solicitacaoAlvara.isSolicitacaoJuridicaNormal() || this.solicitacaoAlvara.isSolicitacaoCBO()) {
            this.srvSolicitacaoAlvara.generateLaudos(this.solicitacaoAlvara);
            return;
        }
        if (this.solicitacaoAlvara.isSolicitacaoPrestadorServico()) {
            this.srvSolicitacaoAlvaraPrestadorServico.generateLaudos(this.solicitacaoAlvara);
            return;
        }
        if (this.solicitacaoAlvara.isSolicitacaoMEI()) {
            this.srvSolicitacaoAlvaraMEI.generateLaudos(this.solicitacaoAlvara);
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }
}

