/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandGeracaoEnvioInscricaoMunicipalRedeSim;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaPrevia;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandGeracaoEnvioInscricaoMunicipalRedeSim")
@Scope(value="prototype")
public class CommandGeracaoEnvioInscricaoMunicipalRedeSimImpl
extends EloLogger
implements CommandGeracaoEnvioInscricaoMunicipalRedeSim {
    private SolicitacaoRedeSimEntity solicitacaoRedeSimEntity;
    @Resource
    private SrvConsultaPrevia srvConsultaPrevia;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;

    public void execute() throws BaseException {
        this.reloadSolicitacaoRedeSim();
        this.generateInscricaoMunicipal();
        this.reloadSolicitacaoRedeSim();
        this.sendInscricaoMunicipalRedeSim();
    }

    public void setSolicitacaoRedeSimEntity(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) {
        this.solicitacaoRedeSimEntity = solicitacaoRedeSimEntity;
    }

    public SolicitacaoRedeSimEntity getSolicitacaoRedeSim() {
        return this.solicitacaoRedeSimEntity;
    }

    private void generateInscricaoMunicipal() throws BaseException {
        this.updateSolicitacao(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara());
        this.srvSolicitacaoAlvaraRedeSim.gerarInscricaoMunicipal(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara());
        SolicitacaoAlvaraEntity solicitacaoAlvaraEntity = this.solicitacaoRedeSimEntity.getSolicitacaoAlvara();
        if (solicitacaoAlvaraEntity.isSolicitacaoMEI()) {
            this.addHistoricoAndamento(this.solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_GERADA, Optional.of("Inscri\u00e7\u00e3o Municipal Gerada - MEI"));
            return;
        }
        this.addHistoricoAndamento(this.solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_GERADA, solicitacaoAlvaraEntity.isGrauRiscoLiberdadeEconomica() ? Optional.of("Inscri\u00e7\u00e3o Municipal Gerada - Liberdade Econ\u00f4mica") : Optional.empty());
    }

    private void sendInscricaoMunicipalRedeSim() throws BaseException {
        this.srvSolicitacaoAlvaraRedeSim.enviarDocumentoInscricaoMunicipal(this.solicitacaoRedeSimEntity, SituacaoRespostaRedeSimEnum.EM_ANALISE);
        this.srvSolicitacaoAlvaraRedeSim.enviarDocumentoInscricaoMunicipal(this.solicitacaoRedeSimEntity, SituacaoRespostaRedeSimEnum.EMITIDO);
        if (this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            this.solicitacaoRedeSimEntity.setAlvaraEnviado(TipoAlvaraEnum.MEI);
            this.solicitacaoRedeSimEntity = this.repositoryConsultaRedeSim.saveOrUpdate(this.solicitacaoRedeSimEntity);
            this.addHistoricoAndamento(this.solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA, Optional.of("Inscri\u00e7\u00e3o Municipal Enviada - MEI"));
            return;
        }
        this.addHistoricoAndamento(this.solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA, this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica() ? Optional.of("Inscri\u00e7\u00e3o Municipal Enviada - Liberdade Econ\u00f4mica") : Optional.empty());
    }

    private void updateSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue() && (solicitacaoAlvara.isNaturezaInicial() || !solicitacaoAlvara.isGrauRiscoLiberdadeEconomica())) {
            return;
        }
        List cadastrosMobiliarios = this.srvConsultaPrevia.loadCadastroMobiliarioByCpfCnpj(solicitacaoAlvara.getCpfCnpj());
        if (EloListUtils.safeIsEmpty((List)cadastrosMobiliarios).booleanValue() && Objects.isNull(solicitacaoAlvara.getCadastroMobiliario())) {
            throw new SolicitacaoAlvaraException("N\u00e3o ser\u00e1 poss\u00edvel gerar a inscri\u00e7\u00e3o municipal. N\u00e3o existe um Cadastro Mobili\u00e1rio para essa Solicita\u00e7\u00e3o.");
        }
        if (cadastrosMobiliarios.size() > 1 && Objects.isNull(solicitacaoAlvara.getCadastroMobiliario())) {
            throw new SolicitacaoAlvaraException("N\u00e3o ser\u00e1 poss\u00edvel gerar a inscri\u00e7\u00e3o municipal. Existe mais de um Cadastro Mobili\u00e1rio para essa Solicita\u00e7\u00e3o.");
        }
        if (cadastrosMobiliarios.size() == 1 && Objects.isNull(solicitacaoAlvara.getCadastroMobiliario())) {
            solicitacaoAlvara.setCadastroMobiliario((CadastroMobiliarioEntity)cadastrosMobiliarios.get(0));
        }
        if (SimNaoEnum.getNaoShortText().equals(solicitacaoAlvara.getEfetivado())) {
            if (solicitacaoAlvara.isSolicitacaoPJ()) {
                this.srvSolicitacaoAlvara.efetivaAlteracaoSolicitacao(solicitacaoAlvara);
            }
            if (solicitacaoAlvara.isSolicitacaoMEI()) {
                this.srvSolicitacaoAlvaraMEI.efetivaAlteracaoSolicitacao(solicitacaoAlvara);
            }
        }
        this.reloadSolicitacaoRedeSim();
    }

    private void addHistoricoAndamento(SolicitacaoRedeSimEntity solicitiacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum situacaoConsultaPrevia, Optional<String> observacao) throws BaseException {
        this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitiacaoRedeSim, situacaoConsultaPrevia, observacao, null);
    }

    private void reloadSolicitacaoRedeSim() {
        this.repositoryConsultaRedeSim.flush();
        this.solicitacaoRedeSimEntity = this.srvConsultaPrevia.getSolicitacaoByProtocoloAndTipo(this.solicitacaoRedeSimEntity.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }
}

