/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandGeracaoEnvioAlvaraRedeSim;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaPrevia;
import br.com.elotech.portalarrecadacao.service.SrvDocumentoRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandGeracaoEnvioAlvaraRedeSim")
@Scope(value="prototype")
public class CommandGeracaoEnvioAlvaraRedeSimImpl
extends EloLogger
implements CommandGeracaoEnvioAlvaraRedeSim {
    private SolicitacaoRedeSimEntity solicitacaoRedeSimEntity;
    @Resource
    SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvConsultaPrevia srvConsultaPrevia;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private SrvDocumentoRedeSim srvDocumentoRedeSim;

    public void execute() throws BaseException {
        this.logger.info((Object)String.format("Gerando o Alvar\u00e1 para o protocolo %s", this.solicitacaoRedeSimEntity.getProtocolo()));
        this.reloadSolicitacaoRedeSim();
        boolean possuiAlgumLaudoEmAnalise = this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().possuiAlgumLaudoEmAnalise();
        if (Boolean.TRUE.equals(this.enviaAlvaraProvisorioRedeSim()) && possuiAlgumLaudoEmAnalise && Objects.isNull(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().getNumeroAlvara())) {
            Date dataAlvaraProvisorio = this.srvSolicitacaoAlvaraHelper.calcularDataAlvaraProvisorio();
            if (Objects.isNull(dataAlvaraProvisorio)) {
                throw new SolicitacaoAlvaraException("Ocorreu um erro ao calcular a data do alvar\u00e1 provis\u00f3rio.");
            }
            this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().setDataValidadeProvisorio(dataAlvaraProvisorio);
        }
        this.gerarAlvara();
        this.reloadSolicitacaoRedeSim();
        this.enviarDocumentoRedeSim();
    }

    private Boolean enviaAlvaraProvisorioRedeSim() throws BaseException {
        return this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().isGrauRiscoBaixo() && SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_ALVARA_PROVISORIO_REDE_SIM)) != false;
    }

    private void gerarAlvara() throws BaseException {
        if (Objects.nonNull(this.solicitacaoRedeSimEntity.getAlvaraEnviado()) && TipoAlvaraEnum.DEFINITIVO.equals((Object)this.solicitacaoRedeSimEntity.getAlvaraEnviado())) {
            throw new SolicitacaoAlvaraException("O Alvar\u00e1 definitivo j\u00e1 foi enviado para o Empresa F\u00e1cil.");
        }
        if (this.solicitacaoRedeSimEntity.isRenovarAlvaraProvisorio()) {
            if (!EloListUtils.safeIsEmpty((List)this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().getLaudos()).booleanValue() && !this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().possuiTodosLaudosLiberado()) {
                throw new SolicitacaoAlvaraException("Todos os Laudos devem estar Liberados.");
            }
            this.srvSolicitacaoAlvaraRedeSim.renovarAlvaraProvisorio(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara());
        }
        if (!this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().isNaturezaInicial()) {
            this.efetivarAlteracaoSolicitacao();
        }
        if (Boolean.TRUE.equals(this.enviaAlvaraProvisorioRedeSim())) {
            this.solicitacaoRedeSimEntity.setAlvaraEnviado(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
        } else {
            this.solicitacaoRedeSimEntity.setAlvaraEnviado(TipoAlvaraEnum.DEFINITIVO);
            this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().setDataValidadeProvisorio(null);
        }
        this.srvSolicitacaoAlvaraRedeSim.montarObsAlvara(this.solicitacaoRedeSimEntity);
        this.srvSolicitacaoAlvaraRedeSim.gerarAlvara(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara());
        this.srvSolicitacaoAlvara.salvarObservacaoAlvaraGerado(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara());
        this.srvSolicitacaoAlvaraRedeSim.imprimeDocumentoAlvara(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara(), DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo());
        if (Boolean.TRUE.equals(this.enviaAlvaraProvisorioRedeSim())) {
            this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(this.solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO, Optional.of("Alvar\u00e1 Provis\u00f3rio"), null);
        } else {
            this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(this.solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.ALVARA_EMITIDO, Optional.empty(), null);
        }
    }

    private void enviarDocumentoRedeSim() throws BaseException {
        if (this.documentoEmitidoInvalidado() && SimNaoEnum.equalSim((String)this.solicitacaoRedeSimEntity.getInvalidado()).booleanValue()) {
            this.srvSolicitacaoAlvaraRedeSim.enviarDocumento(this.solicitacaoRedeSimEntity, SituacaoRespostaRedeSimEnum.EM_ANALISE, Boolean.FALSE.booleanValue(), null);
            this.solicitacaoRedeSimEntity.setInvalidado(SimNaoEnum.getNaoShortText());
            this.salvarSolicitacaoRedeSim(this.solicitacaoRedeSimEntity);
            this.reloadSolicitacaoRedeSim();
        }
        if (Objects.isNull(this.solicitacaoRedeSimEntity.getAlvaraEnviado())) {
            if (Boolean.TRUE.equals(this.enviaAlvaraProvisorioRedeSim())) {
                this.enviarAlvaraParaRedeSim(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
            } else {
                this.enviarAlvaraParaRedeSim(TipoAlvaraEnum.DEFINITIVO);
            }
        } else {
            this.enviarAlvaraParaRedeSim(this.solicitacaoRedeSimEntity.getAlvaraEnviado());
        }
    }

    private void enviarAlvaraParaRedeSim(TipoAlvaraEnum situacaoEnvio) throws BaseException {
        this.solicitacaoRedeSimEntity.setAlvaraEnviado(situacaoEnvio);
        this.srvDocumentoRedeSim.enviarDocumento(this.solicitacaoRedeSimEntity, SituacaoRespostaRedeSimEnum.EMITIDO);
        this.salvarSolicitacaoRedeSim(this.solicitacaoRedeSimEntity);
    }

    private void salvarSolicitacaoRedeSim(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) {
        if (solicitacaoRedeSimEntity.getId() == null) {
            solicitacaoRedeSimEntity.setId(this.repositoryConsultaRedeSim.getSequence());
        }
        this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSimEntity);
    }

    private void efetivarAlteracaoSolicitacao() throws BaseException {
        List cadastrosMobiliarios = this.srvConsultaPrevia.loadCadastroMobiliarioByCpfCnpj(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().getCpfCnpj());
        if (cadastrosMobiliarios.size() == 0 && Objects.isNull(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().getCadastroMobiliario())) {
            throw new SolicitacaoAlvaraException("N\u00e3o existe um cadastro mobili\u00e1rio para essa solicita\u00e7\u00e3o.");
        }
        if (cadastrosMobiliarios.size() > 1 && Objects.isNull(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().getCadastroMobiliario())) {
            throw new SolicitacaoAlvaraException("Existe mais de um cadastro mobili\u00e1rio para essa solicita\u00e7\u00e3o.");
        }
        if (cadastrosMobiliarios.size() == 1 && Objects.isNull(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().getCadastroMobiliario())) {
            this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().setCadastroMobiliario((CadastroMobiliarioEntity)cadastrosMobiliarios.get(0));
        }
        if (SimNaoEnum.getNaoShortText().equals(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().getEfetivado())) {
            if (this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal()) {
                this.srvSolicitacaoAlvara.efetivaAlteracaoSolicitacao(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara());
            } else if (this.solicitacaoRedeSimEntity.getSolicitacaoAlvara().isSolicitacaoMEI()) {
                this.srvSolicitacaoAlvaraMEI.efetivaAlteracaoSolicitacao(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara());
            }
        }
        this.reloadSolicitacaoRedeSim();
    }

    private void reloadSolicitacaoRedeSim() {
        this.repositoryConsultaRedeSim.flush();
        this.solicitacaoRedeSimEntity = this.srvConsultaPrevia.getSolicitacaoByProtocoloAndTipo(this.solicitacaoRedeSimEntity.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }

    public boolean documentoEmitidoInvalidado() throws BaseException {
        String paramInvalidarDocumentoEmitido = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INVALIDAR_DOCUMENTO_EMITIDO);
        return SimNaoEnum.equalSim((String)paramInvalidarDocumentoEmitido);
    }

    public void setSolicitacaoRedeSimEntity(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) {
        this.solicitacaoRedeSimEntity = solicitacaoRedeSimEntity;
    }
}

