/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandGeracaoCadastroLaudoAutomaticoRedeSim;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.GeracaoCadastroLaudoAutomaticoException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosSolicitacao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Endereco;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Natureza_imovel;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Empresa;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.service.SrvConsultaPrevia;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraRedeSimImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroImobiliario;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandGeracaoCadastroLaudoAutomaticoRedeSim")
@Scope(value="prototype")
public class CommandGeracaoCadastroLaudoAutomaticoRedeSimImpl
extends EloLogger
implements CommandGeracaoCadastroLaudoAutomaticoRedeSim {
    private boolean geraLaudos;
    private String protocolo;
    private SolicitacaoDocRedeSimEntity solicitacaoDocRedeSim;
    private SolicitacaoRedeSimEntity solicitacaoRedeSim;
    private CadastroMobiliarioEntity cadastroMobiliario;
    @Resource
    private SrvConsultaPrevia srvConsultaPrevia;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoPrestadorServico;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraCBO srvSolicitacaoAlvaraCBO;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositoryCadastroImobiliario repositoryCadastroImobiliario;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraRedeSimImpl srvSolicitacaoAlvaraRedeSimImpl;

    public void execute() throws BaseException {
        this.solicitacaoRedeSim = this.srvConsultaPrevia.getSolicitacaoByProtocoloAndTipo(this.protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        if (!this.solicitacaoRedeSim.getSolicitacaoAlvara().isSolicitacaoMEI() && (this.solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoBaixo() || this.solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoAlto())) {
            this.setGeraLaudos(true);
        }
        if (this.solicitacaoRedeSim.isSolicitacaoBaixa() || SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_GERACAO_LAUDO_LIBERDADE_ECONOMICA)).booleanValue() && this.solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
            this.setGeraLaudos(false);
        }
        this.generateCadastroLaudo();
        if (this.geraLaudos && Objects.nonNull(this.solicitacaoDocRedeSim)) {
            this.solicitacaoDocRedeSim.setProcessadoAutomatico(SimNaoEnum.getSimShortText());
            if (Objects.isNull(this.solicitacaoDocRedeSim.getId())) {
                this.solicitacaoDocRedeSim.setId(this.repositorySolicitacaoDocRedeSim.getSequence());
            }
            this.repositorySolicitacaoDocRedeSim.saveOrUpdate(this.solicitacaoDocRedeSim);
        }
        UtilsController.commitAndRestartTransaction();
    }

    private void generateCadastroLaudo() throws BaseException {
        if (Objects.isNull(this.solicitacaoRedeSim)) {
            return;
        }
        if (this.solicitacaoRedeSim.isAtualizacaoCadastral()) {
            boolean isNaturezaInicial;
            List cadastrosMobiliarios = this.srvConsultaPrevia.loadCadastroMobiliarioByCpfCnpj(this.solicitacaoRedeSim.getSolicitacaoAlvara().getCpfCnpj());
            this.cadastroMobiliario = null;
            int quantityCadastrosMobiliarios = 0;
            if (!EloListUtils.safeIsEmpty((List)cadastrosMobiliarios).booleanValue()) {
                quantityCadastrosMobiliarios = cadastrosMobiliarios.size();
                if (Objects.nonNull(this.solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario()) && cadastrosMobiliarios.stream().anyMatch(cadastroMobiliarioCnpj -> cadastroMobiliarioCnpj.getCadastroGeral().getId().getCodigo().equals(this.solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getId().getCodigo()))) {
                    this.cadastroMobiliario = this.solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario();
                }
            }
            if (!(isNaturezaInicial = this.solicitacaoRedeSim.getSolicitacaoAlvara().isNaturezaInicial()) && Objects.isNull(this.cadastroMobiliario)) {
                if (quantityCadastrosMobiliarios == 0) {
                    CadastroMobiliarioEntity cadastroMobiliarioEntity = this.cadastroMobiliario = this.geraLaudos ? this.srvSolicitacaoAlvaraRedeSim.criarCadastroMobiliario(this.solicitacaoRedeSim, Optional.empty()) : this.srvSolicitacaoAlvaraRedeSim.createCadastroMobiliarioSemLaudo(this.solicitacaoRedeSim, Optional.empty());
                }
                if (quantityCadastrosMobiliarios > 1) {
                    throw new GeracaoCadastroLaudoAutomaticoException("Existe mais de um Cadastro Mobili\u00e1rio para essa Solicita\u00e7\u00e3o.");
                }
                if (!EloListUtils.safeIsEmpty((List)cadastrosMobiliarios).booleanValue()) {
                    this.cadastroMobiliario = (CadastroMobiliarioEntity)cadastrosMobiliarios.get(0);
                }
            } else if (this.solicitacaoRedeSim.getSolicitacaoAlvara().isSolicitacaoMEI() && Objects.isNull(this.srvConsultaPrevia.getSolicitacaoByProtocoloAndTipo(this.solicitacaoRedeSim.getProtocolo(), TipoSolicitacaoRedeSimEnum.CONSULTA))) {
                CadastroImobiliarioEntity cadastroImobiliario;
                SolicitacaoAlvaraRedeSimDTO arquivoEmpresaSelecionada = PortalUtils.normalizeJson((String)this.solicitacaoRedeSim.getArquivoDadosEmpresa());
                if (!this.solicitacaoRedeSim.getSolicitacaoAlvara().isAlteracaoRazaoOuSocioOuRazaoESocio() && Objects.nonNull(arquivoEmpresaSelecionada) && Objects.nonNull(cadastroImobiliario = this.loadCadastroImobiliario(this.solicitacaoRedeSim.getSolicitacaoAlvara(), this.getNu_Inscricao(arquivoEmpresaSelecionada)))) {
                    this.solicitacaoRedeSim.getSolicitacaoAlvara().setCadastroImobiliario(cadastroImobiliario);
                    this.solicitacaoRedeSim.getSolicitacaoAlvara().setImobiliarioTestada(cadastroImobiliario.getTestadaPrincipal());
                    if (UtilsController.isTestadaGenerica()) {
                        this.solicitacaoRedeSim.getSolicitacaoAlvara().setImobiliarioTestadaGenerica(cadastroImobiliario.getTestadaPrincipalGenerica());
                    }
                }
            } else if (Objects.isNull(this.cadastroMobiliario)) {
                if (Objects.nonNull(this.solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario())) {
                    this.cadastroMobiliario = this.solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario();
                } else if (quantityCadastrosMobiliarios > 1) {
                    this.cadastroMobiliario = null;
                    throw new GeracaoCadastroLaudoAutomaticoException("Existe mais de um Cadastro Mobili\u00e1rio para essa Solicita\u00e7\u00e3o.");
                }
            }
            SolicitacaoAlvaraEntity solicitacaoAlvara = this.solicitacaoRedeSim.getSolicitacaoAlvara();
            solicitacaoAlvara.setCadastroMobiliario(this.cadastroMobiliario);
            if (isNaturezaInicial) {
                this.cadastroMobiliario = this.geraLaudos ? this.srvSolicitacaoAlvaraRedeSim.criarCadastroMobiliario(this.solicitacaoRedeSim, Optional.empty()) : this.srvSolicitacaoAlvaraRedeSim.createCadastroMobiliarioSemLaudo(this.solicitacaoRedeSim, Optional.empty());
                solicitacaoAlvara.setCadastroMobiliario(this.cadastroMobiliario);
                solicitacaoAlvara = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
                this.repositorySolicitacaoAlvara.flush();
                this.finishUpdateOrSaveCadastroMobiliario(this.solicitacaoRedeSim.getProtocolo());
                this.updateSituacaoMobiliario(solicitacaoAlvara);
                return;
            }
            SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)this.solicitacaoRedeSim.getArquivoDadosEmpresa());
            String descricaoAtividades = solicitacaoAlvara.isSolicitacaoMEINormal() ? PortalUtils.getDescricaoAtividadesMei((SolicitacaoAlvaraEntity)solicitacaoAlvara) : solicitacaoDTO.getDados_solicitacao().getEmpresa().getDs_objeto_social();
            solicitacaoAlvara.setDescricaoAtividades(descricaoAtividades);
            if (!solicitacaoAlvara.isAlteracaoRazao()) {
                solicitacaoAlvara.setNomeRazaoSocial(this.cadastroMobiliario.getCadastroGeral().getPessoa().getNome());
                solicitacaoAlvara.setFantasia(this.cadastroMobiliario.getCadastroGeral().getPessoa().getNomeFantasia());
            }
            if ((solicitacaoAlvara = this.saveSolicitacaoAlvaraAlteracao(solicitacaoAlvara)).isAlteracaoNaturezaJuridica()) {
                this.srvSolicitacaoAlvara.alterarNaturezaJuridica(solicitacaoAlvara);
            }
            this.finishUpdateOrSaveCadastroMobiliario(this.solicitacaoRedeSim.getProtocolo());
            this.updateSituacaoMobiliario(solicitacaoAlvara);
        }
    }

    private void addHistoricoAndamento(SituacaoConsultaPreviaRedeSimEnum situacaoConsultaPrevia, Optional<String> observacao) throws BaseException {
        this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(this.solicitacaoRedeSim, situacaoConsultaPrevia, observacao, null);
    }

    private void validateAlteracaoDeEnderecoSemAtividadeNoMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara) throws GeracaoCadastroLaudoAutomaticoException {
        if (solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && !solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && this.isListaAtividadesMobiliarioVazia(solicitacaoAlvara)) {
            throw new GeracaoCadastroLaudoAutomaticoException("Este Cadastro Mobili\u00e1rio n\u00e3o possui nenhuma atividade vinculada. Verifique com o setor respons\u00e1vel e depois tente novamente.");
        }
    }

    private boolean isListaAtividadesMobiliarioVazia(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        CadastroMobiliarioEntity cadastroMobiliario = solicitacaoAlvara.getCadastroMobiliario();
        return cadastroMobiliario != null && EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioCnaes()) != false && EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioAtividadeMeis()) != false;
    }

    private SolicitacaoAlvaraEntity saveSolicitacaoAlvaraAlteracao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (solicitacaoAlvara.isSolicitacaoJuridicaNormal() || solicitacaoAlvara.isSolicitacaoPrestadorServico()) {
            return this.geraLaudos ? this.srvSolicitacaoAlvara.salvarSolicitacaoAlvaraAlteracao(solicitacaoAlvara) : this.srvSolicitacaoAlvara.salvarSolicitacaoAlvaraAlteracaoSemLaudo(solicitacaoAlvara);
        }
        if (solicitacaoAlvara.isSolicitacaoMEI()) {
            return this.geraLaudos ? this.srvSolicitacaoAlvaraMEI.salvarSolicitacaoAlvaraAlteracao(solicitacaoAlvara) : this.srvSolicitacaoAlvaraMEI.salvarSolicitacaoAlvaraAlteracaoSemLaudo(solicitacaoAlvara);
        }
        if (solicitacaoAlvara.isSolicitacaoCBO()) {
            return this.geraLaudos ? this.srvSolicitacaoAlvaraCBO.salvarSolicitacaoAlvaraAlteracao(solicitacaoAlvara) : this.srvSolicitacaoAlvaraCBO.salvarSolicitacaoAlvaraAlteracaoSemLaudo(solicitacaoAlvara);
        }
        return solicitacaoAlvara;
    }

    private void updateSituacaoMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_CADASTRO_EM_EXCLUSAO_LOGICA)).booleanValue() && SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
            this.srvDebitosPortal.alteraMobiliarioSituacao(solicitacaoAlvara, SituacaoMobiliarioAlvaraEnum.SITUACAO_INICIAL_MOBILIARIO);
            if (Objects.nonNull(solicitacaoAlvara.getCadastroMobiliario()) && !EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao()).booleanValue()) {
                Hibernate.initialize((Object)solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao());
                solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao().stream().forEach(p -> Hibernate.initialize((Object)p.getSituacaoMobiliario().getSituacoesMobiliarioAlvara()));
            }
        }
    }

    private void finishUpdateOrSaveCadastroMobiliario(String protocoloRedeSim) throws BaseException {
        String complementoObservacao;
        String string = complementoObservacao = this.solicitacaoRedeSim.getSolicitacaoAlvara().isNaturezaInicial() ? "Gerado" : "Atualizado";
        if (this.solicitacaoRedeSim.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            this.addHistoricoAndamento(SituacaoConsultaPreviaRedeSimEnum.CADASTRO_GERADO_MEI, Optional.of(String.format("O Cadastro foi %s com sucesso", complementoObservacao)));
            return;
        }
        if (this.solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
            this.addHistoricoAndamento(SituacaoConsultaPreviaRedeSimEnum.CADASTRO_GERADO_LIBERDADE_ECONOMICA, Optional.of(String.format("O Cadastro foi %s com sucesso - Liberdade Econ\u00f4mica", complementoObservacao)));
            return;
        }
        if (EloListUtils.safeIsEmpty((List)this.solicitacaoRedeSim.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
            this.addHistoricoAndamento(SituacaoConsultaPreviaRedeSimEnum.CADASTRO_ANALISE, Optional.of(String.format("O Cadastro foi %s para situa\u00e7\u00e3o em An\u00e1lise", complementoObservacao)));
            return;
        }
        if (!this.solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoBaixo() || !SimNaoEnum.getNaoShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_LAUDO_RISCO_B))) {
            this.addHistoricoAndamento(SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA, Optional.of("O Cadastro se encontra com situa\u00e7\u00e3o em An\u00e1lise, e os Laudos j\u00e1 foram Disparados para as Secretarias!"));
        }
    }

    private CadastroImobiliarioEntity loadCadastroImobiliario(SolicitacaoAlvaraEntity solicitacao, String codigoImobiliario) throws BaseException {
        List cadastrosImobiliarios = null;
        if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) || EloStringUtils.isEmpty((String)codigoImobiliario)) {
            return null;
        }
        cadastrosImobiliarios = this.repositoryCadastroImobiliario.getCadastroImobiliarioPorCodigoOuInscricao(codigoImobiliario);
        if (EloListUtils.safeIsEmpty((List)cadastrosImobiliarios).booleanValue()) {
            return null;
        }
        if (cadastrosImobiliarios.size() > 1) {
            throw new CadastroImobiliarioNaoEncontradoException("Existem 2 (dois) ou mais registros para o n\u00famero informado, favor refazer a consulta informando o cadastro imobili\u00e1rio correto.");
        }
        CadastroImobiliarioEntity cadastroImobiliario = (CadastroImobiliarioEntity)cadastrosImobiliarios.stream().findFirst().get();
        if (!EloListUtils.safeIsEmpty((List)cadastroImobiliario.getTestadas()).booleanValue()) {
            Hibernate.initialize((Object)cadastroImobiliario.getTestadas());
        }
        if (!EloListUtils.safeIsEmpty((List)cadastroImobiliario.getTestadasGenericas()).booleanValue()) {
            Hibernate.initialize((Object)cadastroImobiliario.getTestadasGenericas());
        }
        Hibernate.initialize((Object)cadastroImobiliario.getSegmentos());
        return cadastroImobiliario;
    }

    private String getNu_Inscricao(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDto) {
        return Optional.ofNullable(solicitacaoRedeSimDto).map(SolicitacaoAlvaraRedeSimDTO::getDados_solicitacao).map(DadosSolicitacao::getEmpresa).map(Empresa::getEndereco).map(Endereco::getNatureza_imovel).map(Natureza_imovel::getNu_inscricao).map(EloStringUtils::somenteNumeros).orElse(null);
    }

    public void setGeraLaudos(boolean geraLaudos) {
        this.geraLaudos = geraLaudos;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public void setSolicitacaoDocRedeSim(SolicitacaoDocRedeSimEntity solicitacaoDocRedeSim) {
        this.solicitacaoDocRedeSim = solicitacaoDocRedeSim;
    }

    public SolicitacaoRedeSimEntity getSolicitacaoRedeSim() {
        return this.solicitacaoRedeSim;
    }
}

