/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandGeraSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import java.util.Date;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandGeraSolicitacaoAlvara")
@Scope(value="prototype")
public class CommandGeraSolicitacaoAlvaraImpl
implements CommandGeraSolicitacaoAlvara {
    private SolicitacaoAlvaraEntity solicitacao;
    private Boolean consultaPrevia;
    private boolean geraRestricaoCadastroExistente;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoPrestadorServico;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraCBO srvSolicitacaoAlvaraCBO;

    public void execute() throws BaseException {
        this.srvSolicitacaoAlvara.verificarIdClassificacaoTipoInscricao(this.solicitacao);
        if (this.solicitacao.isSolicitacaoJuridicaNormal()) {
            if (this.consultaPrevia.booleanValue()) {
                this.solicitacao.setDataConsultaPrevia(new Date());
                this.srvSolicitacaoAlvara.salvarConsultaPreviaSolicitacao(this.solicitacao);
                if (this.solicitacao.getCadastroImobiliario() != null) {
                    Hibernate.initialize((Object)this.solicitacao.getCadastroImobiliario().getTestadas());
                }
            } else {
                this.srvSolicitacaoAlvara.salvarSolicitacaoInicial(this.solicitacao, this.geraRestricaoCadastroExistente);
            }
        } else if (this.solicitacao.isSolicitacaoPrestadorServico()) {
            if (this.consultaPrevia.booleanValue()) {
                this.solicitacao.setDataConsultaPrevia(new Date());
                this.srvSolicitacaoPrestadorServico.salvarConsultaPrevia(this.solicitacao);
            } else {
                this.srvSolicitacaoPrestadorServico.salvarSolicitacaoInicial(this.solicitacao);
            }
        } else if (this.solicitacao.isSolicitacaoMEI()) {
            if (this.consultaPrevia.booleanValue()) {
                this.solicitacao.setDataConsultaPrevia(new Date());
                this.srvSolicitacaoAlvaraMEI.salvarConsultaPreviaSolicitacao(this.solicitacao);
            } else {
                this.srvSolicitacaoAlvaraMEI.salvarSolicitacaoInicial(this.solicitacao, this.geraRestricaoCadastroExistente);
            }
        } else if (this.solicitacao.isSolicitacaoCBO()) {
            if (this.consultaPrevia.booleanValue()) {
                this.solicitacao.setDataConsultaPrevia(new Date());
                this.srvSolicitacaoAlvaraCBO.salvarConsultaPreviaSolicitacao(this.solicitacao);
            } else {
                this.srvSolicitacaoAlvaraCBO.salvarSolicitacaoInicial(this.solicitacao, this.geraRestricaoCadastroExistente);
            }
        }
        if (!this.solicitacao.isRedeSim() && this.solicitacao.getCadastroMobiliario() != null) {
            Hibernate.initialize((Object)this.solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getContatos());
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacao;
    }

    public void setConsultaPrevia(Boolean consultaPrevia) {
        this.consultaPrevia = consultaPrevia;
    }

    public void setGeraRestricaoCadastroExistente(boolean geraRestricaoCadastroExistente) {
        this.geraRestricaoCadastroExistente = geraRestricaoCadastroExistente;
    }
}

