/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandEnviaDocumentosRedeSim;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.enumerator.ModeloDocumentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.service.SrvDocumentoRedeSim;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandEnviaDocumentosRedeSim")
@Scope(value="prototype")
public class CommandEnviaDocumentosRedeSimImpl
implements CommandEnviaDocumentosRedeSim {
    @Resource
    private SrvDocumentoRedeSim srvDocumentoRedeSim;
    private SolicitacaoRedeSimEntity solicitacaoRedeSim;
    private List<HistoricoExigenciaRedeSimEntity> historicoExigenciaRedeSim;
    private SituacaoRespostaRedeSimEnum situacao;
    private boolean enviaDam;
    private ModeloDocumentoRedeSimEnum modeloDocumento;
    private List<DebitoEntity> listaDebitosSelecionadosParaEnvio;
    private ImprimirTaxasAlvara imprimirTaxasAlvara;
    private String observacaoIndeferimento;

    public void setSolicitacaoRedeSim(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        this.solicitacaoRedeSim = solicitacaoRedeSim;
    }

    public void execute() throws BaseException {
        if (SituacaoRespostaRedeSimEnum.INDEFERIDO.equals((Object)this.situacao) && !EloStringUtils.isEmpty((String)this.observacaoIndeferimento)) {
            this.srvDocumentoRedeSim.enviarIndeferimentoRedeSim(this.solicitacaoRedeSim, this.observacaoIndeferimento);
            return;
        }
        this.srvDocumentoRedeSim.enviarDocumento(this.solicitacaoRedeSim, this.situacao, this.enviaDam, this.imprimirTaxasAlvara, this.historicoExigenciaRedeSim, this.modeloDocumento, this.listaDebitosSelecionadosParaEnvio);
    }

    public void setHistoricoExigenciaRedeSim(List<HistoricoExigenciaRedeSimEntity> historicoExigencia) {
        this.historicoExigenciaRedeSim = historicoExigencia;
    }

    public void setSituacao(SituacaoRespostaRedeSimEnum situacao) {
        this.situacao = situacao;
    }

    public void setEnviaDam(boolean enviaDam) {
        this.enviaDam = enviaDam;
    }

    public void setModeloDocumento(ModeloDocumentoRedeSimEnum modeloDocumento) {
        this.modeloDocumento = modeloDocumento;
    }

    public void setListaDebitosSelecionadosParaEnvio(List<DebitoEntity> listaDebitosSelecionadosParaEnvio) {
        this.listaDebitosSelecionadosParaEnvio = listaDebitosSelecionadosParaEnvio;
    }

    public void setTaxaAlvara(ImprimirTaxasAlvara imprimirTaxaAlvara) {
        this.imprimirTaxasAlvara = imprimirTaxaAlvara;
    }

    public void setObservacaoIndeferimento(String observacaoIndeferimento) {
        this.observacaoIndeferimento = observacaoIndeferimento;
    }
}

