/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandEfetivaAlteracaoSolicitacao;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandEfetivaAlteracaoSolicitacao")
@Scope(value="prototype")
public class CommandEfetivaAlteracaoSolicitacaoImpl
implements CommandEfetivaAlteracaoSolicitacao {
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;

    public void setSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacaoAlvara = solicitacao;
    }

    public void execute() throws BaseException {
        if (SimNaoEnum.getNaoShortText().equals(this.solicitacaoAlvara.getEfetivado())) {
            if (this.solicitacaoAlvara.isSolicitacaoJuridicaNormal()) {
                this.srvSolicitacaoAlvara.efetivaAlteracaoSolicitacao(this.solicitacaoAlvara);
            } else if (this.solicitacaoAlvara.isSolicitacaoMEI()) {
                this.srvSolicitacaoAlvaraMEI.efetivaAlteracaoSolicitacao(this.solicitacaoAlvara);
            }
        }
    }
}

