/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandConsultaCnaePorCodigo;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryCnae;
import br.com.elotech.util.list.EloListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandConsultaCnaePorCodigo")
@Scope(value="prototype")
public class CommandConsultaCnaePorCodigoImpl
implements CommandConsultaCnaePorCodigo {
    private String codigoAtividade;
    private CnaeEntity cnae;
    private String descricaoCnae;
    @Resource
    private RepositoryCnae repositoryCnae;

    public void execute() throws BaseException {
        this.cnae = this.repositoryCnae.consultaCnaePorCodigo(this.codigoAtividade);
        if (this.cnae != null && EloListUtils.safeIsEmpty((List)this.cnae.getCarteirasProfissionais()).booleanValue()) {
            this.cnae.setCarteirasProfissionais(new ArrayList());
        }
        this.descricaoCnae = !Objects.isNull(this.cnae) ? this.cnae.getDescricao() : "CNAE n\u00e3o cadastrado na base. Favor entrar em contato com o setor respons\u00e1vel.";
    }

    public String getCodigoAtividade() {
        return this.codigoAtividade;
    }

    public void setCodigoAtividade(String codigoAtividade) {
        this.codigoAtividade = codigoAtividade;
    }

    public CnaeEntity getCnae() {
        return this.cnae;
    }

    public void setCnae(CnaeEntity cnae) {
        this.cnae = cnae;
    }

    public void setRepositoryCnae(RepositoryCnae repositoryCnae) {
        this.repositoryCnae = repositoryCnae;
    }

    public String getDescricaoCnae() {
        return this.descricaoCnae;
    }
}

