/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.service.SrvUsuario;
import br.com.elotech.tributacao.command.CommandCarregarUsuariosPorModulo;
import br.com.elotech.tributacao.domain.aise.UsuarioEntidadeEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioModuloEntity;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregarUsuariosPorModulo")
public class CommandCarregarUsuariosPorModuloImpl
implements CommandCarregarUsuariosPorModulo {
    private List<UsuarioEntity> usuarios;
    private Modulo modulo;
    @Resource
    private SrvUsuario srvUsuario;

    public void execute() throws BaseException {
        this.usuarios = this.srvUsuario.carregarUsuariosPorModulo(this.modulo);
        this.usuarios.forEach(usuario -> {
            Hibernate.initialize((Object)usuario.getTiposDocumento());
            Hibernate.initialize((Object)usuario.getTipoLaudos());
            Hibernate.initialize((Object)usuario.getUsuarioModulos());
            Hibernate.initialize((Object)usuario.getUsuarioEntidades());
            for (UsuarioModuloEntity usuarioModulo : usuario.getUsuarioModulos()) {
                Hibernate.initialize((Object)usuarioModulo.getId().getModulo().getModulo());
            }
            for (UsuarioEntidadeEntity usuarioEntidade : usuario.getUsuarioEntidades()) {
                Hibernate.initialize((Object)usuarioEntidade.getId().getEntidade().getId());
            }
            if (!EloListUtils.safeIsEmpty((List)usuario.getTipoLaudos()).booleanValue()) {
                usuario.getTipoLaudos().forEach(tipoLaudo -> Hibernate.initialize((Object)tipoLaudo.getUsuarios()));
            }
        });
    }

    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    public List<UsuarioEntity> getUsuarios() {
        return this.usuarios;
    }
}

