/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregarListaConsultaRedeSim;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregarListaConsultaRedeSim")
public class CommandCarregarListaConsultaRedeSimImpl
implements CommandCarregarListaConsultaRedeSim {
    private FiltroConsultaRedeSim filtro;
    private List<SolicitacaoRedeSimEntity> listaConsultaRedeSim;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public void execute() throws BaseException {
        this.listaConsultaRedeSim = this.repositoryConsultaRedeSim.carregarListaConsultaRedeSim(this.filtro);
        if (!EloListUtils.safeIsEmpty((List)this.listaConsultaRedeSim).booleanValue()) {
            for (SolicitacaoRedeSimEntity consultaRedeSim : this.listaConsultaRedeSim) {
                Hibernate.initialize((Object)consultaRedeSim.getEventos());
                Hibernate.initialize((Object)consultaRedeSim.getHistoricosExigencias());
                if (!Objects.nonNull(consultaRedeSim.getSolicitacaoAlvara())) continue;
                this.repositorySolicitacaoAlvara.inicializarDadosSolicitacaoAlvara(consultaRedeSim.getSolicitacaoAlvara());
            }
        }
    }

    public void setFiltro(FiltroConsultaRedeSim filtro) {
        this.filtro = filtro;
    }

    public List<SolicitacaoRedeSimEntity> getListaConsultaRedeSim() {
        return this.listaConsultaRedeSim;
    }
}

