/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregarLaudosVencidos;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioLaudoVo;
import br.com.elotech.portalarrecadacao.repository.RepositoryRelatorioLaudo;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregarLaudosVencidos")
public class CommandCarregarLaudosVencidosImpl
implements CommandCarregarLaudosVencidos {
    @Resource
    private RepositoryRelatorioLaudo repositoryRelatorioLaudo;
    private FiltroRelatorioLaudoVo filtro;
    private List<LaudoAlvaraEntity> listaLaudos;

    public void execute() throws BaseException {
        this.listaLaudos = this.repositoryRelatorioLaudo.carregarLaudosVencidos(this.filtro);
        for (LaudoAlvaraEntity laudo : this.listaLaudos) {
            Hibernate.initialize((Object)laudo.getObservacoesTipoLaudo());
            if (!EloListUtils.safeIsEmpty((List)laudo.getIdSolicitacaoAlvara().getNaturezas()).booleanValue()) {
                Hibernate.initialize((Object)laudo.getIdSolicitacaoAlvara().getNaturezas());
            }
            if (EloListUtils.safeIsEmpty((List)laudo.getIdSolicitacaoAlvara().getSolicitacaoAlvaraAtividades()).booleanValue()) continue;
            Hibernate.initialize((Object)laudo.getIdSolicitacaoAlvara().getSolicitacaoAlvaraAtividades());
            for (SolicitacaoAlvaraAtividadeEntity atividade : laudo.getIdSolicitacaoAlvara().getSolicitacaoAlvaraAtividades()) {
                if (EloListUtils.safeIsEmpty((List)atividade.getNumerosConselho()).booleanValue()) continue;
                Hibernate.initialize((Object)atividade.getNumerosConselho());
            }
        }
    }

    public void setFiltroRelatorioLaudoVo(FiltroRelatorioLaudoVo filtro) {
        this.filtro = filtro;
    }

    public List<LaudoAlvaraEntity> getLaudosVencidos() {
        return this.listaLaudos;
    }
}

