/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregarHistoricoRenovacaoAlvara;
import br.com.elotech.portalarrecadacao.domain.HistoricoRenovacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroHistoricoRenovacao;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoRenovacaoAlvara;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandCarregarHistoricoRenovacaoAlvara")
@Scope(value="prototype")
public class CommandCarregarHistoricoRenovacaoAlvaraImpl
implements CommandCarregarHistoricoRenovacaoAlvara {
    private FiltroHistoricoRenovacao filtro;
    private List<HistoricoRenovacaoAlvaraEntity> renovacoes;
    @Resource
    private RepositoryHistoricoRenovacaoAlvara repositoryHistoricoRenovacaoAlvara;

    public void execute() throws BaseException {
        this.renovacoes = this.repositoryHistoricoRenovacaoAlvara.carregarHistoricoRenovacao(this.filtro);
        for (HistoricoRenovacaoAlvaraEntity renovacao : this.renovacoes) {
            Hibernate.initialize((Object)renovacao.getUsuario().getTipoLaudos());
            Hibernate.initialize((Object)renovacao.getUsuario().getUsuarioSeletores());
            Hibernate.initialize((Object)renovacao.getSolicitacaoAlvara().getNaturezas());
            Hibernate.initialize((Object)renovacao.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroImobiliario());
        }
    }

    public void setFiltro(FiltroHistoricoRenovacao filtro) {
        this.filtro = filtro;
    }

    public List<HistoricoRenovacaoAlvaraEntity> getRenovacoes() {
        return this.renovacoes;
    }
}

