/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaSolicitacoesParaValidar;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandCarregaSolicitacoesParaValidar")
@Scope(value="prototype")
public class CommandCarregaSolicitacoesParaValidarImpl
implements CommandCarregaSolicitacoesParaValidar {
    private Long numeroSolicitacao;
    private Long exercicio;
    private String cpfCnpj;
    private Date dataInicial;
    private Date dataFinal;
    private List<SolicitacaoAlvaraEntity> solicitacoes;
    private boolean documentoNaoValidado;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public void execute() throws BaseException {
        this.solicitacoes = this.repositorySolicitacaoAlvara.buscaSolicitacoesParaValidar(this.numeroSolicitacao, this.exercicio, this.cpfCnpj, this.dataInicial, this.dataFinal, this.documentoNaoValidado);
        for (SolicitacaoAlvaraEntity solicitacao : this.solicitacoes) {
            if (solicitacao.getSolicitacaoAlvaraAtividades().size() <= 0) {
                solicitacao.getSolicitacaoAlvaraAtividades();
            }
            if (solicitacao.getCadastroMobiliario().getContratosSociais().size() <= 0) {
                solicitacao.getCadastroMobiliario().getContratosSociais();
            }
            for (ContratoSocialEntity contrato : solicitacao.getCadastroMobiliario().getContratosSociais()) {
                if (contrato.getPessoas().size() > 0) continue;
                contrato.getPessoas();
            }
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                if (atividade.getNumerosConselho().size() > 0) continue;
                atividade.getNumerosConselho();
            }
            if (solicitacao.getNaturezas().size() > 0) continue;
            solicitacao.getNaturezas();
        }
    }

    public Long getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    public void setNumeroSolicitacao(Long numeroSolicitacao) {
        this.numeroSolicitacao = numeroSolicitacao;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public List<SolicitacaoAlvaraEntity> getSolicitacoes() {
        return this.solicitacoes;
    }

    public void setSolicitacoes(List<SolicitacaoAlvaraEntity> solicitacoes) {
        this.solicitacoes = solicitacoes;
    }

    public void setRepositorySolicitacaoAlvara(RepositorySolicitacaoAlvara repositorySolicitacaoAlvara) {
        this.repositorySolicitacaoAlvara = repositorySolicitacaoAlvara;
    }

    public void setDocumentoNaoValidado(boolean documentoNaoValidado) {
        this.documentoNaoValidado = documentoNaoValidado;
    }
}

