/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaRestricaoForLiberacao;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoAlvara;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregaRestricaoForLiberacao")
public class CommandCarregaRestricaoForLiberacaoImpl
implements CommandCarregaRestricaoForLiberacao {
    private Long idSolicitacao;
    private List<RestricaoAlvaraEntity> listaRestricaoAlvara;
    @Resource
    private RepositoryRestricaoAlvara repositoryRestricaoAlvara;

    public void execute() throws BaseException {
        this.listaRestricaoAlvara = this.repositoryRestricaoAlvara.carregaRestricaoParaLiberacao(this.idSolicitacao);
        for (RestricaoAlvaraEntity restricaoAlvara : this.listaRestricaoAlvara) {
            if (restricaoAlvara.getCadastroRestricaoAlvara() != null) {
                Hibernate.initialize((Object)restricaoAlvara.getCadastroRestricaoAlvara().getUsuarios());
            }
            Hibernate.initialize((Object)restricaoAlvara.getObservacoes());
            Hibernate.initialize((Object)restricaoAlvara.getSolicitacaoAlvara().getNaturezas());
            Hibernate.initialize((Object)restricaoAlvara.getSolicitacaoAlvara().getLaudos());
            Hibernate.initialize((Object)restricaoAlvara.getSolicitacaoAlvara().getRestricoes());
        }
    }

    public List<RestricaoAlvaraEntity> getRestricaoAlvara() {
        return this.listaRestricaoAlvara;
    }

    public void setSolicitacao(Long idSolicitacao) {
        this.idSolicitacao = idSolicitacao;
    }
}

