/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.domain.Page;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaSolicitacaoAlvaraPaginado;
import br.com.elotech.portalarrecadacao.controller.dataModel.SolicitacaoAlvaraDataModel;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandCarregaListaSolicitacaoAlvaraPaginado")
@Scope(value="prototype")
public class CommandCarregaListaSolicitacaoAlvaraPaginadoImpl
implements CommandCarregaListaSolicitacaoAlvaraPaginado {
    private SolicitacaoAlvaraDataModel solicitacaoAlvaraDataModel;
    private Integer pagina;
    private Integer tamanhoPagina;
    private Page<SolicitacaoAlvaraEntity> listaSolicitacaoAlvara;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacao;

    public void execute() throws BaseException {
        this.listaSolicitacaoAlvara = this.repositorySolicitacao.carregarListaSolicitacaoAlvaraPaginado(this.solicitacaoAlvaraDataModel, this.pagina, this.tamanhoPagina);
        if (Objects.nonNull(this.listaSolicitacaoAlvara) && !EloListUtils.safeIsEmpty((List)this.listaSolicitacaoAlvara.getData()).booleanValue()) {
            for (SolicitacaoAlvaraEntity solicitacao : this.listaSolicitacaoAlvara.getData()) {
                this.repositorySolicitacao.inicializarDadosSolicitacaoAlvara(solicitacao);
            }
        }
    }

    public SolicitacaoAlvaraDataModel getSolicitacaoAlvaraDataModel() {
        return this.solicitacaoAlvaraDataModel;
    }

    public void setSolicitacaoAlvaraDataModel(SolicitacaoAlvaraDataModel solicitacaoAlvaraDataModel) {
        this.solicitacaoAlvaraDataModel = solicitacaoAlvaraDataModel;
    }

    public void setPagina(Integer pagina) {
        this.pagina = pagina;
    }

    public void setTamanhoPagina(Integer tamanhoPagina) {
        this.tamanhoPagina = tamanhoPagina;
    }

    public Page<SolicitacaoAlvaraEntity> getListaSolicitacaoAlvara() {
        return this.listaSolicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraDataModel solicitacaoAlvara) {
        this.solicitacaoAlvaraDataModel = solicitacaoAlvara;
    }
}

