/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaParticipantesContratoSocial;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocialPessoa;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocialPessoa;
import br.com.elotech.util.math.EloNumberUtils;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregaListaParticipantesContratoSocial")
public class CommandCarregaListaParticipantesContratoSocialImpl
implements CommandCarregaListaParticipantesContratoSocial {
    @Resource
    private RepositoryContratoSocialPessoa repositoryContratoSocialPessoa;
    @Resource
    private RepositorySolicitacaoContratoSocialPessoa repositorySolicitacaoContratoSocialPessoa;
    private List<ContratoSocialPessoaEntity> listaContratoSocialPessoa;
    private List<SolicitacaoContratoSocialPessoaEntity> listaSolicitacaoContratoSocialPessoa;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    private Long codigoCadastroMobiliario;

    public void execute() throws BaseException {
        block3: {
            block2: {
                if (this.solicitacaoAlvara == null) break block2;
                this.listaSolicitacaoContratoSocialPessoa = this.repositorySolicitacaoContratoSocialPessoa.carregaListaParticipantesContratoSocialDaSolicitacao(this.solicitacaoAlvara);
                for (SolicitacaoContratoSocialPessoaEntity solicitacaoContratoPessoa : this.listaSolicitacaoContratoSocialPessoa) {
                    Hibernate.initialize((Object)solicitacaoContratoPessoa.getPessoa().getEnderecos());
                }
                break block3;
            }
            if (!EloNumberUtils.isBiggerThanZero((Number)this.codigoCadastroMobiliario).booleanValue()) break block3;
            this.listaContratoSocialPessoa = this.repositoryContratoSocialPessoa.carregaListaParticipantesContratoSocial(this.codigoCadastroMobiliario);
            for (ContratoSocialPessoaEntity contratoPessoa : this.listaContratoSocialPessoa) {
                Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getEnderecos());
            }
        }
    }

    public List<ContratoSocialPessoaEntity> getCarregaListaParticipantesContratoSocialDoCadastroMobiliario() {
        return this.listaContratoSocialPessoa;
    }

    public void setCodigo(Long codigo) {
        this.codigoCadastroMobiliario = codigo;
    }

    public List<SolicitacaoContratoSocialPessoaEntity> getCarregaListaParticipantesContratoSocialDaSolicitacao() {
        return this.listaSolicitacaoContratoSocialPessoa;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }
}

